"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTest = exports.IntegTestCase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_assembly_schema_1 = require("aws-cdk-lib/cloud-assembly-schema");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const manifest_synthesizer_1 = require("./manifest-synthesizer");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const constructs_1 = require("constructs");
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 */
class IntegTestCase extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.id = id;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestCaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    /**
     * The integration test manifest for this test case. Manifests are used
     * by the integration test runner.
     */
    get manifest() {
        return {
            version: cloud_assembly_schema_1.Manifest.version(),
            testCases: { [this.id]: toTestCase(this.props) },
        };
    }
}
exports.IntegTestCase = IntegTestCase;
_a = JSII_RTTI_SYMBOL_1;
IntegTestCase[_a] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTestCase", version: "2.22.0-alpha.0" };
/**
 * A collection of test cases. Each test case file should contain exactly one
 * instance of this class.
 */
class IntegTest extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    onPrepare() {
        aws_cdk_lib_1.attachCustomSynthesis(this, {
            onSynthesize: (session) => {
                const synthesizer = new manifest_synthesizer_1.IntegManifestSynthesizer(this.props.testCases);
                synthesizer.synthesize(session);
            },
        });
    }
}
exports.IntegTest = IntegTest;
_b = JSII_RTTI_SYMBOL_1;
IntegTest[_b] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTest", version: "2.22.0-alpha.0" };
function toTestCase(props) {
    return {
        ...props,
        stacks: props.stacks.map(s => s.artifactId),
    };
}
//# sourceMappingURL=data:application/json;base64,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