import * as iam from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
/**
 * Represents an assertions provider. The creates a singletone
 * Lambda Function that will create a single function per stack
 * that serves as the custom resource provider for the various
 * assertion providers
 */
export declare class AssertionsProvider extends Construct {
    readonly serviceToken: string;
    private readonly grantPrincipal;
    constructor(scope: Construct, id: string);
    encode(obj: any): any;
    addPolicyStatementFromSdkCall(service: string, api: string, resources?: string[]): iam.PolicyStatement;
}
