"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EqualsAssertion = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const providers_1 = require("./providers");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const constructs_1 = require("constructs");
/**
 * Construct that creates a CustomResource to assert that two
 * values are equal
 */
class EqualsAssertion extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const assertionProvider = new providers_1.AssertionsProvider(this, 'AssertionProvider');
        const properties = {
            actual: props.inputResource.getAttString(props.inputResourceAtt),
            expected: props.expected,
            assertionType: providers_1.AssertionType.EQUALS,
        };
        const resource = new aws_cdk_lib_1.CustomResource(this, 'Default', {
            serviceToken: assertionProvider.serviceToken,
            properties,
            resourceType: providers_1.ASSERT_RESOURCE_TYPE,
        });
        this.result = resource.getAttString('data');
    }
}
exports.EqualsAssertion = EqualsAssertion;
//# sourceMappingURL=data:application/json;base64,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