import { CustomResource } from 'aws-cdk-lib';
import { IAssertion } from './deploy-assert';
import { Construct } from 'constructs';
/**
 * Options for an EqualsAssertion
 */
export interface EqualsAssertionProps {
    /**
     * The CustomResource that continains the "actual" results
     */
    readonly inputResource: CustomResource;
    /**
     * The CustomResource attribute that continains the "actual" results
     */
    readonly inputResourceAtt: string;
    /**
     * The expected result to assert
     */
    readonly expected: any;
}
/**
 * Construct that creates a CustomResource to assert that two
 * values are equal
 */
export declare class EqualsAssertion extends Construct implements IAssertion {
    readonly result: string;
    constructor(scope: Construct, id: string, props: EqualsAssertionProps);
}
