import { DefaultStackSynthesizer } from 'aws-cdk-lib';
/**
 * As a best practice organizations enforce policies which require all custom IAM Roles created to be defined under
 * a specific path and permission boundary.
 * In order to adhere with such compliance requirements, the CDK bootstrapping is often customized
 * (refer: https://docs.aws.amazon.com/cdk/v2/guide/bootstrapping.html#bootstrapping-customizing).
 * So, we need to ensure that parallel customization is applied during synthesis phase.
 * This Custom Synthesizer is used to modify the default path of the following IAM Roles internally used by CDK:
 *  - deploy role
 *  - file-publishing-role
 *  - image-publishing-role
 *  - cfn-exec-role
 *  - lookup-role
 * @see PermissionsBoundaryAspect
 *
 * Example Usage:
 * ```ts
 *    new DbStack(app, config.id('apiDbStack'), {
 *      env: {account: '123456789012', region: 'us-east-1'},
 *      synthesizer: new CustomSynthesizer('/banking/dev/'),
 *     });
 * ```
 */
export declare class CustomSynthesizer extends DefaultStackSynthesizer {
    private static qualifiedRole;
    constructor(rolePath: string);
}
//# sourceMappingURL=custom-synthesizer.d.ts.map