"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PropagateTags = exports.SchedulingStrategy = exports.EcsService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
class EcsService extends core_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        const { cluster, serviceName, launchType = aws_ecs_1.LaunchType.FARGATE, platformVersion = '1.4.0', desiredCount = 1, prodTargetGroup, testTargetGroup, taskDefinition, healthCheckGracePeriod = core_1.Duration.seconds(60), } = props;
        const containerPort = (_b = props.containerPort) !== null && _b !== void 0 ? _b : taskDefinition.containerPort;
        const { vpc } = cluster;
        this.node.addDependency(prodTargetGroup, testTargetGroup);
        const securityGroups = props.securityGroups || [
            new aws_ec2_1.SecurityGroup(this, 'SecurityGroup', {
                description: `Security group for ${this.node.id} service`,
                vpc,
            }),
        ];
        const serviceToken = new aws_lambda_1.Function(this, 'Function', {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'ecs-service')),
            handler: 'index.handler',
            timeout: core_1.Duration.minutes(15),
        });
        serviceToken.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['ecs:CreateService', 'ecs:UpdateService', 'ecs:DeleteService', 'ecs:DescribeServices'],
            resources: ['*'],
        }));
        serviceToken.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['iam:PassRole'],
            resources: [taskDefinition.executionRole.roleArn],
        }));
        const service = new core_1.CustomResource(this, 'CustomResource', {
            serviceToken: serviceToken.functionArn,
            resourceType: 'Custom::BlueGreenService',
            properties: {
                Cluster: cluster.clusterName,
                ServiceName: serviceName,
                ContainerName: taskDefinition.containerName,
                TaskDefinition: taskDefinition.taskDefinitionArn,
                LaunchType: launchType,
                PlatformVersion: platformVersion,
                DesiredCount: desiredCount,
                Subnets: vpc.privateSubnets.map((sn) => sn.subnetId),
                SecurityGroups: securityGroups.map((sg) => sg.securityGroupId),
                TargetGroupArn: prodTargetGroup.targetGroupArn,
                ContainerPort: containerPort,
                SchedulingStrategy: SchedulingStrategy.REPLICA,
                HealthCheckGracePeriodSeconds: healthCheckGracePeriod.toSeconds(),
                PropagateTags: props.propagateTags,
                DeploymentConfiguration: {
                    maximumPercent: (_c = props.maxHealthyPercent) !== null && _c !== void 0 ? _c : 200,
                    minimumHealthyPercent: (_d = props.minHealthyPercent) !== null && _d !== void 0 ? _d : 50,
                    deploymentCircuitBreaker: props.circuitBreaker
                        ? {
                            enable: true,
                            rollback: (_e = props.circuitBreaker.rollback) !== null && _e !== void 0 ? _e : false,
                        }
                        : undefined,
                },
            },
        });
        service.node.addDependency(prodTargetGroup.loadBalancerAttached);
        this.serviceName = service.getAttString('ServiceName');
        this.clusterName = cluster.clusterName;
        this.connections = new aws_ec2_1.Connections({
            securityGroups,
            defaultPort: aws_ec2_1.Port.tcp(containerPort),
        });
    }
}
exports.EcsService = EcsService;
_a = JSII_RTTI_SYMBOL_1;
EcsService[_a] = { fqn: "@cloudcomponents/cdk-blue-green-container-deployment.EcsService", version: "1.46.0" };
var SchedulingStrategy;
(function (SchedulingStrategy) {
    SchedulingStrategy["REPLICA"] = "REPLICA";
    SchedulingStrategy["DAEMON"] = "DAEMON";
})(SchedulingStrategy = exports.SchedulingStrategy || (exports.SchedulingStrategy = {}));
var PropagateTags;
(function (PropagateTags) {
    PropagateTags["TASK_DEFINITION"] = "TASK_DEFINITION";
    PropagateTags["SERVICE"] = "SERVICE";
})(PropagateTags = exports.PropagateTags || (exports.PropagateTags = {}));
//# sourceMappingURL=data:application/json;base64,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