"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DummyTaskDefinition = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecs_1 = require("@aws-cdk/aws-ecs");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const custom_resources_1 = require("@aws-cdk/custom-resources");
class DummyTaskDefinition extends core_1.Construct {
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        this.executionRole = new aws_iam_1.Role(this, 'ExecutionRole', {
            assumedBy: new aws_iam_1.ServicePrincipal('ecs-tasks.amazonaws.com'),
            managedPolicies: [aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AmazonECSTaskExecutionRolePolicy')],
        });
        this.family = (_b = props.family) !== null && _b !== void 0 ? _b : this.node.addr;
        this.containerName = (_c = props.containerName) !== null && _c !== void 0 ? _c : 'sample-website';
        this.containerPort = (_d = props.containerPort) !== null && _d !== void 0 ? _d : 80;
        const taskDefinition = new custom_resources_1.AwsCustomResource(this, 'DummyTaskDefinition', {
            resourceType: 'Custom::DummyTaskDefinition',
            onCreate: {
                service: 'ECS',
                action: 'registerTaskDefinition',
                parameters: {
                    requiresCompatibilities: ['FARGATE'],
                    family: this.family,
                    executionRoleArn: this.executionRole.roleArn,
                    networkMode: aws_ecs_1.NetworkMode.AWS_VPC,
                    cpu: '256',
                    memory: '512',
                    containerDefinitions: [
                        {
                            name: this.containerName,
                            image: props.image,
                            portMappings: [
                                {
                                    hostPort: this.containerPort,
                                    protocol: 'tcp',
                                    containerPort: this.containerPort,
                                },
                            ],
                        },
                    ],
                },
                physicalResourceId: custom_resources_1.PhysicalResourceId.fromResponse('taskDefinition.taskDefinitionArn'),
            },
            onDelete: {
                service: 'ECS',
                action: 'deregisterTaskDefinition',
                parameters: {
                    taskDefinition: new custom_resources_1.PhysicalResourceIdReference(),
                },
            },
            policy: custom_resources_1.AwsCustomResourcePolicy.fromStatements([
                new aws_iam_1.PolicyStatement({
                    effect: aws_iam_1.Effect.ALLOW,
                    actions: ['ecs:RegisterTaskDefinition', 'ecs:DeregisterTaskDefinition'],
                    resources: ['*'],
                }),
                new aws_iam_1.PolicyStatement({
                    effect: aws_iam_1.Effect.ALLOW,
                    actions: ['iam:PassRole'],
                    resources: [this.executionRole.roleArn],
                }),
            ]),
        });
        this.taskDefinitionArn = taskDefinition.getResponseField('taskDefinition.taskDefinitionArn');
    }
    /**
     * Adds a policy statement to the task execution IAM role.
     */
    addToExecutionRolePolicy(statement) {
        this.executionRole.addToPrincipalPolicy(statement);
    }
}
exports.DummyTaskDefinition = DummyTaskDefinition;
_a = JSII_RTTI_SYMBOL_1;
DummyTaskDefinition[_a] = { fqn: "@cloudcomponents/cdk-blue-green-container-deployment.DummyTaskDefinition", version: "1.46.0" };
//# sourceMappingURL=data:application/json;base64,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