"""Event constants."""
from collections.abc import Mapping

from ..command import Command
from ..commands import (
    GetAdvancedMode,
    GetBattery,
    GetCachedMapInfo,
    GetCarpetAutoFanBoost,
    GetChargeState,
    GetCleanCount,
    GetCleanInfo,
    GetCleanLogs,
    GetCleanPreference,
    GetContinuousCleaning,
    GetError,
    GetFanSpeed,
    GetLifeSpan,
    GetMajorMap,
    GetMapTrace,
    GetMultimapState,
    GetPos,
    GetStats,
    GetTotalStats,
    GetTrueDetect,
    GetVolume,
    GetWaterInfo,
)
from . import (
    AdvancedModeEvent,
    BatteryEvent,
    CarpetAutoFanBoostEvent,
    CleanCountEvent,
    CleanLogEvent,
    CleanPreferenceEvent,
    ContinuousCleaningEvent,
    CustomCommandEvent,
    ErrorEvent,
    Event,
    FanSpeedEvent,
    LifeSpanEvent,
    MultimapStateEvent,
    PositionsEvent,
    ReportStatsEvent,
    RoomsEvent,
    StatsEvent,
    StatusEvent,
    TotalStatsEvent,
    TrueDetectEvent,
    VolumeEvent,
    WaterInfoEvent,
)
from .map import (
    MajorMapEvent,
    MapSetEvent,
    MapSubsetEvent,
    MapTraceEvent,
    MinorMapEvent,
)

EVENT_DTO_REFRESH_COMMANDS: Mapping[type[Event], list[Command]] = {
    AdvancedModeEvent: [GetAdvancedMode()],
    BatteryEvent: [GetBattery()],
    CarpetAutoFanBoostEvent: [GetCarpetAutoFanBoost()],
    CleanLogEvent: [GetCleanLogs()],
    CleanCountEvent: [GetCleanCount()],
    CleanPreferenceEvent: [GetCleanPreference()],
    ContinuousCleaningEvent: [GetContinuousCleaning()],
    CustomCommandEvent: [],
    ErrorEvent: [GetError()],
    FanSpeedEvent: [GetFanSpeed()],
    LifeSpanEvent: [GetLifeSpan()],
    MajorMapEvent: [GetMajorMap()],
    MapSetEvent: [],
    MapSubsetEvent: [],
    MapTraceEvent: [GetMapTrace()],
    MinorMapEvent: [],
    MultimapStateEvent: [GetMultimapState()],
    PositionsEvent: [GetPos()],
    ReportStatsEvent: [],  # ReportStats cannot be pulled
    RoomsEvent: [GetCachedMapInfo()],
    StatsEvent: [GetStats()],
    StatusEvent: [GetChargeState(), GetCleanInfo()],
    TotalStatsEvent: [GetTotalStats()],
    TrueDetectEvent: [GetTrueDetect()],
    VolumeEvent: [GetVolume()],
    WaterInfoEvent: [GetWaterInfo()],
}
