/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import algebra.ring.Field;
import algebra.ring.Rng;
import algebra.ring.Semiring;
import cats.kernel.Eq;
import cats.kernel.Order;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcID$sp;
import scala.collection.IterableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import spire.math.Polynomial;
import spire.math.poly.PolyDense;
import spire.math.poly.PolySparse;
import spire.math.poly.PolySparse$mcD$sp;
import spire.math.poly.Term;
import spire.math.poly.Term$mcD$sp;
import spire.scalacompat.package$;
import spire.std.package$int$;
import spire.syntax.std.package$array$;

public final class PolySparse$
implements Serializable {
    public static final PolySparse$ MODULE$ = new PolySparse$();

    public final <C> PolySparse<C> dense2sparse(PolyDense<C> poly, Semiring<C> evidence$1, Eq<C> evidence$2, ClassTag<C> evidence$3) {
        Object cs = poly.coeffs();
        int[] es = new int[ScalaRunTime$.MODULE$.array_length(cs)];
        for (int index$macro$1 = 0; index$macro$1 < es.length; ++index$macro$1) {
            es[index$macro$1] = index$macro$1;
        }
        return this.safe(es, cs, evidence$1, evidence$2, evidence$3);
    }

    public final <C> PolySparse<C> safe(int[] exp, Object coeff, Semiring<C> evidence$4, Eq<C> evidence$5, ClassTag<C> evidence$6) {
        PolySparse polySparse;
        int len = 0;
        for (int index$macro$1 = 0; index$macro$1 < ScalaRunTime$.MODULE$.array_length(coeff); ++index$macro$1) {
            if (!evidence$5.neqv(ScalaRunTime$.MODULE$.array_apply(coeff, index$macro$1), spire.algebra.package$.MODULE$.Semiring().apply(evidence$4).zero())) continue;
            ++len;
        }
        if (len == ScalaRunTime$.MODULE$.array_length(coeff)) {
            polySparse = new PolySparse(exp, coeff, evidence$6);
        } else {
            int[] es = new int[len];
            Object cs = evidence$6.newArray(len);
            polySparse = this.loop$2(0, 0, coeff, evidence$5, evidence$4, es, exp, cs, evidence$6);
        }
        return polySparse;
    }

    public final <C> PolySparse<C> apply(IterableOnce<Term<C>> data, Semiring<C> evidence$7, Eq<C> evidence$8, ClassTag<C> evidence$9) {
        PolySparse<C> polySparse;
        ObjectRef<ArrayBuilder<Object>> expBldr = ObjectRef.create(package$.MODULE$.arrayBuilderMake(ClassTag$.MODULE$.Int()));
        ObjectRef coeffBldr = ObjectRef.create(package$.MODULE$.arrayBuilderMake(evidence$9));
        Object zero = spire.algebra.package$.MODULE$.Semiring().apply(evidence$7).zero();
        BooleanRef inReverseOrder = BooleanRef.create(true);
        BooleanRef inOrder = BooleanRef.create(true);
        IntRef lastDeg = IntRef.create(-1);
        data.iterator().foreach((Function1<Term, Object> & Serializable)x0$1 -> {
            PolySparse$.$anonfun$apply$1(evidence$8, zero, expBldr, coeffBldr, inOrder, lastDeg, inReverseOrder, x0$1);
            return BoxedUnit.UNIT;
        });
        int[] exp = (int[])((ArrayBuilder)expBldr.elem).result();
        Object coeff = ((ArrayBuilder)coeffBldr.elem).result();
        if (inOrder.elem) {
            polySparse = this.apply(exp, coeff, evidence$9);
        } else if (inReverseOrder.elem) {
            this.spire$math$poly$PolySparse$$reverse(exp);
            this.spire$math$poly$PolySparse$$reverse(coeff);
            polySparse = this.apply(exp, coeff, evidence$9);
        } else {
            Object object;
            int[] indices = Array$.MODULE$.range(0, exp.length);
            package$array$.MODULE$.arrayOps$mIc$sp(indices).qsortBy$mIcI$sp(x$21 -> exp[x$21], (Order)((Object)package$int$.MODULE$.IntAlgebra()), ClassTag$.MODULE$.Int());
            expBldr.elem = package$.MODULE$.arrayBuilderMake(ClassTag$.MODULE$.Int());
            coeffBldr.elem = package$.MODULE$.arrayBuilderMake(evidence$9);
            int j = indices[0];
            int e = exp[j];
            Object c = ScalaRunTime$.MODULE$.array_apply(coeff, j);
            for (int i = 1; i < indices.length; ++i) {
                int j0 = indices[i];
                int e0 = exp[j0];
                Object c0 = ScalaRunTime$.MODULE$.array_apply(coeff, j0);
                if (e != e0) {
                    Object object2;
                    if (!evidence$7.isZero(c, evidence$8)) {
                        ((ArrayBuilder)expBldr.elem).$plus$eq(BoxesRunTime.boxToInteger(e));
                        object2 = ((ArrayBuilder)coeffBldr.elem).$plus$eq(c);
                    } else {
                        object2 = BoxedUnit.UNIT;
                    }
                    c = c0;
                } else {
                    c = evidence$7.plus(c, c0);
                }
                e = e0;
                j = j0;
            }
            if (!evidence$7.isZero(c, evidence$8)) {
                ((ArrayBuilder)expBldr.elem).$plus$eq(BoxesRunTime.boxToInteger(e));
                object = ((ArrayBuilder)coeffBldr.elem).$plus$eq(c);
            } else {
                object = BoxedUnit.UNIT;
            }
            PolySparse<C> poly = this.apply((int[])((ArrayBuilder)expBldr.elem).result(), ((ArrayBuilder)coeffBldr.elem).result(), evidence$9);
            polySparse = poly;
        }
        return polySparse;
    }

    public <A> void spire$math$poly$PolySparse$$reverse(Object arr) {
        int i = 0;
        for (int j = ScalaRunTime$.MODULE$.array_length(arr) - 1; i < j; ++i, --j) {
            Object tmp = ScalaRunTime$.MODULE$.array_apply(arr, i);
            ScalaRunTime$.MODULE$.array_update(arr, i, ScalaRunTime$.MODULE$.array_apply(arr, j));
            ScalaRunTime$.MODULE$.array_update(arr, j, tmp);
        }
    }

    public final <C> PolySparse<C> apply(Map<Object, C> data, Semiring<C> evidence$10, Eq<C> evidence$11, ClassTag<C> evidence$12) {
        Tuple2[] data0 = (Tuple2[])data.toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        package$array$.MODULE$.arrayOps(data0).qsortBy$mIc$sp((Function1<Tuple2, Object> & Serializable)x$22 -> BoxesRunTime.boxToInteger(x$22._1$mcI$sp()), (Order)((Object)package$int$.MODULE$.IntAlgebra()), ClassTag$.MODULE$.apply(Tuple2.class));
        int[] es = new int[data0.length];
        Object cs = evidence$12.newArray(data0.length);
        for (int index$macro$1 = 0; index$macro$1 < data0.length; ++index$macro$1) {
            Tuple2 tuple2 = data0[index$macro$1];
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int e = tuple2._1$mcI$sp();
            Object c = tuple2._2();
            Tuple2 tuple22 = new Tuple2(BoxesRunTime.boxToInteger(e), c);
            Tuple2 tuple23 = tuple22;
            int e2 = tuple23._1$mcI$sp();
            Object c2 = tuple23._2();
            es[index$macro$1] = e2;
            ScalaRunTime$.MODULE$.array_update(cs, index$macro$1, c2);
        }
        return this.safe(es, cs, evidence$10, evidence$11, evidence$12);
    }

    public final <C> PolySparse<C> apply(Polynomial<C> poly, Semiring<C> evidence$13, Eq<C> evidence$14, ClassTag<C> evidence$15) {
        PolySparse<C> polySparse;
        Polynomial<C> polynomial = poly;
        if (polynomial instanceof PolySparse) {
            PolySparse<C> polySparse2;
            polySparse = polySparse2 = (PolySparse<C>)polynomial;
        } else if (polynomial instanceof PolyDense) {
            polySparse = this.dense2sparse((PolyDense)poly, evidence$13, evidence$14, evidence$15);
        } else {
            IntRef len = IntRef.create(0);
            poly.foreachNonZero((Function2<Object, Object, Object> & Serializable)(x$26, x$27) -> {
                PolySparse$.$anonfun$apply$4(len, BoxesRunTime.unboxToInt(x$26), x$27);
                return BoxedUnit.UNIT;
            }, evidence$13, evidence$14);
            int[] es = new int[len.elem];
            Object cs = evidence$15.newArray(len.elem);
            IntRef i = IntRef.create(0);
            poly.foreachNonZero((Function2<Object, Object, Object> & Serializable)(e, c) -> {
                PolySparse$.$anonfun$apply$5(es, i, cs, BoxesRunTime.unboxToInt(e), c);
                return BoxedUnit.UNIT;
            }, evidence$13, evidence$14);
            polySparse = this.safe(es, cs, evidence$13, evidence$14, evidence$15);
        }
        return polySparse;
    }

    public final <C> PolySparse<C> zero(Semiring<C> evidence$16, Eq<C> evidence$17, ClassTag<C> evidence$18) {
        return new PolySparse<C>(new int[0], evidence$18.newArray(0), evidence$18);
    }

    public final <C> PolySparse<C> spire$math$poly$PolySparse$$multiplyTerm(PolySparse<C> poly, C c, int e, Semiring<C> evidence$19, Eq<C> evidence$20, ClassTag<C> evidence$21) {
        int[] exp = poly.exp();
        Object coeff = poly.coeff();
        Object cs = evidence$21.newArray(ScalaRunTime$.MODULE$.array_length(coeff));
        int[] es = new int[exp.length];
        for (int index$macro$1 = 0; index$macro$1 < ScalaRunTime$.MODULE$.array_length(coeff); ++index$macro$1) {
            ScalaRunTime$.MODULE$.array_update(cs, index$macro$1, evidence$19.times(c, ScalaRunTime$.MODULE$.array_apply(coeff, index$macro$1)));
            es[index$macro$1] = exp[index$macro$1] + e;
        }
        return new PolySparse<C>(es, cs, evidence$21);
    }

    public final <C> PolySparse<C> spire$math$poly$PolySparse$$multiplySparse(PolySparse<C> lhs, PolySparse<C> rhs, Semiring<C> evidence$22, Eq<C> evidence$23, ClassTag<C> evidence$24) {
        int[] lexp = lhs.exp();
        Object lcoeff = lhs.coeff();
        PolySparse<Object> sum2 = new PolySparse<C>(new int[0], evidence$24.newArray(0), evidence$24);
        for (int index$macro$1 = 0; index$macro$1 < lexp.length; ++index$macro$1) {
            sum2 = this.spire$math$poly$PolySparse$$addSparse(sum2, this.spire$math$poly$PolySparse$$multiplyTerm(rhs, ScalaRunTime$.MODULE$.array_apply(lcoeff, index$macro$1), lexp[index$macro$1], evidence$22, evidence$23, evidence$24), evidence$23, evidence$22, evidence$24);
        }
        return sum2;
    }

    private final <C> int countSumTerms(PolySparse<C> lhs, PolySparse<C> rhs, int lOffset, int rOffset) {
        PolySparse<C> polySparse = lhs;
        if (polySparse == null) {
            throw new MatchError(polySparse);
        }
        int[] lexp = polySparse.exp();
        Object lcoeff = polySparse.coeff();
        Tuple2<int[], Object> tuple2 = new Tuple2<int[], Object>(lexp, lcoeff);
        Tuple2<int[], Object> tuple22 = tuple2;
        int[] lexp2 = tuple22._1();
        Object lcoeff2 = tuple22._2();
        PolySparse<C> polySparse2 = rhs;
        if (polySparse2 == null) {
            throw new MatchError(polySparse2);
        }
        int[] rexp = polySparse2.exp();
        Object rcoeff = polySparse2.coeff();
        Tuple2<int[], Object> tuple23 = new Tuple2<int[], Object>(rexp, rcoeff);
        Tuple2<int[], Object> tuple24 = tuple23;
        int[] rexp2 = tuple24._1();
        Object rcoeff2 = tuple24._2();
        return this.loop$3(0, 0, 0, lexp2, rexp2, lOffset, rOffset);
    }

    private final <C> int countSumTerms$default$3() {
        return 0;
    }

    private final <C> int countSumTerms$default$4() {
        return 0;
    }

    public final <C> PolySparse<C> spire$math$poly$PolySparse$$addSparse(PolySparse<C> lhs, PolySparse<C> rhs, Eq<C> evidence$25, Semiring<C> evidence$26, ClassTag<C> evidence$27) {
        PolySparse<C> polySparse = lhs;
        if (polySparse == null) {
            throw new MatchError(polySparse);
        }
        int[] lexp = polySparse.exp();
        Object lcoeff = polySparse.coeff();
        Tuple2<int[], Object> tuple2 = new Tuple2<int[], Object>(lexp, lcoeff);
        Tuple2<int[], Object> tuple22 = tuple2;
        int[] lexp2 = tuple22._1();
        Object lcoeff2 = tuple22._2();
        PolySparse<C> polySparse2 = rhs;
        if (polySparse2 == null) {
            throw new MatchError(polySparse2);
        }
        int[] rexp = polySparse2.exp();
        Object rcoeff = polySparse2.coeff();
        Tuple2<int[], Object> tuple23 = new Tuple2<int[], Object>(rexp, rcoeff);
        Tuple2<int[], Object> tuple24 = tuple23;
        int[] rexp2 = tuple24._1();
        Object rcoeff2 = tuple24._2();
        int len = this.countSumTerms(lhs, rhs, this.countSumTerms$default$3(), this.countSumTerms$default$4());
        int[] es = new int[len];
        Object cs = evidence$27.newArray(len);
        return this.sum$1(0, 0, 0, lexp2, rexp2, es, cs, evidence$26, lcoeff2, rcoeff2, evidence$25, evidence$27);
    }

    public final <C> PolySparse<C> spire$math$poly$PolySparse$$subtractScaled(PolySparse<C> lhs, C c, int e, PolySparse<C> rhs, Eq<C> evidence$28, Rng<C> evidence$29, ClassTag<C> evidence$30) {
        PolySparse<C> polySparse = lhs;
        if (polySparse == null) {
            throw new MatchError(polySparse);
        }
        int[] lexp = polySparse.exp();
        Object lcoeff = polySparse.coeff();
        Tuple2<int[], Object> tuple2 = new Tuple2<int[], Object>(lexp, lcoeff);
        Tuple2<int[], Object> tuple22 = tuple2;
        int[] lexp2 = tuple22._1();
        Object lcoeff2 = tuple22._2();
        PolySparse<C> polySparse2 = rhs;
        if (polySparse2 == null) {
            throw new MatchError(polySparse2);
        }
        int[] rexp = polySparse2.exp();
        Object rcoeff = polySparse2.coeff();
        Tuple2<int[], Object> tuple23 = new Tuple2<int[], Object>(rexp, rcoeff);
        Tuple2<int[], Object> tuple24 = tuple23;
        int[] rexp2 = tuple24._1();
        Object rcoeff2 = tuple24._2();
        int len = this.countSumTerms(lhs, rhs, 0, e);
        int[] es = new int[len];
        Object cs = evidence$30.newArray(len);
        return this.loop$4(0, 0, 0, lexp2, rexp2, e, es, cs, evidence$29, lcoeff2, c, rcoeff2, evidence$28, evidence$30);
    }

    public final <C> Tuple2<PolySparse<C>, PolySparse<C>> quotmodSparse(PolySparse<C> lhs, PolySparse<C> rhs, Field<C> evidence$31, Eq<C> evidence$32, ClassTag<C> evidence$33) {
        int rdegree = rhs.degree();
        C rmaxCoeff = rhs.maxOrderTermCoeff(evidence$31);
        return this.loop$5(scala.package$.MODULE$.Nil(), lhs, rdegree, evidence$31, rmaxCoeff, rhs, evidence$32, evidence$33);
    }

    public <C> PolySparse<C> apply(int[] exp, Object coeff, ClassTag<C> ct) {
        return new PolySparse<C>(exp, coeff, ct);
    }

    public <C> Option<Tuple2<int[], Object>> unapply(PolySparse<C> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple2<int[], Object>>(new Tuple2<int[], Object>(x$0.exp(), x$0.coeff()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PolySparse$.class);
    }

    public final PolySparse<Object> dense2sparse$mDc$sp(PolyDense<Object> poly, Semiring<Object> evidence$1, Eq<Object> evidence$2, ClassTag<Object> evidence$3) {
        double[] cs = poly.coeffs$mcD$sp();
        int[] es = new int[cs.length];
        for (int index$macro$1 = 0; index$macro$1 < es.length; ++index$macro$1) {
            es[index$macro$1] = index$macro$1;
        }
        return this.safe$mDc$sp(es, cs, evidence$1, evidence$2, evidence$3);
    }

    public final PolySparse<Object> safe$mDc$sp(int[] exp, double[] coeff, Semiring<Object> evidence$4, Eq<Object> evidence$5, ClassTag<Object> evidence$6) {
        PolySparse polySparse;
        int len = 0;
        for (int index$macro$1 = 0; index$macro$1 < coeff.length; ++index$macro$1) {
            if (!evidence$5.neqv$mcD$sp(coeff[index$macro$1], spire.algebra.package$.MODULE$.Semiring().apply(evidence$4).zero$mcD$sp())) continue;
            ++len;
        }
        if (len == coeff.length) {
            polySparse = new PolySparse$mcD$sp(exp, coeff, evidence$6);
        } else {
            int[] es = new int[len];
            double[] cs = (double[])evidence$6.newArray(len);
            polySparse = this.loop$6(0, 0, coeff, evidence$5, evidence$4, es, exp, cs, evidence$6);
        }
        return polySparse;
    }

    public final PolySparse<Object> apply$mDc$sp(IterableOnce<Term<Object>> data, Semiring<Object> evidence$7, Eq<Object> evidence$8, ClassTag<Object> evidence$9) {
        PolySparse<Object> polySparse;
        ObjectRef<ArrayBuilder<Object>> expBldr = ObjectRef.create(package$.MODULE$.arrayBuilderMake(ClassTag$.MODULE$.Int()));
        ObjectRef<ArrayBuilder<Object>> coeffBldr = ObjectRef.create(package$.MODULE$.arrayBuilderMake(evidence$9));
        double zero = spire.algebra.package$.MODULE$.Semiring().apply(evidence$7).zero$mcD$sp();
        BooleanRef inReverseOrder = BooleanRef.create(true);
        BooleanRef inOrder = BooleanRef.create(true);
        IntRef lastDeg = IntRef.create(-1);
        data.iterator().foreach((Function1<Term, Object> & Serializable)x0$1 -> {
            PolySparse$.$anonfun$apply$6(evidence$8, zero, expBldr, coeffBldr, inOrder, lastDeg, inReverseOrder, x0$1);
            return BoxedUnit.UNIT;
        });
        int[] exp = (int[])((ArrayBuilder)expBldr.elem).result();
        double[] coeff = (double[])((ArrayBuilder)coeffBldr.elem).result();
        if (inOrder.elem) {
            polySparse = this.apply$mDc$sp(exp, coeff, evidence$9);
        } else if (inReverseOrder.elem) {
            this.spire$math$poly$PolySparse$$reverse(exp);
            this.spire$math$poly$PolySparse$$reverse(coeff);
            polySparse = this.apply$mDc$sp(exp, coeff, evidence$9);
        } else {
            PolySparse<Object> poly;
            Object object;
            int[] indices = Array$.MODULE$.range(0, exp.length);
            package$array$.MODULE$.arrayOps$mIc$sp(indices).qsortBy$mIcI$sp(x$21 -> exp[x$21], (Order)((Object)package$int$.MODULE$.IntAlgebra()), ClassTag$.MODULE$.Int());
            expBldr.elem = package$.MODULE$.arrayBuilderMake(ClassTag$.MODULE$.Int());
            coeffBldr.elem = package$.MODULE$.arrayBuilderMake(evidence$9);
            int j = indices[0];
            int e = exp[j];
            double c = coeff[j];
            for (int i = 1; i < indices.length; ++i) {
                int j0 = indices[i];
                int e0 = exp[j0];
                double c0 = coeff[j0];
                if (e != e0) {
                    Object object2;
                    if (!evidence$7.isZero$mcD$sp(c, evidence$8)) {
                        ((ArrayBuilder)expBldr.elem).$plus$eq(BoxesRunTime.boxToInteger(e));
                        object2 = ((ArrayBuilder)coeffBldr.elem).$plus$eq(BoxesRunTime.boxToDouble(c));
                    } else {
                        object2 = BoxedUnit.UNIT;
                    }
                    c = c0;
                } else {
                    c = evidence$7.plus$mcD$sp(c, c0);
                }
                e = e0;
                j = j0;
            }
            if (!evidence$7.isZero$mcD$sp(c, evidence$8)) {
                ((ArrayBuilder)expBldr.elem).$plus$eq(BoxesRunTime.boxToInteger(e));
                object = ((ArrayBuilder)coeffBldr.elem).$plus$eq(BoxesRunTime.boxToDouble(c));
            } else {
                object = BoxedUnit.UNIT;
            }
            polySparse = poly = this.apply$mDc$sp((int[])((ArrayBuilder)expBldr.elem).result(), (double[])((ArrayBuilder)coeffBldr.elem).result(), evidence$9);
        }
        return polySparse;
    }

    private void reverse$mDc$sp(double[] arr) {
        int i = 0;
        for (int j = arr.length - 1; i < j; ++i, --j) {
            double tmp = arr[i];
            arr[i] = arr[j];
            arr[j] = tmp;
        }
    }

    public final PolySparse<Object> apply$mDc$sp(Map<Object, Object> data, Semiring<Object> evidence$10, Eq<Object> evidence$11, ClassTag<Object> evidence$12) {
        Tuple2[] data0 = (Tuple2[])data.toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        package$array$.MODULE$.arrayOps(data0).qsortBy$mIc$sp((Function1<Tuple2, Object> & Serializable)x$22 -> BoxesRunTime.boxToInteger(x$22._1$mcI$sp()), (Order)((Object)package$int$.MODULE$.IntAlgebra()), ClassTag$.MODULE$.apply(Tuple2.class));
        int[] es = new int[data0.length];
        double[] cs = (double[])evidence$12.newArray(data0.length);
        for (int index$macro$1 = 0; index$macro$1 < data0.length; ++index$macro$1) {
            Tuple2 tuple2 = data0[index$macro$1];
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int e = tuple2._1$mcI$sp();
            double c = tuple2._2$mcD$sp();
            Tuple2$mcID$sp tuple2$mcID$sp = new Tuple2$mcID$sp(e, c);
            Tuple2$mcID$sp tuple2$mcID$sp2 = tuple2$mcID$sp;
            int e2 = ((Tuple2)tuple2$mcID$sp2)._1$mcI$sp();
            double c2 = ((Tuple2)tuple2$mcID$sp2)._2$mcD$sp();
            es[index$macro$1] = e2;
            cs[index$macro$1] = c2;
        }
        return this.safe$mDc$sp(es, cs, evidence$10, evidence$11, evidence$12);
    }

    public final PolySparse<Object> apply$mDc$sp(Polynomial<Object> poly, Semiring<Object> evidence$13, Eq<Object> evidence$14, ClassTag<Object> evidence$15) {
        PolySparse<Object> polySparse;
        Polynomial<Object> polynomial = poly;
        if (polynomial instanceof PolySparse) {
            PolySparse<Object> polySparse2;
            polySparse = polySparse2 = (PolySparse<Object>)polynomial;
        } else if (polynomial instanceof PolyDense) {
            polySparse = this.dense2sparse$mDc$sp((PolyDense)poly, evidence$13, evidence$14, evidence$15);
        } else {
            IntRef len = IntRef.create(0);
            poly.foreachNonZero$mcD$sp((x$26, x$27) -> ++len$2.elem, evidence$13, evidence$14);
            int[] es = new int[len.elem];
            double[] cs = (double[])evidence$15.newArray(len.elem);
            IntRef i = IntRef.create(0);
            poly.foreachNonZero$mcD$sp((e, c) -> {
                es$7[i$2.elem] = e;
                cs$7[i$2.elem] = c;
                ++i$2.elem;
            }, evidence$13, evidence$14);
            polySparse = this.safe$mDc$sp(es, cs, evidence$13, evidence$14, evidence$15);
        }
        return polySparse;
    }

    public final PolySparse<Object> zero$mDc$sp(Semiring<Object> evidence$16, Eq<Object> evidence$17, ClassTag<Object> evidence$18) {
        return new PolySparse$mcD$sp(new int[0], (double[])evidence$18.newArray(0), evidence$18);
    }

    private final PolySparse<Object> multiplyTerm$mDc$sp(PolySparse<Object> poly, double c, int e, Semiring<Object> evidence$19, Eq<Object> evidence$20, ClassTag<Object> evidence$21) {
        int[] exp = poly.exp();
        double[] coeff = poly.coeff$mcD$sp();
        double[] cs = (double[])evidence$21.newArray(coeff.length);
        int[] es = new int[exp.length];
        for (int index$macro$1 = 0; index$macro$1 < coeff.length; ++index$macro$1) {
            cs[index$macro$1] = evidence$19.times$mcD$sp(c, coeff[index$macro$1]);
            es[index$macro$1] = exp[index$macro$1] + e;
        }
        return new PolySparse$mcD$sp(es, cs, evidence$21);
    }

    private final PolySparse<Object> multiplySparse$mDc$sp(PolySparse<Object> lhs, PolySparse<Object> rhs, Semiring<Object> evidence$22, Eq<Object> evidence$23, ClassTag<Object> evidence$24) {
        int[] lexp = lhs.exp();
        double[] lcoeff = lhs.coeff$mcD$sp();
        PolySparse sum2 = new PolySparse$mcD$sp(new int[0], (double[])evidence$24.newArray(0), evidence$24);
        for (int index$macro$1 = 0; index$macro$1 < lexp.length; ++index$macro$1) {
            sum2 = this.spire$math$poly$PolySparse$$addSparse(sum2, this.spire$math$poly$PolySparse$$multiplyTerm(rhs, BoxesRunTime.boxToDouble(lcoeff[index$macro$1]), lexp[index$macro$1], evidence$22, evidence$23, evidence$24), evidence$23, evidence$22, evidence$24);
        }
        return sum2;
    }

    private final int countSumTerms$mDc$sp(PolySparse<Object> lhs, PolySparse<Object> rhs, int lOffset, int rOffset) {
        PolySparse<Object> polySparse = lhs;
        if (polySparse == null) {
            throw new MatchError(polySparse);
        }
        int[] lexp = polySparse.exp();
        double[] lcoeff = polySparse.coeff$mcD$sp();
        Tuple2<int[], double[]> tuple2 = new Tuple2<int[], double[]>(lexp, lcoeff);
        Tuple2<int[], double[]> tuple22 = tuple2;
        int[] lexp2 = tuple22._1();
        double[] lcoeff2 = tuple22._2();
        PolySparse<Object> polySparse2 = rhs;
        if (polySparse2 == null) {
            throw new MatchError(polySparse2);
        }
        int[] rexp = polySparse2.exp();
        double[] rcoeff = polySparse2.coeff$mcD$sp();
        Tuple2<int[], double[]> tuple23 = new Tuple2<int[], double[]>(rexp, rcoeff);
        Tuple2<int[], double[]> tuple24 = tuple23;
        int[] rexp2 = tuple24._1();
        double[] rcoeff2 = tuple24._2();
        return this.loop$7(0, 0, 0, lexp2, rexp2, lOffset, rOffset);
    }

    public final Tuple2<PolySparse<Object>, PolySparse<Object>> quotmodSparse$mDc$sp(PolySparse<Object> lhs, PolySparse<Object> rhs, Field<Object> evidence$31, Eq<Object> evidence$32, ClassTag<Object> evidence$33) {
        int rdegree = rhs.degree();
        double rmaxCoeff = rhs.maxOrderTermCoeff$mcD$sp(evidence$31);
        return this.loop$8(scala.package$.MODULE$.Nil(), lhs, rdegree, evidence$31, rmaxCoeff, rhs, evidence$32, evidence$33);
    }

    public PolySparse<Object> apply$mDc$sp(int[] exp, double[] coeff, ClassTag<Object> ct) {
        return new PolySparse$mcD$sp(exp, coeff, ct);
    }

    public Option<Tuple2<int[], double[]>> unapply$mDc$sp(PolySparse<Object> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple2<int[], double[]>>(new Tuple2<int[], double[]>(x$0.exp(), x$0.coeff$mcD$sp()));
    }

    private final PolySparse loop$2(int i, int j, Object coeff$1, Eq evidence$5$1, Semiring evidence$4$1, int[] es$2, int[] exp$1, Object cs$2, ClassTag evidence$6$1) {
        while (i < ScalaRunTime$.MODULE$.array_length(coeff$1)) {
            Object c = ScalaRunTime$.MODULE$.array_apply(coeff$1, i);
            if (evidence$5$1.neqv(c, spire.algebra.package$.MODULE$.Semiring().apply(evidence$4$1).zero())) {
                es$2[j] = exp$1[i];
                ScalaRunTime$.MODULE$.array_update(cs$2, j, c);
                ++j;
                ++i;
                continue;
            }
            ++i;
        }
        return new PolySparse(es$2, cs$2, evidence$6$1);
    }

    public static final /* synthetic */ void $anonfun$apply$1(Eq evidence$8$1, Object zero$1, ObjectRef expBldr$1, ObjectRef coeffBldr$1, BooleanRef inOrder$1, IntRef lastDeg$1, BooleanRef inReverseOrder$1, Term x0$1) {
        BoxedUnit boxedUnit;
        Term term = x0$1;
        if (term != null) {
            Object c = term.coeff();
            int i = term.exp();
            if (evidence$8$1.neqv(c, zero$1)) {
                ((ArrayBuilder)expBldr$1.elem).$plus$eq(BoxesRunTime.boxToInteger(i));
                ((ArrayBuilder)coeffBldr$1.elem).$plus$eq(c);
                inOrder$1.elem = inOrder$1.elem && lastDeg$1.elem < i;
                inReverseOrder$1.elem = inReverseOrder$1.elem && (lastDeg$1.elem < 0 || lastDeg$1.elem > i);
                lastDeg$1.elem = i;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError(term);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$apply$4(IntRef len$1, int x$26, Object x$27) {
        ++len$1.elem;
    }

    public static final /* synthetic */ void $anonfun$apply$5(int[] es$3, IntRef i$1, Object cs$3, int e, Object c) {
        es$3[i$1.elem] = e;
        ScalaRunTime$.MODULE$.array_update(cs$3, i$1.elem, c);
        ++i$1.elem;
    }

    private final int loop$3(int i, int j, int count, int[] lexp$1, int[] rexp$1, int lOffset$1, int rOffset$1) {
        while (i < lexp$1.length && j < rexp$1.length) {
            int cmp = lexp$1[i] + lOffset$1 - rexp$1[j] - rOffset$1;
            if (cmp == 0) {
                ++count;
                ++j;
                ++i;
                continue;
            }
            if (cmp < 0) {
                ++count;
                ++i;
                continue;
            }
            ++count;
            ++j;
        }
        return count + (lexp$1.length - i) + (rexp$1.length - j);
    }

    private final PolySparse sum$1(int i, int j, int k, int[] lexp$2, int[] rexp$2, int[] es$4, Object cs$4, Semiring evidence$26$1, Object lcoeff$1, Object rcoeff$1, Eq evidence$25$1, ClassTag evidence$27$1) {
        while (i < lexp$2.length && j < rexp$2.length) {
            int ei = lexp$2[i];
            int ej = rexp$2[j];
            if (ei == ej) {
                es$4[k] = ei;
                ScalaRunTime$.MODULE$.array_update(cs$4, k, evidence$26$1.plus(ScalaRunTime$.MODULE$.array_apply(lcoeff$1, i), ScalaRunTime$.MODULE$.array_apply(rcoeff$1, j)));
                ++k;
                ++j;
                ++i;
                continue;
            }
            if (ei < ej) {
                es$4[k] = ei;
                ScalaRunTime$.MODULE$.array_update(cs$4, k, ScalaRunTime$.MODULE$.array_apply(lcoeff$1, i));
                ++k;
                ++i;
                continue;
            }
            es$4[k] = ej;
            ScalaRunTime$.MODULE$.array_update(cs$4, k, ScalaRunTime$.MODULE$.array_apply(rcoeff$1, j));
            ++k;
            ++j;
        }
        int k0 = k;
        for (int index$macro$1 = i; index$macro$1 < lexp$2.length; ++index$macro$1) {
            es$4[k0] = lexp$2[index$macro$1];
            ScalaRunTime$.MODULE$.array_update(cs$4, k0, ScalaRunTime$.MODULE$.array_apply(lcoeff$1, index$macro$1));
            ++k0;
        }
        for (int index$macro$2 = j; index$macro$2 < rexp$2.length; ++index$macro$2) {
            es$4[k0] = rexp$2[index$macro$2];
            ScalaRunTime$.MODULE$.array_update(cs$4, k0, ScalaRunTime$.MODULE$.array_apply(rcoeff$1, index$macro$2));
            ++k0;
        }
        return this.safe(es$4, cs$4, evidence$26$1, evidence$25$1, evidence$27$1);
    }

    private final PolySparse loop$4(int i, int j, int k, int[] lexp$3, int[] rexp$3, int e$1, int[] es$5, Object cs$5, Rng evidence$29$1, Object lcoeff$2, Object c$1, Object rcoeff$2, Eq evidence$28$1, ClassTag evidence$30$1) {
        while (i < lexp$3.length && j < rexp$3.length) {
            int ei = lexp$3[i];
            int ej = rexp$3[j] + e$1;
            if (ei == ej) {
                es$5[k] = ei;
                ScalaRunTime$.MODULE$.array_update(cs$5, k, evidence$29$1.minus(ScalaRunTime$.MODULE$.array_apply(lcoeff$2, i), evidence$29$1.times(c$1, ScalaRunTime$.MODULE$.array_apply(rcoeff$2, j))));
                ++k;
                ++j;
                ++i;
                continue;
            }
            if (ei < ej) {
                es$5[k] = ei;
                ScalaRunTime$.MODULE$.array_update(cs$5, k, ScalaRunTime$.MODULE$.array_apply(lcoeff$2, i));
                ++k;
                ++i;
                continue;
            }
            es$5[k] = ej;
            ScalaRunTime$.MODULE$.array_update(cs$5, k, evidence$29$1.times(evidence$29$1.negate(c$1), ScalaRunTime$.MODULE$.array_apply(rcoeff$2, j)));
            ++k;
            ++j;
        }
        int k0 = k;
        for (int index$macro$1 = i; index$macro$1 < lexp$3.length; ++index$macro$1) {
            es$5[k0] = lexp$3[index$macro$1];
            ScalaRunTime$.MODULE$.array_update(cs$5, k0, ScalaRunTime$.MODULE$.array_apply(lcoeff$2, index$macro$1));
            ++k0;
        }
        for (int index$macro$2 = j; index$macro$2 < rexp$3.length; ++index$macro$2) {
            es$5[k0] = rexp$3[index$macro$2] + e$1;
            ScalaRunTime$.MODULE$.array_update(cs$5, k0, evidence$29$1.times(evidence$29$1.negate(c$1), ScalaRunTime$.MODULE$.array_apply(rcoeff$2, index$macro$2)));
            ++k0;
        }
        return this.safe(es$5, cs$5, evidence$29$1, evidence$28$1, evidence$30$1);
    }

    private final PolySparse inflate$1(List ts, int i, int[] es, Object cs, ClassTag evidence$33$1) {
        List list;
        while ((list = ts) instanceof $colon$colon) {
            int e;
            $colon$colon $colon$colon = ($colon$colon)list;
            Term term = (Term)$colon$colon.head();
            List ts0 = $colon$colon.next$access$1();
            if (term == null) break;
            Object c = term.coeff();
            es[i] = e = term.exp();
            ScalaRunTime$.MODULE$.array_update(cs, i, c);
            ++i;
            ts = ts0;
        }
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List list2 = list;
        if (nil$ != null ? !((Object)nil$).equals(list2) : list2 != null) {
            throw new MatchError(list);
        }
        PolySparse polySparse = new PolySparse(es, cs, evidence$33$1);
        return polySparse;
    }

    private final Tuple2 loop$5(List quot, PolySparse rem, int rdegree$1, Field evidence$31$1, Object rmaxCoeff$1, PolySparse rhs$1, Eq evidence$32$1, ClassTag evidence$33$1) {
        while (!rem.isZero() && rem.degree() >= rdegree$1) {
            Object c0 = evidence$31$1.div(rem.maxOrderTermCoeff(evidence$31$1), rmaxCoeff$1);
            int e0 = rem.degree() - rdegree$1;
            Term<Object> term = new Term<Object>(c0, e0);
            rem = this.spire$math$poly$PolySparse$$subtractScaled(rem, c0, e0, rhs$1, evidence$32$1, evidence$31$1, evidence$33$1);
            quot = quot.$colon$colon(term);
        }
        int len = quot.size();
        return new Tuple2<PolySparse, PolySparse>(this.inflate$1(quot, 0, new int[len], evidence$33$1.newArray(len), evidence$33$1), rem);
    }

    private final PolySparse loop$6(int i, int j, double[] coeff$2, Eq evidence$5$2, Semiring evidence$4$2, int[] es$6, int[] exp$3, double[] cs$6, ClassTag evidence$6$2) {
        while (i < coeff$2.length) {
            double c = coeff$2[i];
            if (evidence$5$2.neqv$mcD$sp(c, spire.algebra.package$.MODULE$.Semiring().apply(evidence$4$2).zero$mcD$sp())) {
                es$6[j] = exp$3[i];
                cs$6[j] = c;
                ++j;
                ++i;
                continue;
            }
            ++i;
        }
        return new PolySparse$mcD$sp(es$6, cs$6, evidence$6$2);
    }

    public static final /* synthetic */ void $anonfun$apply$6(Eq evidence$8$2, double zero$2, ObjectRef expBldr$2, ObjectRef coeffBldr$2, BooleanRef inOrder$2, IntRef lastDeg$2, BooleanRef inReverseOrder$2, Term x0$1) {
        BoxedUnit boxedUnit;
        Term term = x0$1;
        if (term != null) {
            double c = term.coeff$mcD$sp();
            int i = term.exp();
            if (evidence$8$2.neqv$mcD$sp(c, zero$2)) {
                ((ArrayBuilder)expBldr$2.elem).$plus$eq(BoxesRunTime.boxToInteger(i));
                ((ArrayBuilder)coeffBldr$2.elem).$plus$eq(BoxesRunTime.boxToDouble(c));
                inOrder$2.elem = inOrder$2.elem && lastDeg$2.elem < i;
                inReverseOrder$2.elem = inReverseOrder$2.elem && (lastDeg$2.elem < 0 || lastDeg$2.elem > i);
                lastDeg$2.elem = i;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError(term);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final int loop$7(int i, int j, int count, int[] lexp$4, int[] rexp$4, int lOffset$2, int rOffset$2) {
        while (i < lexp$4.length && j < rexp$4.length) {
            int cmp = lexp$4[i] + lOffset$2 - rexp$4[j] - rOffset$2;
            if (cmp == 0) {
                ++count;
                ++j;
                ++i;
                continue;
            }
            if (cmp < 0) {
                ++count;
                ++i;
                continue;
            }
            ++count;
            ++j;
        }
        return count + (lexp$4.length - i) + (rexp$4.length - j);
    }

    private final PolySparse inflate$2(List ts, int i, int[] es, double[] cs, ClassTag evidence$33$2) {
        List list;
        while ((list = ts) instanceof $colon$colon) {
            int e;
            $colon$colon $colon$colon = ($colon$colon)list;
            Term term = (Term)$colon$colon.head();
            List ts0 = $colon$colon.next$access$1();
            if (term == null) break;
            double c = term.coeff$mcD$sp();
            es[i] = e = term.exp();
            cs[i] = c;
            ++i;
            ts = ts0;
        }
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List list2 = list;
        if (nil$ != null ? !((Object)nil$).equals(list2) : list2 != null) {
            throw new MatchError(list);
        }
        PolySparse$mcD$sp polySparse$mcD$sp = new PolySparse$mcD$sp(es, cs, evidence$33$2);
        return polySparse$mcD$sp;
    }

    private final Tuple2 loop$8(List quot, PolySparse rem, int rdegree$2, Field evidence$31$2, double rmaxCoeff$2, PolySparse rhs$2, Eq evidence$32$2, ClassTag evidence$33$2) {
        while (!rem.isZero() && rem.degree() >= rdegree$2) {
            double c0 = evidence$31$2.div$mcD$sp(rem.maxOrderTermCoeff$mcD$sp(evidence$31$2), rmaxCoeff$2);
            int e0 = rem.degree() - rdegree$2;
            Term$mcD$sp term$mcD$sp = new Term$mcD$sp(c0, e0);
            rem = this.spire$math$poly$PolySparse$$subtractScaled(rem, BoxesRunTime.boxToDouble(c0), e0, rhs$2, evidence$32$2, evidence$31$2, evidence$33$2);
            quot = quot.$colon$colon(term$mcD$sp);
        }
        int len = quot.size();
        return new Tuple2<PolySparse, PolySparse>(this.inflate$2(quot, 0, new int[len], (double[])evidence$33$2.newArray(len), evidence$33$2), rem);
    }

    private PolySparse$() {
    }
}

