/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import algebra.ring.Field;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Vector;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import spire.math.Algebraic;
import spire.math.AlgebraicInstances;
import spire.math.Bounded;
import spire.math.Interval;
import spire.math.NumberTag;
import spire.math.Point;
import spire.math.Polynomial;
import spire.math.Rational;
import spire.math.package$;
import spire.math.poly.RootIsolator$;
import spire.math.poly.Roots$;

public final class Algebraic$
implements AlgebraicInstances,
Serializable {
    public static final Algebraic$ MODULE$ = new Algebraic$();
    private static final Algebraic Zero;
    private static final Algebraic One;
    private static final double bits2dec;
    private static final BigInteger spire$math$Algebraic$$MaxIntValue;
    private static final BigInteger spire$math$Algebraic$$MinIntValue;
    private static final BigInteger spire$math$Algebraic$$MaxLongValue;
    private static final BigInteger spire$math$Algebraic$$MinLongValue;
    private static Field<Algebraic> AlgebraicAlgebra;
    private static NumberTag<Algebraic> AlgebraicTag;

    static {
        AlgebraicInstances.$init$(MODULE$);
        Zero = new Algebraic(new Algebraic.Expr.ConstantLong(0L));
        One = new Algebraic(new Algebraic.Expr.ConstantLong(1L));
        bits2dec = package$.MODULE$.log(2.0, 10);
        spire$math$Algebraic$$MaxIntValue = BigInteger.valueOf(Integer.MAX_VALUE);
        spire$math$Algebraic$$MinIntValue = BigInteger.valueOf(Integer.MIN_VALUE);
        spire$math$Algebraic$$MaxLongValue = BigInteger.valueOf(Long.MAX_VALUE);
        spire$math$Algebraic$$MinLongValue = BigInteger.valueOf(Long.MIN_VALUE);
    }

    @Override
    public final Field<Algebraic> AlgebraicAlgebra() {
        return AlgebraicAlgebra;
    }

    @Override
    public final NumberTag<Algebraic> AlgebraicTag() {
        return AlgebraicTag;
    }

    @Override
    public final void spire$math$AlgebraicInstances$_setter_$AlgebraicAlgebra_$eq(Field<Algebraic> x$1) {
        AlgebraicAlgebra = x$1;
    }

    @Override
    public final void spire$math$AlgebraicInstances$_setter_$AlgebraicTag_$eq(NumberTag<Algebraic> x$1) {
        AlgebraicTag = x$1;
    }

    public Algebraic Zero() {
        return Zero;
    }

    public Algebraic One() {
        return One;
    }

    public Algebraic apply(int n) {
        return new Algebraic(new Algebraic.Expr.ConstantLong(n));
    }

    public Algebraic apply(long n) {
        return new Algebraic(new Algebraic.Expr.ConstantLong(n));
    }

    public Algebraic apply(float n) {
        return this.apply((double)n);
    }

    public Algebraic apply(double n) {
        if (Double.isInfinite(n)) {
            throw new IllegalArgumentException("cannot construct inifinite Algebraic");
        }
        if (Double.isNaN(n)) {
            throw new IllegalArgumentException("cannot construct Algebraic from NaN");
        }
        return new Algebraic(new Algebraic.Expr.ConstantDouble(n));
    }

    public Algebraic apply(BigInt n) {
        return new Algebraic(new Algebraic.Expr.ConstantBigDecimal(scala.package$.MODULE$.BigDecimal().apply(n)));
    }

    public Algebraic apply(scala.math.BigDecimal n) {
        return new Algebraic(new Algebraic.Expr.ConstantBigDecimal(n));
    }

    public Algebraic apply(Rational n) {
        return new Algebraic(new Algebraic.Expr.ConstantRational(n));
    }

    public Algebraic root(Polynomial<Rational> poly, int i) {
        Algebraic algebraic;
        if (i < 0) {
            throw new ArithmeticException(new StringBuilder(25).append("invalid real root index: ").append(i).toString());
        }
        Polynomial<BigInt> zpoly = Roots$.MODULE$.removeFractions(poly);
        Vector<Interval<Rational>> intervals = Roots$.MODULE$.isolateRoots(zpoly, RootIsolator$.MODULE$.BigIntRootIsolator());
        if (i >= intervals.size()) {
            throw new ArithmeticException(new StringBuilder(43).append("cannot extract root ").append(i).append(", there are only ").append(intervals.size()).append(" roots").toString());
        }
        Interval interval = (Interval)intervals.apply(i);
        if (interval instanceof Point) {
            Point point = (Point)interval;
            Rational value2 = (Rational)point.value();
            algebraic = new Algebraic(new Algebraic.Expr.ConstantRational(value2));
        } else if (interval instanceof Bounded) {
            Bounded bounded = (Bounded)interval;
            Rational lb = (Rational)bounded.lower();
            Rational ub = (Rational)bounded.upper();
            algebraic = new Algebraic(new Algebraic.Expr.ConstantRoot(zpoly, i, lb, ub));
        } else {
            throw new RuntimeException("invalid isolated root interval");
        }
        return algebraic;
    }

    public Vector<Algebraic> roots(Polynomial<Rational> poly) {
        Polynomial<BigInt> zpoly = Roots$.MODULE$.removeFractions(poly);
        Vector<Interval<Rational>> intervals = Roots$.MODULE$.isolateRoots(zpoly, RootIsolator$.MODULE$.BigIntRootIsolator());
        return (Vector)((StrictOptimizedIterableOps)intervals.zipWithIndex()).map((Function1<Tuple2, Algebraic> & Serializable)x0$1 -> {
            Interval interval;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && (interval = (Interval)tuple2._1()) instanceof Point) {
                Point point = (Point)interval;
                Rational value2 = (Rational)point.value();
                return new Algebraic(new Algebraic.Expr.ConstantRational(value2));
            }
            if (tuple2 == null) throw new RuntimeException(new StringBuilder(32).append("invalid isolated root interval: ").append(tuple2).toString());
            Interval interval2 = (Interval)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if (!(interval2 instanceof Bounded)) throw new RuntimeException(new StringBuilder(32).append("invalid isolated root interval: ").append(tuple2).toString());
            Bounded bounded = (Bounded)interval2;
            Rational lb = (Rational)bounded.lower();
            Rational ub = (Rational)bounded.upper();
            return new Algebraic(new Algebraic.Expr.ConstantRoot(zpoly, i, lb, ub));
        });
    }

    public Algebraic unsafeRoot(Polynomial<BigInt> poly, int i, Rational lb, Rational ub) {
        return new Algebraic(new Algebraic.Expr.ConstantRoot(poly, i, lb, ub));
    }

    public Algebraic apply(String n) {
        return this.apply(scala.package$.MODULE$.BigDecimal().apply(new BigDecimal(n)));
    }

    public final BigDecimal nrootApprox(BigDecimal x, int n) {
        int k = package$.MODULE$.min(n, 306);
        int width = (int)(package$.MODULE$.ceil((double)x.unscaledValue().bitLength() * package$.MODULE$.log(2.0) / package$.MODULE$.log(10.0)) - 1.0);
        int safeWidth = width + (x.scale() - width) % k;
        double approx = new BigDecimal(x.unscaledValue().abs(), safeWidth).doubleValue();
        return new BigDecimal((double)x.signum() * package$.MODULE$.pow(approx, 1.0 / (double)k)).scaleByPowerOfTen(-(x.scale() - safeWidth) / k).round(MathContext.DECIMAL64);
    }

    private final BigDecimal nroot(BigDecimal signedValue, int k, Function1<BigDecimal, Object> getEps) {
        if (signedValue.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal value2 = signedValue.abs();
        BigDecimal n = new BigDecimal(k);
        BigDecimal init = this.nrootApprox(value2, k);
        BigDecimal unsignedResult = this.loop$2(init, Integer.MIN_VALUE, BigDecimal.ZERO, getEps, k, value2, n);
        return signedValue.signum() < 0 ? unsignedResult.negate() : unsignedResult;
    }

    private double bits2dec() {
        return bits2dec;
    }

    public final BigDecimal nroot(BigDecimal value2, int n, MathContext mc) {
        BigDecimal result2 = this.nroot(value2, n, (Function1<BigDecimal, Object> & Serializable)(BigDecimal x) -> BoxesRunTime.boxToInteger(Algebraic$.$anonfun$nroot$1(mc, x)));
        return result2.round(mc);
    }

    public final BigDecimal nroot(BigDecimal value2, int n, int scale, RoundingMode roundingMode) {
        return this.nroot(value2, n, (Function1<BigDecimal, Object> & Serializable)(BigDecimal x$1) -> BoxesRunTime.boxToInteger(Algebraic$.$anonfun$nroot$2(scale, x$1))).setScale(scale, roundingMode);
    }

    public BigDecimal spire$math$Algebraic$$roundExact(Algebraic exact, BigDecimal approx, int scale, RoundingMode mode2) {
        BigDecimal bigDecimal;
        if (approx.signum() == 0) {
            BigDecimal bigDecimal2;
            RoundingMode roundingMode = mode2;
            boolean bl = ((Object)((Object)RoundingMode.UP)).equals((Object)roundingMode) ? true : ((Object)((Object)RoundingMode.CEILING)).equals((Object)roundingMode);
            if (bl && exact.signum() > 0) {
                bigDecimal2 = new BigDecimal(BigInteger.ONE, scale);
            } else {
                boolean bl2 = ((Object)((Object)RoundingMode.UP)).equals((Object)roundingMode) ? true : ((Object)((Object)RoundingMode.FLOOR)).equals((Object)roundingMode);
                bigDecimal2 = bl2 && exact.signum() < 0 ? new BigDecimal(BigInteger.ONE.negate(), scale) : approx.setScale(scale, RoundingMode.DOWN);
            }
            bigDecimal = bigDecimal2;
        } else if (approx.signum() > 0) {
            bigDecimal = this.roundPositive(exact, approx, scale, mode2);
        } else {
            RoundingMode roundingMode = mode2;
            RoundingMode roundingMode2 = ((Object)((Object)RoundingMode.CEILING)).equals((Object)roundingMode) ? RoundingMode.FLOOR : (((Object)((Object)RoundingMode.FLOOR)).equals((Object)roundingMode) ? RoundingMode.CEILING : mode2);
            RoundingMode adjustedMode = roundingMode2;
            bigDecimal = this.roundPositive(exact.unary_$minus(), approx.abs(), scale, adjustedMode).negate();
        }
        return bigDecimal;
    }

    private BigDecimal roundPositive(Algebraic exact, BigDecimal approx, int scale, RoundingMode mode2) {
        BigDecimal bigDecimal;
        block23: {
            BigDecimal rounded;
            BigDecimal bigDecimal2;
            int cutoff;
            while (true) {
                if ((cutoff = approx.scale() - scale) == 0) {
                    bigDecimal = approx;
                    break block23;
                }
                if (cutoff < 0) {
                    bigDecimal = approx.setScale(scale, RoundingMode.DOWN);
                    break block23;
                }
                if (cutoff <= 18) break;
                BigDecimal bigDecimal3 = approx.setScale(scale + 18, RoundingMode.DOWN);
                approx = bigDecimal3;
            }
            long unscale = package$.MODULE$.pow(10L, cutoff);
            BigInteger[] arr = approx.unscaledValue().divideAndRemainder(BigInteger.valueOf(unscale));
            BigInteger truncatedUnscaledValue = arr[0];
            BigInteger bigRemainder = arr[1];
            BigDecimal truncated = new BigDecimal(truncatedUnscaledValue, scale);
            long remainder = bigRemainder.longValue();
            RoundingMode roundingMode = mode2;
            if (((Object)((Object)RoundingMode.UNNECESSARY)).equals((Object)roundingMode)) {
                bigDecimal2 = truncated;
            } else {
                boolean bl = ((Object)((Object)RoundingMode.HALF_DOWN)).equals((Object)roundingMode) ? true : (((Object)((Object)RoundingMode.HALF_UP)).equals((Object)roundingMode) ? true : ((Object)((Object)RoundingMode.HALF_EVEN)).equals((Object)roundingMode));
                if (bl) {
                    BigDecimal bigDecimal4;
                    long dangerZoneStart = unscale / 2L - 1L;
                    long dangerZoneStop = dangerZoneStart + 2L;
                    if (remainder >= dangerZoneStart && remainder <= dangerZoneStop) {
                        boolean bl2;
                        scala.math.BigDecimal splitter = scala.package$.MODULE$.BigDecimal().apply(new BigDecimal(truncatedUnscaledValue.multiply(BigInteger.TEN).add(BigInteger.valueOf(5L)), scale + 1));
                        int cmp = exact.compare(this.apply(splitter));
                        RoundingMode roundingMode2 = mode2;
                        if (((Object)((Object)RoundingMode.HALF_DOWN)).equals((Object)roundingMode2)) {
                            bl2 = cmp > 0;
                        } else if (((Object)((Object)RoundingMode.HALF_UP)).equals((Object)roundingMode2)) {
                            bl2 = cmp >= 0;
                        } else if (((Object)((Object)RoundingMode.HALF_EVEN)).equals((Object)roundingMode2)) {
                            bl2 = cmp > 0 || cmp == 0 && truncatedUnscaledValue.testBit(0);
                        } else {
                            throw new MatchError((Object)roundingMode2);
                        }
                        boolean roundUp = bl2;
                        bigDecimal4 = roundUp ? truncated.add(Algebraic$.epsilon$1(scale)) : truncated;
                    } else {
                        bigDecimal4 = remainder < dangerZoneStart ? truncated : truncated.add(Algebraic$.epsilon$1(scale));
                    }
                    bigDecimal2 = bigDecimal4;
                } else {
                    boolean bl3 = ((Object)((Object)RoundingMode.CEILING)).equals((Object)roundingMode) ? true : ((Object)((Object)RoundingMode.UP)).equals((Object)roundingMode);
                    if (bl3) {
                        bigDecimal2 = remainder <= 1L && exact.$less$eq(this.apply(scala.package$.MODULE$.BigDecimal().apply(truncated))) ? truncated : truncated.add(Algebraic$.epsilon$1(scale));
                    } else {
                        boolean bl4 = ((Object)((Object)RoundingMode.FLOOR)).equals((Object)roundingMode) ? true : ((Object)((Object)RoundingMode.DOWN)).equals((Object)roundingMode);
                        if (bl4) {
                            BigDecimal bigDecimal5;
                            if (remainder <= 0L) {
                                bigDecimal5 = exact.$less(this.apply(scala.package$.MODULE$.BigDecimal().apply(truncated))) ? truncated.subtract(Algebraic$.epsilon$1(scale)) : truncated;
                            } else if (remainder >= unscale - 1L) {
                                BigDecimal roundedUp = truncated.add(Algebraic$.epsilon$1(scale));
                                bigDecimal5 = exact.$greater$eq(this.apply(scala.package$.MODULE$.BigDecimal().apply(roundedUp))) ? roundedUp : truncated;
                            } else {
                                bigDecimal5 = truncated;
                            }
                            bigDecimal2 = bigDecimal5;
                        } else {
                            throw new MatchError((Object)roundingMode);
                        }
                    }
                }
            }
            bigDecimal = rounded = bigDecimal2;
        }
        return bigDecimal;
    }

    public BigInteger spire$math$Algebraic$$MaxIntValue() {
        return spire$math$Algebraic$$MaxIntValue;
    }

    public BigInteger spire$math$Algebraic$$MinIntValue() {
        return spire$math$Algebraic$$MinIntValue;
    }

    public BigInteger spire$math$Algebraic$$MaxLongValue() {
        return spire$math$Algebraic$$MaxLongValue;
    }

    public BigInteger spire$math$Algebraic$$MinLongValue() {
        return spire$math$Algebraic$$MinLongValue;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Algebraic$.class);
    }

    private final BigDecimal loop$2(BigDecimal prev, int prevDigits, BigDecimal prevEps, Function1 getEps$1, int k$1, BigDecimal value$1, BigDecimal n$1) {
        while (true) {
            int digits;
            BigDecimal eps = (digits = BoxesRunTime.unboxToInt(getEps$1.apply(prev))) == prevDigits ? prevEps : BigDecimal.ONE.movePointLeft(digits);
            BigDecimal prevExp = prev.pow(k$1 - 1);
            BigDecimal delta = value$1.divide(prevExp, digits, RoundingMode.HALF_UP).subtract(prev).divide(n$1, digits, RoundingMode.HALF_UP);
            if (delta.abs().compareTo(eps) <= 0) break;
            prevEps = eps;
            prevDigits = digits;
            prev = prev.add(delta);
        }
        return prev;
    }

    public static final /* synthetic */ int $anonfun$nroot$1(MathContext mc$1, BigDecimal x) {
        return x.scale() - (int)package$.MODULE$.ceil((double)x.unscaledValue().bitLength() * MODULE$.bits2dec()) + mc$1.getPrecision() + 1;
    }

    public static final /* synthetic */ int $anonfun$nroot$2(int scale$1, BigDecimal x$1) {
        return scale$1 + 1;
    }

    private static final BigDecimal epsilon$1(int scale$2) {
        return new BigDecimal(BigInteger.ONE, scale$2);
    }

    private Algebraic$() {
    }
}

