/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;

public class LargeArrayStatistics {
    private LargeArrayStatistics() {
    }

    public static double min(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return a.getDouble(0L);
        }
        double min2 = a.getDouble(0L);
        long length = a.length();
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 1L; i < length; ++i) {
                double elem = a.getDouble(i);
                if (!(elem < min2)) continue;
                min2 = elem;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double min2 = a.getDouble(firstIdx);
                        for (long k = firstIdx + 1L; k < lastIdx; ++k) {
                            double elem = a.getDouble(k);
                            if (!(elem < min2)) continue;
                            min2 = elem;
                        }
                        return min2;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double res = (Double)threads[j].get();
                    if (!(res < min2)) continue;
                    min2 = res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 1L; i < length; ++i) {
                    double elem = a.getDouble(i);
                    if (!(elem < min2)) continue;
                    min2 = elem;
                }
            }
        }
        return min2;
    }

    public static double max(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return a.getDouble(0L);
        }
        double max2 = a.getDouble(0L);
        long length = a.length();
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 1L; i < length; ++i) {
                double elem = a.getDouble(i);
                if (!(elem > max2)) continue;
                max2 = elem;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double max2 = a.getDouble(firstIdx);
                        for (long k = firstIdx + 1L; k < lastIdx; ++k) {
                            double elem = a.getDouble(k);
                            if (!(elem > max2)) continue;
                            max2 = elem;
                        }
                        return max2;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double res = (Double)threads[j].get();
                    if (!(res > max2)) continue;
                    max2 = res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 1L; i < length; ++i) {
                    double elem = a.getDouble(i);
                    if (!(elem > max2)) continue;
                    max2 = elem;
                }
            }
        }
        return max2;
    }

    public static double sum(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return (double)a.length() * a.getDouble(0L);
        }
        double sum2 = 0.0;
        long length = a.length();
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 0L; i < length; ++i) {
                sum2 += a.getDouble(i);
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double sum2 = 0.0;
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            sum2 += a.getDouble(k);
                        }
                        return sum2;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double res = (Double)threads[j].get();
                    sum2 += res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 0L; i < length; ++i) {
                    sum2 += a.getDouble(i);
                }
            }
        }
        return sum2;
    }

    public static double sumKahan(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return (double)a.length() * a.getDouble(0L);
        }
        double sum2 = 0.0;
        double c = 0.0;
        long length = a.length();
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 0L; i < length; ++i) {
                double y = a.getDouble(i) - c;
                double t = sum2 + y;
                c = t - sum2 - y;
                sum2 = t;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double sum2 = 0.0;
                        double c = 0.0;
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            double y = a.getDouble(k) - c;
                            double t = sum2 + y;
                            c = t - sum2 - y;
                            sum2 = t;
                        }
                        return sum2;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double res = (Double)threads[j].get();
                    sum2 += res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 0L; i < length; ++i) {
                    double y = a.getDouble(i) - c;
                    double t = sum2 + y;
                    c = t - sum2 - y;
                    sum2 = t;
                }
            }
        }
        return sum2;
    }

    public static double avg(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return a.getDouble(0L);
        }
        double sum2 = 0.0;
        long length = a.length();
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 0L; i < length; ++i) {
                sum2 += a.getDouble(i);
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double sum2 = 0.0;
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            sum2 += a.getDouble(k);
                        }
                        return sum2;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double res = (Double)threads[j].get();
                    sum2 += res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 0L; i < length; ++i) {
                    sum2 += a.getDouble(i);
                }
            }
        }
        return sum2 / (double)length;
    }

    public static double avgKahan(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return a.getDouble(0L);
        }
        double sum2 = 0.0;
        double c = 0.0;
        long length = a.length();
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 0L; i < length; ++i) {
                double y = a.getDouble(i) - c;
                double t = sum2 + y;
                c = t - sum2 - y;
                sum2 = t;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() {
                        double sum2 = 0.0;
                        double c = 0.0;
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            double y = a.getDouble(k) - c;
                            double t = sum2 + y;
                            c = t - sum2 - y;
                            sum2 = t;
                        }
                        return sum2;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double res = (Double)threads[j].get();
                    sum2 += res;
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 0L; i < length; ++i) {
                    double y = a.getDouble(i) - c;
                    double t = sum2 + y;
                    c = t - sum2 - y;
                    sum2 = t;
                }
            }
        }
        return sum2 / (double)length;
    }

    public static double std(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return 0.0;
        }
        double sum2 = 0.0;
        double sum22 = 0.0;
        double c1 = 0.0;
        double c2 = 0.0;
        long length = a.length();
        if (length < 2L) {
            return Double.NaN;
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 0L; i < length; ++i) {
                double elem = a.getDouble(i);
                double y = elem - c1;
                double t = sum2 + y;
                c1 = t - sum2 - y;
                sum2 = t;
                double y2 = elem * elem - c2;
                double t2 = sum22 + y2;
                c2 = t2 - sum22 - y2;
                sum22 = t2;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() {
                        double[] sum2 = new double[2];
                        double c1 = 0.0;
                        double c2 = 0.0;
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            double elem = a.getDouble(k);
                            double y = elem - c1;
                            double t = sum2[0] + y;
                            c1 = t - sum2[0] - y;
                            sum2[0] = t;
                            double y2 = elem * elem - c2;
                            double t2 = sum2[1] + y2;
                            c2 = t2 - sum2[1] - y2;
                            sum2[1] = t2;
                        }
                        return sum2;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double[] res = (double[])threads[j].get();
                    sum2 += res[0];
                    sum22 += res[1];
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 0L; i < length; ++i) {
                    double elem = a.getDouble(i);
                    double y = elem - c1;
                    double t = sum2 + y;
                    c1 = t - sum2 - y;
                    sum2 = t;
                    double y2 = elem * elem - c2;
                    double t2 = sum22 + y2;
                    c2 = t2 - sum22 - y2;
                    sum22 = t2;
                }
            }
        }
        return FastMath.sqrt(FastMath.max(0.0, (sum22 /= (double)length) - (sum2 /= (double)length) * sum2));
    }

    public static double stdKahan(final LargeArray a) {
        if (a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (a.isConstant()) {
            return 0.0;
        }
        double sum2 = 0.0;
        double sum22 = 0.0;
        long length = a.length();
        if (length < 2L) {
            return Double.NaN;
        }
        int nthreads = (int)FastMath.min(length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i = 0L; i < length; ++i) {
                double elem = a.getDouble(i);
                sum2 += elem;
                sum22 += elem * elem;
            }
        } else {
            int j;
            long k = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (j = 0; j < nthreads; ++j) {
                final long firstIdx = (long)j * k;
                final long lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                threads[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() {
                        double[] sum2 = new double[2];
                        for (long k = firstIdx; k < lastIdx; ++k) {
                            double elem = a.getDouble(k);
                            sum2[0] = sum2[0] + elem;
                            sum2[1] = sum2[1] + elem * elem;
                        }
                        return sum2;
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
                for (j = 0; j < nthreads; ++j) {
                    double[] res = (double[])threads[j].get();
                    sum2 += res[0];
                    sum22 += res[1];
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i = 0L; i < length; ++i) {
                    double elem = a.getDouble(i);
                    sum2 += elem;
                    sum22 += elem * elem;
                }
            }
        }
        return FastMath.sqrt(FastMath.max(0.0, (sum22 /= (double)length) - (sum2 /= (double)length) * sum2));
    }
}

