/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.series;

import org.knowm.xchart.internal.series.MarkerSeries;
import org.knowm.xchart.internal.series.Series;

public abstract class AxesChartSeriesNumericalNoErrorBars
extends MarkerSeries {
    double[] xData;
    double[] yData;
    double[] extraValues;

    public AxesChartSeriesNumericalNoErrorBars(String name, double[] xData, double[] yData, double[] extraValues, Series.DataType xAxisDataType) {
        super(name, xAxisDataType);
        this.xData = xData;
        this.yData = yData;
        this.extraValues = extraValues;
        this.calculateMinMax();
    }

    public void replaceData(double[] newXData, double[] newYData, double[] newExtraValues) {
        if (newExtraValues != null && newExtraValues.length != newYData.length) {
            throw new IllegalArgumentException("error bars and Y-Axis sizes are not the same!!!");
        }
        if (newXData.length != newYData.length) {
            throw new IllegalArgumentException("X and Y-Axis sizes are not the same!!!");
        }
        this.xData = newXData;
        this.yData = newYData;
        this.extraValues = newExtraValues;
        this.calculateMinMax();
    }

    double[] findMinMax(double[] data) {
        double min2 = Double.MAX_VALUE;
        double max2 = -1.7976931348623157E308;
        for (double dataPoint : data) {
            if (Double.isNaN(dataPoint)) continue;
            if (dataPoint < min2) {
                min2 = dataPoint;
            }
            if (!(dataPoint > max2)) continue;
            max2 = dataPoint;
        }
        return new double[]{min2, max2};
    }

    @Override
    protected void calculateMinMax() {
        double[] xMinMax = this.findMinMax(this.xData);
        this.xMin = xMinMax[0];
        this.xMax = xMinMax[1];
        double[] yMinMax = this.extraValues == null ? this.findMinMax(this.yData) : this.findMinMaxWithErrorBars(this.yData, this.extraValues);
        this.yMin = yMinMax[0];
        this.yMax = yMinMax[1];
    }

    private double[] findMinMaxWithErrorBars(double[] data, double[] errorBars) {
        double min2 = Double.MAX_VALUE;
        double max2 = -1.7976931348623157E308;
        for (int i = 0; i < data.length; ++i) {
            double d = data[i];
            double eb = errorBars[i];
            if (d - eb < min2) {
                min2 = d - eb;
            }
            if (!(d + eb > max2)) continue;
            max2 = d + eb;
        }
        return new double[]{min2, max2};
    }

    public double[] getXData() {
        return this.xData;
    }

    public double[] getYData() {
        return this.yData;
    }

    public double[] getExtraValues() {
        return this.extraValues;
    }
}

