/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.knowm.xchart.internal.Utils;
import org.knowm.xchart.internal.chartpart.Axis;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_;
import org.knowm.xchart.style.AxesChartStyler;

class AxisTickCalculator_Date
extends AxisTickCalculator_ {
    private static final long MILLIS_SCALE = TimeUnit.MILLISECONDS.toMillis(1L);
    private static final long SEC_SCALE = TimeUnit.SECONDS.toMillis(1L);
    private static final long MIN_SCALE = TimeUnit.MINUTES.toMillis(1L);
    private static final long HOUR_SCALE = TimeUnit.HOURS.toMillis(1L);
    private static final long DAY_SCALE = TimeUnit.DAYS.toMillis(1L);
    private static final long MONTH_SCALE = TimeUnit.DAYS.toMillis(1L) * 30L;
    private static final long YEAR_SCALE = TimeUnit.DAYS.toMillis(1L) * 365L;
    private static final List<TimeSpan> timeSpans = new ArrayList<TimeSpan>();

    public AxisTickCalculator_Date(Axis.Direction axisDirection, double workingSpace, double minValue, double maxValue, AxesChartStyler styler) {
        super(axisDirection, workingSpace, minValue, maxValue, styler);
        this.calculate();
    }

    private void calculate() {
        int gridStepInChartSpace;
        double tickSpace = this.styler.getPlotContentSize() * this.workingSpace;
        if (tickSpace < (double)this.styler.getXAxisTickMarkSpacingHint()) {
            return;
        }
        double margin = Utils.getTickStartOffset(this.workingSpace, tickSpace);
        long span = (long)Math.abs(this.maxValue - this.minValue);
        int tickSpacingHint = this.styler.getXAxisTickMarkSpacingHint();
        long gridStepHint = (long)((double)span / tickSpace * (double)tickSpacingHint);
        int index = 0;
        for (int i = 0; i < timeSpans.size() - 1; ++i) {
            if (!((double)span < (double)(timeSpans.get(i).getUnitAmount() * (long)timeSpans.get(i).getMagnitude() + timeSpans.get(i + 1).getUnitAmount() * (long)timeSpans.get(i + 1).getMagnitude()) / 2.0)) continue;
            index = i;
            break;
        }
        String datePattern = timeSpans.get(index).getDatePattern();
        for (int i = index - 1; i > 0; --i) {
            if (gridStepHint <= timeSpans.get(i).getUnitAmount() * (long)timeSpans.get(i).getMagnitude()) continue;
            index = i;
            break;
        }
        --index;
        do {
            this.tickLabels.clear();
            this.tickLocations.clear();
            double gridStep = timeSpans.get(++index).getUnitAmount() * (long)timeSpans.get(index).getMagnitude();
            gridStepInChartSpace = (int)(gridStep / (double)span * tickSpace);
            double firstPosition = this.getFirstPosition(gridStep);
            if (this.styler.getDatePattern() != null) {
                datePattern = this.styler.getDatePattern();
            }
            SimpleDateFormat simpleDateformat = new SimpleDateFormat(datePattern, this.styler.getLocale());
            simpleDateformat.setTimeZone(this.styler.getTimezone());
            this.axisFormat = simpleDateformat;
            for (double value2 = firstPosition; value2 <= this.maxValue + 2.0 * gridStep; value2 += gridStep) {
                this.tickLabels.add(this.axisFormat.format(value2));
                double tickLabelPosition = margin + (value2 - this.minValue) / (this.maxValue - this.minValue) * tickSpace;
                this.tickLocations.add(tickLabelPosition);
            }
        } while (!this.willLabelsFitInTickSpaceHint(this.tickLabels, gridStepInChartSpace));
    }

    static {
        timeSpans.add(new TimeSpan(MILLIS_SCALE, 1, "ss.SSS"));
        timeSpans.add(new TimeSpan(MILLIS_SCALE, 2, "ss.SSS"));
        timeSpans.add(new TimeSpan(MILLIS_SCALE, 5, "ss.SSS"));
        timeSpans.add(new TimeSpan(MILLIS_SCALE, 10, "ss.SSS"));
        timeSpans.add(new TimeSpan(MILLIS_SCALE, 50, "ss.SS"));
        timeSpans.add(new TimeSpan(MILLIS_SCALE, 100, "ss.SS"));
        timeSpans.add(new TimeSpan(MILLIS_SCALE, 200, "ss.SS"));
        timeSpans.add(new TimeSpan(MILLIS_SCALE, 500, "ss.SS"));
        timeSpans.add(new TimeSpan(SEC_SCALE, 1, "ss.SS"));
        timeSpans.add(new TimeSpan(SEC_SCALE, 2, "ss.S"));
        timeSpans.add(new TimeSpan(SEC_SCALE, 5, "ss.S"));
        timeSpans.add(new TimeSpan(SEC_SCALE, 10, "HH:mm:ss"));
        timeSpans.add(new TimeSpan(SEC_SCALE, 15, "HH:mm:ss"));
        timeSpans.add(new TimeSpan(SEC_SCALE, 20, "HH:mm:ss"));
        timeSpans.add(new TimeSpan(SEC_SCALE, 30, "HH:mm:ss"));
        timeSpans.add(new TimeSpan(MIN_SCALE, 1, "HH:mm:ss"));
        timeSpans.add(new TimeSpan(MIN_SCALE, 2, "HH:mm:ss"));
        timeSpans.add(new TimeSpan(MIN_SCALE, 5, "HH:mm:ss"));
        timeSpans.add(new TimeSpan(MIN_SCALE, 10, "HH:mm"));
        timeSpans.add(new TimeSpan(MIN_SCALE, 15, "HH:mm"));
        timeSpans.add(new TimeSpan(MIN_SCALE, 20, "HH:mm"));
        timeSpans.add(new TimeSpan(MIN_SCALE, 30, "HH:mm"));
        timeSpans.add(new TimeSpan(HOUR_SCALE, 1, "HH:mm"));
        timeSpans.add(new TimeSpan(HOUR_SCALE, 2, "HH:mm"));
        timeSpans.add(new TimeSpan(HOUR_SCALE, 4, "HH:mm"));
        timeSpans.add(new TimeSpan(HOUR_SCALE, 8, "HH:mm"));
        timeSpans.add(new TimeSpan(HOUR_SCALE, 12, "HH:mm"));
        timeSpans.add(new TimeSpan(DAY_SCALE, 1, "EEE HH:mm"));
        timeSpans.add(new TimeSpan(DAY_SCALE, 2, "EEE HH:mm"));
        timeSpans.add(new TimeSpan(DAY_SCALE, 3, "EEE HH:mm"));
        timeSpans.add(new TimeSpan(DAY_SCALE, 5, "MM-dd"));
        timeSpans.add(new TimeSpan(DAY_SCALE, 10, "MM-dd"));
        timeSpans.add(new TimeSpan(DAY_SCALE, 15, "MM-dd"));
        timeSpans.add(new TimeSpan(MONTH_SCALE, 1, "MM-dd"));
        timeSpans.add(new TimeSpan(MONTH_SCALE, 2, "MM-dd"));
        timeSpans.add(new TimeSpan(MONTH_SCALE, 3, "MM-dd"));
        timeSpans.add(new TimeSpan(MONTH_SCALE, 4, "MM-dd"));
        timeSpans.add(new TimeSpan(MONTH_SCALE, 6, "yyyy-MM"));
        timeSpans.add(new TimeSpan(YEAR_SCALE, 1, "yyyy-MM"));
        timeSpans.add(new TimeSpan(YEAR_SCALE, 2, "yyyy-MM"));
        timeSpans.add(new TimeSpan(YEAR_SCALE, 5, "yyyy"));
        timeSpans.add(new TimeSpan(YEAR_SCALE, 10, "yyyy"));
        timeSpans.add(new TimeSpan(YEAR_SCALE, 20, "yyyy"));
        timeSpans.add(new TimeSpan(YEAR_SCALE, 100, "yyyy"));
        timeSpans.add(new TimeSpan(YEAR_SCALE, 500, "yyyy"));
        timeSpans.add(new TimeSpan(YEAR_SCALE, 1000, "yyyy"));
    }

    static class TimeSpan {
        private final long unitAmount;
        private final int magnitude;
        private final String datePattern;

        public TimeSpan(long unitAmount, int magnitude, String datePattern) {
            this.unitAmount = unitAmount;
            this.magnitude = magnitude;
            this.datePattern = datePattern;
        }

        public long getUnitAmount() {
            return this.unitAmount;
        }

        public int getMagnitude() {
            return this.magnitude;
        }

        public String getDatePattern() {
            return this.datePattern;
        }

        public String toString() {
            return "TimeSpan [unitAmount=" + this.unitAmount + ", magnitude=" + this.magnitude + ", datePattern=" + this.datePattern + "]";
        }
    }
}

