/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart.internal.chartpart;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import java.util.Map;
import org.knowm.xchart.internal.chartpart.AxisTick;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_Category;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_Date;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_Logarithmic;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_Number;
import org.knowm.xchart.internal.chartpart.AxisTickCalculator_Override;
import org.knowm.xchart.internal.chartpart.AxisTitle;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartPart;
import org.knowm.xchart.internal.series.AxesChartSeries;
import org.knowm.xchart.internal.series.AxesChartSeriesCategory;
import org.knowm.xchart.internal.series.Series;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.Styler;

public class Axis<ST extends AxesChartStyler, S extends AxesChartSeries>
implements ChartPart {
    private final Chart<ST, S> chart;
    private final Rectangle2D.Double bounds;
    private final ST axesChartStyler;
    private final AxisTitle<ST, S> axisTitle;
    private final AxisTick<ST, S> axisTick;
    private final Direction direction;
    private final int yIndex;
    private Series.DataType dataType;
    private AxisTickCalculator_ axisTickCalculator;
    private double min;
    private double max;

    public Axis(Chart<ST, S> chart, Direction direction, int yIndex) {
        this.chart = chart;
        this.axesChartStyler = (AxesChartStyler)chart.getStyler();
        this.direction = direction;
        this.yIndex = yIndex;
        this.bounds = new Rectangle2D.Double();
        this.axisTitle = new AxisTitle<ST, S>(chart, direction, direction == Direction.Y ? this : null, yIndex);
        this.axisTick = new AxisTick<ST, S>(chart, direction, direction == Direction.Y ? this : null);
    }

    void resetMinMax() {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
    }

    void addMinMax(double min2, double max2) {
        if (Double.isNaN(this.min) || min2 < this.min) {
            this.min = min2;
        }
        if (Double.isNaN(this.max) || max2 > this.max) {
            this.max = max2;
        }
    }

    public void preparePaint() {
        if (this.direction == Direction.Y) {
            double height;
            double xOffset = 0.0;
            double yOffset = this.chart.getChartTitle().getBounds().getHeight() + (double)((Styler)this.axesChartStyler).getChartPadding();
            int i = 1;
            double width = 60.0;
            do {
                double approximateXAxisWidth = (double)this.chart.getWidth() - width - (((Styler)this.axesChartStyler).getLegendPosition() == Styler.LegendPosition.OutsideE ? this.chart.getLegend().getBounds().getWidth() : 0.0) - (double)(2 * ((Styler)this.axesChartStyler).getChartPadding()) - (double)(((AxesChartStyler)this.axesChartStyler).isYAxisTicksVisible() ? ((AxesChartStyler)this.axesChartStyler).getPlotMargin() : 0) - (double)(((Styler)this.axesChartStyler).getLegendPosition() == Styler.LegendPosition.OutsideE && ((Styler)this.axesChartStyler).isLegendVisible() ? ((Styler)this.axesChartStyler).getChartPadding() : 0);
                height = (double)this.chart.getHeight() - yOffset - this.chart.getXAxis().getXAxisHeightHint(approximateXAxisWidth) - (double)((AxesChartStyler)this.axesChartStyler).getPlotMargin() - (double)((Styler)this.axesChartStyler).getChartPadding() - (((Styler)this.axesChartStyler).getLegendPosition() == Styler.LegendPosition.OutsideS ? this.chart.getLegend().getBounds().getHeight() : 0.0);
                width = this.getYAxisWidthHint(height);
            } while (i-- > 0);
            this.bounds.setRect(xOffset, yOffset, width, height);
        } else {
            Rectangle2D.Double leftYAxisBounds = this.chart.getAxisPair().getLeftYAxisBounds();
            Rectangle2D.Double rightYAxisBounds = this.chart.getAxisPair().getRightYAxisBounds();
            double maxYAxisY = Math.max(((RectangularShape)leftYAxisBounds).getY() + ((RectangularShape)leftYAxisBounds).getHeight(), ((RectangularShape)rightYAxisBounds).getY() + ((RectangularShape)rightYAxisBounds).getHeight());
            double xOffset = ((RectangularShape)leftYAxisBounds).getWidth() + (double)((Styler)this.axesChartStyler).getChartPadding();
            double yOffset = maxYAxisY + (double)((AxesChartStyler)this.axesChartStyler).getPlotMargin() - (((Styler)this.axesChartStyler).getLegendPosition() == Styler.LegendPosition.OutsideS ? this.chart.getLegend().getBounds().getHeight() : 0.0);
            double legendWidth = 0.0;
            if (((Styler)this.axesChartStyler).getLegendPosition() == Styler.LegendPosition.OutsideE && ((Styler)this.axesChartStyler).isLegendVisible()) {
                legendWidth = this.chart.getLegend().getBounds().getWidth() + (double)((Styler)this.axesChartStyler).getChartPadding();
            }
            double width = (double)this.chart.getWidth() - ((RectangularShape)leftYAxisBounds).getWidth() - ((RectangularShape)rightYAxisBounds).getWidth() - (double)(2 * ((Styler)this.axesChartStyler).getChartPadding()) - legendWidth;
            double height = (double)this.chart.getHeight() - maxYAxisY - (double)((Styler)this.axesChartStyler).getChartPadding() - (double)((AxesChartStyler)this.axesChartStyler).getPlotMargin();
            this.bounds.setRect(xOffset, yOffset, width, height);
        }
    }

    @Override
    public void paint(Graphics2D g) {
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.direction == Direction.Y) {
            double width;
            boolean onRight;
            boolean bl = onRight = ((Styler)this.axesChartStyler).getYAxisGroupPosistion(this.yIndex) == Styler.YAxisPosition.Right;
            if (onRight) {
                this.axisTick.paint(g);
                this.axisTitle.paint(g);
            } else {
                this.axisTitle.paint(g);
                this.axisTick.paint(g);
            }
            this.bounds.width = width = (((AxesChartStyler)this.axesChartStyler).isYAxisTitleVisible() ? this.axisTitle.getBounds().getWidth() : 0.0) + this.axisTick.getBounds().getWidth();
        } else {
            this.axisTickCalculator = this.getAxisTickCalculator(this.bounds.getWidth());
            this.axisTitle.paint(g);
            this.axisTick.paint(g);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    private double getXAxisHeightHint(double workingSpace) {
        double titleHeight = 0.0;
        if (this.chart.getXAxisTitle() != null && !this.chart.getXAxisTitle().trim().equalsIgnoreCase("") && ((AxesChartStyler)this.axesChartStyler).isXAxisTitleVisible()) {
            TextLayout textLayout = new TextLayout(this.chart.getXAxisTitle(), ((AxesChartStyler)this.axesChartStyler).getAxisTitleFont(), new FontRenderContext(null, true, false));
            Rectangle2D rectangle = textLayout.getBounds();
            titleHeight = rectangle.getHeight() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTitlePadding();
        }
        this.axisTickCalculator = this.getAxisTickCalculator(workingSpace);
        double axisTickLabelsHeight = 0.0;
        if (((AxesChartStyler)this.axesChartStyler).isXAxisTicksVisible()) {
            String sampleLabel = "";
            for (int i = 0; i < this.axisTickCalculator.getTickLabels().size(); ++i) {
                if (this.axisTickCalculator.getTickLabels().get(i) == null || this.axisTickCalculator.getTickLabels().get(i).length() <= sampleLabel.length()) continue;
                sampleLabel = this.axisTickCalculator.getTickLabels().get(i);
            }
            TextLayout textLayout = new TextLayout(sampleLabel.length() == 0 ? " " : sampleLabel, ((AxesChartStyler)this.axesChartStyler).getAxisTickLabelsFont(), new FontRenderContext(null, true, false));
            AffineTransform rot = ((AxesChartStyler)this.axesChartStyler).getXAxisLabelRotation() == 0 ? null : AffineTransform.getRotateInstance(-1.0 * Math.toRadians(((AxesChartStyler)this.axesChartStyler).getXAxisLabelRotation()));
            Shape shape = textLayout.getOutline(rot);
            Rectangle rectangle = shape.getBounds();
            axisTickLabelsHeight = ((RectangularShape)rectangle).getHeight() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTickPadding() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTickMarkLength();
        }
        return titleHeight + axisTickLabelsHeight;
    }

    private double getYAxisWidthHint(double workingSpace) {
        double titleHeight = 0.0;
        String yAxisTitle = this.chart.getYAxisGroupTitle(this.yIndex);
        if (yAxisTitle != null && !yAxisTitle.trim().equalsIgnoreCase("") && ((AxesChartStyler)this.axesChartStyler).isYAxisTitleVisible()) {
            TextLayout textLayout = new TextLayout(yAxisTitle, ((AxesChartStyler)this.axesChartStyler).getAxisTitleFont(), new FontRenderContext(null, true, false));
            Rectangle2D rectangle = textLayout.getBounds();
            titleHeight = rectangle.getHeight() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTitlePadding();
        }
        this.axisTickCalculator = this.getAxisTickCalculator(workingSpace);
        double axisTickLabelsHeight = 0.0;
        if (((AxesChartStyler)this.axesChartStyler).isYAxisTicksVisible()) {
            String sampleLabel = "";
            for (int i = 0; i < this.axisTickCalculator.getTickLabels().size(); ++i) {
                if (this.axisTickCalculator.getTickLabels().get(i) == null || this.axisTickCalculator.getTickLabels().get(i).length() <= sampleLabel.length()) continue;
                sampleLabel = this.axisTickCalculator.getTickLabels().get(i);
            }
            TextLayout textLayout = new TextLayout(sampleLabel.length() == 0 ? " " : sampleLabel, ((AxesChartStyler)this.axesChartStyler).getAxisTickLabelsFont(), new FontRenderContext(null, true, false));
            Rectangle2D rectangle = textLayout.getBounds();
            axisTickLabelsHeight = rectangle.getWidth() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTickPadding() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTickMarkLength();
        }
        return titleHeight + axisTickLabelsHeight;
    }

    private AxisTickCalculator_ getAxisTickCalculator(double workingSpace) {
        Map<Double, Object> labelOverrideMap = this.chart.getYAxisLabelOverrideMap(this.getDirection(), this.yIndex);
        if (labelOverrideMap != null) {
            if (this.getDirection() == Direction.X && this.axesChartStyler instanceof CategoryStyler) {
                AxesChartSeriesCategory axesChartSeries = (AxesChartSeriesCategory)this.chart.getSeriesMap().values().iterator().next();
                List categories = (List)axesChartSeries.getXData();
                Series.DataType axisType = this.chart.getAxisPair().getXAxis().getDataType();
                return new AxisTickCalculator_Override(this.getDirection(), workingSpace, (AxesChartStyler)this.axesChartStyler, labelOverrideMap, axisType, categories.size());
            }
            return new AxisTickCalculator_Override(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler, labelOverrideMap);
        }
        if (this.getDirection() == Direction.X) {
            if (this.axesChartStyler instanceof CategoryStyler) {
                AxesChartSeriesCategory axesChartSeries = (AxesChartSeriesCategory)this.chart.getSeriesMap().values().iterator().next();
                List categories = (List)axesChartSeries.getXData();
                Series.DataType axisType = this.chart.getAxisPair().getXAxis().getDataType();
                return new AxisTickCalculator_Category(this.getDirection(), workingSpace, categories, axisType, (AxesChartStyler)this.axesChartStyler);
            }
            if (this.getDataType() == Series.DataType.Date) {
                return new AxisTickCalculator_Date(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
            }
            if (((AxesChartStyler)this.axesChartStyler).isXAxisLogarithmic()) {
                return new AxisTickCalculator_Logarithmic(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
            }
            return new AxisTickCalculator_Number(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
        }
        if (((AxesChartStyler)this.axesChartStyler).isYAxisLogarithmic() && this.getDataType() != Series.DataType.Date) {
            return new AxisTickCalculator_Logarithmic(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
        }
        return new AxisTickCalculator_Number(this.getDirection(), workingSpace, this.min, this.max, (AxesChartStyler)this.axesChartStyler);
    }

    Series.DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(Series.DataType dataType) {
        if (dataType != null && this.dataType != null && this.dataType != dataType) {
            throw new IllegalArgumentException("Different Axes (e.g. Date, Number, String) cannot be mixed on the same chart!!");
        }
        this.dataType = dataType;
    }

    double getMin() {
        return this.min;
    }

    void setMin(double min2) {
        this.min = min2;
    }

    double getMax() {
        return this.max;
    }

    void setMax(double max2) {
        this.max = max2;
    }

    AxisTick<ST, S> getAxisTick() {
        return this.axisTick;
    }

    private Direction getDirection() {
        return this.direction;
    }

    AxisTitle<ST, S> getAxisTitle() {
        return this.axisTitle;
    }

    public AxisTickCalculator_ getAxisTickCalculator() {
        return this.axisTickCalculator;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public int getYIndex() {
        return this.yIndex;
    }

    public static enum Direction {
        X,
        Y;

    }
}

