/*
 * Decompiled with CFR 0.152.
 */
package io.citrine.lolo.stats;

import breeze.stats.distributions.RandBasis;
import breeze.stats.distributions.ThreadLocalRandomGenerator;
import io.citrine.random.Random;
import java.io.Serializable;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.BuildFrom$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.math.Numeric$DoubleIsFractional$;
import scala.math.Ordering$DeprecatedDoubleOrdering$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class StatsUtils$ {
    public static final StatsUtils$ MODULE$ = new StatsUtils$();

    public double range(Seq<Object> X) {
        return X.nonEmpty() ? BoxesRunTime.unboxToDouble(X.max(Ordering$DeprecatedDoubleOrdering$.MODULE$)) - BoxesRunTime.unboxToDouble(X.min(Ordering$DeprecatedDoubleOrdering$.MODULE$)) : 0.0;
    }

    public double mean(Seq<Object> X, Option<Seq<Object>> weights) {
        Seq actualWeights = (Seq)weights.getOrElse((Function0<Seq> & Serializable)() -> (Seq)scala.package$.MODULE$.Seq().fill(X.length(), () -> 1.0));
        double totalWeight = BoxesRunTime.unboxToDouble(actualWeights.sum(Numeric$DoubleIsFractional$.MODULE$));
        Predef$.MODULE$.require(totalWeight > 0.0, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(43).append("total weight must be positive, instead got ").append(totalWeight).toString());
        return BoxesRunTime.unboxToDouble(((IterableOnceOps)((IterableOps)X.zip(actualWeights)).map((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToDouble(StatsUtils$.$anonfun$mean$4(x0$1)))).sum(Numeric$DoubleIsFractional$.MODULE$)) / totalWeight;
    }

    public Option<Seq<Object>> mean$default$2() {
        return None$.MODULE$;
    }

    public double variance(Seq<Object> X, Option<Seq<Object>> weights, int dof) {
        Seq actualWeights = (Seq)weights.getOrElse((Function0<Seq> & Serializable)() -> (Seq)scala.package$.MODULE$.Seq().fill(X.length(), () -> 1.0));
        double totalWeight = BoxesRunTime.unboxToDouble(actualWeights.sum(Numeric$DoubleIsFractional$.MODULE$));
        Predef$.MODULE$.require(dof >= 0, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(53).append("degrees of freedom must be non-negative, instead got ").append(dof).toString());
        Predef$.MODULE$.require(totalWeight > (double)dof, (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(74).append("Cannot compute variance on a sequence of weight ").append(totalWeight).append(" with ").append(dof).append(" degrees of freedom.").toString());
        double mu = this.mean(X, new Some<Seq<Object>>(actualWeights));
        return BoxesRunTime.unboxToDouble(((IterableOnceOps)((IterableOps)X.zip(actualWeights)).map((Function1<Tuple2, Object> & Serializable)x0$1 -> BoxesRunTime.boxToDouble(StatsUtils$.$anonfun$variance$5(mu, x0$1)))).sum(Numeric$DoubleIsFractional$.MODULE$)) / (totalWeight - (double)dof);
    }

    public Option<Seq<Object>> variance$default$2() {
        return None$.MODULE$;
    }

    public int variance$default$3() {
        return 0;
    }

    public double covariance(Seq<Object> X, Seq<Object> Y, Option<Seq<Object>> weights) {
        Predef$.MODULE$.require(X.length() == Y.length(), (Function0<Object>)(Function0<String> & Serializable)() -> new StringBuilder(85).append("Cannot compute covariance between sequences of different lengths (lengths are ").append(X.length()).append(" and ").append(Y.length()).append(").").toString());
        Seq actualWeights = (Seq)weights.getOrElse((Function0<Seq> & Serializable)() -> (Seq)scala.package$.MODULE$.Seq().fill(X.length(), () -> 1.0));
        double totalWeight = BoxesRunTime.unboxToDouble(actualWeights.sum(Numeric$DoubleIsFractional$.MODULE$));
        double muX = this.mean(X, new Some<Seq<Object>>(actualWeights));
        double muY = this.mean(Y, new Some<Seq<Object>>(actualWeights));
        return BoxesRunTime.unboxToDouble(((IterableOnceOps)X.lazyZip(Y).lazyZip(actualWeights).map((Function3<Object, Object, Object, Object> & Serializable)(x0$1, x1$1, x2$1) -> BoxesRunTime.boxToDouble(StatsUtils$.$anonfun$covariance$4(muX, muY, BoxesRunTime.unboxToDouble(x0$1), BoxesRunTime.unboxToDouble(x1$1), BoxesRunTime.unboxToDouble(x2$1))), BuildFrom$.MODULE$.buildFromIterableOps())).sum(Numeric$DoubleIsFractional$.MODULE$)) / totalWeight;
    }

    public Option<Seq<Object>> covariance$default$3() {
        return None$.MODULE$;
    }

    public double correlation(Seq<Object> X, Seq<Object> Y, Option<Seq<Object>> weights) {
        Seq actualWeights = (Seq)weights.getOrElse((Function0<Seq> & Serializable)() -> (Seq)scala.package$.MODULE$.Seq().fill(X.length(), () -> 1.0));
        double sigma2X = this.variance(X, new Some<Seq<Object>>(actualWeights), 0);
        double sigma2Y = this.variance(Y, new Some<Seq<Object>>(actualWeights), 0);
        if (sigma2X == 0.0 || sigma2Y == 0.0) {
            return 0.0;
        }
        return this.covariance(X, Y, new Some<Seq<Object>>(actualWeights)) / package$.MODULE$.sqrt(sigma2X * sigma2Y);
    }

    public Option<Seq<Object>> correlation$default$3() {
        return None$.MODULE$;
    }

    public RandBasis breezeRandBasis(Random rng) {
        return new RandBasis(new ThreadLocalRandomGenerator((Function0<RandomGenerator>)(Function0<MersenneTwister> & Serializable)() -> new MersenneTwister(rng.nextLong())));
    }

    public static final /* synthetic */ double $anonfun$mean$4(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double x = tuple2._1$mcD$sp();
        double w = tuple2._2$mcD$sp();
        double d = x * w;
        return d;
    }

    public static final /* synthetic */ double $anonfun$variance$5(double mu$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double x = tuple2._1$mcD$sp();
        double w = tuple2._2$mcD$sp();
        double d = package$.MODULE$.pow(x - mu$1, 2.0) * w;
        return d;
    }

    public static final /* synthetic */ double $anonfun$covariance$4(double muX$1, double muY$1, double x0$1, double x1$1, double x2$1) {
        Tuple3<Double, Double, Double> tuple3 = new Tuple3<Double, Double, Double>(BoxesRunTime.boxToDouble(x0$1), BoxesRunTime.boxToDouble(x1$1), BoxesRunTime.boxToDouble(x2$1));
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        double x = BoxesRunTime.unboxToDouble(tuple3._1());
        double y = BoxesRunTime.unboxToDouble(tuple3._2());
        double w = BoxesRunTime.unboxToDouble(tuple3._3());
        double d = (x - muX$1) * (y - muY$1) * w;
        return d;
    }

    private StatsUtils$() {
    }
}

