/*
 * Decompiled with CFR 0.152.
 */
package breeze.signal.support;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector;
import breeze.linalg.operators.HasOps$;
import breeze.numerics.package$isOdd$;
import breeze.signal.OptOverhang;
import breeze.signal.OptOverhang$None$;
import breeze.signal.OptOverhang$PreserveLength$;
import breeze.signal.support.CanFilterMedian;
import breeze.stats.median$;
import breeze.util.quickSelectImpl$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class CanFilterMedian$ {
    public static final CanFilterMedian$ MODULE$ = new CanFilterMedian$();

    public CanFilterMedian<Object> dvFilterMedianT_Int() {
        return new CanFilterMedian<Object>(){

            public DenseVector<Object> apply(DenseVector<Object> data, int windowLength, OptOverhang overhang) {
                Vector vector;
                Predef$.MODULE$.require(BoxesRunTime.unboxToBoolean(package$isOdd$.MODULE$.apply(BoxesRunTime.boxToInteger(windowLength), package$isOdd$.MODULE$.isOddImpl_Int())), (Function0<Object>)(Function0<String> & Serializable)() -> "median filter can only take odd windowLength values, since even values will cause a half-frame time shift");
                Predef$.MODULE$.require(data.length() >= 3, (Function0<Object>)(Function0<String> & Serializable)() -> "data must be longer than 3");
                Predef$.MODULE$.require(windowLength >= 1, (Function0<Object>)(Function0<String> & Serializable)() -> "window length must be longer than 1");
                if (windowLength == 1) {
                    vector = data.copy$mcI$sp();
                } else {
                    Vector vector2;
                    int currentMedian;
                    BoxedUnit boxedUnit;
                    int halfWindow;
                    ObjectRef<int[]> tempret = ObjectRef.create(new int[data.length()]);
                    int index = halfWindow = (windowLength - 1) / 2;
                    OptOverhang optOverhang = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang)) {
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp(indexFromBeginning -> {
                            ((int[])tempret$1.elem)[indexFromBeginning] = BoxesRunTime.unboxToInt(median$.MODULE$.apply(data.apply(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), indexFromBeginning * 2), HasOps$.MODULE$.canSlice_DV_Range_eq_DV()), median$.MODULE$.reduce(ClassTag$.MODULE$.Int(), median$.MODULE$.reduceArray_Int())));
                        });
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp(indexToEnd -> {
                            ((int[])tempret$1.elem)[data$1.length() - indexToEnd - 1] = BoxesRunTime.unboxToInt(median$.MODULE$.apply(data.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(data.length() - 2 * indexToEnd - 1), data.length()), HasOps$.MODULE$.canSlice_DV_Range_eq_DV()), median$.MODULE$.reduce(ClassTag$.MODULE$.Int(), median$.MODULE$.reduceArray_Int())));
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang)) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (optOverhang != null) {
                            OptOverhang optOverhang2 = optOverhang;
                            throw new IllegalArgumentException(new StringBuilder(24).append("Option ").append(optOverhang2).append(" is invalid here.").toString());
                        }
                        throw new MatchError(optOverhang);
                    }
                    index = halfWindow;
                    int[] tempDataExtract = data.apply(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), index + halfWindow), HasOps$.MODULE$.canSlice_DV_Range_eq_DV()).toArray$mcI$sp(ClassTag$.MODULE$.Int());
                    ((int[])tempret.elem)[index] = currentMedian = BoxesRunTime.unboxToInt(quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger(halfWindow), quickSelectImpl$.MODULE$.impl_Int()));
                    ++index;
                    while (index < data.length() - halfWindow) {
                        int newWindowValue;
                        int nowObsoleteWindowValue = data.apply$mcI$sp(index - halfWindow - 1);
                        if (nowObsoleteWindowValue != (newWindowValue = data.apply$mcI$sp(index + halfWindow))) {
                            this.findAndReplaceInstanceInPlace(tempDataExtract, nowObsoleteWindowValue, newWindowValue, halfWindow);
                            if (!(nowObsoleteWindowValue < currentMedian && newWindowValue < currentMedian || nowObsoleteWindowValue > currentMedian && newWindowValue > currentMedian)) {
                                currentMedian = BoxesRunTime.unboxToInt(quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger(halfWindow), quickSelectImpl$.MODULE$.impl_Int()));
                            }
                        }
                        ((int[])tempret.elem)[index] = currentMedian;
                        ++index;
                    }
                    OptOverhang optOverhang3 = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mIc$sp((int[])tempret.elem);
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mIc$sp((int[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.intArrayOps((int[])tempret.elem), halfWindow, data.length() - halfWindow));
                    } else {
                        throw new MatchError(optOverhang3);
                    }
                    vector = vector2;
                }
                return vector;
            }

            private void findAndReplaceInstanceInPlace(int[] arr, int fromValue, int toValue, int pivotPoint) {
                int pivotValue = arr[pivotPoint];
                boolean found = false;
                if (fromValue == pivotValue) {
                    arr[pivotPoint] = toValue;
                    found = true;
                } else if (fromValue < pivotValue) {
                    int count = pivotPoint - 1;
                    while (count >= 0) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MIN_VALUE;
                            found = true;
                            continue;
                        }
                        --count;
                    }
                } else {
                    int count = pivotPoint + 1;
                    while (count < arr.length) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MAX_VALUE;
                            found = true;
                            continue;
                        }
                        ++count;
                    }
                }
                Predef$.MODULE$.require(found, (Function0<Object>)(Function0<String> & Serializable)() -> "The fromValue was not found within the given array, something is wrong!");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(), $anonfun$apply$2(), $anonfun$apply$3(), $anonfun$apply$4(scala.runtime.ObjectRef breeze.linalg.DenseVector int ), $anonfun$apply$5(scala.runtime.ObjectRef breeze.linalg.DenseVector int ), $anonfun$findAndReplaceInstanceInPlace$1()}, serializedLambda);
            }
        };
    }

    public CanFilterMedian<Object> dvFilterMedianT_Long() {
        return new CanFilterMedian<Object>(){

            public DenseVector<Object> apply(DenseVector<Object> data, int windowLength, OptOverhang overhang) {
                Vector<Object> vector;
                Predef$.MODULE$.require(BoxesRunTime.unboxToBoolean(package$isOdd$.MODULE$.apply(BoxesRunTime.boxToInteger(windowLength), package$isOdd$.MODULE$.isOddImpl_Int())), (Function0<Object>)(Function0<String> & Serializable)() -> "median filter can only take odd windowLength values, since even values will cause a half-frame time shift");
                Predef$.MODULE$.require(data.length() >= 3, (Function0<Object>)(Function0<String> & Serializable)() -> "data must be longer than 3");
                Predef$.MODULE$.require(windowLength >= 1, (Function0<Object>)(Function0<String> & Serializable)() -> "window length must be longer than 1");
                if (windowLength == 1) {
                    vector = data.copy$mcJ$sp();
                } else {
                    Vector vector2;
                    long currentMedian;
                    BoxedUnit boxedUnit;
                    int halfWindow;
                    ObjectRef<long[]> tempret = ObjectRef.create(new long[data.length()]);
                    int index = halfWindow = (windowLength - 1) / 2;
                    OptOverhang optOverhang = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang)) {
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp(indexFromBeginning -> {
                            ((long[])tempret$2.elem)[indexFromBeginning] = BoxesRunTime.unboxToLong(median$.MODULE$.apply(data.apply(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), indexFromBeginning * 2), HasOps$.MODULE$.canSlice_DV_Range_eq_DV()), median$.MODULE$.reduce(ClassTag$.MODULE$.Long(), median$.MODULE$.reduceArray_Long())));
                        });
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp(indexToEnd -> {
                            ((long[])tempret$2.elem)[data$2.length() - indexToEnd - 1] = BoxesRunTime.unboxToLong(median$.MODULE$.apply(data.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(data.length() - 2 * indexToEnd - 1), data.length()), HasOps$.MODULE$.canSlice_DV_Range_eq_DV()), median$.MODULE$.reduce(ClassTag$.MODULE$.Long(), median$.MODULE$.reduceArray_Long())));
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang)) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (optOverhang != null) {
                            OptOverhang optOverhang2 = optOverhang;
                            throw new IllegalArgumentException(new StringBuilder(24).append("Option ").append(optOverhang2).append(" is invalid here.").toString());
                        }
                        throw new MatchError(optOverhang);
                    }
                    index = halfWindow;
                    long[] tempDataExtract = data.apply(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), index + halfWindow), HasOps$.MODULE$.canSlice_DV_Range_eq_DV()).toArray$mcJ$sp(ClassTag$.MODULE$.Long());
                    ((long[])tempret.elem)[index] = currentMedian = BoxesRunTime.unboxToLong(quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger(halfWindow), quickSelectImpl$.MODULE$.impl_Long()));
                    ++index;
                    while (index < data.length() - halfWindow) {
                        long newWindowValue;
                        long nowObsoleteWindowValue = data.apply$mcJ$sp(index - halfWindow - 1);
                        if (nowObsoleteWindowValue != (newWindowValue = data.apply$mcJ$sp(index + halfWindow))) {
                            this.findAndReplaceInstanceInPlace(tempDataExtract, nowObsoleteWindowValue, newWindowValue, halfWindow);
                            if (!(nowObsoleteWindowValue < currentMedian && newWindowValue < currentMedian || nowObsoleteWindowValue > currentMedian && newWindowValue > currentMedian)) {
                                currentMedian = BoxesRunTime.unboxToLong(quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger(halfWindow), quickSelectImpl$.MODULE$.impl_Long()));
                            }
                        }
                        ((long[])tempret.elem)[index] = currentMedian;
                        ++index;
                    }
                    OptOverhang optOverhang3 = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mJc$sp((long[])tempret.elem);
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mJc$sp((long[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.longArrayOps((long[])tempret.elem), halfWindow, data.length() - halfWindow));
                    } else {
                        throw new MatchError(optOverhang3);
                    }
                    vector = vector2;
                }
                return vector;
            }

            private void findAndReplaceInstanceInPlace(long[] arr, long fromValue, long toValue, int pivotPoint) {
                long pivotValue = arr[pivotPoint];
                boolean found = false;
                if (fromValue == pivotValue) {
                    arr[pivotPoint] = toValue;
                    found = true;
                } else if (fromValue < pivotValue) {
                    int count = pivotPoint - 1;
                    while (count >= 0) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MIN_VALUE;
                            found = true;
                            continue;
                        }
                        --count;
                    }
                } else {
                    int count = pivotPoint + 1;
                    while (count < arr.length) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MAX_VALUE;
                            found = true;
                            continue;
                        }
                        ++count;
                    }
                }
                Predef$.MODULE$.require(found, (Function0<Object>)(Function0<String> & Serializable)() -> "The fromValue was not found within the given array, something is wrong!");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$10(scala.runtime.ObjectRef breeze.linalg.DenseVector int ), $anonfun$apply$6(), $anonfun$apply$7(), $anonfun$apply$8(), $anonfun$apply$9(scala.runtime.ObjectRef breeze.linalg.DenseVector int ), $anonfun$findAndReplaceInstanceInPlace$2()}, serializedLambda);
            }
        };
    }

    public CanFilterMedian<Object> dvFilterMedianT_Double() {
        return new CanFilterMedian<Object>(){

            public DenseVector<Object> apply(DenseVector<Object> data, int windowLength, OptOverhang overhang) {
                Vector vector;
                Predef$.MODULE$.require(BoxesRunTime.unboxToBoolean(package$isOdd$.MODULE$.apply(BoxesRunTime.boxToInteger(windowLength), package$isOdd$.MODULE$.isOddImpl_Int())), (Function0<Object>)(Function0<String> & Serializable)() -> "median filter can only take odd windowLength values, since even values will cause a half-frame time shift");
                Predef$.MODULE$.require(data.length() >= 3, (Function0<Object>)(Function0<String> & Serializable)() -> "data must be longer than 3");
                Predef$.MODULE$.require(windowLength >= 1, (Function0<Object>)(Function0<String> & Serializable)() -> "window length must be longer than 1");
                if (windowLength == 1) {
                    vector = data.copy$mcD$sp();
                } else {
                    Vector vector2;
                    double currentMedian;
                    BoxedUnit boxedUnit;
                    int halfWindow;
                    ObjectRef<double[]> tempret = ObjectRef.create(new double[data.length()]);
                    int index = halfWindow = (windowLength - 1) / 2;
                    OptOverhang optOverhang = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang)) {
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp(indexFromBeginning -> {
                            ((double[])tempret$3.elem)[indexFromBeginning] = BoxesRunTime.unboxToDouble(median$.MODULE$.apply(data.apply(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), indexFromBeginning * 2), HasOps$.MODULE$.canSlice_DV_Range_eq_DV()), median$.MODULE$.reduce(ClassTag$.MODULE$.Double(), median$.MODULE$.reduceArray_Double())));
                        });
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp(indexToEnd -> {
                            ((double[])tempret$3.elem)[data$3.length() - indexToEnd - 1] = BoxesRunTime.unboxToDouble(median$.MODULE$.apply(data.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(data.length() - 2 * indexToEnd - 1), data.length()), HasOps$.MODULE$.canSlice_DV_Range_eq_DV()), median$.MODULE$.reduce(ClassTag$.MODULE$.Double(), median$.MODULE$.reduceArray_Double())));
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang)) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (optOverhang != null) {
                            OptOverhang optOverhang2 = optOverhang;
                            throw new IllegalArgumentException(new StringBuilder(24).append("Option ").append(optOverhang2).append(" is invalid here.").toString());
                        }
                        throw new MatchError(optOverhang);
                    }
                    index = halfWindow;
                    double[] tempDataExtract = data.apply(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), index + halfWindow), HasOps$.MODULE$.canSlice_DV_Range_eq_DV()).toArray$mcD$sp(ClassTag$.MODULE$.Double());
                    ((double[])tempret.elem)[index] = currentMedian = BoxesRunTime.unboxToDouble(quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger(halfWindow), quickSelectImpl$.MODULE$.impl_Double()));
                    ++index;
                    while (index < data.length() - halfWindow) {
                        double newWindowValue;
                        double nowObsoleteWindowValue = data.apply$mcD$sp(index - halfWindow - 1);
                        if (nowObsoleteWindowValue != (newWindowValue = data.apply$mcD$sp(index + halfWindow))) {
                            this.findAndReplaceInstanceInPlace(tempDataExtract, nowObsoleteWindowValue, newWindowValue, halfWindow);
                            if ((nowObsoleteWindowValue >= currentMedian || newWindowValue >= currentMedian) && (nowObsoleteWindowValue <= currentMedian || newWindowValue <= currentMedian)) {
                                currentMedian = BoxesRunTime.unboxToDouble(quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger(halfWindow), quickSelectImpl$.MODULE$.impl_Double()));
                            }
                        }
                        ((double[])tempret.elem)[index] = currentMedian;
                        ++index;
                    }
                    OptOverhang optOverhang3 = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mDc$sp((double[])tempret.elem);
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mDc$sp((double[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.doubleArrayOps((double[])tempret.elem), halfWindow, data.length() - halfWindow));
                    } else {
                        throw new MatchError(optOverhang3);
                    }
                    vector = vector2;
                }
                return vector;
            }

            private void findAndReplaceInstanceInPlace(double[] arr, double fromValue, double toValue, int pivotPoint) {
                double pivotValue = arr[pivotPoint];
                boolean found = false;
                if (fromValue == pivotValue) {
                    arr[pivotPoint] = toValue;
                    found = true;
                } else if (fromValue < pivotValue) {
                    int count = pivotPoint - 1;
                    while (count >= 0) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MIN_VALUE;
                            found = true;
                            continue;
                        }
                        --count;
                    }
                } else {
                    int count = pivotPoint + 1;
                    while (count < arr.length) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MAX_VALUE;
                            found = true;
                            continue;
                        }
                        ++count;
                    }
                }
                Predef$.MODULE$.require(found, (Function0<Object>)(Function0<String> & Serializable)() -> "The fromValue was not found within the given array, something is wrong!");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$11(), $anonfun$apply$12(), $anonfun$apply$13(), $anonfun$apply$14(scala.runtime.ObjectRef breeze.linalg.DenseVector int ), $anonfun$apply$15(scala.runtime.ObjectRef breeze.linalg.DenseVector int ), $anonfun$findAndReplaceInstanceInPlace$3()}, serializedLambda);
            }
        };
    }

    public CanFilterMedian<Object> dvFilterMedianT_Float() {
        return new CanFilterMedian<Object>(){

            public DenseVector<Object> apply(DenseVector<Object> data, int windowLength, OptOverhang overhang) {
                Vector vector;
                Predef$.MODULE$.require(BoxesRunTime.unboxToBoolean(package$isOdd$.MODULE$.apply(BoxesRunTime.boxToInteger(windowLength), package$isOdd$.MODULE$.isOddImpl_Int())), (Function0<Object>)(Function0<String> & Serializable)() -> "median filter can only take odd windowLength values, since even values will cause a half-frame time shift");
                Predef$.MODULE$.require(data.length() >= 3, (Function0<Object>)(Function0<String> & Serializable)() -> "data must be longer than 3");
                Predef$.MODULE$.require(windowLength >= 1, (Function0<Object>)(Function0<String> & Serializable)() -> "window length must be longer than 1");
                if (windowLength == 1) {
                    vector = data.copy$mcF$sp();
                } else {
                    Vector vector2;
                    float currentMedian;
                    BoxedUnit boxedUnit;
                    int halfWindow;
                    ObjectRef<float[]> tempret = ObjectRef.create(new float[data.length()]);
                    int index = halfWindow = (windowLength - 1) / 2;
                    OptOverhang optOverhang = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang)) {
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp(indexFromBeginning -> {
                            ((float[])tempret$4.elem)[indexFromBeginning] = BoxesRunTime.unboxToFloat(median$.MODULE$.apply(data.apply(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), indexFromBeginning * 2), HasOps$.MODULE$.canSlice_DV_Range_eq_DV()), median$.MODULE$.reduce(ClassTag$.MODULE$.Float(), median$.MODULE$.reduceArray_Float())));
                        });
                        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp(indexToEnd -> {
                            ((float[])tempret$4.elem)[data$4.length() - indexToEnd - 1] = BoxesRunTime.unboxToFloat(median$.MODULE$.apply(data.apply(RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(data.length() - 2 * indexToEnd - 1), data.length()), HasOps$.MODULE$.canSlice_DV_Range_eq_DV()), median$.MODULE$.reduce(ClassTag$.MODULE$.Float(), median$.MODULE$.reduceArray_Float())));
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang)) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (optOverhang != null) {
                            OptOverhang optOverhang2 = optOverhang;
                            throw new IllegalArgumentException(new StringBuilder(24).append("Option ").append(optOverhang2).append(" is invalid here.").toString());
                        }
                        throw new MatchError(optOverhang);
                    }
                    index = halfWindow;
                    float[] tempDataExtract = data.apply(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), index + halfWindow), HasOps$.MODULE$.canSlice_DV_Range_eq_DV()).toArray$mcF$sp(ClassTag$.MODULE$.Float());
                    ((float[])tempret.elem)[index] = currentMedian = BoxesRunTime.unboxToFloat(quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger(halfWindow), quickSelectImpl$.MODULE$.impl_Float()));
                    ++index;
                    while (index < data.length() - halfWindow) {
                        float newWindowValue;
                        float nowObsoleteWindowValue = data.apply$mcF$sp(index - halfWindow - 1);
                        if (nowObsoleteWindowValue != (newWindowValue = data.apply$mcF$sp(index + halfWindow))) {
                            this.findAndReplaceInstanceInPlace(tempDataExtract, nowObsoleteWindowValue, newWindowValue, halfWindow);
                            if ((nowObsoleteWindowValue >= currentMedian || newWindowValue >= currentMedian) && (nowObsoleteWindowValue <= currentMedian || newWindowValue <= currentMedian)) {
                                currentMedian = BoxesRunTime.unboxToFloat(quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger(halfWindow), quickSelectImpl$.MODULE$.impl_Float()));
                            }
                        }
                        ((float[])tempret.elem)[index] = currentMedian;
                        ++index;
                    }
                    OptOverhang optOverhang3 = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mFc$sp((float[])tempret.elem);
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mFc$sp((float[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.floatArrayOps((float[])tempret.elem), halfWindow, data.length() - halfWindow));
                    } else {
                        throw new MatchError(optOverhang3);
                    }
                    vector = vector2;
                }
                return vector;
            }

            private void findAndReplaceInstanceInPlace(float[] arr, float fromValue, float toValue, int pivotPoint) {
                float pivotValue = arr[pivotPoint];
                boolean found = false;
                if (fromValue == pivotValue) {
                    arr[pivotPoint] = toValue;
                    found = true;
                } else if (fromValue < pivotValue) {
                    int count = pivotPoint - 1;
                    while (count >= 0) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MIN_VALUE;
                            found = true;
                            continue;
                        }
                        --count;
                    }
                } else {
                    int count = pivotPoint + 1;
                    while (count < arr.length) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MAX_VALUE;
                            found = true;
                            continue;
                        }
                        ++count;
                    }
                }
                Predef$.MODULE$.require(found, (Function0<Object>)(Function0<String> & Serializable)() -> "The fromValue was not found within the given array, something is wrong!");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$16(), $anonfun$apply$17(), $anonfun$apply$18(), $anonfun$apply$19(scala.runtime.ObjectRef breeze.linalg.DenseVector int ), $anonfun$apply$20(scala.runtime.ObjectRef breeze.linalg.DenseVector int ), $anonfun$findAndReplaceInstanceInPlace$4()}, serializedLambda);
            }
        };
    }

    private CanFilterMedian$() {
    }
}

