"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const alarm_state_1 = require("../../common/alarm-state");
const calendar_state_1 = require("./calendar-state");
const pipeline_state_1 = require("./pipeline-state");
exports.handler = async (event, context) => {
    const pipelineName = event.pipelineName;
    const stageName = event.stageName;
    const calendarState = await calendar_state_1.getCalendarState(event.calendar.calendarName);
    const stageState = await pipeline_state_1.getStageState(pipelineName, stageName);
    const alarmState = await alarm_state_1.getAggregateAlarmState(event.searchTerms);
    const input = {
        pipelineName: pipelineName,
        stageName: stageName,
        transitionType: 'Inbound',
    };
    if (calendarState.state === 'OPEN' && alarmState.state === 'OK') {
        console.log(`Enabling transition: ${JSON.stringify(input, null, 2)}`);
        await pipeline_state_1.enableStageTransition(input, context.functionName, stageState);
    }
    else {
        // If in ALARM, use that as the reason instead of the calendar.
        const reason = alarmState.state === 'ALARM' ? alarmState.summary : calendarState.summary;
        const disableInput = { ...input, reason };
        console.log(`Disabling transition: ${JSON.stringify(disableInput, null, 2)}`);
        await pipeline_state_1.disableStageTransition(disableInput, context.functionName, stageState);
    }
};
//# sourceMappingURL=data:application/json;base64,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