"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const aws_sdk_1 = require("aws-sdk");
const calendar_1 = require("./calendar");
exports.handler = async (event) => {
    console.log('Event: %j', { ...event, ResponseURL: '...' });
    const calendarPath = event.ResourceProperties.calendarPath;
    const calendarName = event.ResourceProperties.calendarName;
    let calendar;
    if (event.ResourceProperties.sourceType === calendar_1.CalendarSourceType.PATH) {
        calendar = event.ResourceProperties.calendarBody;
    }
    else {
        const s3 = new aws_sdk_1.S3();
        calendar = (await s3
            .getObject({
            Bucket: calendarPath,
            Key: calendarName,
        })
            .promise()).Body.toString();
    }
    const ssm = new aws_sdk_1.SSM();
    if (event.RequestType === 'Create') {
        const createDocumentRepsonse = await ssm
            .createDocument({
            Name: calendarName,
            Content: calendar,
            DocumentType: 'ChangeCalendar',
            DocumentFormat: 'TEXT',
        })
            .promise();
        console.log('Create document: %j', createDocumentRepsonse);
    }
    if (event.RequestType === 'Update') {
        const updateDocumentResponse = await ssm
            .updateDocument({
            Name: calendarName,
            Content: calendar,
            DocumentVersion: '$LATEST',
        })
            .promise();
        console.log('Update document: %j', updateDocumentResponse);
    }
    if (event.RequestType === 'Delete') {
        const deleteDocumentResponse = await ssm
            .deleteDocument({
            Name: calendarName,
        })
            .promise();
        console.log('Delete document: %j', deleteDocumentResponse);
    }
    return {};
};
//# sourceMappingURL=data:application/json;base64,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