# coding: utf-8

#  -----------------------------------------------------------------------------------------
#  (C) Copyright IBM Corp. 2023-2025.
#  https://opensource.org/licenses/BSD-3-Clause
#  -----------------------------------------------------------------------------------------

from pprint import pformat
from six import iteritems
import re


class ModelContentLocation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, name=None, type=None, connection=None, location=None, schema=None):
        """
        ModelContentLocation - location of model content defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'type': 'str',
            'connection': 'dict(str, str)',
            'location': 'dict(str, str)',
            'schema': 'dict(str,str)'
        }

        self.attribute_map = {
            'name' : 'name',
            'type': 'type',
            'connection': 'connection',
            'location': 'location',
            'schema':'schema'
        }

        self._name = name
        self._type = type
        self._connection = connection
        self._location = location
        self._schema = schema

    @property
    def name(self):
        """
        Gets the temp cos url of this ModelContentLocation.

        :return: The url of this ModelContentLocation.
        :rtype: dict(str, str)
        """
        return self._name

    @type.setter
    def type(self, type):
        """
        Sets the url of temp cos of this ModelContentLocation.

        :param connection: The connection of this ModelContentLocation.
        :type: dict(str, str)
        """

        self._type = type

    @property
    def connection(self):
        """
        Gets the connection of this ModelContentLocation.

        :return: The connection of this ModelContentLocation.
        :rtype: dict(str, str)
        """
        return self._connection

    @connection.setter
    def connection(self, connection):
        """
        Sets the connection of this ModelContentLocation.

        :param connection: The connection of this ModelContentLocation.
        :type: dict(str, str)
        """

        self._connection = connection

    @property
    def location(self):
        """
        Gets the source of this ModelContentLocation.
        Details of the resource in the content source

        :return: The source of this ModelContentLocation.
        :rtype: dict(str, str)
        """
        return self._location

    @location.setter
    def location(self, location):
        """
        Sets the source of this ModelContentLocation.
        Details of the resource in the content data source

        :param source: The source of this ModelContentLocation.
        :type: dict(str, str)
        """

        self._location = location

    @property
    def schema(self):
        """
        Gets the source of this ModelContentLocation.
        Details of the resource in the content source

        :return: The source of this ModelContentLocation.
        :rtype: dict(str, str)
        """
        return self._schema

    @schema.setter
    def schema(self, schema):
        """
        Sets the source of this ModelContentLocation.
        Details of the resource in the content data source

        :param source: The source of this ModelContentLocation.
        :type: dict(str, str)
        """

        self._schema = schema

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
