# coding: utf-8

#  -----------------------------------------------------------------------------------------
#  (C) Copyright IBM Corp. 2023-2025.
#  https://opensource.org/licenses/BSD-3-Clause
#  -----------------------------------------------------------------------------------------

from pprint import pformat
from six import iteritems
import re


class ModelVersionOutputEntity(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, model=None, content_href=None, training_data_ref=None, evaluation=None, current_metrics=None,
                 content_status=None, content_location=None,hyper_parameters=None):
        """
        ModelVersionOutputEntity - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'model': 'ModelVersionOutputEntityModel',
            'content_href': 'str',
            'training_data_ref': 'ModelTrainingDataRef',
            'evaluation': 'EvaluationDefinition',
            'current_metrics': 'ModelMetrics',
            'content_status': 'ContentStatus',
            'content_location': 'ContentLocation',
            'hyper_parameters' : 'list[HyperParameters]'
        }

        self.attribute_map = {
            'model': 'model',
            'content_href': 'contentHref',
            'training_data_ref': 'trainingDataRef',
            'evaluation': 'evaluation',
            'current_metrics': 'currentMetrics',
            'content_status': 'contentStatus',
            'content_location': 'contentLocation',
            'hyper_parameters': 'hyper_parameters'
        }

        self._model = model
        self._content_href = content_href
        self._training_data_ref = training_data_ref
        self._evaluation = evaluation
        self._current_metrics = current_metrics
        self._content_status = content_status
        self._content_location = content_location
        self._hyper_parameters = hyper_parameters

    @property
    def model(self):
        """
        Gets the model of this ModelVersionOutputEntity.


        :return: The model of this ModelVersionOutputEntity.
        :rtype: ModelVersionOutputEntityModel
        """
        return self._model

    @model.setter
    def model(self, model):
        """
        Sets the model of this ModelVersionOutputEntity.


        :param model: The model of this ModelVersionOutputEntity.
        :type: ModelVersionOutputEntityModel
        """

        self._model = model

    @property
    def hyper_parameters(self):
        """
        Gets the hyper_parameters of this MlAssetsCreateModelInput.


        :return: The hyper_parameters of this MlAssetsCreateModelInput.
        :rtype: HyperParameters
        """
        return self._hyper_parameters

    @hyper_parameters.setter
    def hyper_parameters(self, hyper_parameters):
        """
        Sets the framework of this MlAssetsCreateModelInput.


        :param framework: The framework of this MlAssetsCreateModelInput.
        :type: HyperParameters
        """
        self._hyper_parameters = hyper_parameters

    @property
    def content_href(self):
        """
        Gets the content_href of this ModelVersionOutputEntity.
        Href to the binary content of the model version. Make GET on it to download this file

        :return: The content_href of this ModelVersionOutputEntity.
        :rtype: str
        """
        return self._content_href

    @content_href.setter
    def content_href(self, content_href):
        """
        Sets the content_href of this ModelVersionOutputEntity.
        Href to the binary content of the model version. Make GET on it to download this file

        :param content_href: The content_href of this ModelVersionOutputEntity.
        :type: str
        """

        self._content_href = content_href

    @property
    def training_data_ref(self):
        """
        Gets the training_data_ref of this ModelVersionOutputEntity.


        :return: The training_data_ref of this ModelVersionOutputEntity.
        :rtype: ModelTrainingDataRef
        """
        return self._training_data_ref

    @training_data_ref.setter
    def training_data_ref(self, training_data_ref):
        """
        Sets the training_data_ref of this ModelVersionOutputEntity.


        :param training_data_ref: The training_data_ref of this ModelVersionOutputEntity.
        :type: ModelTrainingDataRef
        """

        self._training_data_ref = training_data_ref

    @property
    def evaluation(self):
        """
        Gets the evaluation of this ModelVersionOutputEntity.
        Definition of the evaluation method used for pipeline models

        :return: The evaluation of this ModelVersionOutputEntity.
        :rtype: EvaluationDefinition
        """
        return self._evaluation

    @evaluation.setter
    def evaluation(self, evaluation):
        """
        Sets the evaluation of this ModelVersionOutputEntity.
        Definition of the evaluation method used for pipeline models

        :param evaluation: The evaluation of this ModelVersionOutputEntity.
        :type: EvaluationDefinition
        """

        self._evaluation = evaluation

    @property
    def current_metrics(self):
        """
        Gets the current_metrics of this ModelVersionOutputEntity.


        :return: The current_metrics of this ModelVersionOutputEntity.
        :rtype: ModelMetrics
        """
        return self._current_metrics

    @current_metrics.setter
    def current_metrics(self, current_metrics):
        """
        Sets the current_metrics of this ModelVersionOutputEntity.


        :param current_metrics: The current_metrics of this ModelVersionOutputEntity.
        :type: ModelMetrics
        """

        self._current_metrics = current_metrics

    @property
    def content_status(self):
        """
        Gets the content_status of this ModelVersionOutputEntity.


        :return: The content_status of this ModelVersionOutputEntity.
        :rtype: ContentStatus
        """
        return self._content_status

    @content_status.setter
    def content_status(self, content_status):
        """
        Sets the content_status of this ModelVersionOutputEntity.


        :param content_status: The content_status of this ModelVersionOutputEntity.
        :type: ContentStatus
        """
        self._content_status = content_status

    @property
    def content_location(self):
        """
        Gets the content_status of this ModelVersionOutputEntity.


        :return: The content_status of this ModelVersionOutputEntity.
        :rtype: ContentLocation
        """
        return self._content_location

    @content_location.setter
    def content_location(self, content_location):
        """
        Sets the content_location of this ModelVersionOutputEntity.


        :param content_location: The content_status of this ModelVersionOutputEntity.
        :type: ContentLocation
        """
        self._content_status = content_location

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
