# coding: utf-8

#  -----------------------------------------------------------------------------------------
#  (C) Copyright IBM Corp. 2023-2025.
#  https://opensource.org/licenses/BSD-3-Clause
#  -----------------------------------------------------------------------------------------

from pprint import pformat
from six import iteritems
import re


class ModelMetrics(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self, values=None, timestamp=None):
        """
        ModelMetrics - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'values': 'list[ModelMetricsValues]',
            'timestamp': 'datetime'
        }

        self.attribute_map = {
            'values': 'values',
            'timestamp': 'timestamp'
        }

        self._values = values
        self._timestamp = timestamp

    @property
    def values(self):
        """
        Gets the values of this ModelMetrics.


        :return: The values of this ModelMetrics.
        :rtype: list[ModelMetricsValues]
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Sets the values of this ModelMetrics.


        :param values: The values of this ModelMetrics.
        :type: list[ModelMetricsValues]
        """

        self._values = values

    @property
    def timestamp(self):
        """
        Gets the timestamp of this ModelMetrics.
        The timestamp when the metric was mesured

        :return: The timestamp of this ModelMetrics.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this ModelMetrics.
        The timestamp when the metric was mesured

        :param timestamp: The timestamp of this ModelMetrics.
        :type: datetime
        """

        self._timestamp = timestamp

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
