# coding: utf-8

#  -----------------------------------------------------------------------------------------
#  (C) Copyright IBM Corp. 2023-2025.
#  https://opensource.org/licenses/BSD-3-Clause
#  -----------------------------------------------------------------------------------------

from pprint import pformat
from six import iteritems


class ArtifactVersionRepository(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ArtifactVersionRepository - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'guid': 'UUID',
            'url': 'str',
            'content_url': 'str'
        }

        self.attribute_map = {
            'guid': 'guid',
            'url': 'url',
            'content_url': 'content_url'
        }

        self._guid = None
        self._url = None
        self._content_url = None

    @property
    def guid(self):
        """
        Gets the guid of this ArtifactVersionRepository.


        :return: The guid of this ArtifactVersionRepository.
        :rtype: UUID
        """
        return self._guid

    @guid.setter
    def guid(self, guid):
        """
        Sets the guid of this ArtifactVersionRepository.


        :param guid: The guid of this ArtifactVersionRepository.
        :type: UUID
        """
        self._guid = guid

    @property
    def url(self):
        """
        Gets the url of this ArtifactVersionRepository.


        :return: The url of this ArtifactVersionRepository.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this ArtifactVersionRepository.


        :param url: The url of this ArtifactVersionRepository.
        :type: str
        """
        self._url = url

    @property
    def content_url(self):
        """
        Gets the content_url of this ArtifactVersionRepository.


        :return: The content_url of this ArtifactVersionRepository.
        :rtype: str
        """
        return self._content_url

    @content_url.setter
    def content_url(self, content_url):
        """
        Sets the content_url of this ArtifactVersionRepository.


        :param content_url: The content_url of this ArtifactVersionRepository.
        :type: str
        """
        self._content_url = content_url

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
