"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LustreMaintenanceTime = exports.Weekday = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Enum for representing all the days of the week.
 *
 * @stability stable
 */
var Weekday;
(function (Weekday) {
    Weekday["MONDAY"] = "1";
    Weekday["TUESDAY"] = "2";
    Weekday["WEDNESDAY"] = "3";
    Weekday["THURSDAY"] = "4";
    Weekday["FRIDAY"] = "5";
    Weekday["SATURDAY"] = "6";
    Weekday["SUNDAY"] = "7";
})(Weekday = exports.Weekday || (exports.Weekday = {}));
/**
 * Class for scheduling a weekly manitenance time.
 *
 * @stability stable
 */
class LustreMaintenanceTime {
    /**
     * @stability stable
     */
    constructor(props) {
        this.validate(props.hour, props.minute);
        this.day = props.day;
        this.hour = this.getTwoDigitString(props.hour);
        this.minute = this.getTwoDigitString(props.minute);
    }
    /**
     * Converts a day, hour, and minute into a timestamp as used by FSx for Lustre's weeklyMaintenanceStartTime field.
     *
     * @stability stable
     */
    toTimestamp() {
        return `${this.day.valueOf()}:${this.hour}:${this.minute}`;
    }
    /**
     * Pad an integer so that it always contains at least 2 digits. Assumes the number is a positive integer.
     */
    getTwoDigitString(n) {
        const numberString = n.toString();
        if (numberString.length === 1) {
            return `0${n}`;
        }
        return numberString;
    }
    /**
     * Validation needed for the values of the maintenance time.
     */
    validate(hour, minute) {
        if (!Number.isInteger(hour) || hour < 0 || hour > 24) {
            throw new Error('Maintenance time hour must be an integer between 0 and 24');
        }
        if (!Number.isInteger(minute) || minute < 0 || minute > 59) {
            throw new Error('Maintenance time minute must be an integer between 0 and 59');
        }
    }
}
exports.LustreMaintenanceTime = LustreMaintenanceTime;
_a = JSII_RTTI_SYMBOL_1;
LustreMaintenanceTime[_a] = { fqn: "@aws-cdk/aws-fsx.LustreMaintenanceTime", version: "1.100.0" };
//# sourceMappingURL=data:application/json;base64,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