"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import common.common_pb2
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Side:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _SideEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Side.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    SIDE_UNSPECIFIED: _Side.ValueType  # 0
    BUY: _Side.ValueType  # 1
    SELL: _Side.ValueType  # 2

class Side(_Side, metaclass=_SideEnumTypeWrapper): ...

SIDE_UNSPECIFIED: Side.ValueType  # 0
BUY: Side.ValueType  # 1
SELL: Side.ValueType  # 2
global___Side = Side

class _PnLCalcOption:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PnLCalcOptionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PnLCalcOption.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PNL_CALC_OPTION_UNSPECIFIED: _PnLCalcOption.ValueType  # 0
    SPOT_PRICE: _PnLCalcOption.ValueType  # 1
    TWAP: _PnLCalcOption.ValueType  # 2
    ORACLE: _PnLCalcOption.ValueType  # 3

class PnLCalcOption(_PnLCalcOption, metaclass=_PnLCalcOptionEnumTypeWrapper): ...

PNL_CALC_OPTION_UNSPECIFIED: PnLCalcOption.ValueType  # 0
SPOT_PRICE: PnLCalcOption.ValueType  # 1
TWAP: PnLCalcOption.ValueType  # 2
ORACLE: PnLCalcOption.ValueType  # 3
global___PnLCalcOption = PnLCalcOption

class _PnLPreferenceOption:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PnLPreferenceOptionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PnLPreferenceOption.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    PNL_PREFERENCE_UNSPECIFIED: _PnLPreferenceOption.ValueType  # 0
    MAX: _PnLPreferenceOption.ValueType  # 1
    MIN: _PnLPreferenceOption.ValueType  # 2

class PnLPreferenceOption(_PnLPreferenceOption, metaclass=_PnLPreferenceOptionEnumTypeWrapper): ...

PNL_PREFERENCE_UNSPECIFIED: PnLPreferenceOption.ValueType  # 0
MAX: PnLPreferenceOption.ValueType  # 1
MIN: PnLPreferenceOption.ValueType  # 2
global___PnLPreferenceOption = PnLPreferenceOption

class _MarginCalculationPriceOption:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _MarginCalculationPriceOptionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_MarginCalculationPriceOption.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    MARGIN_CALCULATION_PRICE_OPTION_UNSPECIFIED: _MarginCalculationPriceOption.ValueType  # 0
    SPOT: _MarginCalculationPriceOption.ValueType  # 1
    INDEX: _MarginCalculationPriceOption.ValueType  # 2
    MAX_PNL: _MarginCalculationPriceOption.ValueType  # 3

class MarginCalculationPriceOption(_MarginCalculationPriceOption, metaclass=_MarginCalculationPriceOptionEnumTypeWrapper): ...

MARGIN_CALCULATION_PRICE_OPTION_UNSPECIFIED: MarginCalculationPriceOption.ValueType  # 0
SPOT: MarginCalculationPriceOption.ValueType  # 1
INDEX: MarginCalculationPriceOption.ValueType  # 2
MAX_PNL: MarginCalculationPriceOption.ValueType  # 3
global___MarginCalculationPriceOption = MarginCalculationPriceOption

class Params(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STOPPED_FIELD_NUMBER: builtins.int
    FEE_POOL_FEE_RATIO_FIELD_NUMBER: builtins.int
    ECOSYSTEM_FUND_FEE_RATIO_FIELD_NUMBER: builtins.int
    LIQUIDATION_FEE_RATIO_FIELD_NUMBER: builtins.int
    PARTIAL_LIQUIDATION_RATIO_FIELD_NUMBER: builtins.int
    FUNDING_RATE_INTERVAL_FIELD_NUMBER: builtins.int
    TWAP_LOOKBACK_WINDOW_FIELD_NUMBER: builtins.int
    WHITELISTED_LIQUIDATORS_FIELD_NUMBER: builtins.int
    stopped: builtins.bool
    """stopped identifies if the perp exchange is stopped or not"""
    fee_pool_fee_ratio: builtins.str
    """FeePoolFeeRatio is the ratio transferred to the the fee pool"""
    ecosystem_fund_fee_ratio: builtins.str
    """EcosystemFundFeeRatio is the ratio transferred to the PerpEF."""
    liquidation_fee_ratio: builtins.str
    """LiquidationFeeRatio is the percentage of liquidated position that will be
    given to out as a reward. Half of the liquidation fee is given to the
    liquidator, and the other half is given to the ecosystem fund.
    """
    partial_liquidation_ratio: builtins.str
    """PartialLiquidationRatio is the share we try to liquidate if the margin is
    higher than liquidation fee
    """
    funding_rate_interval: builtins.str
    """specifies the interval on which the funding rate is updated"""
    @property
    def twap_lookback_window(self) -> google.protobuf.duration_pb2.Duration:
        """amount of time to look back for TWAP calculations"""
    @property
    def whitelisted_liquidators(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """whitelisted_liquidators defines the list of addresses
        which are allowed to liquidate a position.
        """
    def __init__(
        self,
        *,
        stopped: builtins.bool = ...,
        fee_pool_fee_ratio: builtins.str = ...,
        ecosystem_fund_fee_ratio: builtins.str = ...,
        liquidation_fee_ratio: builtins.str = ...,
        partial_liquidation_ratio: builtins.str = ...,
        funding_rate_interval: builtins.str = ...,
        twap_lookback_window: google.protobuf.duration_pb2.Duration | None = ...,
        whitelisted_liquidators: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["twap_lookback_window", b"twap_lookback_window"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["ecosystem_fund_fee_ratio", b"ecosystem_fund_fee_ratio", "fee_pool_fee_ratio", b"fee_pool_fee_ratio", "funding_rate_interval", b"funding_rate_interval", "liquidation_fee_ratio", b"liquidation_fee_ratio", "partial_liquidation_ratio", b"partial_liquidation_ratio", "stopped", b"stopped", "twap_lookback_window", b"twap_lookback_window", "whitelisted_liquidators", b"whitelisted_liquidators"]) -> None: ...

global___Params = Params

class Position(google.protobuf.message.Message):
    """Position identifies and records information on a user's position on one of
    the virtual liquidity pools.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TRADER_ADDRESS_FIELD_NUMBER: builtins.int
    PAIR_FIELD_NUMBER: builtins.int
    SIZE_FIELD_NUMBER: builtins.int
    MARGIN_FIELD_NUMBER: builtins.int
    OPEN_NOTIONAL_FIELD_NUMBER: builtins.int
    LATEST_CUMULATIVE_PREMIUM_FRACTION_FIELD_NUMBER: builtins.int
    BLOCK_NUMBER_FIELD_NUMBER: builtins.int
    trader_address: builtins.str
    """address identifies the address owner of this position"""
    @property
    def pair(self) -> common.common_pb2.AssetPair:
        """pair identifies the pair associated with this position"""
    size: builtins.str
    """Position size.
    signed int
    """
    margin: builtins.str
    """Amount of margin remaining in the position."""
    open_notional: builtins.str
    """OpenNotional is the quote denom value of the position when opening.
    Used to calculate PnL.
    """
    latest_cumulative_premium_fraction: builtins.str
    """The most recent cumulative premium fraction this position has.
    Used to calculate the next funding payment.
    """
    block_number: builtins.int
    """BlockNumber is the last block number when this position was updated."""
    def __init__(
        self,
        *,
        trader_address: builtins.str = ...,
        pair: common.common_pb2.AssetPair | None = ...,
        size: builtins.str = ...,
        margin: builtins.str = ...,
        open_notional: builtins.str = ...,
        latest_cumulative_premium_fraction: builtins.str = ...,
        block_number: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pair", b"pair"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["block_number", b"block_number", "latest_cumulative_premium_fraction", b"latest_cumulative_premium_fraction", "margin", b"margin", "open_notional", b"open_notional", "pair", b"pair", "size", b"size", "trader_address", b"trader_address"]) -> None: ...

global___Position = Position

class PairMetadata(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAIR_FIELD_NUMBER: builtins.int
    CUMULATIVE_PREMIUM_FRACTIONS_FIELD_NUMBER: builtins.int
    @property
    def pair(self) -> common.common_pb2.AssetPair: ...
    @property
    def cumulative_premium_fractions(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The historical list of cumulative premium fractions for a given pair.
        Calculated once per epoch.
        A premium fraction is the difference between mark and index, divided by the number of payments per day.
        (mark - index) / # payments in a day
        """
    def __init__(
        self,
        *,
        pair: common.common_pb2.AssetPair | None = ...,
        cumulative_premium_fractions: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["pair", b"pair"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["cumulative_premium_fractions", b"cumulative_premium_fractions", "pair", b"pair"]) -> None: ...

global___PairMetadata = PairMetadata

class PrepaidBadDebt(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DENOM_FIELD_NUMBER: builtins.int
    AMOUNT_FIELD_NUMBER: builtins.int
    denom: builtins.str
    amount: builtins.str
    def __init__(
        self,
        *,
        denom: builtins.str = ...,
        amount: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["amount", b"amount", "denom", b"denom"]) -> None: ...

global___PrepaidBadDebt = PrepaidBadDebt

class PositionResp(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POSITION_FIELD_NUMBER: builtins.int
    EXCHANGED_NOTIONAL_VALUE_FIELD_NUMBER: builtins.int
    EXCHANGED_POSITION_SIZE_FIELD_NUMBER: builtins.int
    BAD_DEBT_FIELD_NUMBER: builtins.int
    FUNDING_PAYMENT_FIELD_NUMBER: builtins.int
    REALIZED_PNL_FIELD_NUMBER: builtins.int
    UNREALIZED_PNL_AFTER_FIELD_NUMBER: builtins.int
    MARGIN_TO_VAULT_FIELD_NUMBER: builtins.int
    POSITION_NOTIONAL_FIELD_NUMBER: builtins.int
    @property
    def position(self) -> global___Position: ...
    exchanged_notional_value: builtins.str
    """The amount of quote assets exchanged."""
    exchanged_position_size: builtins.str
    """The amount of base assets exchanged."""
    bad_debt: builtins.str
    """The amount of bad debt accrued during this position change.
    Measured in absolute value of quote units.
    If greater than zero, then the position change event will likely fail.
    """
    funding_payment: builtins.str
    """The funding payment applied on this position change."""
    realized_pnl: builtins.str
    """The amount of PnL realized on this position changed, measured in quote
    units.
    """
    unrealized_pnl_after: builtins.str
    """The unrealized PnL in the position after the position change."""
    margin_to_vault: builtins.str
    """The amount of margin the trader has to give to the vault.
    A negative value means the vault pays the trader.
    """
    position_notional: builtins.str
    """The position's notional value after the position change, measured in quote
    units.
    """
    def __init__(
        self,
        *,
        position: global___Position | None = ...,
        exchanged_notional_value: builtins.str = ...,
        exchanged_position_size: builtins.str = ...,
        bad_debt: builtins.str = ...,
        funding_payment: builtins.str = ...,
        realized_pnl: builtins.str = ...,
        unrealized_pnl_after: builtins.str = ...,
        margin_to_vault: builtins.str = ...,
        position_notional: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["position", b"position"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bad_debt", b"bad_debt", "exchanged_notional_value", b"exchanged_notional_value", "exchanged_position_size", b"exchanged_position_size", "funding_payment", b"funding_payment", "margin_to_vault", b"margin_to_vault", "position", b"position", "position_notional", b"position_notional", "realized_pnl", b"realized_pnl", "unrealized_pnl_after", b"unrealized_pnl_after"]) -> None: ...

global___PositionResp = PositionResp

class LiquidateResp(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    BAD_DEBT_FIELD_NUMBER: builtins.int
    FEE_TO_LIQUIDATOR_FIELD_NUMBER: builtins.int
    FEE_TO_PERP_ECOSYSTEM_FUND_FIELD_NUMBER: builtins.int
    LIQUIDATOR_FIELD_NUMBER: builtins.int
    POSITION_RESP_FIELD_NUMBER: builtins.int
    bad_debt: builtins.str
    """Amount of bad debt created by the liquidation event"""
    fee_to_liquidator: builtins.str
    """Fee paid to the liquidator"""
    fee_to_perp_ecosystem_fund: builtins.str
    """Fee paid to the Perp EF fund"""
    liquidator: builtins.str
    """Address of the liquidator"""
    @property
    def position_resp(self) -> global___PositionResp:
        """Position response from the close or open reverse position"""
    def __init__(
        self,
        *,
        bad_debt: builtins.str = ...,
        fee_to_liquidator: builtins.str = ...,
        fee_to_perp_ecosystem_fund: builtins.str = ...,
        liquidator: builtins.str = ...,
        position_resp: global___PositionResp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["position_resp", b"position_resp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["bad_debt", b"bad_debt", "fee_to_liquidator", b"fee_to_liquidator", "fee_to_perp_ecosystem_fund", b"fee_to_perp_ecosystem_fund", "liquidator", b"liquidator", "position_resp", b"position_resp"]) -> None: ...

global___LiquidateResp = LiquidateResp
