"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class Plan(google.protobuf.message.Message):
    """Plan specifies information about a planned upgrade and when it should occur."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TIME_FIELD_NUMBER: builtins.int
    HEIGHT_FIELD_NUMBER: builtins.int
    INFO_FIELD_NUMBER: builtins.int
    UPGRADED_CLIENT_STATE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Sets the name for the upgrade. This name will be used by the upgraded
    version of the software to apply any special "on-upgrade" commands during
    the first BeginBlock method after the upgrade is applied. It is also used
    to detect whether a software version can handle a given upgrade. If no
    upgrade handler with this name has been set in the software, it will be
    assumed that the software is out-of-date when the upgrade Time or Height is
    reached and the software will exit.
    """
    @property
    def time(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Deprecated: Time based upgrades have been deprecated. Time based upgrade logic
        has been removed from the SDK.
        If this field is not empty, an error will be thrown.
        """
    height: builtins.int
    """The height at which the upgrade must be performed.
    Only used if Time is not set.
    """
    info: builtins.str
    """Any application specific upgrade info to be included on-chain
    such as a git commit that validators could automatically upgrade to
    """
    @property
    def upgraded_client_state(self) -> google.protobuf.any_pb2.Any:
        """Deprecated: UpgradedClientState field has been deprecated. IBC upgrade logic has been
        moved to the IBC module in the sub module 02-client.
        If this field is not empty, an error will be thrown.
        """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        height: builtins.int = ...,
        info: builtins.str = ...,
        upgraded_client_state: google.protobuf.any_pb2.Any | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["time", b"time", "upgraded_client_state", b"upgraded_client_state"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["height", b"height", "info", b"info", "name", b"name", "time", b"time", "upgraded_client_state", b"upgraded_client_state"]) -> None: ...

global___Plan = Plan

class SoftwareUpgradeProposal(google.protobuf.message.Message):
    """SoftwareUpgradeProposal is a gov Content type for initiating a software
    upgrade.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    PLAN_FIELD_NUMBER: builtins.int
    title: builtins.str
    description: builtins.str
    @property
    def plan(self) -> global___Plan: ...
    def __init__(
        self,
        *,
        title: builtins.str = ...,
        description: builtins.str = ...,
        plan: global___Plan | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["plan", b"plan"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "plan", b"plan", "title", b"title"]) -> None: ...

global___SoftwareUpgradeProposal = SoftwareUpgradeProposal

class CancelSoftwareUpgradeProposal(google.protobuf.message.Message):
    """CancelSoftwareUpgradeProposal is a gov Content type for cancelling a software
    upgrade.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TITLE_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    title: builtins.str
    description: builtins.str
    def __init__(
        self,
        *,
        title: builtins.str = ...,
        description: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["description", b"description", "title", b"title"]) -> None: ...

global___CancelSoftwareUpgradeProposal = CancelSoftwareUpgradeProposal

class ModuleVersion(google.protobuf.message.Message):
    """ModuleVersion specifies a module and its consensus version.

    Since: cosmos-sdk 0.43
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    name: builtins.str
    """name of the app module"""
    version: builtins.int
    """consensus version of the app module"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        version: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "version", b"version"]) -> None: ...

global___ModuleVersion = ModuleVersion
