"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _HashOp:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _HashOpEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_HashOp.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NO_HASH: _HashOp.ValueType  # 0
    """NO_HASH is the default if no data passed. Note this is an illegal argument some places."""
    SHA256: _HashOp.ValueType  # 1
    SHA512: _HashOp.ValueType  # 2
    KECCAK: _HashOp.ValueType  # 3
    RIPEMD160: _HashOp.ValueType  # 4
    BITCOIN: _HashOp.ValueType  # 5
    """ripemd160(sha256(x))"""

class HashOp(_HashOp, metaclass=_HashOpEnumTypeWrapper): ...

NO_HASH: HashOp.ValueType  # 0
"""NO_HASH is the default if no data passed. Note this is an illegal argument some places."""
SHA256: HashOp.ValueType  # 1
SHA512: HashOp.ValueType  # 2
KECCAK: HashOp.ValueType  # 3
RIPEMD160: HashOp.ValueType  # 4
BITCOIN: HashOp.ValueType  # 5
"""ripemd160(sha256(x))"""
global___HashOp = HashOp

class _LengthOp:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LengthOpEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LengthOp.ValueType], builtins.type):  # noqa: F821
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NO_PREFIX: _LengthOp.ValueType  # 0
    """NO_PREFIX don't include any length info"""
    VAR_PROTO: _LengthOp.ValueType  # 1
    """VAR_PROTO uses protobuf (and go-amino) varint encoding of the length"""
    VAR_RLP: _LengthOp.ValueType  # 2
    """VAR_RLP uses rlp int encoding of the length"""
    FIXED32_BIG: _LengthOp.ValueType  # 3
    """FIXED32_BIG uses big-endian encoding of the length as a 32 bit integer"""
    FIXED32_LITTLE: _LengthOp.ValueType  # 4
    """FIXED32_LITTLE uses little-endian encoding of the length as a 32 bit integer"""
    FIXED64_BIG: _LengthOp.ValueType  # 5
    """FIXED64_BIG uses big-endian encoding of the length as a 64 bit integer"""
    FIXED64_LITTLE: _LengthOp.ValueType  # 6
    """FIXED64_LITTLE uses little-endian encoding of the length as a 64 bit integer"""
    REQUIRE_32_BYTES: _LengthOp.ValueType  # 7
    """REQUIRE_32_BYTES is like NONE, but will fail if the input is not exactly 32 bytes (sha256 output)"""
    REQUIRE_64_BYTES: _LengthOp.ValueType  # 8
    """REQUIRE_64_BYTES is like NONE, but will fail if the input is not exactly 64 bytes (sha512 output)"""

class LengthOp(_LengthOp, metaclass=_LengthOpEnumTypeWrapper):
    """*
    LengthOp defines how to process the key and value of the LeafOp
    to include length information. After encoding the length with the given
    algorithm, the length will be prepended to the key and value bytes.
    (Each one with it's own encoded length)
    """

NO_PREFIX: LengthOp.ValueType  # 0
"""NO_PREFIX don't include any length info"""
VAR_PROTO: LengthOp.ValueType  # 1
"""VAR_PROTO uses protobuf (and go-amino) varint encoding of the length"""
VAR_RLP: LengthOp.ValueType  # 2
"""VAR_RLP uses rlp int encoding of the length"""
FIXED32_BIG: LengthOp.ValueType  # 3
"""FIXED32_BIG uses big-endian encoding of the length as a 32 bit integer"""
FIXED32_LITTLE: LengthOp.ValueType  # 4
"""FIXED32_LITTLE uses little-endian encoding of the length as a 32 bit integer"""
FIXED64_BIG: LengthOp.ValueType  # 5
"""FIXED64_BIG uses big-endian encoding of the length as a 64 bit integer"""
FIXED64_LITTLE: LengthOp.ValueType  # 6
"""FIXED64_LITTLE uses little-endian encoding of the length as a 64 bit integer"""
REQUIRE_32_BYTES: LengthOp.ValueType  # 7
"""REQUIRE_32_BYTES is like NONE, but will fail if the input is not exactly 32 bytes (sha256 output)"""
REQUIRE_64_BYTES: LengthOp.ValueType  # 8
"""REQUIRE_64_BYTES is like NONE, but will fail if the input is not exactly 64 bytes (sha512 output)"""
global___LengthOp = LengthOp

class ExistenceProof(google.protobuf.message.Message):
    """*
    ExistenceProof takes a key and a value and a set of steps to perform on it.
    The result of peforming all these steps will provide a "root hash", which can
    be compared to the value in a header.

    Since it is computationally infeasible to produce a hash collission for any of the used
    cryptographic hash functions, if someone can provide a series of operations to transform
    a given key and value into a root hash that matches some trusted root, these key and values
    must be in the referenced merkle tree.

    The only possible issue is maliablity in LeafOp, such as providing extra prefix data,
    which should be controlled by a spec. Eg. with lengthOp as NONE,
    prefix = FOO, key = BAR, value = CHOICE
    and
    prefix = F, key = OOBAR, value = CHOICE
    would produce the same value.

    With LengthOp this is tricker but not impossible. Which is why the "leafPrefixEqual" field
    in the ProofSpec is valuable to prevent this mutability. And why all trees should
    length-prefix the data before hashing it.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    LEAF_FIELD_NUMBER: builtins.int
    PATH_FIELD_NUMBER: builtins.int
    key: builtins.bytes
    value: builtins.bytes
    @property
    def leaf(self) -> global___LeafOp: ...
    @property
    def path(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InnerOp]: ...
    def __init__(
        self,
        *,
        key: builtins.bytes = ...,
        value: builtins.bytes = ...,
        leaf: global___LeafOp | None = ...,
        path: collections.abc.Iterable[global___InnerOp] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["leaf", b"leaf"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "leaf", b"leaf", "path", b"path", "value", b"value"]) -> None: ...

global___ExistenceProof = ExistenceProof

class NonExistenceProof(google.protobuf.message.Message):
    """
    NonExistenceProof takes a proof of two neighbors, one left of the desired key,
    one right of the desired key. If both proofs are valid AND they are neighbors,
    then there is no valid proof for the given key.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    LEFT_FIELD_NUMBER: builtins.int
    RIGHT_FIELD_NUMBER: builtins.int
    key: builtins.bytes
    """TODO: remove this as unnecessary??? we prove a range"""
    @property
    def left(self) -> global___ExistenceProof: ...
    @property
    def right(self) -> global___ExistenceProof: ...
    def __init__(
        self,
        *,
        key: builtins.bytes = ...,
        left: global___ExistenceProof | None = ...,
        right: global___ExistenceProof | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["left", b"left", "right", b"right"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "left", b"left", "right", b"right"]) -> None: ...

global___NonExistenceProof = NonExistenceProof

class CommitmentProof(google.protobuf.message.Message):
    """
    CommitmentProof is either an ExistenceProof or a NonExistenceProof, or a Batch of such messages
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXIST_FIELD_NUMBER: builtins.int
    NONEXIST_FIELD_NUMBER: builtins.int
    BATCH_FIELD_NUMBER: builtins.int
    COMPRESSED_FIELD_NUMBER: builtins.int
    @property
    def exist(self) -> global___ExistenceProof: ...
    @property
    def nonexist(self) -> global___NonExistenceProof: ...
    @property
    def batch(self) -> global___BatchProof: ...
    @property
    def compressed(self) -> global___CompressedBatchProof: ...
    def __init__(
        self,
        *,
        exist: global___ExistenceProof | None = ...,
        nonexist: global___NonExistenceProof | None = ...,
        batch: global___BatchProof | None = ...,
        compressed: global___CompressedBatchProof | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["batch", b"batch", "compressed", b"compressed", "exist", b"exist", "nonexist", b"nonexist", "proof", b"proof"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["batch", b"batch", "compressed", b"compressed", "exist", b"exist", "nonexist", b"nonexist", "proof", b"proof"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["proof", b"proof"]) -> typing_extensions.Literal["exist", "nonexist", "batch", "compressed"] | None: ...

global___CommitmentProof = CommitmentProof

class LeafOp(google.protobuf.message.Message):
    """*
    LeafOp represents the raw key-value data we wish to prove, and
    must be flexible to represent the internal transformation from
    the original key-value pairs into the basis hash, for many existing
    merkle trees.

    key and value are passed in. So that the signature of this operation is:
    leafOp(key, value) -> output

    To process this, first prehash the keys and values if needed (ANY means no hash in this case):
    hkey = prehashKey(key)
    hvalue = prehashValue(value)

    Then combine the bytes, and hash it
    output = hash(prefix || length(hkey) || hkey || length(hvalue) || hvalue)
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HASH_FIELD_NUMBER: builtins.int
    PREHASH_KEY_FIELD_NUMBER: builtins.int
    PREHASH_VALUE_FIELD_NUMBER: builtins.int
    LENGTH_FIELD_NUMBER: builtins.int
    PREFIX_FIELD_NUMBER: builtins.int
    hash: global___HashOp.ValueType
    prehash_key: global___HashOp.ValueType
    prehash_value: global___HashOp.ValueType
    length: global___LengthOp.ValueType
    prefix: builtins.bytes
    """prefix is a fixed bytes that may optionally be included at the beginning to differentiate
    a leaf node from an inner node.
    """
    def __init__(
        self,
        *,
        hash: global___HashOp.ValueType = ...,
        prehash_key: global___HashOp.ValueType = ...,
        prehash_value: global___HashOp.ValueType = ...,
        length: global___LengthOp.ValueType = ...,
        prefix: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["hash", b"hash", "length", b"length", "prefix", b"prefix", "prehash_key", b"prehash_key", "prehash_value", b"prehash_value"]) -> None: ...

global___LeafOp = LeafOp

class InnerOp(google.protobuf.message.Message):
    """*
    InnerOp represents a merkle-proof step that is not a leaf.
    It represents concatenating two children and hashing them to provide the next result.

    The result of the previous step is passed in, so the signature of this op is:
    innerOp(child) -> output

    The result of applying InnerOp should be:
    output = op.hash(op.prefix || child || op.suffix)

    where the || operator is concatenation of binary data,
    and child is the result of hashing all the tree below this step.

    Any special data, like prepending child with the length, or prepending the entire operation with
    some value to differentiate from leaf nodes, should be included in prefix and suffix.
    If either of prefix or suffix is empty, we just treat it as an empty string
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HASH_FIELD_NUMBER: builtins.int
    PREFIX_FIELD_NUMBER: builtins.int
    SUFFIX_FIELD_NUMBER: builtins.int
    hash: global___HashOp.ValueType
    prefix: builtins.bytes
    suffix: builtins.bytes
    def __init__(
        self,
        *,
        hash: global___HashOp.ValueType = ...,
        prefix: builtins.bytes = ...,
        suffix: builtins.bytes = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["hash", b"hash", "prefix", b"prefix", "suffix", b"suffix"]) -> None: ...

global___InnerOp = InnerOp

class ProofSpec(google.protobuf.message.Message):
    """*
    ProofSpec defines what the expected parameters are for a given proof type.
    This can be stored in the client and used to validate any incoming proofs.

    verify(ProofSpec, Proof) -> Proof | Error

    As demonstrated in tests, if we don't fix the algorithm used to calculate the
    LeafHash for a given tree, there are many possible key-value pairs that can
    generate a given hash (by interpretting the preimage differently).
    We need this for proper security, requires client knows a priori what
    tree format server uses. But not in code, rather a configuration object.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LEAF_SPEC_FIELD_NUMBER: builtins.int
    INNER_SPEC_FIELD_NUMBER: builtins.int
    MAX_DEPTH_FIELD_NUMBER: builtins.int
    MIN_DEPTH_FIELD_NUMBER: builtins.int
    @property
    def leaf_spec(self) -> global___LeafOp:
        """any field in the ExistenceProof must be the same as in this spec.
        except Prefix, which is just the first bytes of prefix (spec can be longer)
        """
    @property
    def inner_spec(self) -> global___InnerSpec: ...
    max_depth: builtins.int
    """max_depth (if > 0) is the maximum number of InnerOps allowed (mainly for fixed-depth tries)"""
    min_depth: builtins.int
    """min_depth (if > 0) is the minimum number of InnerOps allowed (mainly for fixed-depth tries)"""
    def __init__(
        self,
        *,
        leaf_spec: global___LeafOp | None = ...,
        inner_spec: global___InnerSpec | None = ...,
        max_depth: builtins.int = ...,
        min_depth: builtins.int = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["inner_spec", b"inner_spec", "leaf_spec", b"leaf_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["inner_spec", b"inner_spec", "leaf_spec", b"leaf_spec", "max_depth", b"max_depth", "min_depth", b"min_depth"]) -> None: ...

global___ProofSpec = ProofSpec

class InnerSpec(google.protobuf.message.Message):
    """
    InnerSpec contains all store-specific structure info to determine if two proofs from a
    given store are neighbors.

    This enables:

    isLeftMost(spec: InnerSpec, op: InnerOp)
    isRightMost(spec: InnerSpec, op: InnerOp)
    isLeftNeighbor(spec: InnerSpec, left: InnerOp, right: InnerOp)
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHILD_ORDER_FIELD_NUMBER: builtins.int
    CHILD_SIZE_FIELD_NUMBER: builtins.int
    MIN_PREFIX_LENGTH_FIELD_NUMBER: builtins.int
    MAX_PREFIX_LENGTH_FIELD_NUMBER: builtins.int
    EMPTY_CHILD_FIELD_NUMBER: builtins.int
    HASH_FIELD_NUMBER: builtins.int
    @property
    def child_order(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """Child order is the ordering of the children node, must count from 0
        iavl tree is [0, 1] (left then right)
        merk is [0, 2, 1] (left, right, here)
        """
    child_size: builtins.int
    min_prefix_length: builtins.int
    max_prefix_length: builtins.int
    empty_child: builtins.bytes
    """empty child is the prehash image that is used when one child is nil (eg. 20 bytes of 0)"""
    hash: global___HashOp.ValueType
    """hash is the algorithm that must be used for each InnerOp"""
    def __init__(
        self,
        *,
        child_order: collections.abc.Iterable[builtins.int] | None = ...,
        child_size: builtins.int = ...,
        min_prefix_length: builtins.int = ...,
        max_prefix_length: builtins.int = ...,
        empty_child: builtins.bytes = ...,
        hash: global___HashOp.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["child_order", b"child_order", "child_size", b"child_size", "empty_child", b"empty_child", "hash", b"hash", "max_prefix_length", b"max_prefix_length", "min_prefix_length", b"min_prefix_length"]) -> None: ...

global___InnerSpec = InnerSpec

class BatchProof(google.protobuf.message.Message):
    """
    BatchProof is a group of multiple proof types than can be compressed
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTRIES_FIELD_NUMBER: builtins.int
    @property
    def entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BatchEntry]: ...
    def __init__(
        self,
        *,
        entries: collections.abc.Iterable[global___BatchEntry] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["entries", b"entries"]) -> None: ...

global___BatchProof = BatchProof

class BatchEntry(google.protobuf.message.Message):
    """Use BatchEntry not CommitmentProof, to avoid recursion"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXIST_FIELD_NUMBER: builtins.int
    NONEXIST_FIELD_NUMBER: builtins.int
    @property
    def exist(self) -> global___ExistenceProof: ...
    @property
    def nonexist(self) -> global___NonExistenceProof: ...
    def __init__(
        self,
        *,
        exist: global___ExistenceProof | None = ...,
        nonexist: global___NonExistenceProof | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["exist", b"exist", "nonexist", b"nonexist", "proof", b"proof"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["exist", b"exist", "nonexist", b"nonexist", "proof", b"proof"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["proof", b"proof"]) -> typing_extensions.Literal["exist", "nonexist"] | None: ...

global___BatchEntry = BatchEntry

class CompressedBatchProof(google.protobuf.message.Message):
    """***** all items here are compressed forms ******"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTRIES_FIELD_NUMBER: builtins.int
    LOOKUP_INNERS_FIELD_NUMBER: builtins.int
    @property
    def entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CompressedBatchEntry]: ...
    @property
    def lookup_inners(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___InnerOp]: ...
    def __init__(
        self,
        *,
        entries: collections.abc.Iterable[global___CompressedBatchEntry] | None = ...,
        lookup_inners: collections.abc.Iterable[global___InnerOp] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["entries", b"entries", "lookup_inners", b"lookup_inners"]) -> None: ...

global___CompressedBatchProof = CompressedBatchProof

class CompressedBatchEntry(google.protobuf.message.Message):
    """Use BatchEntry not CommitmentProof, to avoid recursion"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXIST_FIELD_NUMBER: builtins.int
    NONEXIST_FIELD_NUMBER: builtins.int
    @property
    def exist(self) -> global___CompressedExistenceProof: ...
    @property
    def nonexist(self) -> global___CompressedNonExistenceProof: ...
    def __init__(
        self,
        *,
        exist: global___CompressedExistenceProof | None = ...,
        nonexist: global___CompressedNonExistenceProof | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["exist", b"exist", "nonexist", b"nonexist", "proof", b"proof"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["exist", b"exist", "nonexist", b"nonexist", "proof", b"proof"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["proof", b"proof"]) -> typing_extensions.Literal["exist", "nonexist"] | None: ...

global___CompressedBatchEntry = CompressedBatchEntry

class CompressedExistenceProof(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    LEAF_FIELD_NUMBER: builtins.int
    PATH_FIELD_NUMBER: builtins.int
    key: builtins.bytes
    value: builtins.bytes
    @property
    def leaf(self) -> global___LeafOp: ...
    @property
    def path(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """these are indexes into the lookup_inners table in CompressedBatchProof"""
    def __init__(
        self,
        *,
        key: builtins.bytes = ...,
        value: builtins.bytes = ...,
        leaf: global___LeafOp | None = ...,
        path: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["leaf", b"leaf"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "leaf", b"leaf", "path", b"path", "value", b"value"]) -> None: ...

global___CompressedExistenceProof = CompressedExistenceProof

class CompressedNonExistenceProof(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    LEFT_FIELD_NUMBER: builtins.int
    RIGHT_FIELD_NUMBER: builtins.int
    key: builtins.bytes
    """TODO: remove this as unnecessary??? we prove a range"""
    @property
    def left(self) -> global___CompressedExistenceProof: ...
    @property
    def right(self) -> global___CompressedExistenceProof: ...
    def __init__(
        self,
        *,
        key: builtins.bytes = ...,
        left: global___CompressedExistenceProof | None = ...,
        right: global___CompressedExistenceProof | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["left", b"left", "right", b"right"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "left", b"left", "right", b"right"]) -> None: ...

global___CompressedNonExistenceProof = CompressedNonExistenceProof
