"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LustreMaintenanceTime = exports.Weekday = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Enum for representing all the days of the week
 */
var Weekday;
(function (Weekday) {
    /**
     * Monday
     */
    Weekday["MONDAY"] = "1";
    /**
     * Tuesday
     */
    Weekday["TUESDAY"] = "2";
    /**
     * Wednesday
     */
    Weekday["WEDNESDAY"] = "3";
    /**
     * Thursday
     */
    Weekday["THURSDAY"] = "4";
    /**
     * Friday
     */
    Weekday["FRIDAY"] = "5";
    /**
     * Saturday
     */
    Weekday["SATURDAY"] = "6";
    /**
     * Sunday
     */
    Weekday["SUNDAY"] = "7";
})(Weekday = exports.Weekday || (exports.Weekday = {}));
/**
 * Class for scheduling a weekly manitenance time.
 */
class LustreMaintenanceTime {
    constructor(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_fsx_LustreMaintenanceTimeProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.validate(props.hour, props.minute);
        this.day = props.day;
        this.hour = this.getTwoDigitString(props.hour);
        this.minute = this.getTwoDigitString(props.minute);
    }
    /**
     * Converts a day, hour, and minute into a timestamp as used by FSx for Lustre's weeklyMaintenanceStartTime field.
     */
    toTimestamp() {
        return `${this.day.valueOf()}:${this.hour}:${this.minute}`;
    }
    /**
     * Pad an integer so that it always contains at least 2 digits. Assumes the number is a positive integer.
     */
    getTwoDigitString(n) {
        const numberString = n.toString();
        if (numberString.length === 1) {
            return `0${n}`;
        }
        return numberString;
    }
    /**
     * Validation needed for the values of the maintenance time.
     */
    validate(hour, minute) {
        if (!Number.isInteger(hour) || hour < 0 || hour > 24) {
            throw new Error('Maintenance time hour must be an integer between 0 and 24');
        }
        if (!Number.isInteger(minute) || minute < 0 || minute > 59) {
            throw new Error('Maintenance time minute must be an integer between 0 and 59');
        }
    }
}
exports.LustreMaintenanceTime = LustreMaintenanceTime;
_a = JSII_RTTI_SYMBOL_1;
LustreMaintenanceTime[_a] = { fqn: "@aws-cdk/aws-fsx.LustreMaintenanceTime", version: "1.153.1" };
//# sourceMappingURL=data:application/json;base64,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