# AUTOGENERATED! DO NOT EDIT! File to edit: 00_core.ipynb (unless otherwise specified).

__all__ = ['zenodo_url_to_data_url', 'get_audio_data', 'show_info', 'plot_waveform', 'plot_melspec', 'play_audio',
           'show_audio', 'get_accompanying_tracks']

# Cell

#from fastai.vision.all import *
from fastai.data.all import *
#from subprocess import Popen, PIPE
import pyzenodo3
import torchaudio
import librosa
import librosa.display
from IPython.display import Audio
import re

#from zipfile import ZipFile

# some data urls
URLs.AUDIOMDPI = 'https://zenodo.org/record/3562442'
URLs.MARCO = URLs.AUDIOMDPI  # just a shorthand alias I'm more likely to remember
URLs.SIGNALTRAIN_LA2A_1_1 = 'https://zenodo.org/record/3824876'
URLs.SIGNALTRAIN_LA2A_REDUCED = 'http://hedges.belmont.edu/data/SignalTrain_LA2A_Reduced.tgz'

# Cell
def zenodo_url_to_data_url(url):
    #%pip install pyzenodo3 -q
    zen = pyzenodo3.Zenodo()
    record = url.split('/')[-1]
    return zen.get_record(record).data['files'][0]['links']['self']

# Cell

# extract_func no longer supported  in untar_data, so zipfile stuff is unused
# thanks KevinB for the zip_extract! https://forums.fast.ai/t/generalizing-untar-data-to-also-work-with-zips/53741/14?u=drscotthawley
#def zip_extract(fname, dest):
#    zipfile.ZipFile(fname, mode='r').extractall(dest)

def get_audio_data(url):
    if ('zenodo' in url.lower()):
        url = zenodo_url_to_data_url(url)
    if '.zip' in url[-5:]:
        return untar_data(url)#, extract_func=zip_extract) #
    else:
        return untar_data(url)

# Cell

def show_info(waveform, sample_rate):
    print(f"Shape: {tuple(waveform.shape)}, Dtype: {waveform.dtype}, Duration: {waveform.shape[-1]/sample_rate} s")
    print(f"Max: {waveform.max().item():6.3f},  Min: {waveform.min().item():6.3f}, Mean: {waveform.mean().item():6.3f}, Std Dev: {waveform.std().item():6.3f}")

def plot_waveform(
    waveform,       # the tensor to plot.
    sample_rate,    # used for labeling x-axis in terms of time
    ax=None,        # can be an existing array of plot axes, or None
    xlim=None,      # limits of x-axis
    ylim=[-1,1],    # limits of y-axis
    color = 'blue',      # can specify color for waveform plot
    label = '',     # label for waveform plot
    title= 'Waveform'):
    "Waveform plot, from https://pytorch.org/tutorials/beginner/audio_preprocessing_tutorial.html"
    if ax is None: fig, ax = plt.subplots()
    waveform = waveform.numpy()
    if len(waveform.shape) < 2:  waveform =  waveform[np.newaxis, :]
    num_channels, num_frames = waveform.shape
    time_axis = torch.arange(0, num_frames) / sample_rate
    if num_channels > 1:
        for c in range(num_channels):
            label = f'Channel {c+1}' if num_channels > 1 else ''  # overwrite label kwarg
            ax.plot(time_axis, waveform[c], linewidth=1, label=label)
    else:
        ax.plot(time_axis, waveform[0], linewidth=1, color=color, label=label)
    ax.grid(True)
    if ylim: ax.set_ylim(ylim)
    ax.title.set_text(title)
    ax.set_xlabel('Time (s)')
    if num_channels > 1: ax.legend()
    if ax is None: plt.show(block=False)

def plot_melspec(waveform, sample_rate, ax=None, ref=np.max, vmin=-70, vmax=0):
    "Mel-spectrogram plot, from librosa documentation"
    if ax is None: fig, ax = plt.subplots()
    M = librosa.feature.melspectrogram(y=waveform.numpy()[0], sr=sample_rate)
    M_db = librosa.power_to_db(M, ref=ref)
    img = librosa.display.specshow(M_db, y_axis='mel', x_axis='time', ax=ax, sr=sample_rate, vmin=vmin, vmax=vmax)
    ax.set(title='Mel spectrogram display (Channel 0)')
    plt.colorbar(img, ax=ax, format="%+2.f dB")
    if ax is None: plt.show(block=False)

def play_audio(waveform, sample_rate):
    """From torchaudio preprocessing tutorial.
    note ipython docs claim Audio can already do multichannel: "# Can also do stereo or more channels"
    """
    display(Audio(waveform.numpy(), rate=sample_rate, normalize=False))


def show_audio(waveform, sample_rate, info=True, play=True, plots=['waveform','melspec'], ref=500):
    "This display routine is an amalgam of the torchaudio tutorial and the librosa documentation:"
    # ref=500 is a bit arbitrary choice of reference intensity value but works well
    if info: show_info(waveform, sample_rate)
    if play: play_audio(waveform, sample_rate)
    num_channels = waveform.shape[0]
    if num_channels <= 2:
        ncols = len(plots)
        if  ncols > 0:
            fig, ax = plt.subplots(nrows=1, ncols=ncols, figsize=(12,4))
            for i, pstr in enumerate(plots):
                if 'waveform'==pstr: plot_waveform(waveform, sample_rate, ax=ax[i] if ncols>1 else ax)
                if 'melspec'==pstr:  plot_melspec(waveform,  sample_rate, ax=ax[i] if ncols>1 else ax, ref=ref)
    else:  # "multichannel audio" handled separately for backwards compatibility & needs of time-align project
        fig, ax = plt.subplots(nrows=num_channels, ncols=1, figsize=(10,2*num_channels)) # just plot waveforms for now
        for c in range(num_channels):
            plot_waveform(waveform[c], sample_rate, ax=ax[c], title='', color=(['k','b','y','g','r']*10)[c], label=f"Channel {c}")

# Cell
def get_accompanying_tracks(
    fn,       # one filename
    fn_list,  # list of all filenames
    remove=False,  # remove these accompanying filenames from the main list.
    ):
    """"Given one filename, and a list of all filenames, return a list of that filename and
    any files it 'goes with'
    """
    # make a copies of fn & fn_list with all hyphen+stuff removed.
    basename = re.sub(r'-[a-zA-Z0-9]+','', fn)
    basename_list = [re.sub(r'-[a-zA-Z0-9]+','', x) for x in fn_list]

    # get indices of all elements of basename_list matching basename, return original filenames
    accompanying = [fn_list[i] for i, x in enumerate(basename_list) if x == basename]
    if remove:
        for x in accompanying:
            if x != fn: fn_list.remove(x)  # don't remove the file we search on though
    return accompanying # note accompanying list includes original file too