# coding: utf-8

from __future__ import annotations
from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, Field, validator  # noqa: F401
from openapi_server.models.financial_connections_investment_security import FinancialConnectionsInvestmentSecurity
from openapi_server.models.financial_connections_investment_transaction_currency import FinancialConnectionsInvestmentTransactionCurrency


class FinancialConnectionsInvestmentTransaction(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    FinancialConnectionsInvestmentTransaction - a model defined in OpenAPI

        remote_id: The remote_id of this FinancialConnectionsInvestmentTransaction.
        remote_account_id: The remote_account_id of this FinancialConnectionsInvestmentTransaction.
        account_name: The account_name of this FinancialConnectionsInvestmentTransaction [Optional].
        amount: The amount of this FinancialConnectionsInvestmentTransaction.
        currency: The currency of this FinancialConnectionsInvestmentTransaction.
        description: The description of this FinancialConnectionsInvestmentTransaction.
        fees: The fees of this FinancialConnectionsInvestmentTransaction.
        date: The date of this FinancialConnectionsInvestmentTransaction.
        type: The type of this FinancialConnectionsInvestmentTransaction.
        quantity: The quantity of this FinancialConnectionsInvestmentTransaction.
        price: The price of this FinancialConnectionsInvestmentTransaction.
        security: The security of this FinancialConnectionsInvestmentTransaction.
    """

    remote_id: str = Field(alias="remote_id")
    remote_account_id: str = Field(alias="remote_account_id")
    account_name: Optional[str] = Field(alias="account_name", default=None)
    amount: float = Field(alias="amount")
    currency: FinancialConnectionsInvestmentTransactionCurrency = Field(alias="currency")
    description: str = Field(alias="description")
    fees: float = Field(alias="fees")
    date: datetime = Field(alias="date")
    type: str = Field(alias="type")
    quantity: float = Field(alias="quantity")
    price: float = Field(alias="price")
    security: FinancialConnectionsInvestmentSecurity = Field(alias="security")

FinancialConnectionsInvestmentTransaction.update_forward_refs()
