# coding: utf-8

from __future__ import annotations
from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, Field, validator  # noqa: F401
from openapi_server.models.account_subtype import AccountSubtype
from openapi_server.models.account_type import AccountType
from openapi_server.models.financial_connections_account_cached_balance import FinancialConnectionsAccountCachedBalance
from openapi_server.models.financial_connections_account_institution import FinancialConnectionsAccountInstitution


class FinancialConnectionsAccount(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    FinancialConnectionsAccount - a model defined in OpenAPI

        remote_id: The remote_id of this FinancialConnectionsAccount.
        fingerprint: The fingerprint of this FinancialConnectionsAccount.
        institution: The institution of this FinancialConnectionsAccount [Optional].
        mask: The mask of this FinancialConnectionsAccount [Optional].
        name: The name of this FinancialConnectionsAccount.
        type: The type of this FinancialConnectionsAccount.
        subtype: The subtype of this FinancialConnectionsAccount [Optional].
        balance: The balance of this FinancialConnectionsAccount.
    """

    remote_id: str = Field(alias="remote_id")
    fingerprint: str = Field(alias="fingerprint")
    institution: Optional[FinancialConnectionsAccountInstitution] = Field(alias="institution", default=None)
    mask: Optional[str] = Field(alias="mask", default=None)
    name: str = Field(alias="name")
    type: AccountType = Field(alias="type")
    subtype: Optional[AccountSubtype] = Field(alias="subtype", default=None)
    balance: FinancialConnectionsAccountCachedBalance = Field(alias="balance")

FinancialConnectionsAccount.update_forward_refs()
