# coding: utf-8

from __future__ import annotations
from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, Field, validator  # noqa: F401
from fuse_clients.models.financial_connections_investment_security_currency import FinancialConnectionsInvestmentSecurityCurrency
from fuse_clients.models.financial_connections_investment_security_exchange import FinancialConnectionsInvestmentSecurityExchange


class FinancialConnectionsInvestmentSecurity(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    FinancialConnectionsInvestmentSecurity - a model defined in OpenAPI

        remote_id: The remote_id of this FinancialConnectionsInvestmentSecurity.
        symbol: The symbol of this FinancialConnectionsInvestmentSecurity.
        isin: The isin of this FinancialConnectionsInvestmentSecurity [Optional].
        sedol: The sedol of this FinancialConnectionsInvestmentSecurity [Optional].
        cusip: The cusip of this FinancialConnectionsInvestmentSecurity [Optional].
        close_price: The close_price of this FinancialConnectionsInvestmentSecurity.
        currency: The currency of this FinancialConnectionsInvestmentSecurity.
        name: The name of this FinancialConnectionsInvestmentSecurity [Optional].
        type: The type of this FinancialConnectionsInvestmentSecurity [Optional].
        exchange: The exchange of this FinancialConnectionsInvestmentSecurity [Optional].
    """

    remote_id: str = Field(alias="remote_id")
    symbol: str = Field(alias="symbol")
    isin: Optional[str] = Field(alias="isin", default=None)
    sedol: Optional[str] = Field(alias="sedol", default=None)
    cusip: Optional[str] = Field(alias="cusip", default=None)
    close_price: float = Field(alias="close_price")
    currency: FinancialConnectionsInvestmentSecurityCurrency = Field(alias="currency")
    name: Optional[str] = Field(alias="name", default=None)
    type: Optional[str] = Field(alias="type", default=None)
    exchange: Optional[FinancialConnectionsInvestmentSecurityExchange] = Field(alias="exchange", default=None)

FinancialConnectionsInvestmentSecurity.update_forward_refs()
