# coding: utf-8

from __future__ import annotations
from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, Field, validator  # noqa: F401
from fuse_client.models.get_investment_transactions_request_options import GetInvestmentTransactionsRequestOptions


class GetInvestmentTransactionsRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    GetInvestmentTransactionsRequest - a model defined in OpenAPI

        access_token: The access_token of this GetInvestmentTransactionsRequest.
        start_date: The start_date of this GetInvestmentTransactionsRequest [Optional].
        end_date: The end_date of this GetInvestmentTransactionsRequest [Optional].
        page: The page of this GetInvestmentTransactionsRequest [Optional].
        records_per_page: The records_per_page of this GetInvestmentTransactionsRequest [Optional].
        options: The options of this GetInvestmentTransactionsRequest [Optional].
    """

    access_token: str = Field(alias="access_token")
    start_date: Optional[str] = Field(alias="start_date", default=None)
    end_date: Optional[str] = Field(alias="end_date", default=None)
    page: Optional[int] = Field(alias="page", default=None)
    records_per_page: Optional[int] = Field(alias="records_per_page", default=None)
    options: Optional[GetInvestmentTransactionsRequestOptions] = Field(alias="options", default=None)

    @validator("page")
    def page_min(cls, value):
        assert value >= 1
        return value

    @validator("records_per_page")
    def records_per_page_max(cls, value):
        assert value <= 100
        return value

    @validator("records_per_page")
    def records_per_page_min(cls, value):
        assert value >= 10
        return value

GetInvestmentTransactionsRequest.update_forward_refs()
