# coding: utf-8

from __future__ import annotations
from datetime import date, datetime  # noqa: F401

import re  # noqa: F401
from typing import Any, Dict, List, Optional  # noqa: F401

from pydantic import AnyUrl, BaseModel, EmailStr, Field, validator  # noqa: F401
from 3.4.5.models.account_subtype import AccountSubtype
from 3.4.5.models.account_type import AccountType
from 3.4.5.models.financial_connections_account_cached_balance import FinancialConnectionsAccountCachedBalance
from 3.4.5.models.financial_connections_account_institution import FinancialConnectionsAccountInstitution
from 3.4.5.models.financial_connections_account_liability_all_of_aprs import FinancialConnectionsAccountLiabilityAllOfAprs


class FinancialConnectionsAccountLiability(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    FinancialConnectionsAccountLiability - a model defined in OpenAPI

        remote_id: The remote_id of this FinancialConnectionsAccountLiability.
        fingerprint: The fingerprint of this FinancialConnectionsAccountLiability.
        institution: The institution of this FinancialConnectionsAccountLiability [Optional].
        mask: The mask of this FinancialConnectionsAccountLiability [Optional].
        name: The name of this FinancialConnectionsAccountLiability.
        type: The type of this FinancialConnectionsAccountLiability.
        subtype: The subtype of this FinancialConnectionsAccountLiability [Optional].
        balance: The balance of this FinancialConnectionsAccountLiability.
        aprs: The aprs of this FinancialConnectionsAccountLiability [Optional].
        interest_rate_percentage: The interest_rate_percentage of this FinancialConnectionsAccountLiability [Optional].
        origination_principal_amount: The origination_principal_amount of this FinancialConnectionsAccountLiability [Optional].
        next_payment_due_date: The next_payment_due_date of this FinancialConnectionsAccountLiability [Optional].
        last_payment_date: The last_payment_date of this FinancialConnectionsAccountLiability [Optional].
        last_payment_amount: The last_payment_amount of this FinancialConnectionsAccountLiability [Optional].
        minimum_payment_amount: The minimum_payment_amount of this FinancialConnectionsAccountLiability [Optional].
    """

    remote_id: str = Field(alias="remote_id")
    fingerprint: str = Field(alias="fingerprint")
    institution: Optional[FinancialConnectionsAccountInstitution] = Field(alias="institution", default=None)
    mask: Optional[str] = Field(alias="mask", default=None)
    name: str = Field(alias="name")
    type: AccountType = Field(alias="type")
    subtype: Optional[AccountSubtype] = Field(alias="subtype", default=None)
    balance: FinancialConnectionsAccountCachedBalance = Field(alias="balance")
    aprs: Optional[List[FinancialConnectionsAccountLiabilityAllOfAprs]] = Field(alias="aprs", default=None)
    interest_rate_percentage: Optional[float] = Field(alias="interest_rate_percentage", default=None)
    origination_principal_amount: Optional[float] = Field(alias="origination_principal_amount", default=None)
    next_payment_due_date: Optional[str] = Field(alias="next_payment_due_date", default=None)
    last_payment_date: Optional[str] = Field(alias="last_payment_date", default=None)
    last_payment_amount: Optional[float] = Field(alias="last_payment_amount", default=None)
    minimum_payment_amount: Optional[float] = Field(alias="minimum_payment_amount", default=None)

FinancialConnectionsAccountLiability.update_forward_refs()
