IF (ROCBLAS_LIBRARY_DIRS AND ROCBLAS_LIBRARIES)
  KOKKOSKERNELS_FIND_IMPORTED(ROCBLAS INTERFACE LIBRARIES ${ROCBLAS_LIBRARIES} LIBRARY_PATHS ${ROCBLAS_LIBRARY_DIRS})
ELSEIF (ROCBLAS_LIBRARIES)
  KOKKOSKERNELS_FIND_IMPORTED(ROCBLAS INTERFACE LIBRARIES ${ROCBLAS_LIBRARIES})
ELSEIF (ROCBLAS_LIBRARY_DIRS)
  KOKKOSKERNELS_FIND_IMPORTED(ROCBLAS INTERFACE LIBRARIES rocblas LIBRARY_PATHS ${ROCBLAS_LIBRARY_DIRS})
ELSEIF (KokkosKernels_ROCBLAS_ROOT)
  KOKKOSKERNELS_FIND_IMPORTED(ROCBLAS INTERFACE
    LIBRARIES
      rocblas
    LIBRARY_PATHS
      ${KokkosKernels_ROCBLAS_ROOT}/lib
    HEADERS
      rocblas.h
    HEADER_PATHS
      ${KokkosKernels_ROCBLAS_ROOT}/include
  )
ELSEIF (DEFINED ENV{ROCM_PATH})
  MESSAGE(STATUS "Detected ROCM_PATH: ENV{ROCM_PATH}")
  SET(ROCBLAS_ROOT "$ENV{ROCM_PATH}/rocblas")
  KOKKOSKERNELS_FIND_IMPORTED(ROCBLAS INTERFACE
    LIBRARIES
      rocblas
    LIBRARY_PATHS
      ${ROCBLAS_ROOT}/lib
    HEADERS
      rocblas.h
    HEADER_PATHS
      ${ROCBLAS_ROOT}/include
  )
ELSE()
  MESSAGE(ERROR "rocBLAS was not detected properly, please disable it or provide sufficient information at configure time.")
  # Todo: figure out how to use the target defined during rocblas installation
  # FIND_PACKAGE(ROCBLAS REQUIRED)
  # KOKKOSKERNELS_CREATE_IMPORTED_TPL(ROCBLAS INTERFACE LINK_LIBRARIES ${ROCBLAS_LIBRARIES})
  # GET_TARGET_PROPERTY(ROCBLAS_LINK_LIBRARIES ${ROCBLAS_LIBRARIES} IMPORTED_LINK_INTERFACE_LIBRARIES)
ENDIF()