#!/usr/bin/env python
# -*- coding: utf-8 -*-
# @Time    : 2022/12/10 0:33
# @Author  : mtl
# @File    : example.py
# @Description : *****
import collections
from pathlib import Path

from openpyxl import load_workbook
from openpyxl.worksheet.worksheet import Worksheet

from simple_export.excel import write_excel_for_template
from simple_export.utils.util import dynamic_method
class dynamic_method2(dynamic_method):
    def abc(self, coordinate: str, sheet: Worksheet, pos_mapping: collections.defaultdict, pos: collections.defaultdict ):
        print("abc")

    def get_sum(self, coordinate: str, sheet: Worksheet, pos_mapping: collections.defaultdict, pos: collections.defaultdict, a):
        print("abc")

def test1():
    wb_tmp = load_workbook(Path(__file__).parent / 'template/excel1.xlsx')
    value = {
        "家庭财产库存清单": {
            "sheet_name": "11",
            "thing": [
                {
                    "id": "=ROW($A1)",
                    "room": "客厅",
                    "goods": "物品1",
                    "structure": "制造商1",
                    "serial_number": "33XCBH3",
                    "time": "=TODAY()-120",
                    "source": "联机",
                    "price": 2000,
                    "eval_price": 2000,
                    "remark": "",
                    "has_photo": "是",
                    "photo_url": "https://t13.baidu.com/it/u=3512963775,847648221&fm=224&app=112&f=JPEG?w=500&h=500"
                },
                {
                    "id": "=ROW($A1)",
                    "room": "客厅2",
                    "goods": "物品2",
                    "structure": "制造商2",
                    "serial_number": "33XCBH4",
                    "time": "=TODAY()-90",
                    "source": "联机",
                    "price": 1000,
                    "eval_price": 1000,
                    "remark": "",
                    "has_photo": "是",
                    "photo_url": r"C:\Users\e9\Pictures\微信图片_20220616151258.png"
                }
            ],
            "thing2": [
                {
                    "id": "=ROW($A1)",
                    "room": "客厅",
                    "goods": "物品1",
                    "structure": "制造商1",
                    "serial_number": "33XCBH3",
                    "time": "=TODAY()-120",
                    "source": "联机",
                    "price": 2000,
                    "eval_price": 2000,
                    "remark": "",
                    "has_photo": "是",
                    "photo_url": "https://t13.baidu.com/it/u=3512963775,847648221&fm=224&app=112&f=JPEG?w=500&h=500"
                },
                {
                    "id": "=ROW($A1)",
                    "room": "客厅2",
                    "goods": "物品2",
                    "structure": "制造商2",
                    "serial_number": "33XCBH4",
                    "time": "=TODAY()-90",
                    "source": "联机",
                    "price": 1000,
                    "eval_price": 1000,
                    "remark": "",
                    "has_photo": "是",
                    "photo_url": r"C:\Users\e9\Pictures\微信图片_20220616151258.png"
                }
            ],
            "test": "1"
        },
        "sheet1": {
            "data": {
                "name": "1",
                "data_list": [
                    {"a": 3},
                    {"a": 4}
                ],
                "b": "cec测试"
            },
            "data_list": [
                {
                    "a": 1,
                    "b": 2
                },
                {
                    "a": 2,
                    "b": 1
                }
            ],
            "name": 123
        },
        "sheet2": {
            "data": {
                "name": "1",
                "data_list": [
                    {"a": 3}
                ],
                "b": "cec测试"
            }
        }
    }
    write_excel_for_template(value=value, wb_tmp=wb_tmp, convert_pic=True)
    wb_tmp.save("./val1.xlsx")
    wb_tmp.close()
    wb_tmp = load_workbook(f'./val1.xlsx', data_only=True, read_only=True)


def test2():
    wb_tmp = load_workbook(Path(__file__).parent / 'template/excel2.xlsx')
    value = {
        "sheet1": {
            "data": {
                "name": "1",
                "data_list": [
                    {"a": 3},
                    {"a": 4}
                ],
                "b": "cec测试"
            },
            "data_list": [
                {
                    "a": 1,
                    "b": 2
                },
                {
                    "a": 2,
                    "b": 1
                }
            ],
            "name": 123
        },
        "Sheet2": {
            "data": {
                "b": "1"
            },
            "b": "cec测试"
        }
    }
    write_excel_for_template(value=value, wb_tmp=wb_tmp, convert_pic=True)
    wb_tmp.save("./val2.xlsx")
    # wb_tmp.close()
    # wb_tmp = load_workbook(f'./vaL2.xlsx', data_only=True, read_only=True)

def test3():
    value = {'烧结工序': {'val': [{'id': 2047, 'name': '装备配置', 'type': '2', 'index': None, 'weighted_value': '0.27', 'one_benchmark': '360 m2 及以上烧结机，配置率≥60%', 'two_benchmark': '280 m2 及以上烧结机，配置率≥60%', 'three_benchmark': '180 m2 及以上烧结机，配置率 100%', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.45'}, {'id': 2048, 'name': '厚料层技术', 'type': '2', 'index': None, 'weighted_value': '0.08', 'one_benchmark': '≥800mm', 'two_benchmark': '≥700mm', 'three_benchmark': '≥600mm', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.45'}, {'id': 2049, 'name': '低温烧结工艺', 'type': '2', 'index': None, 'weighted_value': '0.09', 'one_benchmark': '采用该技术', 'two_benchmark': '采用该技术<br/>', 'three_benchmark': '不采用该技术', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.45'}, {'id': 2050, 'name': '余热回收利用装备(回收量以蒸汽计)', 'type': '2', 'index': None, 'weighted_value': '0.11', 'one_benchmark': '建有烧结余热回收利用装置，余热回收量≥9kgce/t 矿', 'two_benchmark': '建有烧结余热回收利用装置，余热回收量≥7kgce/t 矿', 'three_benchmark': '建有烧结余热回收利用装置，余热回收量≥4kgce/t 矿', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.45'}, {'id': 2051, 'name': '降低漏风率技术', 'type': '2', 'index': None, 'weighted_value': '0.09', 'one_benchmark': '采用降低漏风率的技术，使漏风率不超过 35%', 'two_benchmark': '采用降低漏风率的技术，使漏风率不超过 43%', 'three_benchmark': '采用降低漏风率的技术，使漏风率不超过 50%', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.45'}, {'id': 2052, 'name': '烟气综合净化技术', 'type': '2', 'index': None, 'weighted_value': '0.11', 'one_benchmark': '采用烧结机头脱硫、脱硝、脱二噁英及重金属的烟气综合净化技术', 'two_benchmark': '采用烧结机头脱硫、脱硝烟气综合净化技术', 'three_benchmark': '采用烧结机头脱硫烟气净化技术', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.45'}, {'id': 2053, 'name': '除尘设施', 'type': '2', 'index': None, 'weighted_value': '0.11', 'one_benchmark': '物料储存：石灰、除尘灰、脱硫灰等粉状物料，应采用料仓、储罐等方式密闭储存；其他散状物料密闭储存:物料输送：散状物料密闭输送', 'two_benchmark': '物料储存和物料输送：散状物料密闭储存和输送', 'three_benchmark': '物料储存：散状物料采用防风抑尘网或密闭储存；物料输送：散状物料密闭输送', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.45'}, {'id': 2054, 'name': '除尘设施2', 'type': '2', 'index': None, 'weighted_value': '0.14', 'one_benchmark': '机头、机尾、整粒、筛分等主要工序配备有齐全的除尘装置，确保无可见烟粉尘外逸<br/>', 'two_benchmark': '机头、机尾、整粒、筛分等主要工序配备有齐全的除尘装置，确保无可见烟粉尘外逸', 'three_benchmark': '机头、机尾、整粒、筛分等主要工序配备有齐全的除尘装置，确保无可见烟粉尘外逸', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.45'}, {'id': 2056, 'name': '工序能耗（不含脱硝）*', 'type': '2', 'index': None, 'weighted_value': '0.45', 'one_benchmark': '≤45', 'two_benchmark': '≤50', 'three_benchmark': '≤58', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2'}, {'id': 2057, 'name': '工序能耗（含脱硝）*', 'type': '2', 'index': None, 'weighted_value': '0.45', 'one_benchmark': '≤49', 'two_benchmark': '≤54', 'three_benchmark': '≤62', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2'}, {'id': 2058, 'name': '电力消耗，kwh/t（不含脱硝，回收电量不抵扣）', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≤40', 'two_benchmark': '≤45', 'three_benchmark': '≤50', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2'}, {'id': 2059, 'name': '电力消耗，kwh/t（含脱硝，回收电量不抵扣）', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≤50', 'two_benchmark': '≤54', 'three_benchmark': '≤57', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2'}, {'id': 2060, 'name': '固体燃料消耗', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≤41', 'two_benchmark': '≤43', 'three_benchmark': '≤55', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2'}, {'id': 2061, 'name': '生产取水量', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '≤0.2', 'two_benchmark': '≤0.3', 'three_benchmark': '≤0.6', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2'}, {'id': 2063, 'name': '烧结矿品位', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≥58', 'two_benchmark': '≥56', 'three_benchmark': '≥54', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '产品特征', 'parent_weighted_value': '0.05'}, {'id': 2064, 'name': '烧结内循环返矿率', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '≤17', 'two_benchmark': '≤20', 'three_benchmark': '≤27', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '产品特征', 'parent_weighted_value': '0.05'}, {'id': 2065, 'name': '转鼓指数', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '≥83', 'two_benchmark': '≥78', 'three_benchmark': '≥74', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '产品特征', 'parent_weighted_value': '0.05'}, {'id': 2066, 'name': '产品合格率', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '≥99.7', 'two_benchmark': '≥98.0', 'three_benchmark': '≥95.0', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '产品特征', 'parent_weighted_value': '0.05'}, {'id': 2068, 'name': '颗粒物排放量*', 'type': '2', 'index': None, 'weighted_value': '0.25', 'one_benchmark': '≤0.05', 'two_benchmark': '≤0.09', 'three_benchmark': '≤0.22', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2069, 'name': 'SO2排放量*', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≤0.10', 'two_benchmark': '≤0.14', 'three_benchmark': '≤0.57', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2070, 'name': 'NOx（以NO2计）排放量*', 'type': '2', 'index': None, 'weighted_value': '0.25', 'one_benchmark': '≤0.14', 'two_benchmark': '≤0.28', 'three_benchmark': '≤0.85', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2071, 'name': '原料选取', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '控制易产生二噁英物质的原料，包括采用低氯无烟煤、选用含铜量低的铁矿石原料、不再喷 CaCl2 溶液', 'two_benchmark': '控制易产生二噁英物质的原料，包括采用低氯无烟煤、选用含铜量低的铁矿石原料、不再喷 CaCl2 溶液', 'three_benchmark': '-', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2073, 'name': '脱硫副产物利用率', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≥90', 'two_benchmark': '≥70', 'three_benchmark': '-', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1'}, {'id': 2074, 'name': '工业用水重复利用率', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≥92', 'two_benchmark': '≥89', 'three_benchmark': '≥80', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1'}, {'id': 2075, 'name': '粉尘综合利用率', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≥99.9', 'two_benchmark': '≥99.5', 'three_benchmark': '≥99.0', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1'}, {'id': 2077, 'name': '产业政策符合性*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'two_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'three_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2078, 'name': '达标排放*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'two_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'three_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2079, 'name': '总量控制*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'two_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'three_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2080, 'name': '突发环境事件预防*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事故发生', 'two_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事故发生', 'three_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事故发生', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2081, 'name': '建立健全环境管理体系', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建有环境管理体系，并取得认证，能有效运行；全部完成年度环境目标、指标和环境管理方案，并达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'two_benchmark': '建有环境管理体系，能有效运行；完成年度环境目标、指标和环境管理方案≥80%，达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'three_benchmark': '建立有环境管理体系，能有效运行；完成年度环境目标、指标和环境管理方案≥60%，部分达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2082, 'name': '物料和产品运输', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '进出企业的铁精矿、煤炭、焦炭等大宗物料和产品采用铁路、水路、管道或管状带式输送机等清洁方式运输比例不低于 80%；或全部采用新能源汽车或达到国六排放标准的汽车运输', 'two_benchmark': '采用清洁运输方式，减少公路运输比例', 'three_benchmark': '采用清洁运输方式，减少公路运输比例', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2083, 'name': '固体废物处置', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建立固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥80%', 'two_benchmark': '建立固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥70%', 'three_benchmark': '建立固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥50%', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2084, 'name': '清洁生产机制建设与清洁生产审核', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '建有清洁生产领导机构，成员单位与主管人员职责分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥90%；有开展清洁生产工作记录', 'two_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥70%；有开展清洁生产工作记录', 'three_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥50%；有开展清洁生产工作记录', 'proce_id': 8, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}], 'sumr': 0.0}, '球团工序': {'val': [{'id': 2086, 'name': '装备配置', 'type': '2', 'index': None, 'weighted_value': '0.28', 'one_benchmark': '建有链算机-回转窑或带式焙烧装置，单套设备球团生产规模≥300万t', 'two_benchmark': '建有链算机-回转窑或带式焙烧装置，单套设备球团生产规模≥200万t', 'three_benchmark': None, 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35'}, {'id': 2087, 'name': '烟气综合净化技术', 'type': '2', 'index': None, 'weighted_value': '0.26', 'one_benchmark': '采用该技术，烟气脱硫脱硝', 'two_benchmark': '采用该技术，烟气脱硫', 'three_benchmark': '采用该技术，烟气脱硫', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35'}, {'id': 2088, 'name': '余热回收利用装备(回收量以蒸汽计)', 'type': '2', 'index': None, 'weighted_value': '0.23', 'one_benchmark': '采用该技术', 'two_benchmark': '采用该技术', 'three_benchmark': None, 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35'}, {'id': 2089, 'name': '除尘设施', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '物料储存：除尘灰、脱硫灰等粉状\n物料，应采用料仓、储罐等方式密闭储存；其他散状物料密闭储存；\n物抖输送：散状物料密闭输送', 'two_benchmark': '物料储存和物料输送：散状物料密闭储存和输送', 'three_benchmark': '物料储存：散状物料采用\n防风抑尘网或密闭储存； 物料输送：散状物抖密闭\n输送', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35'}, {'id': 2090, 'name': '除尘设施3', 'type': '2', 'index': None, 'weighted_value': '0.13', 'one_benchmark': '焙烧、配料、转运、成品除尘及精矿干燥等主要工序配备有 齐全的除尘装置，确保无可见烟粉尘外逸', 'two_benchmark': '焙烧、配料、转运、成品除尘及精矿干燥等主要工序配备有 齐全的除尘装置，确保无可见烟粉尘外逸', 'three_benchmark': '焙烧、配料、转运、成品除尘及精矿干燥等主要工序配备有 齐全的除尘装置，确保无可见烟粉尘外逸', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35'}, {'id': 2092, 'name': '工序能耗*', 'type': '2', 'index': None, 'weighted_value': '0.45', 'one_benchmark': '≤15', 'two_benchmark': '≤24', 'three_benchmark': '≤26', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2'}, {'id': 2093, 'name': '电力消耗', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≤16', 'two_benchmark': '≤26', 'three_benchmark': '≤36', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2'}, {'id': 2094, 'name': '焙烧燃料消耗', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≤17', 'two_benchmark': '≤27', 'three_benchmark': '≤34', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2'}, {'id': 2095, 'name': '生产取水量', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '≤0.2', 'two_benchmark': '≤0.3', 'three_benchmark': '≤0.5', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2'}, {'id': 2097, 'name': '产品合格率', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≥99.7', 'two_benchmark': '≥98.5', 'three_benchmark': '95.5', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '产品特征', 'parent_weighted_value': '0.05'}, {'id': 2098, 'name': '烧结矿品位', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≥64', 'two_benchmark': '≥62', 'three_benchmark': '≥61', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '产品特征', 'parent_weighted_value': '0.05'}, {'id': 2099, 'name': '转鼓指数', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '≥95', 'two_benchmark': '≥93', 'three_benchmark': '≥91', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '产品特征', 'parent_weighted_value': '0.05'}, {'id': 2101, 'name': '颗粒物排放量*', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≤0.04', 'two_benchmark': '≤0.08', 'three_benchmark': '≤0.20', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2102, 'name': 'SO2排放量*', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≤0.09', 'two_benchmark': '≤0.13', 'three_benchmark': '≤0.50', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2103, 'name': 'NOx（以NO2计）排放量*', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≤0.12', 'two_benchmark': '≤0.25', 'three_benchmark': '≤0.74', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2105, 'name': '脱硫副产物利用率', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≥90', 'two_benchmark': '≥70', 'three_benchmark': None, 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1'}, {'id': 2106, 'name': '工业用水重复利用率', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≥95', 'two_benchmark': '≥90', 'three_benchmark': '≥80', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1'}, {'id': 2107, 'name': '粉尘综合利用率', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≥99.9', 'two_benchmark': '≥99.5', 'three_benchmark': '≥99.0', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1'}, {'id': 2109, 'name': '产业政策符合性*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'two_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'three_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2110, 'name': '达标排放*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物排放浓度满足国家及地方政府相关规定要求', 'two_benchmark': '污染物排放浓度满足国家及地方政府相关规定要求', 'three_benchmark': '污染物排放浓度满足国家及地方政府相关规定要求', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2111, 'name': '总量控制*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物排放量、 二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'two_benchmark': '污染物排放量、 二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'three_benchmark': '污染物排放量、 二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2112, 'name': '突发环境事件预防*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事故发生', 'two_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事故发生', 'three_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事故发生', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2113, 'name': '建立健全环境管理体系', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建有环境管理体系，并取得认证，能有效运行；全部完成年度环境目标、指标和环境管理方案，并达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'two_benchmark': '建有环境管理体系，能有效运行；完成年度环境目标、指标和环境管理方案≥80%，达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'three_benchmark': '建有环境管理体系，能有效运行；完成年度环境目标、指标和环境管理方案≥80%，达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2114, 'name': '物料和产品运输', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '进出企业的铁精矿、煤炭、焦炭等大宗物料和产品采用铁路、水路、管道或管状带式输送机 等清洁方式运输比例不低千 80% ；或全部采用新能源汽车或达到国六排放标准的汽车运输', 'two_benchmark': '采用清洁运输方式，减少公路运输比例', 'three_benchmark': '采用清洁运输方式，减少公路运输比例', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2115, 'name': '固体废物处置', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建立固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥80%', 'two_benchmark': '建立固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥70%', 'three_benchmark': '建立固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥50%', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2116, 'name': '清洁生产机制建设与清洁生产审核', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '建有清洁生产领导机构，成员单位与主管入员职责分工明确；有消洁生产管理制度和奖励管理 办法；定期开展清洁生产审核活动，消洁生产方案实施率≥90%; 有开展清洁生产工作记录', 'two_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有消洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥70%；有开展清洁生产工作记录', 'three_benchmark': '建有清洁生产领导机构 ， 成员单位与主管人员分工明确；有消洁生产管理制度和奖励管理办法；定期开展清沽生产审核活动， 清沽生产方案实施率≥50%；有开展清洁生产工作记录', 'proce_id': 9, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}], 'sumr': 0.0}, '炼铁工序': {'val': [{'id': 2118, 'name': '高炉炉容', 'type': '2', 'index': None, 'weighted_value': '0.24', 'one_benchmark': '4000m³ 以上高炉，配置率≥60 %', 'two_benchmark': '3000m³ 以上高炉，配置率≥60 %', 'three_benchmark': '1200m³ 以上高炉，配置率100 %', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.3'}, {'id': 2119, 'name': '高炉煤气干法除尘装置配置率', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '100', 'two_benchmark': '≥60', 'three_benchmark': '≥25', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.3'}, {'id': 2120, 'name': '高炉煤气干法除尘配置脱酸系统', 'type': '2', 'index': None, 'weighted_value': '0.06', 'one_benchmark': '100', 'two_benchmark': '≥65', 'three_benchmark': '≥50', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.3'}, {'id': 2121, 'name': '高炉炉顶煤气余压利用（TRT或BPRT）装置配置', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': 'TRT 装置配置率 100%，发电量≥45kWh/t 铁；或BPRT 装置配置率\n≥50%，节电量≥40 %', 'two_benchmark': 'TRT 装置配置率 100%，发电量≥42kWh/t 铁；或BPRT 装置配置率\n≥30%，节电量≥30 %', 'three_benchmark': 'TRT 装置配置率 100%，发电量≥35kWh/t 铁；或BPRT 装置配置率\n≥30%，节电量≥20 %', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.3'}, {'id': 2122, 'name': '平均热风温度', 'type': '2', 'index': None, 'weighted_value': '0.18', 'one_benchmark': '≥1240', 'two_benchmark': '≥1200', 'three_benchmark': '≥1160', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.3'}, {'id': 2123, 'name': '除尘设施', 'type': '2', 'index': None, 'weighted_value': '0.11', 'one_benchmark': '1）物料储存：石灰、除尘灰等粉状物料，应采用料仓、储罐等方式密闭储存，其他散状物料密闭储存；物料输送：散状物料密闭输送；生产工艺过程：高炉出铁场平台应封闭或半封闭 ，铁沟、渣沟加盖封闭；\n2）高炉环境除尘及矿槽除尘配备有齐全的除尘装置，确保无可见烟粉尘外逸', 'two_benchmark': '1）物料储存和物料输送：散状物料密闭储存和输送；生产工艺过程：高炉出铁场平台应封闭或半封闭，铁沟、渣沟加盖封闭；\n2）高炉环境除尘及矿槽除尘配备有齐全的除尘装置，确保无可见烟粉尘外逸', 'three_benchmark': '1）物料储存和物料输送：散状物料密闭储存和输送；生产工艺过程：高炉出铁场平台应半封闭，铁沟、渣沟加盖封闭；\n2）高炉环境除尘及矿槽除尘配备有齐全的除尘装置，确保无可见烟粉尘外逸', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.3'}, {'id': 2124, 'name': '炉顶均压煤气回收', 'type': '2', 'index': None, 'weighted_value': '0.11', 'one_benchmark': '采用该技术', 'two_benchmark': '采用该技术', 'three_benchmark': None, 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.3'}, {'id': 2126, 'name': '炼铁工序能耗*', 'type': '2', 'index': None, 'weighted_value': '0.18', 'one_benchmark': '≤380', 'two_benchmark': '≤390', 'three_benchmark': '≤400', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35'}, {'id': 2127, 'name': '高炉燃料比', 'type': '2', 'index': None, 'weighted_value': '0.14', 'one_benchmark': '≤495', 'two_benchmark': '≤515', 'three_benchmark': '≤530', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35'}, {'id': 2128, 'name': '入炉焦比', 'type': '2', 'index': None, 'weighted_value': '0.11', 'one_benchmark': '≤315', 'two_benchmark': '≤340', 'three_benchmark': '≤365', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35'}, {'id': 2129, 'name': '高炉喷煤比', 'type': '2', 'index': None, 'weighted_value': '0.11', 'one_benchmark': '≥170', 'two_benchmark': '≥155', 'three_benchmark': '≥140', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35'}, {'id': 2130, 'name': '入炉铁矿品位', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≥60.0', 'two_benchmark': '≥58.5', 'three_benchmark': '≥57.0', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35'}, {'id': 2131, 'name': '入炉料球团矿比例', 'type': '2', 'index': None, 'weighted_value': '0.03', 'one_benchmark': '≥30.0', 'two_benchmark': '≥20.0', 'three_benchmark': '≥15.0', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35'}, {'id': 2132, 'name': '炼铁金属收得率', 'type': '2', 'index': None, 'weighted_value': '0.06', 'one_benchmark': '≥95.0', 'two_benchmark': '≥90.0', 'three_benchmark': '≥88.0', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35'}, {'id': 2133, 'name': '生产取水量', 'type': '2', 'index': None, 'weighted_value': '0.14', 'one_benchmark': '≤0.6', 'two_benchmark': '≤0.9', 'three_benchmark': '≤1.2', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35'}, {'id': 2134, 'name': '水重复利用率', 'type': '2', 'index': None, 'weighted_value': '0.08', 'one_benchmark': '≥98.0', 'two_benchmark': '≥97.5', 'three_benchmark': '≥97.0', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35'}, {'id': 2136, 'name': '颗粒物排放量*', 'type': '2', 'index': None, 'weighted_value': '0.27', 'one_benchmark': '≤0.1', 'two_benchmark': '≤0.2', 'three_benchmark': '≤0.3', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.15'}, {'id': 2137, 'name': '烟气SO2排放量', 'type': '2', 'index': None, 'weighted_value': '0.13', 'one_benchmark': '≤0.06', 'two_benchmark': '≤0.10', 'three_benchmark': '≤0.12', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.15'}, {'id': 2138, 'name': '烟气NOX排放量', 'type': '2', 'index': None, 'weighted_value': '0.13', 'one_benchmark': '≤0.20', 'two_benchmark': '≤0.30', 'three_benchmark': '≤0.38', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.15'}, {'id': 2139, 'name': '废水排放量', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '0', 'two_benchmark': '0', 'three_benchmark': '0', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.15'}, {'id': 2140, 'name': '渣铁比（干基）', 'type': '2', 'index': None, 'weighted_value': '0.27', 'one_benchmark': '≤300', 'two_benchmark': '≤320', 'three_benchmark': '≤350', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.15'}, {'id': 2142, 'name': '高炉煤气放散率', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≤0.2', 'two_benchmark': '≤0.5', 'three_benchmark': '≤1.0', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1'}, {'id': 2143, 'name': '高炉渣回收利用率', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '100', 'two_benchmark': '100', 'three_benchmark': '≥99', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1'}, {'id': 2144, 'name': '高炉瓦斯灰/泥回收利用率', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '100', 'two_benchmark': '100', 'three_benchmark': '≥95', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1'}, {'id': 2145, 'name': '高炉冲渣水余热回收利用', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '配备余热回收装置并利用', 'two_benchmark': '配备余热回收装置并利用', 'three_benchmark': None, 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1'}, {'id': 2147, 'name': '产业政策符合性*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'two_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'three_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2148, 'name': '达标排放*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'two_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'three_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2149, 'name': '总量控制*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'two_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'three_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2150, 'name': '突发环境事件预防*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施 ，杜绝重大环境污染事故发生', 'two_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施 ，杜绝重大环境污染事故发生', 'three_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施 ，杜绝重大环境污染事故发生', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2151, 'name': '建立健全环境管理体系', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建有环境管理体系，并取得认证,能有效运行；全部完成年度环境目标、指标和环境管理方案，并达到环境持续改进的要求；环境 管理手册、程序文件及作业文件齐备、有效', 'two_benchmark': '建有环境管理体系，能有效运行； 完成年度环境目标、指标和环境管理方案≥80%，达到环境待续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'three_benchmark': '建立有环境管理体系，能有效运 行；完成年度环境目标、指标和环境管理方案≥60%，部分达到环境持续改进的要求；坏境管理手册、程序文件及作业文件齐备', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2152, 'name': '物料和产品运输', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '进出企业的铁精矿、煤炭、焦炭等\n大宗物料和产品采用铁路、水路、管道或管状带式输送机等消洁方式运输比例不低于 80%；或全部采用新能源汽车或达到国六排放标准的汽车运输', 'two_benchmark': '采用清洁运输方式，减少公路运输比例', 'three_benchmark': '采用清洁运输方式，减少公路运输比例', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2153, 'name': '固体废物处置', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建立固体废物管理制度。危险废物\n贮存设有标识，转移联单完备， 制\n定有防范措施和应急预案，无害化\n处理后综合利用率≥80%', 'two_benchmark': '建立固体废物管理制度。危险废物\n贮存设有标识，转移联单完备， 制\n定有防范措施和应急预案，无害化\n处理后综合利用率≥70%', 'three_benchmark': '建立固体废物管理制度。危险废物\n贮存设有标识，转移联单完备， 制\n定有防范措施和应急预案，无害化\n处理后综合利用率≥50%', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2154, 'name': '清洁生产机制建设与清洁生产审核', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '建有清洁生产领导机构，成员单位与主管人员职责分工明确；有清洁生产管理制度和奖励管理办法 ；定期开展清洁生产审核活动，清洁生产方案实施率≥90%；有开展清洁生产工作记录', 'two_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法 ；定期开展清洁生产审核活动，清洁生产方案实施率≥70%；有开展清洁生产工作记录', 'three_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法 ；定期开展清洁生产审核活动，清洁生产方案实施率≥50%；有开展清洁生产工作记录', 'proce_id': 10, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}], 'sumr': 0.0}, '炼钢转炉工序': {'val': [{'id': 2156, 'name': '转炉公称容量', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '200 t 以上转炉配置率≥60%', 'two_benchmark': '150 t 以上转炉配置率≥60%', 'three_benchmark': '100 t 以上转炉配置率100%', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25'}, {'id': 2157, 'name': '炉衬寿命', 'type': '2', 'index': None, 'weighted_value': '0.08', 'one_benchmark': '≥15000', 'two_benchmark': '≥13000', 'three_benchmark': '≥10000', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25'}, {'id': 2158, 'name': '转炉煤气净化装置', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '采用干法除尘技术', 'two_benchmark': '采用改进型湿法除尘技术', 'three_benchmark': '采用改进型湿法除尘技术', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25'}, {'id': 2159, 'name': '除尘设施①', 'type': '2', 'index': None, 'weighted_value': '0.16', 'one_benchmark': '配备转炉一次烟气、二次烟气、 三次烟气除尘设施 ；铁水预处\n理、炉外精炼装置、上料系统、废钢切割系统、钢渣处理及车间内其他散尘点设有除尘设施', 'two_benchmark': '配备转炉一次烟气、二次烟气、 三次烟气除尘设施 ；铁水预处\n理、炉外精炼装置、上料系统、废钢切割系统、钢渣处理及车间内其他散尘点设有除尘设施', 'three_benchmark': '配备转炉一次烟气、二次烟气除\n尘设施；铁水预处理、炉外精炼装置、上料系统设有除 尘设施', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25'}, {'id': 2160, 'name': '除尘设施①', 'type': '2', 'index': None, 'weighted_value': '0.12', 'one_benchmark': '物料储存：除尘灰等粉状物料采用料仓、储罐密闭储存物料输送：除尘灰等粉状物料采用管状带式输送机、气力输送设备、罐车等方式密闭输送生产工艺过程：无可见烟粉尘外溢', 'two_benchmark': '物料储存：除尘灰等粉状物料采用料仓、储罐密闭储存物料输送：除尘灰等粉状物料采用管状带式输送机、气力输送设备、罐车等方式密闭输送生产工艺过程：无可见烟粉尘外溢', 'three_benchmark': '除尘灰等粉状物料密闭储存和输送', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25'}, {'id': 2161, 'name': '铁-钢高效衔接技术', 'type': '2', 'index': None, 'weighted_value': '0.12', 'one_benchmark': '采用该技术，铁水温降≤80°C', 'two_benchmark': '采用该技术，铁水温降≤100°C', 'three_benchmark': '采用该技术，铁水温降≤130°C', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25'}, {'id': 2162, 'name': '自动化控制系统', 'type': '2', 'index': None, 'weighted_value': '0.12', 'one_benchmark': '采用生产管理级、过程控制级和基础自动化级三级计算机控制', 'two_benchmark': '采用基础自动化级和过程控制级两级计算机控制', 'three_benchmark': '采用基础自动化级计算机控制', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25'}, {'id': 2164, 'name': '钢铁料消耗', 'type': '2', 'index': None, 'weighted_value': '0.16', 'one_benchmark': '≤1060', 'two_benchmark': '≤1070', 'three_benchmark': '≤1080', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.25'}, {'id': 2165, 'name': '生产取水量', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '≤0.3', 'two_benchmark': '≤0.5', 'three_benchmark': '≤0.7', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.25'}, {'id': 2166, 'name': '煤气、蒸汽余能余热回收量', 'type': '2', 'index': None, 'weighted_value': '0.32', 'one_benchmark': '≥38', 'two_benchmark': '≥33', 'three_benchmark': '≥28', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.25'}, {'id': 2167, 'name': '冶炼能耗*', 'type': '2', 'index': None, 'weighted_value': '0.32', 'one_benchmark': '≤-30', 'two_benchmark': '≤-25', 'three_benchmark': '≤-20', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.25'}, {'id': 2169, 'name': '钢水合格率', 'type': '2', 'index': None, 'weighted_value': '0.5', 'one_benchmark': '≥99.9', 'two_benchmark': '≥99.8', 'three_benchmark': '≥99.7', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '产品特征', 'parent_weighted_value': '0.05'}, {'id': 2170, 'name': '连铸坯合格率', 'type': '2', 'index': None, 'weighted_value': '0.5', 'one_benchmark': '≥99.90', 'two_benchmark': '≥99.85', 'three_benchmark': '≥99.70', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '产品特征', 'parent_weighted_value': '0.05'}, {'id': 2172, 'name': '颗粒物排放量*', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≤0.10', 'two_benchmark': '≤0.11', 'three_benchmark': '≤0.13', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2173, 'name': '吨钢产渣量', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≤80', 'two_benchmark': '≤90', 'three_benchmark': '≤100', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2174, 'name': '钢渣堆场污染控制措施①', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '钢渣堆场地面满足 GB18599\n防渗等要求，周边设有地下水监测井、定期监测地下水水质', 'two_benchmark': '钢渣堆场地面满足 GB18599防渗等要求', 'three_benchmark': '钢渣堆场地面满足 GB18599防渗等要求', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2176, 'name': '水重复利用率', 'type': '2', 'index': None, 'weighted_value': '0.34', 'one_benchmark': '≥98', 'two_benchmark': '≥97', 'three_benchmark': '≥96', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.15'}, {'id': 2177, 'name': '钢渣综合利用', 'type': '2', 'index': None, 'weighted_value': '0.33', 'one_benchmark': '钢渣综合利用率100%，设有\n钢渣微粉等深度处理设施', 'two_benchmark': '钢渣综合利用率100%', 'three_benchmark': '钢渣综合利用率100%', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.15'}, {'id': 2178, 'name': '含铁尘泥综合利用', 'type': '2', 'index': None, 'weighted_value': '0.33', 'one_benchmark': '设有含铁尘泥集中加工处理设施，含铁尘泥综合利用率 100%', 'two_benchmark': '设有含铁尘泥集中加工处理设施，含铁尘泥综合利用率 100%', 'three_benchmark': '含铁尘泥综合利用率 100%', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.15'}, {'id': 2180, 'name': '产业政策符合性*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'two_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'three_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2181, 'name': '达标排放*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'two_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'three_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2182, 'name': '总量控制*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'two_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'three_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2183, 'name': '突发环境事件预防*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事件发生', 'two_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事件发生', 'three_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事件发生', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2184, 'name': '建立健全环境管理体系', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建有环境管理体系， 并取得认证， 能有效运行； 全部完成年度环境目标、指标和环境管理方案，并达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'two_benchmark': '建有环境管理体系， 并取得认证， 能有效运行； 全部完成年度环境目标、指标和环境管理方案≥80，达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'three_benchmark': '建有环境管理体系， 并取得认证， 能有效运行； 全部完成年度环境目标、指标和环境管理方案≥60，达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2185, 'name': '固体废物处置', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建立有固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥80', 'two_benchmark': '建立有固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥70', 'three_benchmark': '建立有固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥50', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2186, 'name': '清洁生产机制建设与清洁生产审核', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '建有清洁生产领导机构，成员单位与主管人员职责分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥90%;有开展清洁生产工作记录', 'two_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥70%；有开展清洁生产工作记录', 'three_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥50%；有开展清洁生产工作记录', 'proce_id': 11, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}], 'sumr': 0.0}, '轧钢工序': {'val': [{'id': 2220, 'name': '加热炉余热回收', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '双预热蓄热燃烧＋加热炉汽化冷却', 'two_benchmark': '单预热蓄热燃烧 ＋加热炉汽化冷却，或双预热蓄热燃烧', 'three_benchmark': '单预执蓄执燃烧 或加执炉汽化冷却', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25'}, {'id': 2221, 'name': '热轧薄板、棒线连铸坯热送热装技术', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '热装温度≥600°C，热装比≥40%，热轧薄板采用薄板坯连铸连轧技术', 'two_benchmark': '热装温度≥400°C，热装比≥30%', 'three_benchmark': '热装温度≥300°C，热装比≥20%', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25'}, {'id': 2222, 'name': '辊道连接保温设施', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '采用该技术', 'two_benchmark': '采用该技术', 'three_benchmark': '采用该技术', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25'}, {'id': 2223, 'name': '采用轧机烟气净化处理技术', 'type': '2', 'index': None, 'weighted_value': '0.12', 'one_benchmark': '采用该技术，并稳定达标', 'two_benchmark': '采用该技术，并稳定达标', 'three_benchmark': '采用该技术，并稳定达标', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25'}, {'id': 2224, 'name': '加热炉采用低氮燃烧技术', 'type': '2', 'index': None, 'weighted_value': '0.08', 'one_benchmark': '采用低氮燃烧', 'two_benchmark': '采用低氮燃烧', 'three_benchmark': '采用低氮燃烧', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25'}, {'id': 2226, 'name': '主轧线工序能耗（中厚板/棒线/热轧薄板）*', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '\n45/48/48', 'two_benchmark': '48/53/50', 'three_benchmark': '53/58/53', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.25'}, {'id': 2227, 'name': '燃气消耗(中厚板/棒线/热轧薄板）', 'type': '2', 'index': None, 'weighted_value': '0.36', 'one_benchmark': '39/32/40', 'two_benchmark': '43/35/42', 'three_benchmark': '47/39/45', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.25'}, {'id': 2228, 'name': '吨产品新水消耗', 'type': '2', 'index': None, 'weighted_value': '0.24', 'one_benchmark': '≤0.60', 'two_benchmark': '≤0.75', 'three_benchmark': '≤0.90', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.25'}, {'id': 2230, 'name': '钢材综合成材率', 'type': '2', 'index': None, 'weighted_value': '0.6', 'one_benchmark': '棒线/热轧薄板≥99 中厚板≥90', 'two_benchmark': '棒线/热轧薄板≥98 中厚板≥89', 'three_benchmark': '棒线/热轧薄板≥97 中厚板≥88', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '产品特征', 'parent_weighted_value': '0.05'}, {'id': 2231, 'name': '钢材质量合格率', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '棒线/热轧薄板≥99.8 中厚板≥97', 'two_benchmark': '棒线/热轧薄板≥99.5 中厚板≥96', 'three_benchmark': '棒线/热轧薄板≥99.0 中厚板≥95', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '产品特征', 'parent_weighted_value': '0.05'}, {'id': 2233, 'name': '废水排放量*', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≤0.20', 'two_benchmark': '≤0.30', 'three_benchmark': '≤0.40', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'},
            {'id': 2234, 'name': '化学需氧量单位排放量', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≤0.006', 'two_benchmark': '≤0.015', 'three_benchmark': '≤0.020', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2235, 'name': '石油类单位排放量', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≤0.0002', 'two_benchmark': '≤0.0009', 'three_benchmark': '≤0.0012', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2236, 'name': '颗粒物单位排放量', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '≤0.019', 'two_benchmark': '≤0.025', 'three_benchmark': '≤0.050', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2237, 'name': '二氧化硫单位排放量', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≤0.02', 'two_benchmark': '≤0.05', 'three_benchmark': '≤0.07', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2238, 'name': '氮氧化物单位排放量', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≤0.10', 'two_benchmark': '≤0.15', 'three_benchmark': '≤0.17', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2'}, {'id': 2240, 'name': '工业用水重复利用率', 'type': '2', 'index': None, 'weighted_value': '0.53', 'one_benchmark': '≥98', 'two_benchmark': '≥98', 'three_benchmark': '≥95', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.15'}, {'id': 2241, 'name': '氧化铁皮回收利用率', 'type': '2', 'index': None, 'weighted_value': '0.47', 'one_benchmark': '100', 'two_benchmark': '100', 'three_benchmark': '100', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.15'}, {'id': 2243, 'name': '产业政策符合性*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备,未生产国家明令禁止的产品', 'two_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备,未生产国家明令禁止的产品', 'three_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备,未生产国家明令禁止的产品', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2244, 'name': '达标排放*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'two_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'three_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2245, 'name': '总量控制*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'two_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'three_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2246, 'name': '突发环境事件预防*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，杜绝重大环境污染事件发生', 'two_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，杜绝重大环境污染事件发生', 'three_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，杜绝重大环境污染事件发生', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2247, 'name': '建立健全环境管理体系', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '与所在企业同步建立有 GB/T24001 环境管理体系，并取得认证，能有效运行；全部完成年度环境目标、指标和环境管理方案，并达到环境持续改进的要求；环境 管理手册、程序文件及作业文件齐备、有效', 'two_benchmark': '与所在企业同步建立有GB/T24001 环境管理体系，并能有效运行；完成年度环境目标、指标和环境管理方案≥80%，达到环境持续改进的要求：环境管理手册、程序文件及作业文件齐备、有效', 'three_benchmark': '与所在企业同步建立有GB/T24001 环境管理体系，并能有效运行；完成年度环境目标、指标和环境管理方案≥60%，部分达到环境持续改进的要求：环境管理手册、程序文件及作业文件齐备', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2248, 'name': '物料和产品运输', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '进出企业的物料和产品通过铁路、水路、管道等清洁方式运输比例不低于 80%；达不到的，应全部采用新能源汽车或达到国六排放标准的\n汽车运输', 'two_benchmark': '采用清洁运输方式，减少公路运输比例', 'three_benchmark': '采用清洁运输方式，减少公路运输比例', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2249, 'name': '固体废物处置', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建立有固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥80', 'two_benchmark': '建立有固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥70', 'three_benchmark': '建立有固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥50', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}, {'id': 2250, 'name': '清洁生产机制建设与清洁生产审核', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '建有清洁生产领导机构，成员单位与主管人员职责分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥90%;有开展清洁生产工作记录', 'two_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥70%；有开展清洁生产工作记录', 'three_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥50%；有开展清洁生产工作记录', 'proce_id': 13, 'index_value': None, 'level': None, 'score': None, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1'}], 'sumr': 0.0}, 'data': {}}
    wb_tmp = load_workbook(Path(__file__).parent / 'template/excel4.xlsx')
    write_excel_for_template(value=value, wb_tmp=wb_tmp, convert_pic=True, dynamic_method=dynamic_method2())
    wb_tmp.save("./val3.xlsx")


def test4():
    value = {'烧结工序': {'val': [{'id': 2047, 'name': '装备配置', 'type': '2', 'index': None, 'weighted_value': '0.26', 'one_benchmark': '360 m2 及以上烧结机，配置率≥60%', 'two_benchmark': '280 m2 及以上烧结机，配置率≥60%', 'three_benchmark': '180 m2 及以上烧结机，配置率 100%', 'proce_id': 8, 'index_value': '10', 'level': '3', 'score': 0.0546, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35', 'level_name': 'Ⅲ级'}, {'id': 2048, 'name': '厚料层技术', 'type': '2', 'index': None, 'weighted_value': '0.09', 'one_benchmark': '≥800mm', 'two_benchmark': '≥700mm', 'three_benchmark': '≥600mm', 'proce_id': 8, 'index_value': '20', 'level': '1', 'score': 0.0315, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35', 'level_name': 'Ⅰ级'}, {'id': 2049, 'name': '低温烧结工艺', 'type': '2', 'index': None, 'weighted_value': '0.09', 'one_benchmark': '采用该技术', 'two_benchmark': '采用该技术<br/>', 'three_benchmark': '不采用该技术', 'proce_id': 8, 'index_value': '40', 'level': '1', 'score': 0.0315, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35', 'level_name': 'Ⅰ级'}, {'id': 2050, 'name': '余热回收利用装备(回收量以蒸汽计)', 'type': '2', 'index': None, 'weighted_value': '0.11', 'one_benchmark': '建有烧结余热回收利用装置，余热回收量≥9kgce/t 矿', 'two_benchmark': '建有烧结余热回收利用装置，余热回收量≥7kgce/t 矿', 'three_benchmark': '建有烧结余热回收利用装置，余热回收量≥4kgce/t 矿', 'proce_id': 8, 'index_value': '40', 'level': '2', 'score': 0.0308, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35', 'level_name': 'Ⅱ级'}, {'id': 2051, 'name': '降低漏风率技术', 'type': '2', 'index': None, 'weighted_value': '0.09', 'one_benchmark': '采用降低漏风率的技术，使漏风率不超过 35%', 'two_benchmark': '采用降低漏风率的技术，使漏风率不超过 43%', 'three_benchmark': '采用降低漏风率的技术，使漏风率不超过 50%', 'proce_id': 8, 'index_value': '40', 'level': '2', 'score': 0.0252, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35', 'level_name': 'Ⅱ级'}, {'id': 2052, 'name': '烟气综合净化技术', 'type': '2', 'index': None, 'weighted_value': '0.11', 'one_benchmark': '采用烧结机头脱硫、脱硝、脱二噁英及重金属的烟气综合净化技术', 'two_benchmark': '采用烧结机头脱硫、脱硝烟气综合净化技术', 'three_benchmark': '采用烧结机头脱硫烟气净化技术', 'proce_id': 8, 'index_value': '50', 'level': '1', 'score': 0.0385, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35', 'level_name': 'Ⅰ级'}, {'id': 2053, 'name': '除尘设施', 'type': '2', 'index': None, 'weighted_value': '0.11', 'one_benchmark': '物料储存：石灰、除尘灰、脱硫灰等粉状物料，应采用料仓、储罐等方式密闭储存；其他散状物料密闭储存:物料输送：散状物料密闭输送', 'two_benchmark': '物料储存和物料输送：散状物料密闭储存和输送', 'three_benchmark': '物料储存：散状物料采用防风抑尘网或密闭储存；物料输送：散状物料密闭输送', 'proce_id': 8, 'index_value': '70', 'level': '1', 'score': 0.0385, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35', 'level_name': 'Ⅰ级'}, {'id': 2054, 'name': '除尘设施2', 'type': '2', 'index': None, 'weighted_value': '0.14', 'one_benchmark': '机头、机尾、整粒、筛分等主要工序配备有齐全的除尘装置，确保无可见烟粉尘外逸<br/>', 'two_benchmark': '机头、机尾、整粒、筛分等主要工序配备有齐全的除尘装置，确保无可见烟粉尘外逸', 'three_benchmark': '机头、机尾、整粒、筛分等主要工序配备有齐全的除尘装置，确保无可见烟粉尘外逸', 'proce_id': 8, 'index_value': '50', 'level': '1', 'score': 0.049, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35', 'level_name': 'Ⅰ级'}, {'id': 2056, 'name': '工序能耗（不含脱硝）*', 'type': '2', 'index': None, 'weighted_value': '0.45', 'one_benchmark': '≤45', 'two_benchmark': '≤50', 'three_benchmark': '≤58', 'proce_id': 8, 'index_value': '10', 'level': '4', 'score': 0.0, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2', 'level_name': '低于Ⅲ级'}, {'id': 2057, 'name': '工序能耗（含脱硝）*', 'type': '2', 'index': None, 'weighted_value': '0.45', 'one_benchmark': '≤49', 'two_benchmark': '≤54', 'three_benchmark': '≤62', 'proce_id': 8, 'index_value': '50', 'level': '1', 'score': 0.09, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2058, 'name': '电力消耗，kwh/t（不含脱硝，回收电量不抵扣）', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≤40', 'two_benchmark': '≤45', 'three_benchmark': '≤50', 'proce_id': 8, 'index_value': '70', 'level': '4', 'score': 0.0, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2', 'level_name': '低于Ⅲ级'}, {'id': 2059, 'name': '电力消耗，kwh/t（含脱硝，回收电量不抵扣）', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≤50', 'two_benchmark': '≤54', 'three_benchmark': '≤57', 'proce_id': 8, 'index_value': '50', 'level': '1', 'score': 0.03, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2060, 'name': '固体燃料消耗', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≤41', 'two_benchmark': '≤43', 'three_benchmark': '≤55', 'proce_id': 8, 'index_value': '70', 'level': '1', 'score': 0.06, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2061, 'name': '生产取水量', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '≤0.2', 'two_benchmark': '≤0.3', 'three_benchmark': '≤0.6', 'proce_id': 8, 'index_value': '70', 'level': '1', 'score': 0.02, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2063, 'name': '烧结矿品位', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≥58', 'two_benchmark': '≥56', 'three_benchmark': '≥54', 'proce_id': 8, 'index_value': '15', 'level': '3', 'score': 0.012, 'parent_name': '产品特征', 'parent_weighted_value': '0.05', 'level_name': 'Ⅲ级'}, {'id': 2064, 'name': '烧结内循环返矿率', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '≤17', 'two_benchmark': '≤20', 'three_benchmark': '≤27', 'proce_id': 8, 'index_value': '75', 'level': '1', 'score': 0.01, 'parent_name': '产品特征', 'parent_weighted_value': '0.05', 'level_name': 'Ⅰ级'}, {'id': 2065, 'name': '转鼓指数', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '≥83', 'two_benchmark': '≥78', 'three_benchmark': '≥74', 'proce_id': 8, 'index_value': '45', 'level': '2', 'score': 0.008, 'parent_name': '产品特征', 'parent_weighted_value': '0.05', 'level_name': 'Ⅱ级'}, {'id': 2066, 'name': '产品合格率', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '≥99.7', 'two_benchmark': '≥98.0', 'three_benchmark': '≥95.0', 'proce_id': 8, 'index_value': '540', 'level': '1', 'score': 0.01, 'parent_name': '产品特征', 'parent_weighted_value': '0.05', 'level_name': 'Ⅰ级'}, {'id': 2068, 'name': '颗粒物排放量*', 'type': '2', 'index': None, 'weighted_value': '0.25', 'one_benchmark': '≤0.05', 'two_benchmark': '≤0.09', 'three_benchmark': '≤0.22', 'proce_id': 8, 'index_value': '520', 'level': '1', 'score': 0.05, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2069, 'name': 'SO2排放量*', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≤0.10', 'two_benchmark': '≤0.14', 'three_benchmark': '≤0.57', 'proce_id': 8, 'index_value': '45', 'level': '1', 'score': 0.06, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2070, 'name': 'NOx（以NO2计）排放量*', 'type': '2', 'index': None, 'weighted_value': '0.25', 'one_benchmark': '≤0.14', 'two_benchmark': '≤0.28', 'three_benchmark': '≤0.85', 'proce_id': 8, 'index_value': '45', 'level': '1', 'score': 0.05, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2071, 'name': '原料选取', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '控制易产生二噁英物质的原料，包括采用低氯无烟煤、选用含铜量低的铁矿石原料、不再喷 CaCl2 溶液', 'two_benchmark': '控制易产生二噁英物质的原料，包括采用低氯无烟煤、选用含铜量低的铁矿石原料、不再喷 CaCl2 溶液', 'three_benchmark': '-', 'proce_id': 8, 'index_value': '54', 'level': '1', 'score': 0.04, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2073, 'name': '脱硫副产物利用率', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≥90', 'two_benchmark': '≥70', 'three_benchmark': '-', 'proce_id': 8, 'index_value': '5', 'level': '1', 'score': 0.04, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2074, 'name': '工业用水重复利用率', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≥92', 'two_benchmark': '≥89', 'three_benchmark': '≥80', 'proce_id': 8, 'index_value': '5', 'level': '1', 'score': 0.03, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2075, 'name': '粉尘综合利用率', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≥99.9', 'two_benchmark': '≥99.5', 'three_benchmark': '≥99.0', 'proce_id': 8, 'index_value': '42', 'level': '1', 'score': 0.03, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2077, 'name': '产业政策符合性*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'two_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'three_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'proce_id': 8, 'index_value': '52', 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2078, 'name': '达标排放*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'two_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'three_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'proce_id': 8, 'index_value': '45', 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2079, 'name': '总量控制*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'two_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'three_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'proce_id': 8, 'index_value': '54', 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2080, 'name': '突发环境事件预防*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事故发生', 'two_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事故发生', 'three_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事故发生', 'proce_id': 8, 'index_value': '54', 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2081, 'name': '建立健全环境管理体系', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建有环境管理体系，并取得认证，能有效运行；全部完成年度环境目标、指标和环境管理方案，并达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'two_benchmark': '建有环境管理体系，能有效运行；完成年度环境目标、指标和环境管理方案≥80%，达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'three_benchmark': '建立有环境管理体系，能有效运行；完成年度环境目标、指标和环境管理方案≥60%，部分达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备', 'proce_id': 8, 'index_value': '25', 'level': '1', 'score': 0.005, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2082, 'name': '物料和产品运输', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '进出企业的铁精矿、煤炭、焦炭等大宗物料和产品采用铁路、水路、管道或管状带式输送机等清洁方式运输比例不低于 80%；或全部采用新能源汽车或达到国六排放标准的汽车运输', 'two_benchmark': '采用清洁运输方式，减少公路运输比例', 'three_benchmark': '采用清洁运输方式，减少公路运输比例', 'proce_id': 8, 'index_value': '54', 'level': '1', 'score': 0.01, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2083, 'name': '固体废物处置', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建立固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥80%', 'two_benchmark': '建立固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥70%', 'three_benchmark': '建立固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥50%', 'proce_id': 8, 'index_value': '52', 'level': '1', 'score': 0.005, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2084, 'name': '清洁生产机制建设与清洁生产审核', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '建有清洁生产领导机构，成员单位与主管人员职责分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥90%；有开展清洁生产工作记录', 'two_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥70%；有开展清洁生产工作记录', 'three_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥50%；有开展清洁生产工作记录', 'proce_id': 8, 'index_value': '52', 'level': '1', 'score': 0.01, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2291, 'name': '节能减碳机制建设与节能减碳活动', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥90%；年度节能减碳任务达到国家要求', 'two_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥80%；年度节能减碳任务达到国家要求', 'three_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥70%；年度节能减碳任务基本达到国家要求', 'proce_id': 8, 'index_value': None, 'level': '1', 'score': 0.01, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}], 'sumr': '0.9396', 'appraise': '综合评价：钢铁行业（轧钢工序）清洁生产评价指标达到国内清洁生产先进水平。'}, '球团工序': {'val': [{'id': 2086, 'name': '装备配置', 'type': '2', 'index': None, 'weighted_value': '0.28', 'one_benchmark': '建有链算机-回转窑或带式焙烧装置，单套设备球团生产规模≥300万t', 'two_benchmark': '建有链算机-回转窑或带式焙烧装置，单套设备球团生产规模≥200万t', 'three_benchmark': None, 'proce_id': 9, 'index_value': '20', 'level': '3', 'score': 0.0588, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35', 'level_name': 'Ⅲ级'}, {'id': 2087, 'name': '烟气综合净化技术', 'type': '2', 'index': None, 'weighted_value': '0.26', 'one_benchmark': '采用该技术，烟气脱硫脱硝', 'two_benchmark': '采用该技术，烟气脱硫', 'three_benchmark': '采用该技术，烟气脱硫', 'proce_id': 9, 'index_value': None, 'level': '2', 'score': 0.0728, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35', 'level_name': 'Ⅱ级'}, {'id': 2088, 'name': '余热回收利用装备(回收量以蒸汽计)', 'type': '2', 'index': None, 'weighted_value': '0.23', 'one_benchmark': '采用该技术', 'two_benchmark': '采用该技术', 'three_benchmark': None, 'proce_id': 9, 'index_value': None, 'level': '3', 'score': 0.0483, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35', 'level_name': 'Ⅲ级'}, {'id': 2089, 'name': '除尘设施', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '物料储存：除尘灰、脱硫灰等粉状\n物料，应采用料仓、储罐等方式密闭储存；其他散状物料密闭储存；\n物抖输送：散状物料密闭输送', 'two_benchmark': '物料储存和物料输送：散状物料密闭储存和输送', 'three_benchmark': '物料储存：散状物料采用\n防风抑尘网或密闭储存； 物料输送：散状物抖密闭\n输送', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.035, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35', 'level_name': 'Ⅰ级'}, {'id': 2090, 'name': '除尘设施3', 'type': '2', 'index': None, 'weighted_value': '0.13', 'one_benchmark': '焙烧、配料、转运、成品除尘及精矿干燥等主要工序配备有 齐全的除尘装置，确保无可见烟粉尘外逸', 'two_benchmark': '焙烧、配料、转运、成品除尘及精矿干燥等主要工序配备有 齐全的除尘装置，确保无可见烟粉尘外逸', 'three_benchmark': '焙烧、配料、转运、成品除尘及精矿干燥等主要工序配备有 齐全的除尘装置，确保无可见烟粉尘外逸', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.0455, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.35', 'level_name': 'Ⅰ级'}, {'id': 2092, 'name': '工序能耗*', 'type': '2', 'index': None, 'weighted_value': '0.45', 'one_benchmark': '≤15', 'two_benchmark': '≤24', 'three_benchmark': '≤26', 'proce_id': 9, 'index_value': '20', 'level': '4', 'score': 0.0, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2', 'level_name': '低于Ⅲ级'}, {'id': 2093, 'name': '电力消耗', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≤16', 'two_benchmark': '≤26', 'three_benchmark': '≤36', 'proce_id': 9, 'index_value': None, 'level': '4', 'score': 0.0, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2', 'level_name': '低于Ⅲ级'}, {'id': 2094, 'name': '焙烧燃料消耗', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≤17', 'two_benchmark': '≤27', 'three_benchmark': '≤34', 'proce_id': 9, 'index_value': None, 'level': '3', 'score': 0.036, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2', 'level_name': 'Ⅲ级'}, {'id': 2095, 'name': '生产取水量', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '≤0.2', 'two_benchmark': '≤0.3', 'three_benchmark': '≤0.5', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.02, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2097, 'name': '产品合格率', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≥99.7', 'two_benchmark': '≥98.5', 'three_benchmark': '95.5', 'proce_id': 9, 'index_value': None, 'level': '3', 'score': 0.012, 'parent_name': '产品特征', 'parent_weighted_value': '0.05', 'level_name': 'Ⅲ级'}, {'id': 2098, 'name': '烧结矿品位', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≥64', 'two_benchmark': '≥62', 'three_benchmark': '≥61', 'proce_id': 9, 'index_value': None, 'level': '3', 'score': 0.012, 'parent_name': '产品特征', 'parent_weighted_value': '0.05', 'level_name': 'Ⅲ级'}, {'id': 2099, 'name': '转鼓指数', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '≥95', 'two_benchmark': '≥93', 'three_benchmark': '≥91', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.01, 'parent_name': '产品特征', 'parent_weighted_value': '0.05', 'level_name': 'Ⅰ级'}, {'id': 2101, 'name': '颗粒物排放量*', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≤0.04', 'two_benchmark': '≤0.08', 'three_benchmark': '≤0.20', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.06, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2102, 'name': 'SO2排放量*', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≤0.09', 'two_benchmark': '≤0.13', 'three_benchmark': '≤0.50', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.08, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2103, 'name': 'NOx（以NO2计）排放量*', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≤0.12', 'two_benchmark': '≤0.25', 'three_benchmark': '≤0.74', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.06, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2105, 'name': '脱硫副产物利用率', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≥90', 'two_benchmark': '≥70', 'three_benchmark': None, 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.04, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2106, 'name': '工业用水重复利用率', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≥95', 'two_benchmark': '≥90', 'three_benchmark': '≥80', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.03, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2107, 'name': '粉尘综合利用率', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≥99.9', 'two_benchmark': '≥99.5', 'three_benchmark': '≥99.0', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.03, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2109, 'name': '产业政策符合性*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'two_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'three_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2110, 'name': '达标排放*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物排放浓度满足国家及地方政府相关规定要求', 'two_benchmark': '污染物排放浓度满足国家及地方政府相关规定要求', 'three_benchmark': '污染物排放浓度满足国家及地方政府相关规定要求', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2111, 'name': '总量控制*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物排放量、 二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'two_benchmark': '污染物排放量、 二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'three_benchmark': '污染物排放量、 二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2112, 'name': '突发环境事件预防*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事故发生', 'two_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事故发生', 'three_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事故发生', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2113, 'name': '建立健全环境管理体系', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建有环境管理体系，并取得认证，能有效运行；全部完成年度环境目标、指标和环境管理方案，并达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'two_benchmark': '建有环境管理体系，能有效运行；完成年度环境目标、指标和环境管理方案≥80%，达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'three_benchmark': '建有环境管理体系，能有效运行；完成年度环境目标、指标和环境管理方案≥80%，达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.005, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2114, 'name': '物料和产品运输', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '进出企业的铁精矿、煤炭、焦炭等大宗物料和产品采用铁路、水路、管道或管状带式输送机 等清洁方式运输比例不低千 80% ；或全部采用新能源汽车或达到国六排放标准的汽车运输', 'two_benchmark': '采用清洁运输方式，减少公路运输比例', 'three_benchmark': '采用清洁运输方式，减少公路运输比例', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.01, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2115, 'name': '固体废物处置', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建立固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥80%', 'two_benchmark': '建立固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥70%', 'three_benchmark': '建立固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥50%', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.005, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2116, 'name': '清洁生产机制建设与清洁生产审核', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '建有清洁生产领导机构，成员单位与主管入员职责分工明确；有消洁生产管理制度和奖励管理 办法；定期开展清洁生产审核活动，消洁生产方案实施率≥90%; 有开展清洁生产工作记录', 'two_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有消洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥70%；有开展清洁生产工作记录', 'three_benchmark': '建有清洁生产领导机构 ， 成员单位与主管人员分工明确；有消洁生产管理制度和奖励管理办法；定期开展清沽生产审核活动， 清沽生产方案实施率≥50%；有开展清洁生产工作记录', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.01, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2292, 'name': '节能减碳机制建设与节能减碳活动', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥90%；年度节能减碳任务达到国家要求', 'two_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥80%；年度节能减碳任务达到国家要求', 'three_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥70%；年度节能减碳任务基本达到国家要求', 'proce_id': 9, 'index_value': None, 'level': '1', 'score': 0.01, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}], 'sumr': '0.7504', 'appraise': '综合评价：钢铁行业（轧钢工序）清洁生产评价指标未达到国内清洁生产一般水平。'}, '炼铁工序': {'val': [{'id': 2118, 'name': '高炉炉容', 'type': '2', 'index': None, 'weighted_value': '0.24', 'one_benchmark': '4000m³ 以上高炉，配置率≥60 %', 'two_benchmark': '3000m³ 以上高炉，配置率≥60 %', 'three_benchmark': '1200m³ 以上高炉，配置率100 %', 'proce_id': 10, 'index_value': None, 'level': '3', 'score': 0.0432, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.3', 'level_name': 'Ⅲ级'}, {'id': 2119, 'name': '高炉煤气干法除尘装置配置率', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '100', 'two_benchmark': '≥60', 'three_benchmark': '≥25', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.045, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.3', 'level_name': 'Ⅰ级'}, {'id': 2120, 'name': '高炉煤气干法除尘配置脱酸系统', 'type': '2', 'index': None, 'weighted_value': '0.06', 'one_benchmark': '100', 'two_benchmark': '≥65', 'three_benchmark': '≥50', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.018, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.3', 'level_name': 'Ⅰ级'}, {'id': 2121, 'name': '高炉炉顶煤气余压利用（TRT或BPRT）装置配置', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': 'TRT 装置配置率 100%，发电量≥45kWh/t 铁；或BPRT 装置配置率\n≥50%，节电量≥40 %', 'two_benchmark': 'TRT 装置配置率 100%，发电量≥42kWh/t 铁；或BPRT 装置配置率\n≥30%，节电量≥30 %', 'three_benchmark': 'TRT 装置配置率 100%，发电量≥35kWh/t 铁；或BPRT 装置配置率\n≥30%，节电量≥20 %', 'proce_id': 10, 'index_value': None, 'level': '2', 'score': 0.036, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.3', 'level_name': 'Ⅱ级'}, {'id': 2122, 'name': '平均热风温度', 'type': '2', 'index': None, 'weighted_value': '0.18', 'one_benchmark': '≥1240', 'two_benchmark': '≥1200', 'three_benchmark': '≥1160', 'proce_id': 10, 'index_value': None, 'level': '3', 'score': 0.0324, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.3', 'level_name': 'Ⅲ级'}, {'id': 2123, 'name': '除尘设施', 'type': '2', 'index': None, 'weighted_value': '0.11', 'one_benchmark': '1）物料储存：石灰、除尘灰等粉状物料，应采用料仓、储罐等方式密闭储存，其他散状物料密闭储存；物料输送：散状物料密闭输送；生产工艺过程：高炉出铁场平台应封闭或半封闭 ，铁沟、渣沟加盖封闭；\n2）高炉环境除尘及矿槽除尘配备有齐全的除尘装置，确保无可见烟粉尘外逸', 'two_benchmark': '1）物料储存和物料输送：散状物料密闭储存和输送；生产工艺过程：高炉出铁场平台应封闭或半封闭，铁沟、渣沟加盖封闭；\n2）高炉环境除尘及矿槽除尘配备有齐全的除尘装置，确保无可见烟粉尘外逸', 'three_benchmark': '1）物料储存和物料输送：散状物料密闭储存和输送；生产工艺过程：高炉出铁场平台应半封闭，铁沟、渣沟加盖封闭；\n2）高炉环境除尘及矿槽除尘配备有齐全的除尘装置，确保无可见烟粉尘外逸', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.033, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.3', 'level_name': 'Ⅰ级'}, {'id': 2124, 'name': '炉顶均压煤气回收', 'type': '2', 'index': None, 'weighted_value': '0.11', 'one_benchmark': '采用该技术', 'two_benchmark': '采用该技术', 'three_benchmark': None, 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.033, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.3', 'level_name': 'Ⅰ级'}, {'id': 2126, 'name': '炼铁工序能耗*', 'type': '2', 'index': None, 'weighted_value': '0.18', 'one_benchmark': '≤380', 'two_benchmark': '≤390', 'three_benchmark': '≤400', 'proce_id': 10, 'index_value': None, 'level': '3', 'score': 0.0378, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35', 'level_name': 'Ⅲ级'}, {'id': 2127, 'name': '高炉燃料比', 'type': '2', 'index': None, 'weighted_value': '0.14', 'one_benchmark': '≤495', 'two_benchmark': '≤515', 'three_benchmark': '≤530', 'proce_id': 10, 'index_value': None, 'level': '4', 'score': 0.0, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35', 'level_name': '低于Ⅲ级'}, {'id': 2128, 'name': '入炉焦比', 'type': '2', 'index': None, 'weighted_value': '0.11', 'one_benchmark': '≤315', 'two_benchmark': '≤340', 'three_benchmark': '≤365', 'proce_id': 10, 'index_value': None, 'level': '4', 'score': 0.0, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35', 'level_name': '低于Ⅲ级'}, {'id': 2129, 'name': '高炉喷煤比', 'type': '2', 'index': None, 'weighted_value': '0.11', 'one_benchmark': '≥170', 'two_benchmark': '≥155', 'three_benchmark': '≥140', 'proce_id': 10, 'index_value': None, 'level': '3', 'score': 0.0231, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35', 'level_name': 'Ⅲ级'}, {'id': 2130, 'name': '入炉铁矿品位', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≥60.0', 'two_benchmark': '≥58.5', 'three_benchmark': '≥57.0', 'proce_id': 10, 'index_value': None, 'level': '4', 'score': 0.0, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35', 'level_name': '低于Ⅲ级'}, {'id': 2131, 'name': '入炉料球团矿比例', 'type': '2', 'index': None, 'weighted_value': '0.03', 'one_benchmark': '≥30.0', 'two_benchmark': '≥20.0', 'three_benchmark': '≥15.0', 'proce_id': 10, 'index_value': None, 'level': '3', 'score': 0.0063, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35', 'level_name': 'Ⅲ级'}, {'id': 2132, 'name': '炼铁金属收得率', 'type': '2', 'index': None, 'weighted_value': '0.06', 'one_benchmark': '≥95.0', 'two_benchmark': '≥90.0', 'three_benchmark': '≥88.0', 'proce_id': 10, 'index_value': None, 'level': '2', 'score': 0.0168, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35', 'level_name': 'Ⅱ级'}, {'id': 2133, 'name': '生产取水量', 'type': '2', 'index': None, 'weighted_value': '0.14', 'one_benchmark': '≤0.6', 'two_benchmark': '≤0.9', 'three_benchmark': '≤1.2', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.049, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35', 'level_name': 'Ⅰ级'}, {'id': 2134, 'name': '水重复利用率', 'type': '2', 'index': None, 'weighted_value': '0.08', 'one_benchmark': '≥98.0', 'two_benchmark': '≥97.5', 'three_benchmark': '≥97.0', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.028, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.35', 'level_name': 'Ⅰ级'}, {'id': 2136, 'name': '颗粒物排放量*', 'type': '2', 'index': None, 'weighted_value': '0.27', 'one_benchmark': '≤0.1', 'two_benchmark': '≤0.2', 'three_benchmark': '≤0.3', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.0405, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.15', 'level_name': 'Ⅰ级'}, {'id': 2137, 'name': '烟气SO2排放量', 'type': '2', 'index': None, 'weighted_value': '0.13', 'one_benchmark': '≤0.06', 'two_benchmark': '≤0.10', 'three_benchmark': '≤0.12', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.0195, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.15', 'level_name': 'Ⅰ级'}, {'id': 2138, 'name': '烟气NOX排放量', 'type': '2', 'index': None, 'weighted_value': '0.13', 'one_benchmark': '≤0.20', 'two_benchmark': '≤0.30', 'three_benchmark': '≤0.38', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.0195, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.15', 'level_name': 'Ⅰ级'}, {'id': 2139, 'name': '废水排放量', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '0', 'two_benchmark': '0', 'three_benchmark': '0', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.03, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.15', 'level_name': 'Ⅰ级'}, {'id': 2140, 'name': '渣铁比（干基）', 'type': '2', 'index': None, 'weighted_value': '0.27', 'one_benchmark': '≤300', 'two_benchmark': '≤320', 'three_benchmark': '≤350', 'proce_id': 10, 'index_value': None, 'level': '4', 'score': 0.0, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.15', 'level_name': '低于Ⅲ级'}, {'id': 2142, 'name': '高炉煤气放散率', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≤0.2', 'two_benchmark': '≤0.5', 'three_benchmark': '≤1.0', 'proce_id': 10, 'index_value': None, 'level': '4', 'score': 0.0, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1', 'level_name': '低于Ⅲ级'}, {'id': 2143, 'name': '高炉渣回收利用率', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '100', 'two_benchmark': '100', 'three_benchmark': '≥99', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.03, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2144, 'name': '高炉瓦斯灰/泥回收利用率', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '100', 'two_benchmark': '100', 'three_benchmark': '≥95', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.02, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2145, 'name': '高炉冲渣水余热回收利用', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '配备余热回收装置并利用', 'two_benchmark': '配备余热回收装置并利用', 'three_benchmark': None, 'proce_id': 10, 'index_value': None, 'level': '3', 'score': 0.006, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.1', 'level_name': 'Ⅲ级'}, {'id': 2147, 'name': '产业政策符合性*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'two_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'three_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2148, 'name': '达标排放*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'two_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'three_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2149, 'name': '总量控制*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'two_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'three_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2150, 'name': '突发环境事件预防*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施 ，杜绝重大环境污染事故发生', 'two_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施 ，杜绝重大环境污染事故发生', 'three_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施 ，杜绝重大环境污染事故发生', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2151, 'name': '建立健全环境管理体系', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建有环境管理体系，并取得认证,能有效运行；全部完成年度环境目标、指标和环境管理方案，并达到环境持续改进的要求；环境 管理手册、程序文件及作业文件齐备、有效', 'two_benchmark': '建有环境管理体系，能有效运行； 完成年度环境目标、指标和环境管理方案≥80%，达到环境待续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'three_benchmark': '建立有环境管理体系，能有效运 行；完成年度环境目标、指标和环境管理方案≥60%，部分达到环境持续改进的要求；坏境管理手册、程序文件及作业文件齐备', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.005, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2152, 'name': '物料和产品运输', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '进出企业的铁精矿、煤炭、焦炭等\n大宗物料和产品采用铁路、水路、管道或管状带式输送机等消洁方式运输比例不低于 80%；或全部采用新能源汽车或达到国六排放标准的汽车运输', 'two_benchmark': '采用清洁运输方式，减少公路运输比例', 'three_benchmark': '采用清洁运输方式，减少公路运输比例', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.01, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2153, 'name': '固体废物处置', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建立固体废物管理制度。危险废物\n贮存设有标识，转移联单完备， 制\n定有防范措施和应急预案，无害化\n处理后综合利用率≥80%', 'two_benchmark': '建立固体废物管理制度。危险废物\n贮存设有标识，转移联单完备， 制\n定有防范措施和应急预案，无害化\n处理后综合利用率≥70%', 'three_benchmark': '建立固体废物管理制度。危险废物\n贮存设有标识，转移联单完备， 制\n定有防范措施和应急预案，无害化\n处理后综合利用率≥50%', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.005, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2154, 'name': '清洁生产机制建设与清洁生产审核', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '建有清洁生产领导机构，成员单位与主管人员职责分工明确；有清洁生产管理制度和奖励管理办法 ；定期开展清洁生产审核活动，清洁生产方案实施率≥90%；有开展清洁生产工作记录', 'two_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法 ；定期开展清洁生产审核活动，清洁生产方案实施率≥70%；有开展清洁生产工作记录', 'three_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法 ；定期开展清洁生产审核活动，清洁生产方案实施率≥50%；有开展清洁生产工作记录', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.01, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2293, 'name': '节能减碳机制建设与节能减碳活动', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥90%；年度节能减碳任务达到国家要求', 'two_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥80%；年度节能减碳任务达到国家要求', 'three_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥70%；年度节能减碳任务基本达到国家要求', 'proce_id': 10, 'index_value': None, 'level': '1', 'score': 0.01, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}], 'sumr': '0.6671', 'appraise': '综合评价：钢铁行业（轧钢工序）清洁生产评价指标未达到国内清洁生产一般水平。'}, '炼钢转炉工序': {'val': [{'id': 2156, 'name': '转炉公称容量', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '200 t 以上转炉配置率≥60%', 'two_benchmark': '150 t 以上转炉配置率≥60%', 'three_benchmark': '100 t 以上转炉配置率100%', 'proce_id': 11, 'index_value': None, 'level': '3', 'score': 0.03, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25', 'level_name': 'Ⅲ级'}, {'id': 2157, 'name': '炉衬寿命', 'type': '2', 'index': None, 'weighted_value': '0.08', 'one_benchmark': '≥15000', 'two_benchmark': '≥13000', 'three_benchmark': '≥10000', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.02, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25', 'level_name': 'Ⅰ级'}, {'id': 2158, 'name': '转炉煤气净化装置', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '采用干法除尘技术', 'two_benchmark': '采用改进型湿法除尘技术', 'three_benchmark': '采用改进型湿法除尘技术', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.05, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25', 'level_name': 'Ⅰ级'}, {'id': 2159, 'name': '除尘设施①', 'type': '2', 'index': None, 'weighted_value': '0.16', 'one_benchmark': '配备转炉一次烟气、二次烟气、 三次烟气除尘设施 ；铁水预处\n理、炉外精炼装置、上料系统、废钢切割系统、钢渣处理及车间内其他散尘点设有除尘设施', 'two_benchmark': '配备转炉一次烟气、二次烟气、 三次烟气除尘设施 ；铁水预处\n理、炉外精炼装置、上料系统、废钢切割系统、钢渣处理及车间内其他散尘点设有除尘设施', 'three_benchmark': '配备转炉一次烟气、二次烟气除\n尘设施；铁水预处理、炉外精炼装置、上料系统设有除 尘设施', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.04, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25', 'level_name': 'Ⅰ级'}, {'id': 2160, 'name': '除尘设施①', 'type': '2', 'index': None, 'weighted_value': '0.12', 'one_benchmark': '物料储存：除尘灰等粉状物料采用料仓、储罐密闭储存物料输送：除尘灰等粉状物料采用管状带式输送机、气力输送设备、罐车等方式密闭输送生产工艺过程：无可见烟粉尘外溢', 'two_benchmark': '物料储存：除尘灰等粉状物料采用料仓、储罐密闭储存物料输送：除尘灰等粉状物料采用管状带式输送机、气力输送设备、罐车等方式密闭输送生产工艺过程：无可见烟粉尘外溢', 'three_benchmark': '除尘灰等粉状物料密闭储存和输送', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.03, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25', 'level_name': 'Ⅰ级'}, {'id': 2161, 'name': '铁-钢高效衔接技术', 'type': '2', 'index': None, 'weighted_value': '0.12', 'one_benchmark': '采用该技术，铁水温降≤80°C', 'two_benchmark': '采用该技术，铁水温降≤100°C', 'three_benchmark': '采用该技术，铁水温降≤130°C', 'proce_id': 11, 'index_value': None, 'level': '2', 'score': 0.024, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25', 'level_name': 'Ⅱ级'}, {'id': 2162, 'name': '自动化控制系统', 'type': '2', 'index': None, 'weighted_value': '0.12', 'one_benchmark': '采用生产管理级、过程控制级和基础自动化级三级计算机控制', 'two_benchmark': '采用基础自动化级和过程控制级两级计算机控制', 'three_benchmark': '采用基础自动化级计算机控制', 'proce_id': 11, 'index_value': None, 'level': '3', 'score': 0.018, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25', 'level_name': 'Ⅲ级'}, {'id': 2164, 'name': '钢铁料消耗', 'type': '2', 'index': None, 'weighted_value': '0.16', 'one_benchmark': '≤1060', 'two_benchmark': '≤1070', 'three_benchmark': '≤1080', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.04, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.25', 'level_name': 'Ⅰ级'}, {'id': 2165, 'name': '生产取水量', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '≤0.3', 'two_benchmark': '≤0.5', 'three_benchmark': '≤0.7', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.05, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.25', 'level_name': 'Ⅰ级'}, {'id': 2166, 'name': '煤气、蒸汽余能余热回收量', 'type': '2', 'index': None, 'weighted_value': '0.32', 'one_benchmark': '≥38', 'two_benchmark': '≥33', 'three_benchmark': '≥28', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.08, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.25', 'level_name': 'Ⅰ级'}, {'id': 2167, 'name': '冶炼能耗*', 'type': '2', 'index': None, 'weighted_value': '0.32', 'one_benchmark': '≤-30', 'two_benchmark': '≤-25', 'three_benchmark': '≤-20', 'proce_id': 11, 'index_value': None, 'level': '2', 'score': 0.064, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.25', 'level_name': 'Ⅱ级'}, {'id': 2169, 'name': '钢水合格率', 'type': '2', 'index': None, 'weighted_value': '0.5', 'one_benchmark': '≥99.9', 'two_benchmark': '≥99.8', 'three_benchmark': '≥99.7', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.025, 'parent_name': '产品特征', 'parent_weighted_value': '0.05', 'level_name': 'Ⅰ级'}, {'id': 2170, 'name': '连铸坯合格率', 'type': '2', 'index': None, 'weighted_value': '0.5', 'one_benchmark': '≥99.90', 'two_benchmark': '≥99.85', 'three_benchmark': '≥99.70', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.025, 'parent_name': '产品特征', 'parent_weighted_value': '0.05', 'level_name': 'Ⅰ级'}, {'id': 2172, 'name': '颗粒物排放量*', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '≤0.10', 'two_benchmark': '≤0.11', 'three_benchmark': '≤0.13', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.08, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2173, 'name': '吨钢产渣量', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≤80', 'two_benchmark': '≤90', 'three_benchmark': '≤100', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.06, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2174, 'name': '钢渣堆场污染控制措施①', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '钢渣堆场地面满足 GB18599\n防渗等要求，周边设有地下水监测井、定期监测地下水水质', 'two_benchmark': '钢渣堆场地面满足 GB18599防渗等要求', 'three_benchmark': '钢渣堆场地面满足 GB18599防渗等要求', 'proce_id': 11, 'index_value': None, 'level': '2', 'score': 0.048, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅱ级'}, {'id': 2176, 'name': '水重复利用率', 'type': '2', 'index': None, 'weighted_value': '0.34', 'one_benchmark': '≥98', 'two_benchmark': '≥97', 'three_benchmark': '≥96', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.051, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.15', 'level_name': 'Ⅰ级'}, {'id': 2177, 'name': '钢渣综合利用', 'type': '2', 'index': None, 'weighted_value': '0.33', 'one_benchmark': '钢渣综合利用率100%，设有\n钢渣微粉等深度处理设施', 'two_benchmark': '钢渣综合利用率100%', 'three_benchmark': '钢渣综合利用率100%', 'proce_id': 11, 'index_value': None, 'level': '2', 'score': 0.0396, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.15', 'level_name': 'Ⅱ级'}, {'id': 2178, 'name': '含铁尘泥综合利用', 'type': '2', 'index': None, 'weighted_value': '0.33', 'one_benchmark': '设有含铁尘泥集中加工处理设施，含铁尘泥综合利用率 100%', 'two_benchmark': '设有含铁尘泥集中加工处理设施，含铁尘泥综合利用率 100%', 'three_benchmark': '含铁尘泥综合利用率 100%', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.0495, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.15', 'level_name': 'Ⅰ级'}, {'id': 2180, 'name': '产业政策符合性*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'two_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'three_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2181, 'name': '达标排放*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'two_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'three_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2182, 'name': '总量控制*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'two_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'three_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2183, 'name': '突发环境事件预防*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事件发生', 'two_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事件发生', 'three_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，无重大环境污染事件发生', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2184, 'name': '建立健全环境管理体系', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建有环境管理体系， 并取得认证， 能有效运行； 全部完成年度环境目标、指标和环境管理方案，并达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'two_benchmark': '建有环境管理体系， 并取得认证， 能有效运行； 全部完成年度环境目标、指标和环境管理方案≥80，达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'three_benchmark': '建有环境管理体系， 并取得认证， 能有效运行； 全部完成年度环境目标、指标和环境管理方案≥60，达到环境持续改进的要求；环境管理手册、程序文件及作业文件齐备、有效', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.005, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2185, 'name': '固体废物处置', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建立有固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥80', 'two_benchmark': '建立有固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥70', 'three_benchmark': '建立有固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥50', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.005, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2186, 'name': '清洁生产机制建设与清洁生产审核', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '建有清洁生产领导机构，成员单位与主管人员职责分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥90%;有开展清洁生产工作记录', 'two_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥70%；有开展清洁生产工作记录', 'three_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥50%；有开展清洁生产工作记录', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2294, 'name': '节能减碳机制建设与节能减碳活动', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥90%；年度节能减碳任务达到国家要求', 'two_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥80%；年度节能减碳任务达到国家要求', 'three_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥70%；年度节能减碳任务基本达到国家要求', 'proce_id': 11, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '环境管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}], 'sumr': '0.9241', 'appraise': '综合评价：钢铁行业（轧钢工序）清洁生产评价指标达到国内清洁生产先进水平。'}, '轧钢工序': {'val': [{'id': 2220, 'name': '加热炉余热回收', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '双预热蓄热燃烧＋加热炉汽化冷却', 'two_benchmark': '单预热蓄热燃烧 ＋加热炉汽化冷却，或双预热蓄热燃烧', 'three_benchmark': '单预执蓄执燃烧 或加执炉汽化冷却', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.1, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25', 'level_name': 'Ⅰ级'}, {'id': 2221, 'name': '热轧薄板、棒线连铸坯热送热装技术', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '热装温度≥600°C，热装比≥40%，热轧薄板采用薄板坯连铸连轧技术', 'two_benchmark': '热装温度≥400°C，热装比≥30%', 'three_benchmark': '热装温度≥300°C，热装比≥20%', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.05, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25', 'level_name': 'Ⅰ级'}, {'id': 2222, 'name': '辊道连接保温设施', 'type': '2', 'index': None, 'weighted_value': '0.2', 'one_benchmark': '采用该技术', 'two_benchmark': '采用该技术', 'three_benchmark': '采用该技术', 'proce_id': 13, 'index_value': None, 'level': '2', 'score': 0.04, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25', 'level_name': 'Ⅱ级'}, {'id': 2223, 'name': '采用轧机烟气净化处理技术', 'type': '2', 'index': None, 'weighted_value': '0.12', 'one_benchmark': '采用该技术，并稳定达标', 'two_benchmark': '采用该技术，并稳定达标', 'three_benchmark': '采用该技术，并稳定达标', 'proce_id': 13, 'index_value': None, 'level': '4', 'score': 0.0, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25', 'level_name': '低于Ⅲ级'}, {'id': 2224, 'name': '加热炉采用低氮燃烧技术', 'type': '2', 'index': None, 'weighted_value': '0.08', 'one_benchmark': '采用低氮燃烧', 'two_benchmark': '采用低氮燃烧', 'three_benchmark': '采用低氮燃烧', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.02, 'parent_name': '生产工艺装备及技术', 'parent_weighted_value': '0.25', 'level_name': 'Ⅰ级'}, {'id': 2226, 'name': '主轧线工序能耗（中厚板/棒线/热轧薄板）*', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '\n45/48/48', 'two_benchmark': '48/53/50', 'three_benchmark': '53/58/53', 'proce_id': 13, 'index_value': None, 'level': '2', 'score': 0.08, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.25', 'level_name': 'Ⅱ级'}, {'id': 2227, 'name': '燃气消耗(中厚板/棒线/热轧薄板）', 'type': '2', 'index': None, 'weighted_value': '0.36', 'one_benchmark': '39/32/40', 'two_benchmark': '43/35/42', 'three_benchmark': '47/39/45', 'proce_id': 13, 'index_value': None, 'level': '2', 'score': 0.072, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.25', 'level_name': 'Ⅱ级'}, {'id': 2228, 'name': '吨产品新水消耗', 'type': '2', 'index': None, 'weighted_value': '0.24', 'one_benchmark': '≤0.60', 'two_benchmark': '≤0.75', 'three_benchmark': '≤0.90', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.06, 'parent_name': '资源与能源消耗', 'parent_weighted_value': '0.25', 'level_name': 'Ⅰ级'}, {'id': 2230, 'name': '钢材综合成材率', 'type': '2', 'index': None, 'weighted_value': '0.6', 'one_benchmark': '棒线/热轧薄板≥99 中厚板≥90', 'two_benchmark': '棒线/热轧薄板≥98 中厚板≥89', 'three_benchmark': '棒线/热轧薄板≥97 中厚板≥88', 'proce_id': 13, 'index_value': None, 'level': '2', 'score': 0.024, 'parent_name': '产品特征', 'parent_weighted_value': '0.05', 'level_name': 'Ⅱ级'}, {'id': 2231, 'name': '钢材质量合格率', 'type': '2', 'index': None, 'weighted_value': '0.4', 'one_benchmark': '棒线/热轧薄板≥99.8 中厚板≥97', 'two_benchmark': '棒线/热轧薄板≥99.5 中厚板≥96', 'three_benchmark': '棒线/热轧薄板≥99.0 中厚板≥95', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.02, 'parent_name': '产品特征', 'parent_weighted_value': '0.05', 'level_name': 'Ⅰ级'}, {'id': 2233, 'name': '废水排放量*', 'type': '2', 'index': None, 'weighted_value': '0.3', 'one_benchmark': '≤0.20', 'two_benchmark': '≤0.30', 'three_benchmark': '≤0.40', 'proce_id': 13,
            'index_value': None, 'level': '1', 'score': 0.06, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2234, 'name': '化学需氧量单位排放量', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≤0.006', 'two_benchmark': '≤0.015', 'three_benchmark': '≤0.020', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.03, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2235, 'name': '石油类单位排放量', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≤0.0002', 'two_benchmark': '≤0.0009', 'three_benchmark': '≤0.0012', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.03, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2236, 'name': '颗粒物单位排放量', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '≤0.019', 'two_benchmark': '≤0.025', 'three_benchmark': '≤0.050', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.02, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2237, 'name': '二氧化硫单位排放量', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≤0.02', 'two_benchmark': '≤0.05', 'three_benchmark': '≤0.07', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.03, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2238, 'name': '氮氧化物单位排放量', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '≤0.10', 'two_benchmark': '≤0.15', 'three_benchmark': '≤0.17', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.03, 'parent_name': '污染物排放控制', 'parent_weighted_value': '0.2', 'level_name': 'Ⅰ级'}, {'id': 2240, 'name': '工业用水重复利用率', 'type': '2', 'index': None, 'weighted_value': '0.53', 'one_benchmark': '≥98', 'two_benchmark': '≥98', 'three_benchmark': '≥95', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.0795, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.15', 'level_name': 'Ⅰ级'}, {'id': 2241, 'name': '氧化铁皮回收利用率', 'type': '2', 'index': None, 'weighted_value': '0.47', 'one_benchmark': '100', 'two_benchmark': '100', 'three_benchmark': '100', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.0705, 'parent_name': '资源综合利用', 'parent_weighted_value': '0.15', 'level_name': 'Ⅰ级'}, {'id': 2243, 'name': '产业政策符合性*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备,未生产国家明令禁止的产品', 'two_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备,未生产国家明令禁止的产品', 'three_benchmark': '未采用国家明令禁止和淘汰的生产工艺、装备,未生产国家明令禁止的产品', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '清洁生产管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2244, 'name': '达标排放*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'two_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'three_benchmark': '污染物排放满足国家及地方政府相关规定要求', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '清洁生产管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2245, 'name': '总量控制*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'two_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'three_benchmark': '污染物许可排放量、二氧化碳排放量及能源消耗量满足国家及地方政府相关规定要求', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '清洁生产管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2246, 'name': '突发环境事件预防*', 'type': '2', 'index': None, 'weighted_value': '0.15', 'one_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，杜绝重大环境污染事件发生', 'two_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，杜绝重大环境污染事件发生', 'three_benchmark': '按照国家相关规定要求，建立健全环境管理制度及污染事故防范措施，杜绝重大环境污染事件发生', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.015, 'parent_name': '清洁生产管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2247, 'name': '建立健全环境管理体系', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '与所在企业同步建立有 GB/T24001 环境管理体系，并取得认证，能有效运行；全部完成年度环境目标、指标和环境管理方案，并达到环境持续改进的要求；环境 管理手册、程序文件及作业文件齐备、有效', 'two_benchmark': '与所在企业同步建立有GB/T24001 环境管理体系，并能有效运行；完成年度环境目标、指标和环境管理方案≥80%，达到环境持续改进的要求：环境管理手册、程序文件及作业文件齐备、有效', 'three_benchmark': '与所在企业同步建立有GB/T24001 环境管理体系，并能有效运行；完成年度环境目标、指标和环境管理方案≥60%，部分达到环境持续改进的要求：环境管理手册、程序文件及作业文件齐备', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.005, 'parent_name': '清洁生产管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2248, 'name': '物料和产品运输', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '进出企业的物料和产品通过铁路、水路、管道等清洁方式运输比例不低于 80%；达不到的，应全部采用新能源汽车或达到国六排放标准的\n汽车运输', 'two_benchmark': '采用清洁运输方式，减少公路运输比例', 'three_benchmark': '采用清洁运输方式，减少公路运输比例', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.01, 'parent_name': '清洁生产管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2249, 'name': '固体废物处置', 'type': '2', 'index': None, 'weighted_value': '0.05', 'one_benchmark': '建立有固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥80', 'two_benchmark': '建立有固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥70', 'three_benchmark': '建立有固体废物管理制度。危险废物贮存设有标识，转移联单完备，制定有防范措施和应急预案，无害化处理后综合利用率≥50', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.005, 'parent_name': '清洁生产管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2250, 'name': '清洁生产机制建设与清洁生产审核', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '建有清洁生产领导机构，成员单位与主管人员职责分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥90%;有开展清洁生产工作记录', 'two_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥70%；有开展清洁生产工作记录', 'three_benchmark': '建有清洁生产领导机构，成员单位与主管人员分工明确；有清洁生产管理制度和奖励管理办法；定期开展清洁生产审核活动，清洁生产方案实施率≥50%；有开展清洁生产工作记录', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.01, 'parent_name': '清洁生产管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}, {'id': 2295, 'name': '节能减碳机制建设与节能减碳活动', 'type': '2', 'index': None, 'weighted_value': '0.1', 'one_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥90%；年度节能减碳任务达到国家要求', 'two_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥80%；年度节能减碳任务达到国家要求', 'three_benchmark': '建有节能减碳领导机构，成员单位及主管人员职责分工明确；与所在企业同步建立有能源与低碳管理体系并有效运行；制定有节能减碳年度工作计划，组织开展节能减碳工作，年度管控目标完成率≥70%；年度节能减碳任务基本达到国家要求', 'proce_id': 13, 'index_value': None, 'level': '1', 'score': 0.01, 'parent_name': '清洁生产管理要求', 'parent_weighted_value': '0.1', 'level_name': 'Ⅰ级'}], 'sumr': '0.916', 'appraise': '综合评价：钢铁行业（轧钢工序）清洁生产评价指标达到国内清洁生产先进水平。'}}
    wb_tmp = load_workbook(Path(__file__).parent / 'template/excel6.xlsx')
    write_excel_for_template(value=value, wb_tmp=wb_tmp, convert_pic=True, dynamic_method=dynamic_method2())
    wb_tmp.save("./val4.xlsx")

if __name__ == '__main__':
    # test3()
    # test2()
    test1()