YARP 2.3.72 (2018-02-12)                                              {#v2_3_72}
========================

[TOC]

YARP 2.3.72 Release Notes
=========================


A (partial) list of bug fixed and issues resolved in this release can be found
[here](https://github.com/robotology/yarp/issues?q=label%3A%22Fixed+in%3A+YARP+v2.3.72%22).


Important Changes
-----------------

* All the functionalities deprecated in YARP 2.3.65 and previous releases were
  removed.
* C++11 is required also for using YARP, not just for compiling.
* Optional dependency on YCM now requires version 0.6.0 or later.
* Optional dependency on RTF now requires version 1.4.0 or later.
* Dropped `YARP1` support.
* Changed how JAVA bindings are generated
* `yarp::sig::image::getIplImage()` now can return a null pointer
  (instead of terminating with an assert) for not valid Ipl image formats
* `yarp::sig::image::setPixelCode()` now set the pixelSize accordingly (which
  should not be set).
  Since `yarp::sig::image::setPixelSize()` also sets an arbitrary pixel code
  equal to negative itself (`setPixelSize(3)` will set the pixelCode to -3), it
  should be use only for image with custom formats not covered by a yarp
  `pixelCode`.

### Libraries

#### `YARP_OS`

* Clock refactoring: clock type can be initialized in the `yarp::os::Network`
  constructor or in the `Network::init()` function.
  This will take precedence over the environment variable.
  `yarp::os::SystemRateThread` class created as `RateThread` clone but runs
  using system clock only, independently from other settings.
  Any call to `yarp::os::Time::now()` or `delay()` before the object
  `yarp::os::Network` is initialized will abort the program in order to avoid
  undefined behaviour of uninitialized `Time` object
* `Contactable::open(void)` was deprecated. Use `open("...")` instead.
* The following methods in `yarp::os::RateThread` are now `protected` instead
  of `public`:
  * `virtual bool threadInit();`
  * `virtual void threadRelease();`
  * `virtual void run() = 0;`
  * `virtual void beforeStart();`
  * `virtual void afterStart(bool success);`
* The following methods in `yarp::os::PortReaderBufferBase` are now deprecated:
  * `void setAllowReuse(bool flag = true)`
  * `void release(yarp::os::PortReader* completed)`
* The methods `yarp::os::Bottle::operator==()` and
  `yarp::os::Bottle::operator!=()` are now const.


New Features
------------

### Libraries

#### `YARP_OS`

* Added the property *yarprun* to ports opened through `yarprun --server`.
* Added the property *nameserver* for the port opened through `yarpserver`.
* The method `yarp::os::Network::runNameServer()` was removed.
* Added possibility to enable and disable macOS AppNap (`yarp/os/Os.h`).
* Added a few missing `ConstString::assign` overloads.
* Added method `yarp::os::carrier::createFace()`, that returns the needed face
  of the carrier.
  This method is used in `carriers::listen()` and `carriers::connect()` in order
  to open new connection using the correct face.
* The `YARP_WRAP_STL_STRING` option value is now by default `OFF` on non-MSVC
  platforms. This means that `yarp::os::ConstString` is now by default a typedef
  to `std::string` on these platforms.
* Improve how parameters are given to the chosen carrier for a connection:
  all parameters given both on registration and on connect command are collected
  and made available in the connection initialization step.
* Added support for register a contact with an associated carrier different from
  tcp. If the chosen carrier provides a custom `yarp::os::Face` implementation
  this becomes the handler of incoming connections.
  In any case the carrier becomes the default for future connections.

#### `YARP_dev`

* Added a new interface for visual servoing: `IVisualServoing.h`.
* `yarp::dev::CanBuffer` now supports a `const` version of `operator[]`.
* Methods of `yarp::dev::IVirtualAnalogSensor` renamed in order to avoid
  conflicts with similar methods of `yarp::dev::IAnalogSensor`.
* FrameGrabber: add a way to get cropped image via RPC. Streaming of full images
  can be disabled.

#### `YARP_serversql`

* Added a new `Server` class for using yarp server inside an applications.
  Both the yarp server application and the yarpserver rtf fixture use it.


### Carriers

* New H264 carrier. It let you to read and decoding a h264 stream
  published by Gstreamer server.


### Devices

#### `ovrheadset`

* Added hud element set by the configuration file and connected diretly to
  image ports

#### `Map2DServer`

* Several RPC commands were added and removed.
* Added options `ROS::enable_ros_subscriber` and `ROS::enable_ros_publisher`.

#### `laserHokuyo`

* Serial port configuration is now searched in the SERIAL_PORT_CONFIGURATION
  configuration group.


### GUIs

* New `yarpviz` gui imported from https://github.com/robotology/yarpviz

#### `yarpmanager`

* Imported the `iCubCluster` GUI from iCub
  (https://github.com/robotology/icub-main/tree/master/app/iCubCluster).
  It is available only on Unix.
* Added file system watcher to reload the applications when the xml
  has been modified externally. The automatic reload can be disabled
  through a dedicated checkbox in "File" menu.
* Added `yarp name list` and `yarp clean` actions after importing
  profiling capabilities of `yarpviz`.
* Added modifiers column in the connection list for portmonitors.
* Added the possibility to switch broker run-time, from `LocalBroker` to
  `YarpBroker` and viceversa.


### RTF Plugins

* `yarpserver`: created a RTF Fixture manager for running yarpserver as a
  fixture.


### Bindings

* Add bindings to `yarp::dev::IRemoteVariables` and `yarp::dev::IAxisInfo` interfaces, for:
  - retrieving internal variables like the joint coupling matrices while on Gazebo simulation
  - get the mapping of joint indexes to joint names defined in the motors control board server (simulation and real robot)

#### Java

* Completely refactored JAVA Bindings (#1372)
  Java sources and pre-compiled classes are no more generated during the build
  process (`PREPARE_CLASS_FILES` option has been removed too).
  Two `.jar` files are instead generated and installed:
  * `<install_dir>/share/yarp/java/yarp.jar`: contains all the YARP Java
    classes.
  * `<install_dir>/share/yarp/java/yarp_matlab_java.jar`: contains Java
    utilities for MATLAB.
  The JNI libraries to be loaded by the JAVA application is now called
  `libyarp_java.jnilib` and it is installed in
  `<install_dir>/lib/jni/libyarp_java.jnilib`.
* Changed `package` of JAVA MATLAB Utilities: from global package to
  `yarp.matlab`


Bug Fixes
---------

### Libraries

#### `YARP_OS`

* Added `unprepare` method to `Publisher`. See `BufferedPort` for documentation
  on how to use `prepare` and `unprepare` (#1425).
* Optimized `Stamp::read()` and `Stamp::write()` for textMode.

#### `YARP_sig`

* Fixed pixelSize information loss in `yarp::sig::FlexImage:::read()`.


### GUIs

#### yarpmanager

* Fixed the check of the status of the Computers, now it verifies that the
  corresponding port has been opened through `yarp run`. Be aware that after
  these changes `yarpmanager` will not detect machines with `yarp 2.3.70`
  and earlier.
* Added scan among the available carriers when you click connect and disconnect,
  if the specified carrier is not available a proper error message will be
  written on log.
* the column carrier in the connection list has been substituted with a combobox
  with the available carriers.

#### yarpdataplayer

* Fixed `yarpdataplayer` going to idle because of AppNap on macOS (#1153)


Contributors
------------

This is a list of people that contributed to this release (generated from the
git history using `git shortlog -ens --no-merges v2.3.70..v2.3.72`):

```
   192	Daniele E. Domenichelli <daniele.domenichelli@iit.it>
   169	Nicolò Genesio <nicolo.genesio@iit.it>
   166	Damiano Enerli <damiano.enerli@iit.it>
    64	Alberto Cardellino <alberto.cardellino@iit.it>
    49	Andrea Ruzzenenti <andrea.ruzzenenti@iit.it>
    35	Marco Randazzo <marco.randazzo@iit.it>
    25	Francesco Romano <francesco.romano@iit.it>
    22	Ali Paikan <ali.paikan@iit.it>
    14	Claudio Fantacci <claudio.fantacci@iit.it>
    13	Silvio Traversaro <silvio.traversaro@iit.it>
    12	Valentina Gaggero <valentina.gaggero@iit.it>
     7	YARP Developers <yarp0-devel@lists.sourceforge.net>
     5	Bartek Łukawski <bwmn.peter@gmail.com>
     5	Nuno Guedelha <nuno.guedelha@iit.it>
     4	Ugo Pattacini <ugo.pattacini@iit.it>
     3	David-Estevez <david.estevez.fdez@gmail.com>
     3	Lorenzo Natale <lorenzo.natale@iit.it>
     3	Matteo Brunettini <matteo.brunettini@iit.it>
     2	Juan G. Victores <jcgvicto@gmail.com>
     1	Elena Rampone <elena.rampone@iit.it>
     1	Giovanni Saponaro <gsaponaro@isr.ist.utl.pt>
     1	Marco Monforte <marco.monforte@iit.it>
     1	Massimiliano Iacono <massimiliano.iacono@iit.it>
```
