# coding: utf-8

"""


    Generated by: https://openapi-generator.tech
"""

from dataclasses import dataclass
import typing_extensions
import urllib3
from urllib3._collections import HTTPHeaderDict

from collibra_core import api_client, exceptions
from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from collibra_core import schemas  # noqa: F401

from collibra_core.model.paged_response_view_permission import PagedResponseViewPermission

from . import path

# Query params
OffsetSchema = schemas.Int32Schema
LimitSchema = schemas.Int32Schema
CountLimitSchema = schemas.Int32Schema
UserIdSchema = schemas.UUIDSchema
UserGroupIdSchema = schemas.UUIDSchema
ResourceIdSchema = schemas.UUIDSchema


class ResourceTypeSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "View": "VIEW",
            "Asset": "ASSET",
            "Community": "COMMUNITY",
            "Domain": "DOMAIN",
            "AssetType": "ASSET_TYPE",
            "DomainType": "DOMAIN_TYPE",
            "Status": "STATUS",
            "User": "USER",
            "ClassificationMatch": "CLASSIFICATION_MATCH",
            "UserGroup": "USER_GROUP",
            "Attribute": "ATTRIBUTE",
            "StringAttribute": "STRING_ATTRIBUTE",
            "ScriptAttribute": "SCRIPT_ATTRIBUTE",
            "BooleanAttribute": "BOOLEAN_ATTRIBUTE",
            "DateAttribute": "DATE_ATTRIBUTE",
            "NumericAttribute": "NUMERIC_ATTRIBUTE",
            "SingleValueListAttribute": "SINGLE_VALUE_LIST_ATTRIBUTE",
            "MultiValueListAttribute": "MULTI_VALUE_LIST_ATTRIBUTE",
            "Comment": "COMMENT",
            "Attachment": "ATTACHMENT",
            "Responsibility": "RESPONSIBILITY",
            "Workflow": "WORKFLOW",
            "Job": "JOB",
            "Relation": "RELATION",
            "RelationType": "RELATION_TYPE",
            "ComplexRelation": "COMPLEX_RELATION",
            "ComplexRelationType": "COMPLEX_RELATION_TYPE",
            "ArticulationRule": "ARTICULATION_RULE",
            "Assignment": "ASSIGNMENT",
            "Scope": "SCOPE",
            "RelationTrace": "RELATION_TRACE",
            "ValidationRule": "VALIDATION_RULE",
            "DataQualityRule": "DATA_QUALITY_RULE",
            "DataQualityMetric": "DATA_QUALITY_METRIC",
            "Address": "ADDRESS",
            "InstantMessagingAccount": "INSTANT_MESSAGING_ACCOUNT",
            "Email": "EMAIL",
            "PhoneNumber": "PHONE_NUMBER",
            "Website": "WEBSITE",
            "Activity": "ACTIVITY",
            "FormProperty": "FORM_PROPERTY",
            "WorkflowTask": "WORKFLOW_TASK",
            "ActivityChange": "ACTIVITY_CHANGE",
            "WorkflowInstance": "WORKFLOW_INSTANCE",
            "Role": "ROLE",
            "AttributeType": "ATTRIBUTE_TYPE",
            "BooleanAttributeType": "BOOLEAN_ATTRIBUTE_TYPE",
            "DateAttributeType": "DATE_ATTRIBUTE_TYPE",
            "DateTimeAttributeType": "DATE_TIME_ATTRIBUTE_TYPE",
            "MultiValueListAttributeType": "MULTI_VALUE_LIST_ATTRIBUTE_TYPE",
            "NumericAttributeType": "NUMERIC_ATTRIBUTE_TYPE",
            "ScriptAttributeType": "SCRIPT_ATTRIBUTE_TYPE",
            "SingleValueListAttributeType": "SINGLE_VALUE_LIST_ATTRIBUTE_TYPE",
            "StringAttributeType": "STRING_ATTRIBUTE_TYPE",
            "ViewSharingRule": "VIEW_SHARING_RULE",
            "ViewAssignmentRule": "VIEW_ASSIGNMENT_RULE",
            "JdbcDriverFile": "JDBC_DRIVER_FILE",
            "JdbcDriver": "JDBC_DRIVER",
            "JdbcIngestionProperties": "JDBC_INGESTION_PROPERTIES",
            "CsvIngestionProperties": "CSV_INGESTION_PROPERTIES",
            "ExcelIngestionProperties": "EXCEL_INGESTION_PROPERTIES",
            "ConnectionStringParameter": "CONNECTION_STRING_PARAMETER",
            "AssignedCharacteristicType": "ASSIGNED_CHARACTERISTIC_TYPE",
            "Notification": "NOTIFICATION",
            "Tag": "TAG",
            "ComplexRelationLegType": "COMPLEX_RELATION_LEG_TYPE",
            "ComplexRelationAttributeType": "COMPLEX_RELATION_ATTRIBUTE_TYPE",
            "ComplexRelationLeg": "COMPLEX_RELATION_LEG",
            "BaseDataType": "BASE_DATA_TYPE",
            "AdvancedDataType": "ADVANCED_DATA_TYPE",
            "DiagramPicture": "DIAGRAM_PICTURE",
            "DiagramPictureSharingRule": "DIAGRAM_PICTURE_SHARING_RULE",
            "DiagramPictureAssignmentRule": "DIAGRAM_PICTURE_ASSIGNMENT_RULE",
            "Rating": "RATING",
            "Classification": "CLASSIFICATION",
            "PhysicalDataConnector": "PHYSICAL_DATA_CONNECTOR",
            "Context": "CONTEXT",
        }
    
    @schemas.classproperty
    def VIEW(cls):
        return cls("View")
    
    @schemas.classproperty
    def ASSET(cls):
        return cls("Asset")
    
    @schemas.classproperty
    def COMMUNITY(cls):
        return cls("Community")
    
    @schemas.classproperty
    def DOMAIN(cls):
        return cls("Domain")
    
    @schemas.classproperty
    def ASSET_TYPE(cls):
        return cls("AssetType")
    
    @schemas.classproperty
    def DOMAIN_TYPE(cls):
        return cls("DomainType")
    
    @schemas.classproperty
    def STATUS(cls):
        return cls("Status")
    
    @schemas.classproperty
    def USER(cls):
        return cls("User")
    
    @schemas.classproperty
    def CLASSIFICATION_MATCH(cls):
        return cls("ClassificationMatch")
    
    @schemas.classproperty
    def USER_GROUP(cls):
        return cls("UserGroup")
    
    @schemas.classproperty
    def ATTRIBUTE(cls):
        return cls("Attribute")
    
    @schemas.classproperty
    def STRING_ATTRIBUTE(cls):
        return cls("StringAttribute")
    
    @schemas.classproperty
    def SCRIPT_ATTRIBUTE(cls):
        return cls("ScriptAttribute")
    
    @schemas.classproperty
    def BOOLEAN_ATTRIBUTE(cls):
        return cls("BooleanAttribute")
    
    @schemas.classproperty
    def DATE_ATTRIBUTE(cls):
        return cls("DateAttribute")
    
    @schemas.classproperty
    def NUMERIC_ATTRIBUTE(cls):
        return cls("NumericAttribute")
    
    @schemas.classproperty
    def SINGLE_VALUE_LIST_ATTRIBUTE(cls):
        return cls("SingleValueListAttribute")
    
    @schemas.classproperty
    def MULTI_VALUE_LIST_ATTRIBUTE(cls):
        return cls("MultiValueListAttribute")
    
    @schemas.classproperty
    def COMMENT(cls):
        return cls("Comment")
    
    @schemas.classproperty
    def ATTACHMENT(cls):
        return cls("Attachment")
    
    @schemas.classproperty
    def RESPONSIBILITY(cls):
        return cls("Responsibility")
    
    @schemas.classproperty
    def WORKFLOW(cls):
        return cls("Workflow")
    
    @schemas.classproperty
    def JOB(cls):
        return cls("Job")
    
    @schemas.classproperty
    def RELATION(cls):
        return cls("Relation")
    
    @schemas.classproperty
    def RELATION_TYPE(cls):
        return cls("RelationType")
    
    @schemas.classproperty
    def COMPLEX_RELATION(cls):
        return cls("ComplexRelation")
    
    @schemas.classproperty
    def COMPLEX_RELATION_TYPE(cls):
        return cls("ComplexRelationType")
    
    @schemas.classproperty
    def ARTICULATION_RULE(cls):
        return cls("ArticulationRule")
    
    @schemas.classproperty
    def ASSIGNMENT(cls):
        return cls("Assignment")
    
    @schemas.classproperty
    def SCOPE(cls):
        return cls("Scope")
    
    @schemas.classproperty
    def RELATION_TRACE(cls):
        return cls("RelationTrace")
    
    @schemas.classproperty
    def VALIDATION_RULE(cls):
        return cls("ValidationRule")
    
    @schemas.classproperty
    def DATA_QUALITY_RULE(cls):
        return cls("DataQualityRule")
    
    @schemas.classproperty
    def DATA_QUALITY_METRIC(cls):
        return cls("DataQualityMetric")
    
    @schemas.classproperty
    def ADDRESS(cls):
        return cls("Address")
    
    @schemas.classproperty
    def INSTANT_MESSAGING_ACCOUNT(cls):
        return cls("InstantMessagingAccount")
    
    @schemas.classproperty
    def EMAIL(cls):
        return cls("Email")
    
    @schemas.classproperty
    def PHONE_NUMBER(cls):
        return cls("PhoneNumber")
    
    @schemas.classproperty
    def WEBSITE(cls):
        return cls("Website")
    
    @schemas.classproperty
    def ACTIVITY(cls):
        return cls("Activity")
    
    @schemas.classproperty
    def FORM_PROPERTY(cls):
        return cls("FormProperty")
    
    @schemas.classproperty
    def WORKFLOW_TASK(cls):
        return cls("WorkflowTask")
    
    @schemas.classproperty
    def ACTIVITY_CHANGE(cls):
        return cls("ActivityChange")
    
    @schemas.classproperty
    def WORKFLOW_INSTANCE(cls):
        return cls("WorkflowInstance")
    
    @schemas.classproperty
    def ROLE(cls):
        return cls("Role")
    
    @schemas.classproperty
    def ATTRIBUTE_TYPE(cls):
        return cls("AttributeType")
    
    @schemas.classproperty
    def BOOLEAN_ATTRIBUTE_TYPE(cls):
        return cls("BooleanAttributeType")
    
    @schemas.classproperty
    def DATE_ATTRIBUTE_TYPE(cls):
        return cls("DateAttributeType")
    
    @schemas.classproperty
    def DATE_TIME_ATTRIBUTE_TYPE(cls):
        return cls("DateTimeAttributeType")
    
    @schemas.classproperty
    def MULTI_VALUE_LIST_ATTRIBUTE_TYPE(cls):
        return cls("MultiValueListAttributeType")
    
    @schemas.classproperty
    def NUMERIC_ATTRIBUTE_TYPE(cls):
        return cls("NumericAttributeType")
    
    @schemas.classproperty
    def SCRIPT_ATTRIBUTE_TYPE(cls):
        return cls("ScriptAttributeType")
    
    @schemas.classproperty
    def SINGLE_VALUE_LIST_ATTRIBUTE_TYPE(cls):
        return cls("SingleValueListAttributeType")
    
    @schemas.classproperty
    def STRING_ATTRIBUTE_TYPE(cls):
        return cls("StringAttributeType")
    
    @schemas.classproperty
    def VIEW_SHARING_RULE(cls):
        return cls("ViewSharingRule")
    
    @schemas.classproperty
    def VIEW_ASSIGNMENT_RULE(cls):
        return cls("ViewAssignmentRule")
    
    @schemas.classproperty
    def JDBC_DRIVER_FILE(cls):
        return cls("JdbcDriverFile")
    
    @schemas.classproperty
    def JDBC_DRIVER(cls):
        return cls("JdbcDriver")
    
    @schemas.classproperty
    def JDBC_INGESTION_PROPERTIES(cls):
        return cls("JdbcIngestionProperties")
    
    @schemas.classproperty
    def CSV_INGESTION_PROPERTIES(cls):
        return cls("CsvIngestionProperties")
    
    @schemas.classproperty
    def EXCEL_INGESTION_PROPERTIES(cls):
        return cls("ExcelIngestionProperties")
    
    @schemas.classproperty
    def CONNECTION_STRING_PARAMETER(cls):
        return cls("ConnectionStringParameter")
    
    @schemas.classproperty
    def ASSIGNED_CHARACTERISTIC_TYPE(cls):
        return cls("AssignedCharacteristicType")
    
    @schemas.classproperty
    def NOTIFICATION(cls):
        return cls("Notification")
    
    @schemas.classproperty
    def TAG(cls):
        return cls("Tag")
    
    @schemas.classproperty
    def COMPLEX_RELATION_LEG_TYPE(cls):
        return cls("ComplexRelationLegType")
    
    @schemas.classproperty
    def COMPLEX_RELATION_ATTRIBUTE_TYPE(cls):
        return cls("ComplexRelationAttributeType")
    
    @schemas.classproperty
    def COMPLEX_RELATION_LEG(cls):
        return cls("ComplexRelationLeg")
    
    @schemas.classproperty
    def BASE_DATA_TYPE(cls):
        return cls("BaseDataType")
    
    @schemas.classproperty
    def ADVANCED_DATA_TYPE(cls):
        return cls("AdvancedDataType")
    
    @schemas.classproperty
    def DIAGRAM_PICTURE(cls):
        return cls("DiagramPicture")
    
    @schemas.classproperty
    def DIAGRAM_PICTURE_SHARING_RULE(cls):
        return cls("DiagramPictureSharingRule")
    
    @schemas.classproperty
    def DIAGRAM_PICTURE_ASSIGNMENT_RULE(cls):
        return cls("DiagramPictureAssignmentRule")
    
    @schemas.classproperty
    def RATING(cls):
        return cls("Rating")
    
    @schemas.classproperty
    def CLASSIFICATION(cls):
        return cls("Classification")
    
    @schemas.classproperty
    def PHYSICAL_DATA_CONNECTOR(cls):
        return cls("PhysicalDataConnector")
    
    @schemas.classproperty
    def CONTEXT(cls):
        return cls("Context")
IncludeInheritedSchema = schemas.BoolSchema
RequestRequiredQueryParams = typing_extensions.TypedDict(
    'RequestRequiredQueryParams',
    {
    }
)
RequestOptionalQueryParams = typing_extensions.TypedDict(
    'RequestOptionalQueryParams',
    {
        'offset': typing.Union[OffsetSchema, decimal.Decimal, int, ],
        'limit': typing.Union[LimitSchema, decimal.Decimal, int, ],
        'countLimit': typing.Union[CountLimitSchema, decimal.Decimal, int, ],
        'userId': typing.Union[UserIdSchema, str, uuid.UUID, ],
        'userGroupId': typing.Union[UserGroupIdSchema, str, uuid.UUID, ],
        'resourceId': typing.Union[ResourceIdSchema, str, uuid.UUID, ],
        'resourceType': typing.Union[ResourceTypeSchema, str, ],
        'includeInherited': typing.Union[IncludeInheritedSchema, bool, ],
    },
    total=False
)


class RequestQueryParams(RequestRequiredQueryParams, RequestOptionalQueryParams):
    pass


request_query_offset = api_client.QueryParameter(
    name="offset",
    style=api_client.ParameterStyle.FORM,
    schema=OffsetSchema,
    explode=True,
)
request_query_limit = api_client.QueryParameter(
    name="limit",
    style=api_client.ParameterStyle.FORM,
    schema=LimitSchema,
    explode=True,
)
request_query_count_limit = api_client.QueryParameter(
    name="countLimit",
    style=api_client.ParameterStyle.FORM,
    schema=CountLimitSchema,
    explode=True,
)
request_query_user_id = api_client.QueryParameter(
    name="userId",
    style=api_client.ParameterStyle.FORM,
    schema=UserIdSchema,
    explode=True,
)
request_query_user_group_id = api_client.QueryParameter(
    name="userGroupId",
    style=api_client.ParameterStyle.FORM,
    schema=UserGroupIdSchema,
    explode=True,
)
request_query_resource_id = api_client.QueryParameter(
    name="resourceId",
    style=api_client.ParameterStyle.FORM,
    schema=ResourceIdSchema,
    explode=True,
)
request_query_resource_type = api_client.QueryParameter(
    name="resourceType",
    style=api_client.ParameterStyle.FORM,
    schema=ResourceTypeSchema,
    explode=True,
)
request_query_include_inherited = api_client.QueryParameter(
    name="includeInherited",
    style=api_client.ParameterStyle.FORM,
    schema=IncludeInheritedSchema,
    explode=True,
)
_auth = [
    'basicAuth',
    'bearerAuth',
]
SchemaFor0ResponseBodyApplicationJson = PagedResponseViewPermission


@dataclass
class ApiResponseForDefault(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[
        SchemaFor0ResponseBodyApplicationJson,
    ]
    headers: schemas.Unset = schemas.unset


_response_for_default = api_client.OpenApiResponse(
    response_cls=ApiResponseForDefault,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor0ResponseBodyApplicationJson),
    },
)
_status_code_to_response = {
    'default': _response_for_default,
}
_all_accept_content_types = (
    'application/json',
)


class BaseApi(api_client.Api):
    @typing.overload
    def _find_view_permissions_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[
        ApiResponseForDefault,
    ]: ...

    @typing.overload
    def _find_view_permissions_oapg(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization: ...

    @typing.overload
    def _find_view_permissions_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[
        ApiResponseForDefault,
        api_client.ApiResponseWithoutDeserialization,
    ]: ...

    def _find_view_permissions_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        """
        Finds view permissions with given criteria.
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        used_path = path.value

        prefix_separator_iterator = None
        for parameter in (
            request_query_offset,
            request_query_limit,
            request_query_count_limit,
            request_query_user_id,
            request_query_user_group_id,
            request_query_resource_id,
            request_query_resource_type,
            request_query_include_inherited,
        ):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(parameter_data, prefix_separator_iterator)
            for serialized_value in serialized_data.values():
                used_path += serialized_value

        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)

        response = self.api_client.call_api(
            resource_path=used_path,
            method='get'.upper(),
            headers=_headers,
            auth_settings=_auth,
            stream=stream,
            timeout=timeout,
        )

        if skip_deserialization:
            api_response = api_client.ApiResponseWithoutDeserialization(response=response)
        else:
            response_for_status = _status_code_to_response.get(str(response.status))
            if response_for_status:
                api_response = response_for_status.deserialize(response, self.api_client.configuration)
            else:
                default_response = _status_code_to_response.get('default')
                if default_response:
                    api_response = default_response.deserialize(response, self.api_client.configuration)
                else:
                    api_response = api_client.ApiResponseWithoutDeserialization(response=response)

        if not 200 <= response.status <= 299:
            raise exceptions.ApiException(api_response=api_response)

        return api_response


class FindViewPermissions(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId fn names

    @typing.overload
    def find_view_permissions(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[
        ApiResponseForDefault,
    ]: ...

    @typing.overload
    def find_view_permissions(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization: ...

    @typing.overload
    def find_view_permissions(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[
        ApiResponseForDefault,
        api_client.ApiResponseWithoutDeserialization,
    ]: ...

    def find_view_permissions(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        return self._find_view_permissions_oapg(
            query_params=query_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization
        )


class ApiForget(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names

    @typing.overload
    def get(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[
        ApiResponseForDefault,
    ]: ...

    @typing.overload
    def get(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization: ...

    @typing.overload
    def get(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[
        ApiResponseForDefault,
        api_client.ApiResponseWithoutDeserialization,
    ]: ...

    def get(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        return self._find_view_permissions_oapg(
            query_params=query_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization
        )


