# coding: utf-8

"""


    Generated by: https://openapi-generator.tech
"""

from dataclasses import dataclass
import typing_extensions
import urllib3
from urllib3._collections import HTTPHeaderDict

from collibra_core import api_client, exceptions
from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from collibra_core import schemas  # noqa: F401

from . import path

# Query params


class ViewLocationSchema(
    schemas.EnumBase,
    schemas.StrSchema
):


    class MetaOapg:
        enum_value_to_name = {
            "GLOBAL_VIEW": "GLOBAL_VIEW",
            "DOMAIN_DOMAIN_ASSETS": "DOMAIN_DOMAIN_ASSETS",
            "COMMUNITY_COMMUNITY_ASSETS": "COMMUNITY_COMMUNITY_ASSETS",
            "BUSINESS_GLOSSARY_BUSINESS_ASSETS": "BUSINESS_GLOSSARY_BUSINESS_ASSETS",
            "BUSINESS_GLOSSARY_GLOSSARIES": "BUSINESS_GLOSSARY_GLOSSARIES",
            "REFERENCE_DATA_CODEVALUES_AND_SETS": "REFERENCE_DATA_CODEVALUES_AND_SETS",
            "REFERENCE_DATA_HIERARCHIES": "REFERENCE_DATA_HIERARCHIES",
            "CATALOG_DATA_SETS": "CATALOG_DATA_SETS",
            "CATALOG_DATA_SOURCES": "CATALOG_DATA_SOURCES",
            "CATALOG_DATA_DICTIONARY": "CATALOG_DATA_DICTIONARY",
            "CATALOG_TECHNOLOGY_ASSETS": "CATALOG_TECHNOLOGY_ASSETS",
            "CATALOG_REPORTS": "CATALOG_REPORTS",
            "DATA_HELPDESK_ISSUES": "DATA_HELPDESK_ISSUES",
            "DATA_HELPDESK_DATA_QUALITY": "DATA_HELPDESK_DATA_QUALITY",
            "STEWARDSHIP_BUSINESS_DIMENSIONS": "STEWARDSHIP_BUSINESS_DIMENSIONS",
            "POLICY_MANAGER_GOVERNANCE_ASSETS": "POLICY_MANAGER_GOVERNANCE_ASSETS",
        }
    
    @schemas.classproperty
    def GLOBAL_VIEW(cls):
        return cls("GLOBAL_VIEW")
    
    @schemas.classproperty
    def DOMAIN_DOMAIN_ASSETS(cls):
        return cls("DOMAIN_DOMAIN_ASSETS")
    
    @schemas.classproperty
    def COMMUNITY_COMMUNITY_ASSETS(cls):
        return cls("COMMUNITY_COMMUNITY_ASSETS")
    
    @schemas.classproperty
    def BUSINESS_GLOSSARY_BUSINESS_ASSETS(cls):
        return cls("BUSINESS_GLOSSARY_BUSINESS_ASSETS")
    
    @schemas.classproperty
    def BUSINESS_GLOSSARY_GLOSSARIES(cls):
        return cls("BUSINESS_GLOSSARY_GLOSSARIES")
    
    @schemas.classproperty
    def REFERENCE_DATA_CODEVALUES_AND_SETS(cls):
        return cls("REFERENCE_DATA_CODEVALUES_AND_SETS")
    
    @schemas.classproperty
    def REFERENCE_DATA_HIERARCHIES(cls):
        return cls("REFERENCE_DATA_HIERARCHIES")
    
    @schemas.classproperty
    def CATALOG_DATA_SETS(cls):
        return cls("CATALOG_DATA_SETS")
    
    @schemas.classproperty
    def CATALOG_DATA_SOURCES(cls):
        return cls("CATALOG_DATA_SOURCES")
    
    @schemas.classproperty
    def CATALOG_DATA_DICTIONARY(cls):
        return cls("CATALOG_DATA_DICTIONARY")
    
    @schemas.classproperty
    def CATALOG_TECHNOLOGY_ASSETS(cls):
        return cls("CATALOG_TECHNOLOGY_ASSETS")
    
    @schemas.classproperty
    def CATALOG_REPORTS(cls):
        return cls("CATALOG_REPORTS")
    
    @schemas.classproperty
    def DATA_HELPDESK_ISSUES(cls):
        return cls("DATA_HELPDESK_ISSUES")
    
    @schemas.classproperty
    def DATA_HELPDESK_DATA_QUALITY(cls):
        return cls("DATA_HELPDESK_DATA_QUALITY")
    
    @schemas.classproperty
    def STEWARDSHIP_BUSINESS_DIMENSIONS(cls):
        return cls("STEWARDSHIP_BUSINESS_DIMENSIONS")
    
    @schemas.classproperty
    def POLICY_MANAGER_GOVERNANCE_ASSETS(cls):
        return cls("POLICY_MANAGER_GOVERNANCE_ASSETS")
RequestRequiredQueryParams = typing_extensions.TypedDict(
    'RequestRequiredQueryParams',
    {
    }
)
RequestOptionalQueryParams = typing_extensions.TypedDict(
    'RequestOptionalQueryParams',
    {
        'viewLocation': typing.Union[ViewLocationSchema, str, ],
    },
    total=False
)


class RequestQueryParams(RequestRequiredQueryParams, RequestOptionalQueryParams):
    pass


request_query_view_location = api_client.QueryParameter(
    name="viewLocation",
    style=api_client.ParameterStyle.FORM,
    schema=ViewLocationSchema,
    explode=True,
)
# Path params
ViewIdSchema = schemas.UUIDSchema
RequestRequiredPathParams = typing_extensions.TypedDict(
    'RequestRequiredPathParams',
    {
        'viewId': typing.Union[ViewIdSchema, str, uuid.UUID, ],
    }
)
RequestOptionalPathParams = typing_extensions.TypedDict(
    'RequestOptionalPathParams',
    {
    },
    total=False
)


class RequestPathParams(RequestRequiredPathParams, RequestOptionalPathParams):
    pass


request_path_view_id = api_client.PathParameter(
    name="viewId",
    style=api_client.ParameterStyle.SIMPLE,
    schema=ViewIdSchema,
    required=True,
)
_auth = [
    'basicAuth',
    'bearerAuth',
]
SchemaFor200ResponseBodyApplicationJson = schemas.StrSchema


@dataclass
class ApiResponseFor200(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: typing.Union[
        SchemaFor200ResponseBodyApplicationJson,
    ]
    headers: schemas.Unset = schemas.unset


_response_for_200 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor200,
    content={
        'application/json': api_client.MediaType(
            schema=SchemaFor200ResponseBodyApplicationJson),
    },
)


@dataclass
class ApiResponseFor404(api_client.ApiResponse):
    response: urllib3.HTTPResponse
    body: schemas.Unset = schemas.unset
    headers: schemas.Unset = schemas.unset


_response_for_404 = api_client.OpenApiResponse(
    response_cls=ApiResponseFor404,
)
_status_code_to_response = {
    '200': _response_for_200,
    '404': _response_for_404,
}
_all_accept_content_types = (
    'application/json',
)


class BaseApi(api_client.Api):
    @typing.overload
    def _get_table_view_config_by_view_id_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[
        ApiResponseFor200,
    ]: ...

    @typing.overload
    def _get_table_view_config_by_view_id_oapg(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization: ...

    @typing.overload
    def _get_table_view_config_by_view_id_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]: ...

    def _get_table_view_config_by_view_id_oapg(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        """
        Returns TableViewConfig based on id of given View and its Location.
        :param skip_deserialization: If true then api_response.response will be set but
            api_response.body and api_response.headers will not be deserialized into schema
            class instances
        """
        self._verify_typed_dict_inputs_oapg(RequestQueryParams, query_params)
        self._verify_typed_dict_inputs_oapg(RequestPathParams, path_params)
        used_path = path.value

        _path_params = {}
        for parameter in (
            request_path_view_id,
        ):
            parameter_data = path_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            serialized_data = parameter.serialize(parameter_data)
            _path_params.update(serialized_data)

        for k, v in _path_params.items():
            used_path = used_path.replace('{%s}' % k, v)

        prefix_separator_iterator = None
        for parameter in (
            request_query_view_location,
        ):
            parameter_data = query_params.get(parameter.name, schemas.unset)
            if parameter_data is schemas.unset:
                continue
            if prefix_separator_iterator is None:
                prefix_separator_iterator = parameter.get_prefix_separator_iterator()
            serialized_data = parameter.serialize(parameter_data, prefix_separator_iterator)
            for serialized_value in serialized_data.values():
                used_path += serialized_value

        _headers = HTTPHeaderDict()
        # TODO add cookie handling
        if accept_content_types:
            for accept_content_type in accept_content_types:
                _headers.add('Accept', accept_content_type)

        response = self.api_client.call_api(
            resource_path=used_path,
            method='get'.upper(),
            headers=_headers,
            auth_settings=_auth,
            stream=stream,
            timeout=timeout,
        )

        if skip_deserialization:
            api_response = api_client.ApiResponseWithoutDeserialization(response=response)
        else:
            response_for_status = _status_code_to_response.get(str(response.status))
            if response_for_status:
                api_response = response_for_status.deserialize(response, self.api_client.configuration)
            else:
                api_response = api_client.ApiResponseWithoutDeserialization(response=response)

        if not 200 <= response.status <= 299:
            raise exceptions.ApiException(api_response=api_response)

        return api_response


class GetTableViewConfigByViewId(BaseApi):
    # this class is used by api classes that refer to endpoints with operationId fn names

    @typing.overload
    def get_table_view_config_by_view_id(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[
        ApiResponseFor200,
    ]: ...

    @typing.overload
    def get_table_view_config_by_view_id(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization: ...

    @typing.overload
    def get_table_view_config_by_view_id(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]: ...

    def get_table_view_config_by_view_id(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        return self._get_table_view_config_by_view_id_oapg(
            query_params=query_params,
            path_params=path_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization
        )


class ApiForget(BaseApi):
    # this class is used by api classes that refer to endpoints by path and http method names

    @typing.overload
    def get(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: typing_extensions.Literal[False] = ...,
    ) -> typing.Union[
        ApiResponseFor200,
    ]: ...

    @typing.overload
    def get(
        self,
        skip_deserialization: typing_extensions.Literal[True],
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
    ) -> api_client.ApiResponseWithoutDeserialization: ...

    @typing.overload
    def get(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = ...,
    ) -> typing.Union[
        ApiResponseFor200,
        api_client.ApiResponseWithoutDeserialization,
    ]: ...

    def get(
        self,
        query_params: RequestQueryParams = frozendict.frozendict(),
        path_params: RequestPathParams = frozendict.frozendict(),
        accept_content_types: typing.Tuple[str] = _all_accept_content_types,
        stream: bool = False,
        timeout: typing.Optional[typing.Union[int, typing.Tuple]] = None,
        skip_deserialization: bool = False,
    ):
        return self._get_table_view_config_by_view_id_oapg(
            query_params=query_params,
            path_params=path_params,
            accept_content_types=accept_content_types,
            stream=stream,
            timeout=timeout,
            skip_deserialization=skip_deserialization
        )


