# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from collibra_core import schemas  # noqa: F401


class WorkflowTask(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Represents a workflow task.
    """


    class MetaOapg:
        required = {
            "id",
            "resourceType",
        }
        
        class properties:
            id = schemas.UUIDSchema
            
            
            class resourceType(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "View": "VIEW",
                        "Asset": "ASSET",
                        "Community": "COMMUNITY",
                        "Domain": "DOMAIN",
                        "AssetType": "ASSET_TYPE",
                        "DomainType": "DOMAIN_TYPE",
                        "Status": "STATUS",
                        "User": "USER",
                        "ClassificationMatch": "CLASSIFICATION_MATCH",
                        "UserGroup": "USER_GROUP",
                        "Attribute": "ATTRIBUTE",
                        "StringAttribute": "STRING_ATTRIBUTE",
                        "ScriptAttribute": "SCRIPT_ATTRIBUTE",
                        "BooleanAttribute": "BOOLEAN_ATTRIBUTE",
                        "DateAttribute": "DATE_ATTRIBUTE",
                        "NumericAttribute": "NUMERIC_ATTRIBUTE",
                        "SingleValueListAttribute": "SINGLE_VALUE_LIST_ATTRIBUTE",
                        "MultiValueListAttribute": "MULTI_VALUE_LIST_ATTRIBUTE",
                        "Comment": "COMMENT",
                        "Attachment": "ATTACHMENT",
                        "Responsibility": "RESPONSIBILITY",
                        "Workflow": "WORKFLOW",
                        "Job": "JOB",
                        "Relation": "RELATION",
                        "RelationType": "RELATION_TYPE",
                        "ComplexRelation": "COMPLEX_RELATION",
                        "ComplexRelationType": "COMPLEX_RELATION_TYPE",
                        "ArticulationRule": "ARTICULATION_RULE",
                        "Assignment": "ASSIGNMENT",
                        "Scope": "SCOPE",
                        "RelationTrace": "RELATION_TRACE",
                        "ValidationRule": "VALIDATION_RULE",
                        "DataQualityRule": "DATA_QUALITY_RULE",
                        "DataQualityMetric": "DATA_QUALITY_METRIC",
                        "Address": "ADDRESS",
                        "InstantMessagingAccount": "INSTANT_MESSAGING_ACCOUNT",
                        "Email": "EMAIL",
                        "PhoneNumber": "PHONE_NUMBER",
                        "Website": "WEBSITE",
                        "Activity": "ACTIVITY",
                        "FormProperty": "FORM_PROPERTY",
                        "WorkflowTask": "WORKFLOW_TASK",
                        "ActivityChange": "ACTIVITY_CHANGE",
                        "WorkflowInstance": "WORKFLOW_INSTANCE",
                        "Role": "ROLE",
                        "AttributeType": "ATTRIBUTE_TYPE",
                        "BooleanAttributeType": "BOOLEAN_ATTRIBUTE_TYPE",
                        "DateAttributeType": "DATE_ATTRIBUTE_TYPE",
                        "DateTimeAttributeType": "DATE_TIME_ATTRIBUTE_TYPE",
                        "MultiValueListAttributeType": "MULTI_VALUE_LIST_ATTRIBUTE_TYPE",
                        "NumericAttributeType": "NUMERIC_ATTRIBUTE_TYPE",
                        "ScriptAttributeType": "SCRIPT_ATTRIBUTE_TYPE",
                        "SingleValueListAttributeType": "SINGLE_VALUE_LIST_ATTRIBUTE_TYPE",
                        "StringAttributeType": "STRING_ATTRIBUTE_TYPE",
                        "ViewSharingRule": "VIEW_SHARING_RULE",
                        "ViewAssignmentRule": "VIEW_ASSIGNMENT_RULE",
                        "JdbcDriverFile": "JDBC_DRIVER_FILE",
                        "JdbcDriver": "JDBC_DRIVER",
                        "JdbcIngestionProperties": "JDBC_INGESTION_PROPERTIES",
                        "CsvIngestionProperties": "CSV_INGESTION_PROPERTIES",
                        "ExcelIngestionProperties": "EXCEL_INGESTION_PROPERTIES",
                        "ConnectionStringParameter": "CONNECTION_STRING_PARAMETER",
                        "AssignedCharacteristicType": "ASSIGNED_CHARACTERISTIC_TYPE",
                        "Notification": "NOTIFICATION",
                        "Tag": "TAG",
                        "ComplexRelationLegType": "COMPLEX_RELATION_LEG_TYPE",
                        "ComplexRelationAttributeType": "COMPLEX_RELATION_ATTRIBUTE_TYPE",
                        "ComplexRelationLeg": "COMPLEX_RELATION_LEG",
                        "BaseDataType": "BASE_DATA_TYPE",
                        "AdvancedDataType": "ADVANCED_DATA_TYPE",
                        "DiagramPicture": "DIAGRAM_PICTURE",
                        "DiagramPictureSharingRule": "DIAGRAM_PICTURE_SHARING_RULE",
                        "DiagramPictureAssignmentRule": "DIAGRAM_PICTURE_ASSIGNMENT_RULE",
                        "Rating": "RATING",
                        "Classification": "CLASSIFICATION",
                        "PhysicalDataConnector": "PHYSICAL_DATA_CONNECTOR",
                        "Context": "CONTEXT",
                    }
                
                @schemas.classproperty
                def VIEW(cls):
                    return cls("View")
                
                @schemas.classproperty
                def ASSET(cls):
                    return cls("Asset")
                
                @schemas.classproperty
                def COMMUNITY(cls):
                    return cls("Community")
                
                @schemas.classproperty
                def DOMAIN(cls):
                    return cls("Domain")
                
                @schemas.classproperty
                def ASSET_TYPE(cls):
                    return cls("AssetType")
                
                @schemas.classproperty
                def DOMAIN_TYPE(cls):
                    return cls("DomainType")
                
                @schemas.classproperty
                def STATUS(cls):
                    return cls("Status")
                
                @schemas.classproperty
                def USER(cls):
                    return cls("User")
                
                @schemas.classproperty
                def CLASSIFICATION_MATCH(cls):
                    return cls("ClassificationMatch")
                
                @schemas.classproperty
                def USER_GROUP(cls):
                    return cls("UserGroup")
                
                @schemas.classproperty
                def ATTRIBUTE(cls):
                    return cls("Attribute")
                
                @schemas.classproperty
                def STRING_ATTRIBUTE(cls):
                    return cls("StringAttribute")
                
                @schemas.classproperty
                def SCRIPT_ATTRIBUTE(cls):
                    return cls("ScriptAttribute")
                
                @schemas.classproperty
                def BOOLEAN_ATTRIBUTE(cls):
                    return cls("BooleanAttribute")
                
                @schemas.classproperty
                def DATE_ATTRIBUTE(cls):
                    return cls("DateAttribute")
                
                @schemas.classproperty
                def NUMERIC_ATTRIBUTE(cls):
                    return cls("NumericAttribute")
                
                @schemas.classproperty
                def SINGLE_VALUE_LIST_ATTRIBUTE(cls):
                    return cls("SingleValueListAttribute")
                
                @schemas.classproperty
                def MULTI_VALUE_LIST_ATTRIBUTE(cls):
                    return cls("MultiValueListAttribute")
                
                @schemas.classproperty
                def COMMENT(cls):
                    return cls("Comment")
                
                @schemas.classproperty
                def ATTACHMENT(cls):
                    return cls("Attachment")
                
                @schemas.classproperty
                def RESPONSIBILITY(cls):
                    return cls("Responsibility")
                
                @schemas.classproperty
                def WORKFLOW(cls):
                    return cls("Workflow")
                
                @schemas.classproperty
                def JOB(cls):
                    return cls("Job")
                
                @schemas.classproperty
                def RELATION(cls):
                    return cls("Relation")
                
                @schemas.classproperty
                def RELATION_TYPE(cls):
                    return cls("RelationType")
                
                @schemas.classproperty
                def COMPLEX_RELATION(cls):
                    return cls("ComplexRelation")
                
                @schemas.classproperty
                def COMPLEX_RELATION_TYPE(cls):
                    return cls("ComplexRelationType")
                
                @schemas.classproperty
                def ARTICULATION_RULE(cls):
                    return cls("ArticulationRule")
                
                @schemas.classproperty
                def ASSIGNMENT(cls):
                    return cls("Assignment")
                
                @schemas.classproperty
                def SCOPE(cls):
                    return cls("Scope")
                
                @schemas.classproperty
                def RELATION_TRACE(cls):
                    return cls("RelationTrace")
                
                @schemas.classproperty
                def VALIDATION_RULE(cls):
                    return cls("ValidationRule")
                
                @schemas.classproperty
                def DATA_QUALITY_RULE(cls):
                    return cls("DataQualityRule")
                
                @schemas.classproperty
                def DATA_QUALITY_METRIC(cls):
                    return cls("DataQualityMetric")
                
                @schemas.classproperty
                def ADDRESS(cls):
                    return cls("Address")
                
                @schemas.classproperty
                def INSTANT_MESSAGING_ACCOUNT(cls):
                    return cls("InstantMessagingAccount")
                
                @schemas.classproperty
                def EMAIL(cls):
                    return cls("Email")
                
                @schemas.classproperty
                def PHONE_NUMBER(cls):
                    return cls("PhoneNumber")
                
                @schemas.classproperty
                def WEBSITE(cls):
                    return cls("Website")
                
                @schemas.classproperty
                def ACTIVITY(cls):
                    return cls("Activity")
                
                @schemas.classproperty
                def FORM_PROPERTY(cls):
                    return cls("FormProperty")
                
                @schemas.classproperty
                def WORKFLOW_TASK(cls):
                    return cls("WorkflowTask")
                
                @schemas.classproperty
                def ACTIVITY_CHANGE(cls):
                    return cls("ActivityChange")
                
                @schemas.classproperty
                def WORKFLOW_INSTANCE(cls):
                    return cls("WorkflowInstance")
                
                @schemas.classproperty
                def ROLE(cls):
                    return cls("Role")
                
                @schemas.classproperty
                def ATTRIBUTE_TYPE(cls):
                    return cls("AttributeType")
                
                @schemas.classproperty
                def BOOLEAN_ATTRIBUTE_TYPE(cls):
                    return cls("BooleanAttributeType")
                
                @schemas.classproperty
                def DATE_ATTRIBUTE_TYPE(cls):
                    return cls("DateAttributeType")
                
                @schemas.classproperty
                def DATE_TIME_ATTRIBUTE_TYPE(cls):
                    return cls("DateTimeAttributeType")
                
                @schemas.classproperty
                def MULTI_VALUE_LIST_ATTRIBUTE_TYPE(cls):
                    return cls("MultiValueListAttributeType")
                
                @schemas.classproperty
                def NUMERIC_ATTRIBUTE_TYPE(cls):
                    return cls("NumericAttributeType")
                
                @schemas.classproperty
                def SCRIPT_ATTRIBUTE_TYPE(cls):
                    return cls("ScriptAttributeType")
                
                @schemas.classproperty
                def SINGLE_VALUE_LIST_ATTRIBUTE_TYPE(cls):
                    return cls("SingleValueListAttributeType")
                
                @schemas.classproperty
                def STRING_ATTRIBUTE_TYPE(cls):
                    return cls("StringAttributeType")
                
                @schemas.classproperty
                def VIEW_SHARING_RULE(cls):
                    return cls("ViewSharingRule")
                
                @schemas.classproperty
                def VIEW_ASSIGNMENT_RULE(cls):
                    return cls("ViewAssignmentRule")
                
                @schemas.classproperty
                def JDBC_DRIVER_FILE(cls):
                    return cls("JdbcDriverFile")
                
                @schemas.classproperty
                def JDBC_DRIVER(cls):
                    return cls("JdbcDriver")
                
                @schemas.classproperty
                def JDBC_INGESTION_PROPERTIES(cls):
                    return cls("JdbcIngestionProperties")
                
                @schemas.classproperty
                def CSV_INGESTION_PROPERTIES(cls):
                    return cls("CsvIngestionProperties")
                
                @schemas.classproperty
                def EXCEL_INGESTION_PROPERTIES(cls):
                    return cls("ExcelIngestionProperties")
                
                @schemas.classproperty
                def CONNECTION_STRING_PARAMETER(cls):
                    return cls("ConnectionStringParameter")
                
                @schemas.classproperty
                def ASSIGNED_CHARACTERISTIC_TYPE(cls):
                    return cls("AssignedCharacteristicType")
                
                @schemas.classproperty
                def NOTIFICATION(cls):
                    return cls("Notification")
                
                @schemas.classproperty
                def TAG(cls):
                    return cls("Tag")
                
                @schemas.classproperty
                def COMPLEX_RELATION_LEG_TYPE(cls):
                    return cls("ComplexRelationLegType")
                
                @schemas.classproperty
                def COMPLEX_RELATION_ATTRIBUTE_TYPE(cls):
                    return cls("ComplexRelationAttributeType")
                
                @schemas.classproperty
                def COMPLEX_RELATION_LEG(cls):
                    return cls("ComplexRelationLeg")
                
                @schemas.classproperty
                def BASE_DATA_TYPE(cls):
                    return cls("BaseDataType")
                
                @schemas.classproperty
                def ADVANCED_DATA_TYPE(cls):
                    return cls("AdvancedDataType")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE(cls):
                    return cls("DiagramPicture")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE_SHARING_RULE(cls):
                    return cls("DiagramPictureSharingRule")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE_ASSIGNMENT_RULE(cls):
                    return cls("DiagramPictureAssignmentRule")
                
                @schemas.classproperty
                def RATING(cls):
                    return cls("Rating")
                
                @schemas.classproperty
                def CLASSIFICATION(cls):
                    return cls("Classification")
                
                @schemas.classproperty
                def PHYSICAL_DATA_CONNECTOR(cls):
                    return cls("PhysicalDataConnector")
                
                @schemas.classproperty
                def CONTEXT(cls):
                    return cls("Context")
            system = schemas.BoolSchema
        
            @staticmethod
            def workflowDefinition() -> typing.Type['WorkflowDefinitionReference']:
                return WorkflowDefinitionReference
            workflowInstanceId = schemas.UUIDSchema
            key = schemas.StrSchema
            type = schemas.StrSchema
            aggregationKey = schemas.StrSchema
            priority = schemas.Int32Schema
            owner = schemas.StrSchema
            
            
            class candidateUsers(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['User']:
                        return User
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['User'], typing.List['User']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'candidateUsers':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'User':
                    return super().__getitem__(i)
            createTime = schemas.Int64Schema
            dueDate = schemas.Int64Schema
            cancelable = schemas.BoolSchema
            reassignable = schemas.BoolSchema
            formRequired = schemas.BoolSchema
            formKeyAvailable = schemas.BoolSchema
            containsActivityStream = schemas.BoolSchema
            inError = schemas.BoolSchema
            errorMessage = schemas.StrSchema
            
            
            class customButtons(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['FormProperty']:
                        return FormProperty
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['FormProperty'], typing.List['FormProperty']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'customButtons':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'FormProperty':
                    return super().__getitem__(i)
            description = schemas.StrSchema
            title = schemas.StrSchema
        
            @staticmethod
            def businessItem() -> typing.Type['ResourceReference']:
                return ResourceReference
        
            @staticmethod
            def businessItemReference() -> typing.Type['NamedResourceReferenceImpl']:
                return NamedResourceReferenceImpl
            __annotations__ = {
                "id": id,
                "resourceType": resourceType,
                "system": system,
                "workflowDefinition": workflowDefinition,
                "workflowInstanceId": workflowInstanceId,
                "key": key,
                "type": type,
                "aggregationKey": aggregationKey,
                "priority": priority,
                "owner": owner,
                "candidateUsers": candidateUsers,
                "createTime": createTime,
                "dueDate": dueDate,
                "cancelable": cancelable,
                "reassignable": reassignable,
                "formRequired": formRequired,
                "formKeyAvailable": formKeyAvailable,
                "containsActivityStream": containsActivityStream,
                "inError": inError,
                "errorMessage": errorMessage,
                "customButtons": customButtons,
                "description": description,
                "title": title,
                "businessItem": businessItem,
                "businessItemReference": businessItemReference,
            }
    
    id: MetaOapg.properties.id
    resourceType: MetaOapg.properties.resourceType
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["resourceType"]) -> MetaOapg.properties.resourceType: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["system"]) -> MetaOapg.properties.system: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["workflowDefinition"]) -> 'WorkflowDefinitionReference': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["workflowInstanceId"]) -> MetaOapg.properties.workflowInstanceId: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["key"]) -> MetaOapg.properties.key: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["type"]) -> MetaOapg.properties.type: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["aggregationKey"]) -> MetaOapg.properties.aggregationKey: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["priority"]) -> MetaOapg.properties.priority: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["owner"]) -> MetaOapg.properties.owner: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["candidateUsers"]) -> MetaOapg.properties.candidateUsers: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["createTime"]) -> MetaOapg.properties.createTime: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["dueDate"]) -> MetaOapg.properties.dueDate: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["cancelable"]) -> MetaOapg.properties.cancelable: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["reassignable"]) -> MetaOapg.properties.reassignable: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["formRequired"]) -> MetaOapg.properties.formRequired: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["formKeyAvailable"]) -> MetaOapg.properties.formKeyAvailable: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["containsActivityStream"]) -> MetaOapg.properties.containsActivityStream: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["inError"]) -> MetaOapg.properties.inError: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["errorMessage"]) -> MetaOapg.properties.errorMessage: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["customButtons"]) -> MetaOapg.properties.customButtons: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["description"]) -> MetaOapg.properties.description: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["title"]) -> MetaOapg.properties.title: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["businessItem"]) -> 'ResourceReference': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["businessItemReference"]) -> 'NamedResourceReferenceImpl': ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["id", "resourceType", "system", "workflowDefinition", "workflowInstanceId", "key", "type", "aggregationKey", "priority", "owner", "candidateUsers", "createTime", "dueDate", "cancelable", "reassignable", "formRequired", "formKeyAvailable", "containsActivityStream", "inError", "errorMessage", "customButtons", "description", "title", "businessItem", "businessItemReference", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["resourceType"]) -> MetaOapg.properties.resourceType: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["system"]) -> typing.Union[MetaOapg.properties.system, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["workflowDefinition"]) -> typing.Union['WorkflowDefinitionReference', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["workflowInstanceId"]) -> typing.Union[MetaOapg.properties.workflowInstanceId, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["key"]) -> typing.Union[MetaOapg.properties.key, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["type"]) -> typing.Union[MetaOapg.properties.type, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["aggregationKey"]) -> typing.Union[MetaOapg.properties.aggregationKey, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["priority"]) -> typing.Union[MetaOapg.properties.priority, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["owner"]) -> typing.Union[MetaOapg.properties.owner, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["candidateUsers"]) -> typing.Union[MetaOapg.properties.candidateUsers, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["createTime"]) -> typing.Union[MetaOapg.properties.createTime, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["dueDate"]) -> typing.Union[MetaOapg.properties.dueDate, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["cancelable"]) -> typing.Union[MetaOapg.properties.cancelable, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["reassignable"]) -> typing.Union[MetaOapg.properties.reassignable, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["formRequired"]) -> typing.Union[MetaOapg.properties.formRequired, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["formKeyAvailable"]) -> typing.Union[MetaOapg.properties.formKeyAvailable, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["containsActivityStream"]) -> typing.Union[MetaOapg.properties.containsActivityStream, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["inError"]) -> typing.Union[MetaOapg.properties.inError, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["errorMessage"]) -> typing.Union[MetaOapg.properties.errorMessage, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["customButtons"]) -> typing.Union[MetaOapg.properties.customButtons, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["description"]) -> typing.Union[MetaOapg.properties.description, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["title"]) -> typing.Union[MetaOapg.properties.title, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["businessItem"]) -> typing.Union['ResourceReference', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["businessItemReference"]) -> typing.Union['NamedResourceReferenceImpl', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["id", "resourceType", "system", "workflowDefinition", "workflowInstanceId", "key", "type", "aggregationKey", "priority", "owner", "candidateUsers", "createTime", "dueDate", "cancelable", "reassignable", "formRequired", "formKeyAvailable", "containsActivityStream", "inError", "errorMessage", "customButtons", "description", "title", "businessItem", "businessItemReference", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        id: typing.Union[MetaOapg.properties.id, str, uuid.UUID, ],
        resourceType: typing.Union[MetaOapg.properties.resourceType, str, ],
        system: typing.Union[MetaOapg.properties.system, bool, schemas.Unset] = schemas.unset,
        workflowDefinition: typing.Union['WorkflowDefinitionReference', schemas.Unset] = schemas.unset,
        workflowInstanceId: typing.Union[MetaOapg.properties.workflowInstanceId, str, uuid.UUID, schemas.Unset] = schemas.unset,
        key: typing.Union[MetaOapg.properties.key, str, schemas.Unset] = schemas.unset,
        type: typing.Union[MetaOapg.properties.type, str, schemas.Unset] = schemas.unset,
        aggregationKey: typing.Union[MetaOapg.properties.aggregationKey, str, schemas.Unset] = schemas.unset,
        priority: typing.Union[MetaOapg.properties.priority, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        owner: typing.Union[MetaOapg.properties.owner, str, schemas.Unset] = schemas.unset,
        candidateUsers: typing.Union[MetaOapg.properties.candidateUsers, list, tuple, schemas.Unset] = schemas.unset,
        createTime: typing.Union[MetaOapg.properties.createTime, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        dueDate: typing.Union[MetaOapg.properties.dueDate, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        cancelable: typing.Union[MetaOapg.properties.cancelable, bool, schemas.Unset] = schemas.unset,
        reassignable: typing.Union[MetaOapg.properties.reassignable, bool, schemas.Unset] = schemas.unset,
        formRequired: typing.Union[MetaOapg.properties.formRequired, bool, schemas.Unset] = schemas.unset,
        formKeyAvailable: typing.Union[MetaOapg.properties.formKeyAvailable, bool, schemas.Unset] = schemas.unset,
        containsActivityStream: typing.Union[MetaOapg.properties.containsActivityStream, bool, schemas.Unset] = schemas.unset,
        inError: typing.Union[MetaOapg.properties.inError, bool, schemas.Unset] = schemas.unset,
        errorMessage: typing.Union[MetaOapg.properties.errorMessage, str, schemas.Unset] = schemas.unset,
        customButtons: typing.Union[MetaOapg.properties.customButtons, list, tuple, schemas.Unset] = schemas.unset,
        description: typing.Union[MetaOapg.properties.description, str, schemas.Unset] = schemas.unset,
        title: typing.Union[MetaOapg.properties.title, str, schemas.Unset] = schemas.unset,
        businessItem: typing.Union['ResourceReference', schemas.Unset] = schemas.unset,
        businessItemReference: typing.Union['NamedResourceReferenceImpl', schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'WorkflowTask':
        return super().__new__(
            cls,
            *args,
            id=id,
            resourceType=resourceType,
            system=system,
            workflowDefinition=workflowDefinition,
            workflowInstanceId=workflowInstanceId,
            key=key,
            type=type,
            aggregationKey=aggregationKey,
            priority=priority,
            owner=owner,
            candidateUsers=candidateUsers,
            createTime=createTime,
            dueDate=dueDate,
            cancelable=cancelable,
            reassignable=reassignable,
            formRequired=formRequired,
            formKeyAvailable=formKeyAvailable,
            containsActivityStream=containsActivityStream,
            inError=inError,
            errorMessage=errorMessage,
            customButtons=customButtons,
            description=description,
            title=title,
            businessItem=businessItem,
            businessItemReference=businessItemReference,
            _configuration=_configuration,
            **kwargs,
        )

from collibra_core.model.form_property import FormProperty
from collibra_core.model.named_resource_reference_impl import NamedResourceReferenceImpl
from collibra_core.model.resource_reference import ResourceReference
from collibra_core.model.user import User
from collibra_core.model.workflow_definition_reference import WorkflowDefinitionReference
