# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from collibra_core import schemas  # noqa: F401


class WorkflowDefinitionImpl(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Definition of a workflow. It contains the workflow logic, code, configuration and is usually represented by a diagram or a .bpmn file.
    """


    class MetaOapg:
        required = {
            "id",
            "resourceType",
        }
        
        class properties:
            id = schemas.UUIDSchema
            
            
            class resourceType(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "View": "VIEW",
                        "Asset": "ASSET",
                        "Community": "COMMUNITY",
                        "Domain": "DOMAIN",
                        "AssetType": "ASSET_TYPE",
                        "DomainType": "DOMAIN_TYPE",
                        "Status": "STATUS",
                        "User": "USER",
                        "ClassificationMatch": "CLASSIFICATION_MATCH",
                        "UserGroup": "USER_GROUP",
                        "Attribute": "ATTRIBUTE",
                        "StringAttribute": "STRING_ATTRIBUTE",
                        "ScriptAttribute": "SCRIPT_ATTRIBUTE",
                        "BooleanAttribute": "BOOLEAN_ATTRIBUTE",
                        "DateAttribute": "DATE_ATTRIBUTE",
                        "NumericAttribute": "NUMERIC_ATTRIBUTE",
                        "SingleValueListAttribute": "SINGLE_VALUE_LIST_ATTRIBUTE",
                        "MultiValueListAttribute": "MULTI_VALUE_LIST_ATTRIBUTE",
                        "Comment": "COMMENT",
                        "Attachment": "ATTACHMENT",
                        "Responsibility": "RESPONSIBILITY",
                        "Workflow": "WORKFLOW",
                        "Job": "JOB",
                        "Relation": "RELATION",
                        "RelationType": "RELATION_TYPE",
                        "ComplexRelation": "COMPLEX_RELATION",
                        "ComplexRelationType": "COMPLEX_RELATION_TYPE",
                        "ArticulationRule": "ARTICULATION_RULE",
                        "Assignment": "ASSIGNMENT",
                        "Scope": "SCOPE",
                        "RelationTrace": "RELATION_TRACE",
                        "ValidationRule": "VALIDATION_RULE",
                        "DataQualityRule": "DATA_QUALITY_RULE",
                        "DataQualityMetric": "DATA_QUALITY_METRIC",
                        "Address": "ADDRESS",
                        "InstantMessagingAccount": "INSTANT_MESSAGING_ACCOUNT",
                        "Email": "EMAIL",
                        "PhoneNumber": "PHONE_NUMBER",
                        "Website": "WEBSITE",
                        "Activity": "ACTIVITY",
                        "FormProperty": "FORM_PROPERTY",
                        "WorkflowTask": "WORKFLOW_TASK",
                        "ActivityChange": "ACTIVITY_CHANGE",
                        "WorkflowInstance": "WORKFLOW_INSTANCE",
                        "Role": "ROLE",
                        "AttributeType": "ATTRIBUTE_TYPE",
                        "BooleanAttributeType": "BOOLEAN_ATTRIBUTE_TYPE",
                        "DateAttributeType": "DATE_ATTRIBUTE_TYPE",
                        "DateTimeAttributeType": "DATE_TIME_ATTRIBUTE_TYPE",
                        "MultiValueListAttributeType": "MULTI_VALUE_LIST_ATTRIBUTE_TYPE",
                        "NumericAttributeType": "NUMERIC_ATTRIBUTE_TYPE",
                        "ScriptAttributeType": "SCRIPT_ATTRIBUTE_TYPE",
                        "SingleValueListAttributeType": "SINGLE_VALUE_LIST_ATTRIBUTE_TYPE",
                        "StringAttributeType": "STRING_ATTRIBUTE_TYPE",
                        "ViewSharingRule": "VIEW_SHARING_RULE",
                        "ViewAssignmentRule": "VIEW_ASSIGNMENT_RULE",
                        "JdbcDriverFile": "JDBC_DRIVER_FILE",
                        "JdbcDriver": "JDBC_DRIVER",
                        "JdbcIngestionProperties": "JDBC_INGESTION_PROPERTIES",
                        "CsvIngestionProperties": "CSV_INGESTION_PROPERTIES",
                        "ExcelIngestionProperties": "EXCEL_INGESTION_PROPERTIES",
                        "ConnectionStringParameter": "CONNECTION_STRING_PARAMETER",
                        "AssignedCharacteristicType": "ASSIGNED_CHARACTERISTIC_TYPE",
                        "Notification": "NOTIFICATION",
                        "Tag": "TAG",
                        "ComplexRelationLegType": "COMPLEX_RELATION_LEG_TYPE",
                        "ComplexRelationAttributeType": "COMPLEX_RELATION_ATTRIBUTE_TYPE",
                        "ComplexRelationLeg": "COMPLEX_RELATION_LEG",
                        "BaseDataType": "BASE_DATA_TYPE",
                        "AdvancedDataType": "ADVANCED_DATA_TYPE",
                        "DiagramPicture": "DIAGRAM_PICTURE",
                        "DiagramPictureSharingRule": "DIAGRAM_PICTURE_SHARING_RULE",
                        "DiagramPictureAssignmentRule": "DIAGRAM_PICTURE_ASSIGNMENT_RULE",
                        "Rating": "RATING",
                        "Classification": "CLASSIFICATION",
                        "PhysicalDataConnector": "PHYSICAL_DATA_CONNECTOR",
                        "Context": "CONTEXT",
                    }
                
                @schemas.classproperty
                def VIEW(cls):
                    return cls("View")
                
                @schemas.classproperty
                def ASSET(cls):
                    return cls("Asset")
                
                @schemas.classproperty
                def COMMUNITY(cls):
                    return cls("Community")
                
                @schemas.classproperty
                def DOMAIN(cls):
                    return cls("Domain")
                
                @schemas.classproperty
                def ASSET_TYPE(cls):
                    return cls("AssetType")
                
                @schemas.classproperty
                def DOMAIN_TYPE(cls):
                    return cls("DomainType")
                
                @schemas.classproperty
                def STATUS(cls):
                    return cls("Status")
                
                @schemas.classproperty
                def USER(cls):
                    return cls("User")
                
                @schemas.classproperty
                def CLASSIFICATION_MATCH(cls):
                    return cls("ClassificationMatch")
                
                @schemas.classproperty
                def USER_GROUP(cls):
                    return cls("UserGroup")
                
                @schemas.classproperty
                def ATTRIBUTE(cls):
                    return cls("Attribute")
                
                @schemas.classproperty
                def STRING_ATTRIBUTE(cls):
                    return cls("StringAttribute")
                
                @schemas.classproperty
                def SCRIPT_ATTRIBUTE(cls):
                    return cls("ScriptAttribute")
                
                @schemas.classproperty
                def BOOLEAN_ATTRIBUTE(cls):
                    return cls("BooleanAttribute")
                
                @schemas.classproperty
                def DATE_ATTRIBUTE(cls):
                    return cls("DateAttribute")
                
                @schemas.classproperty
                def NUMERIC_ATTRIBUTE(cls):
                    return cls("NumericAttribute")
                
                @schemas.classproperty
                def SINGLE_VALUE_LIST_ATTRIBUTE(cls):
                    return cls("SingleValueListAttribute")
                
                @schemas.classproperty
                def MULTI_VALUE_LIST_ATTRIBUTE(cls):
                    return cls("MultiValueListAttribute")
                
                @schemas.classproperty
                def COMMENT(cls):
                    return cls("Comment")
                
                @schemas.classproperty
                def ATTACHMENT(cls):
                    return cls("Attachment")
                
                @schemas.classproperty
                def RESPONSIBILITY(cls):
                    return cls("Responsibility")
                
                @schemas.classproperty
                def WORKFLOW(cls):
                    return cls("Workflow")
                
                @schemas.classproperty
                def JOB(cls):
                    return cls("Job")
                
                @schemas.classproperty
                def RELATION(cls):
                    return cls("Relation")
                
                @schemas.classproperty
                def RELATION_TYPE(cls):
                    return cls("RelationType")
                
                @schemas.classproperty
                def COMPLEX_RELATION(cls):
                    return cls("ComplexRelation")
                
                @schemas.classproperty
                def COMPLEX_RELATION_TYPE(cls):
                    return cls("ComplexRelationType")
                
                @schemas.classproperty
                def ARTICULATION_RULE(cls):
                    return cls("ArticulationRule")
                
                @schemas.classproperty
                def ASSIGNMENT(cls):
                    return cls("Assignment")
                
                @schemas.classproperty
                def SCOPE(cls):
                    return cls("Scope")
                
                @schemas.classproperty
                def RELATION_TRACE(cls):
                    return cls("RelationTrace")
                
                @schemas.classproperty
                def VALIDATION_RULE(cls):
                    return cls("ValidationRule")
                
                @schemas.classproperty
                def DATA_QUALITY_RULE(cls):
                    return cls("DataQualityRule")
                
                @schemas.classproperty
                def DATA_QUALITY_METRIC(cls):
                    return cls("DataQualityMetric")
                
                @schemas.classproperty
                def ADDRESS(cls):
                    return cls("Address")
                
                @schemas.classproperty
                def INSTANT_MESSAGING_ACCOUNT(cls):
                    return cls("InstantMessagingAccount")
                
                @schemas.classproperty
                def EMAIL(cls):
                    return cls("Email")
                
                @schemas.classproperty
                def PHONE_NUMBER(cls):
                    return cls("PhoneNumber")
                
                @schemas.classproperty
                def WEBSITE(cls):
                    return cls("Website")
                
                @schemas.classproperty
                def ACTIVITY(cls):
                    return cls("Activity")
                
                @schemas.classproperty
                def FORM_PROPERTY(cls):
                    return cls("FormProperty")
                
                @schemas.classproperty
                def WORKFLOW_TASK(cls):
                    return cls("WorkflowTask")
                
                @schemas.classproperty
                def ACTIVITY_CHANGE(cls):
                    return cls("ActivityChange")
                
                @schemas.classproperty
                def WORKFLOW_INSTANCE(cls):
                    return cls("WorkflowInstance")
                
                @schemas.classproperty
                def ROLE(cls):
                    return cls("Role")
                
                @schemas.classproperty
                def ATTRIBUTE_TYPE(cls):
                    return cls("AttributeType")
                
                @schemas.classproperty
                def BOOLEAN_ATTRIBUTE_TYPE(cls):
                    return cls("BooleanAttributeType")
                
                @schemas.classproperty
                def DATE_ATTRIBUTE_TYPE(cls):
                    return cls("DateAttributeType")
                
                @schemas.classproperty
                def DATE_TIME_ATTRIBUTE_TYPE(cls):
                    return cls("DateTimeAttributeType")
                
                @schemas.classproperty
                def MULTI_VALUE_LIST_ATTRIBUTE_TYPE(cls):
                    return cls("MultiValueListAttributeType")
                
                @schemas.classproperty
                def NUMERIC_ATTRIBUTE_TYPE(cls):
                    return cls("NumericAttributeType")
                
                @schemas.classproperty
                def SCRIPT_ATTRIBUTE_TYPE(cls):
                    return cls("ScriptAttributeType")
                
                @schemas.classproperty
                def SINGLE_VALUE_LIST_ATTRIBUTE_TYPE(cls):
                    return cls("SingleValueListAttributeType")
                
                @schemas.classproperty
                def STRING_ATTRIBUTE_TYPE(cls):
                    return cls("StringAttributeType")
                
                @schemas.classproperty
                def VIEW_SHARING_RULE(cls):
                    return cls("ViewSharingRule")
                
                @schemas.classproperty
                def VIEW_ASSIGNMENT_RULE(cls):
                    return cls("ViewAssignmentRule")
                
                @schemas.classproperty
                def JDBC_DRIVER_FILE(cls):
                    return cls("JdbcDriverFile")
                
                @schemas.classproperty
                def JDBC_DRIVER(cls):
                    return cls("JdbcDriver")
                
                @schemas.classproperty
                def JDBC_INGESTION_PROPERTIES(cls):
                    return cls("JdbcIngestionProperties")
                
                @schemas.classproperty
                def CSV_INGESTION_PROPERTIES(cls):
                    return cls("CsvIngestionProperties")
                
                @schemas.classproperty
                def EXCEL_INGESTION_PROPERTIES(cls):
                    return cls("ExcelIngestionProperties")
                
                @schemas.classproperty
                def CONNECTION_STRING_PARAMETER(cls):
                    return cls("ConnectionStringParameter")
                
                @schemas.classproperty
                def ASSIGNED_CHARACTERISTIC_TYPE(cls):
                    return cls("AssignedCharacteristicType")
                
                @schemas.classproperty
                def NOTIFICATION(cls):
                    return cls("Notification")
                
                @schemas.classproperty
                def TAG(cls):
                    return cls("Tag")
                
                @schemas.classproperty
                def COMPLEX_RELATION_LEG_TYPE(cls):
                    return cls("ComplexRelationLegType")
                
                @schemas.classproperty
                def COMPLEX_RELATION_ATTRIBUTE_TYPE(cls):
                    return cls("ComplexRelationAttributeType")
                
                @schemas.classproperty
                def COMPLEX_RELATION_LEG(cls):
                    return cls("ComplexRelationLeg")
                
                @schemas.classproperty
                def BASE_DATA_TYPE(cls):
                    return cls("BaseDataType")
                
                @schemas.classproperty
                def ADVANCED_DATA_TYPE(cls):
                    return cls("AdvancedDataType")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE(cls):
                    return cls("DiagramPicture")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE_SHARING_RULE(cls):
                    return cls("DiagramPictureSharingRule")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE_ASSIGNMENT_RULE(cls):
                    return cls("DiagramPictureAssignmentRule")
                
                @schemas.classproperty
                def RATING(cls):
                    return cls("Rating")
                
                @schemas.classproperty
                def CLASSIFICATION(cls):
                    return cls("Classification")
                
                @schemas.classproperty
                def PHYSICAL_DATA_CONNECTOR(cls):
                    return cls("PhysicalDataConnector")
                
                @schemas.classproperty
                def CONTEXT(cls):
                    return cls("Context")
            createdBy = schemas.UUIDSchema
            createdOn = schemas.Int64Schema
            lastModifiedBy = schemas.UUIDSchema
            lastModifiedOn = schemas.Int64Schema
            system = schemas.BoolSchema
            name = schemas.StrSchema
            description = schemas.StrSchema
            processId = schemas.StrSchema
            startLabel = schemas.StrSchema
            formRequired = schemas.BoolSchema
            startFormKeyAvailable = schemas.BoolSchema
            startFormJsonModelAvailable = schemas.BoolSchema
            enabled = schemas.BoolSchema
            
            
            class domainAssignmentRules(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['AssetAssignmentRuleImpl']:
                        return AssetAssignmentRuleImpl
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['AssetAssignmentRuleImpl'], typing.List['AssetAssignmentRuleImpl']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'domainAssignmentRules':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'AssetAssignmentRuleImpl':
                    return super().__getitem__(i)
            
            
            class assetAssignmentRules(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['AssetAssignmentRuleImpl']:
                        return AssetAssignmentRuleImpl
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['AssetAssignmentRuleImpl'], typing.List['AssetAssignmentRuleImpl']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'assetAssignmentRules':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'AssetAssignmentRuleImpl':
                    return super().__getitem__(i)
            
            
            class businessItemResourceType(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "ASSET": "ASSET",
                        "DOMAIN": "DOMAIN",
                        "COMMUNITY": "COMMUNITY",
                        "GLOBAL": "GLOBAL",
                    }
                
                @schemas.classproperty
                def ASSET(cls):
                    return cls("ASSET")
                
                @schemas.classproperty
                def DOMAIN(cls):
                    return cls("DOMAIN")
                
                @schemas.classproperty
                def COMMUNITY(cls):
                    return cls("COMMUNITY")
                
                @schemas.classproperty
                def GLOBAL(cls):
                    return cls("GLOBAL")
            
            
            class exclusivity(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "RESOURCE_EXCLUSIVITY": "RESOURCE_EXCLUSIVITY",
                        "DEFINITION_EXCLUSIVITY": "DEFINITION_EXCLUSIVITY",
                        "UNCONSTRAINED": "UNCONSTRAINED",
                    }
                
                @schemas.classproperty
                def RESOURCE_EXCLUSIVITY(cls):
                    return cls("RESOURCE_EXCLUSIVITY")
                
                @schemas.classproperty
                def DEFINITION_EXCLUSIVITY(cls):
                    return cls("DEFINITION_EXCLUSIVITY")
                
                @schemas.classproperty
                def UNCONSTRAINED(cls):
                    return cls("UNCONSTRAINED")
            guestUserAccessible = schemas.BoolSchema
            registeredUserAccessible = schemas.BoolSchema
            candidateUserCheckEnabled = schemas.BoolSchema
            globalCreate = schemas.BoolSchema
            
            
            class startEvents(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    
                    class items(
                        schemas.EnumBase,
                        schemas.StrSchema
                    ):
                    
                    
                        class MetaOapg:
                            enum_value_to_name = {
                                "ASSET_ADDED": "ASSET_ADDED",
                                "ASSET_REMOVED": "ASSET_REMOVED",
                                "ASSET_STATUS_CHANGED": "ASSET_STATUS_CHANGED",
                                "ASSET_DOMAIN_CHANGED": "ASSET_DOMAIN_CHANGED",
                                "ASSET_TYPE_CHANGED": "ASSET_TYPE_CHANGED",
                                "ASSET_ATTRIBUTE_CHANGED": "ASSET_ATTRIBUTE_CHANGED",
                                "ASSET_NAME_CHANGED": "ASSET_NAME_CHANGED",
                                "ASSET_DISPLAY_NAME_CHANGED": "ASSET_DISPLAY_NAME_CHANGED",
                                "ASSET_ATTRIBUTE_ADDED": "ASSET_ATTRIBUTE_ADDED",
                                "ASSET_ATTRIBUTE_REMOVED": "ASSET_ATTRIBUTE_REMOVED",
                                "DOMAIN_ADDED": "DOMAIN_ADDED",
                                "DOMAIN_REMOVED": "DOMAIN_REMOVED",
                                "ROLE_GRANTED": "ROLE_GRANTED",
                                "ROLE_REVOKED": "ROLE_REVOKED",
                                "WORKFLOW_STARTED": "WORKFLOW_STARTED",
                                "WORKFLOW_CANCELED": "WORKFLOW_CANCELED",
                                "WORKLFLOW_ESCALATION": "WORKLFLOW_ESCALATION",
                                "WORKFLOW_TASK_COMPLETED": "WORKFLOW_TASK_COMPLETED",
                                "USER_ADDED": "USER_ADDED",
                                "USER_REMOVED": "USER_REMOVED",
                                "USER_DISABLED": "USER_DISABLED",
                                "COMMENT_ADDED": "COMMENT_ADDED",
                                "COMMENT_REMOVED": "COMMENT_REMOVED",
                                "COMMENT_CHANGED": "COMMENT_CHANGED",
                                "RELATION_ADDED_AND_ASSET_IS_SOURCE": "RELATION_ADDED_AND_ASSET_IS_SOURCE",
                                "RELATION_REMOVED_AND_ASSET_WAS_SOURCE": "RELATION_REMOVED_AND_ASSET_WAS_SOURCE",
                                "RELATION_ADDED_AND_ASSET_IS_TARGET": "RELATION_ADDED_AND_ASSET_IS_TARGET",
                                "RELATION_REMOVED_AND_ASSET_WAS_TARGET": "RELATION_REMOVED_AND_ASSET_WAS_TARGET",
                                "TAG_ASSIGN_CHANGED": "TAG_ASSIGN_CHANGED",
                                "CLASSIFICATION_MATCH_ACCEPTED": "CLASSIFICATION_MATCH_ACCEPTED",
                                "CLASSIFICATION_MATCH_REJECTED": "CLASSIFICATION_MATCH_REJECTED",
                                "CLASSIFICATION_MATCH_ADDED": "CLASSIFICATION_MATCH_ADDED",
                                "CLASSIFICATION_MATCH_REMOVED": "CLASSIFICATION_MATCH_REMOVED",
                                "CLASSIFICATION_MATCH_UPDATED": "CLASSIFICATION_MATCH_UPDATED",
                                "DATABASE_REGISTRATION_COMPLETED": "DATABASE_REGISTRATION_COMPLETED",
                                "DATABASE_REGISTRATION_FAILED": "DATABASE_REGISTRATION_FAILED",
                            }
                        
                        @schemas.classproperty
                        def ASSET_ADDED(cls):
                            return cls("ASSET_ADDED")
                        
                        @schemas.classproperty
                        def ASSET_REMOVED(cls):
                            return cls("ASSET_REMOVED")
                        
                        @schemas.classproperty
                        def ASSET_STATUS_CHANGED(cls):
                            return cls("ASSET_STATUS_CHANGED")
                        
                        @schemas.classproperty
                        def ASSET_DOMAIN_CHANGED(cls):
                            return cls("ASSET_DOMAIN_CHANGED")
                        
                        @schemas.classproperty
                        def ASSET_TYPE_CHANGED(cls):
                            return cls("ASSET_TYPE_CHANGED")
                        
                        @schemas.classproperty
                        def ASSET_ATTRIBUTE_CHANGED(cls):
                            return cls("ASSET_ATTRIBUTE_CHANGED")
                        
                        @schemas.classproperty
                        def ASSET_NAME_CHANGED(cls):
                            return cls("ASSET_NAME_CHANGED")
                        
                        @schemas.classproperty
                        def ASSET_DISPLAY_NAME_CHANGED(cls):
                            return cls("ASSET_DISPLAY_NAME_CHANGED")
                        
                        @schemas.classproperty
                        def ASSET_ATTRIBUTE_ADDED(cls):
                            return cls("ASSET_ATTRIBUTE_ADDED")
                        
                        @schemas.classproperty
                        def ASSET_ATTRIBUTE_REMOVED(cls):
                            return cls("ASSET_ATTRIBUTE_REMOVED")
                        
                        @schemas.classproperty
                        def DOMAIN_ADDED(cls):
                            return cls("DOMAIN_ADDED")
                        
                        @schemas.classproperty
                        def DOMAIN_REMOVED(cls):
                            return cls("DOMAIN_REMOVED")
                        
                        @schemas.classproperty
                        def ROLE_GRANTED(cls):
                            return cls("ROLE_GRANTED")
                        
                        @schemas.classproperty
                        def ROLE_REVOKED(cls):
                            return cls("ROLE_REVOKED")
                        
                        @schemas.classproperty
                        def WORKFLOW_STARTED(cls):
                            return cls("WORKFLOW_STARTED")
                        
                        @schemas.classproperty
                        def WORKFLOW_CANCELED(cls):
                            return cls("WORKFLOW_CANCELED")
                        
                        @schemas.classproperty
                        def WORKLFLOW_ESCALATION(cls):
                            return cls("WORKLFLOW_ESCALATION")
                        
                        @schemas.classproperty
                        def WORKFLOW_TASK_COMPLETED(cls):
                            return cls("WORKFLOW_TASK_COMPLETED")
                        
                        @schemas.classproperty
                        def USER_ADDED(cls):
                            return cls("USER_ADDED")
                        
                        @schemas.classproperty
                        def USER_REMOVED(cls):
                            return cls("USER_REMOVED")
                        
                        @schemas.classproperty
                        def USER_DISABLED(cls):
                            return cls("USER_DISABLED")
                        
                        @schemas.classproperty
                        def COMMENT_ADDED(cls):
                            return cls("COMMENT_ADDED")
                        
                        @schemas.classproperty
                        def COMMENT_REMOVED(cls):
                            return cls("COMMENT_REMOVED")
                        
                        @schemas.classproperty
                        def COMMENT_CHANGED(cls):
                            return cls("COMMENT_CHANGED")
                        
                        @schemas.classproperty
                        def RELATION_ADDED_AND_ASSET_IS_SOURCE(cls):
                            return cls("RELATION_ADDED_AND_ASSET_IS_SOURCE")
                        
                        @schemas.classproperty
                        def RELATION_REMOVED_AND_ASSET_WAS_SOURCE(cls):
                            return cls("RELATION_REMOVED_AND_ASSET_WAS_SOURCE")
                        
                        @schemas.classproperty
                        def RELATION_ADDED_AND_ASSET_IS_TARGET(cls):
                            return cls("RELATION_ADDED_AND_ASSET_IS_TARGET")
                        
                        @schemas.classproperty
                        def RELATION_REMOVED_AND_ASSET_WAS_TARGET(cls):
                            return cls("RELATION_REMOVED_AND_ASSET_WAS_TARGET")
                        
                        @schemas.classproperty
                        def TAG_ASSIGN_CHANGED(cls):
                            return cls("TAG_ASSIGN_CHANGED")
                        
                        @schemas.classproperty
                        def CLASSIFICATION_MATCH_ACCEPTED(cls):
                            return cls("CLASSIFICATION_MATCH_ACCEPTED")
                        
                        @schemas.classproperty
                        def CLASSIFICATION_MATCH_REJECTED(cls):
                            return cls("CLASSIFICATION_MATCH_REJECTED")
                        
                        @schemas.classproperty
                        def CLASSIFICATION_MATCH_ADDED(cls):
                            return cls("CLASSIFICATION_MATCH_ADDED")
                        
                        @schemas.classproperty
                        def CLASSIFICATION_MATCH_REMOVED(cls):
                            return cls("CLASSIFICATION_MATCH_REMOVED")
                        
                        @schemas.classproperty
                        def CLASSIFICATION_MATCH_UPDATED(cls):
                            return cls("CLASSIFICATION_MATCH_UPDATED")
                        
                        @schemas.classproperty
                        def DATABASE_REGISTRATION_COMPLETED(cls):
                            return cls("DATABASE_REGISTRATION_COMPLETED")
                        
                        @schemas.classproperty
                        def DATABASE_REGISTRATION_FAILED(cls):
                            return cls("DATABASE_REGISTRATION_FAILED")
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'startEvents':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            
            
            class configurationVariables(
                schemas.DictSchema
            ):
            
            
                class MetaOapg:
                    additional_properties = schemas.StrSchema
                
                def __getitem__(self, name: typing.Union[str, ]) -> MetaOapg.additional_properties:
                    # dict_instance[name] accessor
                    return super().__getitem__(name)
                
                def get_item_oapg(self, name: typing.Union[str, ]) -> MetaOapg.additional_properties:
                    return super().get_item_oapg(name)
            
                def __new__(
                    cls,
                    *args: typing.Union[dict, frozendict.frozendict, ],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                    **kwargs: typing.Union[MetaOapg.additional_properties, str, ],
                ) -> 'configurationVariables':
                    return super().__new__(
                        cls,
                        *args,
                        _configuration=_configuration,
                        **kwargs,
                    )
            
            
            class startRoles(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['RoleImpl']:
                        return RoleImpl
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['RoleImpl'], typing.List['RoleImpl']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'startRoles':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'RoleImpl':
                    return super().__getitem__(i)
            
            
            class stopRoles(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['RoleImpl']:
                        return RoleImpl
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['RoleImpl'], typing.List['RoleImpl']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'stopRoles':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'RoleImpl':
                    return super().__getitem__(i)
            
            
            class reassignRoles(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['RoleImpl']:
                        return RoleImpl
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['RoleImpl'], typing.List['RoleImpl']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'reassignRoles':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'RoleImpl':
                    return super().__getitem__(i)
            __annotations__ = {
                "id": id,
                "resourceType": resourceType,
                "createdBy": createdBy,
                "createdOn": createdOn,
                "lastModifiedBy": lastModifiedBy,
                "lastModifiedOn": lastModifiedOn,
                "system": system,
                "name": name,
                "description": description,
                "processId": processId,
                "startLabel": startLabel,
                "formRequired": formRequired,
                "startFormKeyAvailable": startFormKeyAvailable,
                "startFormJsonModelAvailable": startFormJsonModelAvailable,
                "enabled": enabled,
                "domainAssignmentRules": domainAssignmentRules,
                "assetAssignmentRules": assetAssignmentRules,
                "businessItemResourceType": businessItemResourceType,
                "exclusivity": exclusivity,
                "guestUserAccessible": guestUserAccessible,
                "registeredUserAccessible": registeredUserAccessible,
                "candidateUserCheckEnabled": candidateUserCheckEnabled,
                "globalCreate": globalCreate,
                "startEvents": startEvents,
                "configurationVariables": configurationVariables,
                "startRoles": startRoles,
                "stopRoles": stopRoles,
                "reassignRoles": reassignRoles,
            }
    
    id: MetaOapg.properties.id
    resourceType: MetaOapg.properties.resourceType
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["resourceType"]) -> MetaOapg.properties.resourceType: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["createdBy"]) -> MetaOapg.properties.createdBy: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["createdOn"]) -> MetaOapg.properties.createdOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastModifiedBy"]) -> MetaOapg.properties.lastModifiedBy: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastModifiedOn"]) -> MetaOapg.properties.lastModifiedOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["system"]) -> MetaOapg.properties.system: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["description"]) -> MetaOapg.properties.description: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["processId"]) -> MetaOapg.properties.processId: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["startLabel"]) -> MetaOapg.properties.startLabel: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["formRequired"]) -> MetaOapg.properties.formRequired: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["startFormKeyAvailable"]) -> MetaOapg.properties.startFormKeyAvailable: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["startFormJsonModelAvailable"]) -> MetaOapg.properties.startFormJsonModelAvailable: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enabled"]) -> MetaOapg.properties.enabled: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["domainAssignmentRules"]) -> MetaOapg.properties.domainAssignmentRules: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["assetAssignmentRules"]) -> MetaOapg.properties.assetAssignmentRules: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["businessItemResourceType"]) -> MetaOapg.properties.businessItemResourceType: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["exclusivity"]) -> MetaOapg.properties.exclusivity: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["guestUserAccessible"]) -> MetaOapg.properties.guestUserAccessible: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["registeredUserAccessible"]) -> MetaOapg.properties.registeredUserAccessible: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["candidateUserCheckEnabled"]) -> MetaOapg.properties.candidateUserCheckEnabled: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["globalCreate"]) -> MetaOapg.properties.globalCreate: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["startEvents"]) -> MetaOapg.properties.startEvents: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["configurationVariables"]) -> MetaOapg.properties.configurationVariables: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["startRoles"]) -> MetaOapg.properties.startRoles: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["stopRoles"]) -> MetaOapg.properties.stopRoles: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["reassignRoles"]) -> MetaOapg.properties.reassignRoles: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["id", "resourceType", "createdBy", "createdOn", "lastModifiedBy", "lastModifiedOn", "system", "name", "description", "processId", "startLabel", "formRequired", "startFormKeyAvailable", "startFormJsonModelAvailable", "enabled", "domainAssignmentRules", "assetAssignmentRules", "businessItemResourceType", "exclusivity", "guestUserAccessible", "registeredUserAccessible", "candidateUserCheckEnabled", "globalCreate", "startEvents", "configurationVariables", "startRoles", "stopRoles", "reassignRoles", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["resourceType"]) -> MetaOapg.properties.resourceType: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["createdBy"]) -> typing.Union[MetaOapg.properties.createdBy, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["createdOn"]) -> typing.Union[MetaOapg.properties.createdOn, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastModifiedBy"]) -> typing.Union[MetaOapg.properties.lastModifiedBy, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastModifiedOn"]) -> typing.Union[MetaOapg.properties.lastModifiedOn, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["system"]) -> typing.Union[MetaOapg.properties.system, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["name"]) -> typing.Union[MetaOapg.properties.name, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["description"]) -> typing.Union[MetaOapg.properties.description, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["processId"]) -> typing.Union[MetaOapg.properties.processId, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["startLabel"]) -> typing.Union[MetaOapg.properties.startLabel, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["formRequired"]) -> typing.Union[MetaOapg.properties.formRequired, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["startFormKeyAvailable"]) -> typing.Union[MetaOapg.properties.startFormKeyAvailable, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["startFormJsonModelAvailable"]) -> typing.Union[MetaOapg.properties.startFormJsonModelAvailable, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enabled"]) -> typing.Union[MetaOapg.properties.enabled, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["domainAssignmentRules"]) -> typing.Union[MetaOapg.properties.domainAssignmentRules, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["assetAssignmentRules"]) -> typing.Union[MetaOapg.properties.assetAssignmentRules, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["businessItemResourceType"]) -> typing.Union[MetaOapg.properties.businessItemResourceType, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["exclusivity"]) -> typing.Union[MetaOapg.properties.exclusivity, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["guestUserAccessible"]) -> typing.Union[MetaOapg.properties.guestUserAccessible, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["registeredUserAccessible"]) -> typing.Union[MetaOapg.properties.registeredUserAccessible, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["candidateUserCheckEnabled"]) -> typing.Union[MetaOapg.properties.candidateUserCheckEnabled, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["globalCreate"]) -> typing.Union[MetaOapg.properties.globalCreate, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["startEvents"]) -> typing.Union[MetaOapg.properties.startEvents, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["configurationVariables"]) -> typing.Union[MetaOapg.properties.configurationVariables, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["startRoles"]) -> typing.Union[MetaOapg.properties.startRoles, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["stopRoles"]) -> typing.Union[MetaOapg.properties.stopRoles, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["reassignRoles"]) -> typing.Union[MetaOapg.properties.reassignRoles, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["id", "resourceType", "createdBy", "createdOn", "lastModifiedBy", "lastModifiedOn", "system", "name", "description", "processId", "startLabel", "formRequired", "startFormKeyAvailable", "startFormJsonModelAvailable", "enabled", "domainAssignmentRules", "assetAssignmentRules", "businessItemResourceType", "exclusivity", "guestUserAccessible", "registeredUserAccessible", "candidateUserCheckEnabled", "globalCreate", "startEvents", "configurationVariables", "startRoles", "stopRoles", "reassignRoles", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        id: typing.Union[MetaOapg.properties.id, str, uuid.UUID, ],
        resourceType: typing.Union[MetaOapg.properties.resourceType, str, ],
        createdBy: typing.Union[MetaOapg.properties.createdBy, str, uuid.UUID, schemas.Unset] = schemas.unset,
        createdOn: typing.Union[MetaOapg.properties.createdOn, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        lastModifiedBy: typing.Union[MetaOapg.properties.lastModifiedBy, str, uuid.UUID, schemas.Unset] = schemas.unset,
        lastModifiedOn: typing.Union[MetaOapg.properties.lastModifiedOn, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        system: typing.Union[MetaOapg.properties.system, bool, schemas.Unset] = schemas.unset,
        name: typing.Union[MetaOapg.properties.name, str, schemas.Unset] = schemas.unset,
        description: typing.Union[MetaOapg.properties.description, str, schemas.Unset] = schemas.unset,
        processId: typing.Union[MetaOapg.properties.processId, str, schemas.Unset] = schemas.unset,
        startLabel: typing.Union[MetaOapg.properties.startLabel, str, schemas.Unset] = schemas.unset,
        formRequired: typing.Union[MetaOapg.properties.formRequired, bool, schemas.Unset] = schemas.unset,
        startFormKeyAvailable: typing.Union[MetaOapg.properties.startFormKeyAvailable, bool, schemas.Unset] = schemas.unset,
        startFormJsonModelAvailable: typing.Union[MetaOapg.properties.startFormJsonModelAvailable, bool, schemas.Unset] = schemas.unset,
        enabled: typing.Union[MetaOapg.properties.enabled, bool, schemas.Unset] = schemas.unset,
        domainAssignmentRules: typing.Union[MetaOapg.properties.domainAssignmentRules, list, tuple, schemas.Unset] = schemas.unset,
        assetAssignmentRules: typing.Union[MetaOapg.properties.assetAssignmentRules, list, tuple, schemas.Unset] = schemas.unset,
        businessItemResourceType: typing.Union[MetaOapg.properties.businessItemResourceType, str, schemas.Unset] = schemas.unset,
        exclusivity: typing.Union[MetaOapg.properties.exclusivity, str, schemas.Unset] = schemas.unset,
        guestUserAccessible: typing.Union[MetaOapg.properties.guestUserAccessible, bool, schemas.Unset] = schemas.unset,
        registeredUserAccessible: typing.Union[MetaOapg.properties.registeredUserAccessible, bool, schemas.Unset] = schemas.unset,
        candidateUserCheckEnabled: typing.Union[MetaOapg.properties.candidateUserCheckEnabled, bool, schemas.Unset] = schemas.unset,
        globalCreate: typing.Union[MetaOapg.properties.globalCreate, bool, schemas.Unset] = schemas.unset,
        startEvents: typing.Union[MetaOapg.properties.startEvents, list, tuple, schemas.Unset] = schemas.unset,
        configurationVariables: typing.Union[MetaOapg.properties.configurationVariables, dict, frozendict.frozendict, schemas.Unset] = schemas.unset,
        startRoles: typing.Union[MetaOapg.properties.startRoles, list, tuple, schemas.Unset] = schemas.unset,
        stopRoles: typing.Union[MetaOapg.properties.stopRoles, list, tuple, schemas.Unset] = schemas.unset,
        reassignRoles: typing.Union[MetaOapg.properties.reassignRoles, list, tuple, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'WorkflowDefinitionImpl':
        return super().__new__(
            cls,
            *args,
            id=id,
            resourceType=resourceType,
            createdBy=createdBy,
            createdOn=createdOn,
            lastModifiedBy=lastModifiedBy,
            lastModifiedOn=lastModifiedOn,
            system=system,
            name=name,
            description=description,
            processId=processId,
            startLabel=startLabel,
            formRequired=formRequired,
            startFormKeyAvailable=startFormKeyAvailable,
            startFormJsonModelAvailable=startFormJsonModelAvailable,
            enabled=enabled,
            domainAssignmentRules=domainAssignmentRules,
            assetAssignmentRules=assetAssignmentRules,
            businessItemResourceType=businessItemResourceType,
            exclusivity=exclusivity,
            guestUserAccessible=guestUserAccessible,
            registeredUserAccessible=registeredUserAccessible,
            candidateUserCheckEnabled=candidateUserCheckEnabled,
            globalCreate=globalCreate,
            startEvents=startEvents,
            configurationVariables=configurationVariables,
            startRoles=startRoles,
            stopRoles=stopRoles,
            reassignRoles=reassignRoles,
            _configuration=_configuration,
            **kwargs,
        )

from collibra_core.model.asset_assignment_rule_impl import AssetAssignmentRuleImpl
from collibra_core.model.role_impl import RoleImpl
