# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from collibra_core import schemas  # noqa: F401


class User(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Represents a user in the system.
    """


    class MetaOapg:
        required = {
            "id",
            "resourceType",
        }
        
        class properties:
            id = schemas.UUIDSchema
            
            
            class resourceType(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "View": "VIEW",
                        "Asset": "ASSET",
                        "Community": "COMMUNITY",
                        "Domain": "DOMAIN",
                        "AssetType": "ASSET_TYPE",
                        "DomainType": "DOMAIN_TYPE",
                        "Status": "STATUS",
                        "User": "USER",
                        "ClassificationMatch": "CLASSIFICATION_MATCH",
                        "UserGroup": "USER_GROUP",
                        "Attribute": "ATTRIBUTE",
                        "StringAttribute": "STRING_ATTRIBUTE",
                        "ScriptAttribute": "SCRIPT_ATTRIBUTE",
                        "BooleanAttribute": "BOOLEAN_ATTRIBUTE",
                        "DateAttribute": "DATE_ATTRIBUTE",
                        "NumericAttribute": "NUMERIC_ATTRIBUTE",
                        "SingleValueListAttribute": "SINGLE_VALUE_LIST_ATTRIBUTE",
                        "MultiValueListAttribute": "MULTI_VALUE_LIST_ATTRIBUTE",
                        "Comment": "COMMENT",
                        "Attachment": "ATTACHMENT",
                        "Responsibility": "RESPONSIBILITY",
                        "Workflow": "WORKFLOW",
                        "Job": "JOB",
                        "Relation": "RELATION",
                        "RelationType": "RELATION_TYPE",
                        "ComplexRelation": "COMPLEX_RELATION",
                        "ComplexRelationType": "COMPLEX_RELATION_TYPE",
                        "ArticulationRule": "ARTICULATION_RULE",
                        "Assignment": "ASSIGNMENT",
                        "Scope": "SCOPE",
                        "RelationTrace": "RELATION_TRACE",
                        "ValidationRule": "VALIDATION_RULE",
                        "DataQualityRule": "DATA_QUALITY_RULE",
                        "DataQualityMetric": "DATA_QUALITY_METRIC",
                        "Address": "ADDRESS",
                        "InstantMessagingAccount": "INSTANT_MESSAGING_ACCOUNT",
                        "Email": "EMAIL",
                        "PhoneNumber": "PHONE_NUMBER",
                        "Website": "WEBSITE",
                        "Activity": "ACTIVITY",
                        "FormProperty": "FORM_PROPERTY",
                        "WorkflowTask": "WORKFLOW_TASK",
                        "ActivityChange": "ACTIVITY_CHANGE",
                        "WorkflowInstance": "WORKFLOW_INSTANCE",
                        "Role": "ROLE",
                        "AttributeType": "ATTRIBUTE_TYPE",
                        "BooleanAttributeType": "BOOLEAN_ATTRIBUTE_TYPE",
                        "DateAttributeType": "DATE_ATTRIBUTE_TYPE",
                        "DateTimeAttributeType": "DATE_TIME_ATTRIBUTE_TYPE",
                        "MultiValueListAttributeType": "MULTI_VALUE_LIST_ATTRIBUTE_TYPE",
                        "NumericAttributeType": "NUMERIC_ATTRIBUTE_TYPE",
                        "ScriptAttributeType": "SCRIPT_ATTRIBUTE_TYPE",
                        "SingleValueListAttributeType": "SINGLE_VALUE_LIST_ATTRIBUTE_TYPE",
                        "StringAttributeType": "STRING_ATTRIBUTE_TYPE",
                        "ViewSharingRule": "VIEW_SHARING_RULE",
                        "ViewAssignmentRule": "VIEW_ASSIGNMENT_RULE",
                        "JdbcDriverFile": "JDBC_DRIVER_FILE",
                        "JdbcDriver": "JDBC_DRIVER",
                        "JdbcIngestionProperties": "JDBC_INGESTION_PROPERTIES",
                        "CsvIngestionProperties": "CSV_INGESTION_PROPERTIES",
                        "ExcelIngestionProperties": "EXCEL_INGESTION_PROPERTIES",
                        "ConnectionStringParameter": "CONNECTION_STRING_PARAMETER",
                        "AssignedCharacteristicType": "ASSIGNED_CHARACTERISTIC_TYPE",
                        "Notification": "NOTIFICATION",
                        "Tag": "TAG",
                        "ComplexRelationLegType": "COMPLEX_RELATION_LEG_TYPE",
                        "ComplexRelationAttributeType": "COMPLEX_RELATION_ATTRIBUTE_TYPE",
                        "ComplexRelationLeg": "COMPLEX_RELATION_LEG",
                        "BaseDataType": "BASE_DATA_TYPE",
                        "AdvancedDataType": "ADVANCED_DATA_TYPE",
                        "DiagramPicture": "DIAGRAM_PICTURE",
                        "DiagramPictureSharingRule": "DIAGRAM_PICTURE_SHARING_RULE",
                        "DiagramPictureAssignmentRule": "DIAGRAM_PICTURE_ASSIGNMENT_RULE",
                        "Rating": "RATING",
                        "Classification": "CLASSIFICATION",
                        "PhysicalDataConnector": "PHYSICAL_DATA_CONNECTOR",
                        "Context": "CONTEXT",
                    }
                
                @schemas.classproperty
                def VIEW(cls):
                    return cls("View")
                
                @schemas.classproperty
                def ASSET(cls):
                    return cls("Asset")
                
                @schemas.classproperty
                def COMMUNITY(cls):
                    return cls("Community")
                
                @schemas.classproperty
                def DOMAIN(cls):
                    return cls("Domain")
                
                @schemas.classproperty
                def ASSET_TYPE(cls):
                    return cls("AssetType")
                
                @schemas.classproperty
                def DOMAIN_TYPE(cls):
                    return cls("DomainType")
                
                @schemas.classproperty
                def STATUS(cls):
                    return cls("Status")
                
                @schemas.classproperty
                def USER(cls):
                    return cls("User")
                
                @schemas.classproperty
                def CLASSIFICATION_MATCH(cls):
                    return cls("ClassificationMatch")
                
                @schemas.classproperty
                def USER_GROUP(cls):
                    return cls("UserGroup")
                
                @schemas.classproperty
                def ATTRIBUTE(cls):
                    return cls("Attribute")
                
                @schemas.classproperty
                def STRING_ATTRIBUTE(cls):
                    return cls("StringAttribute")
                
                @schemas.classproperty
                def SCRIPT_ATTRIBUTE(cls):
                    return cls("ScriptAttribute")
                
                @schemas.classproperty
                def BOOLEAN_ATTRIBUTE(cls):
                    return cls("BooleanAttribute")
                
                @schemas.classproperty
                def DATE_ATTRIBUTE(cls):
                    return cls("DateAttribute")
                
                @schemas.classproperty
                def NUMERIC_ATTRIBUTE(cls):
                    return cls("NumericAttribute")
                
                @schemas.classproperty
                def SINGLE_VALUE_LIST_ATTRIBUTE(cls):
                    return cls("SingleValueListAttribute")
                
                @schemas.classproperty
                def MULTI_VALUE_LIST_ATTRIBUTE(cls):
                    return cls("MultiValueListAttribute")
                
                @schemas.classproperty
                def COMMENT(cls):
                    return cls("Comment")
                
                @schemas.classproperty
                def ATTACHMENT(cls):
                    return cls("Attachment")
                
                @schemas.classproperty
                def RESPONSIBILITY(cls):
                    return cls("Responsibility")
                
                @schemas.classproperty
                def WORKFLOW(cls):
                    return cls("Workflow")
                
                @schemas.classproperty
                def JOB(cls):
                    return cls("Job")
                
                @schemas.classproperty
                def RELATION(cls):
                    return cls("Relation")
                
                @schemas.classproperty
                def RELATION_TYPE(cls):
                    return cls("RelationType")
                
                @schemas.classproperty
                def COMPLEX_RELATION(cls):
                    return cls("ComplexRelation")
                
                @schemas.classproperty
                def COMPLEX_RELATION_TYPE(cls):
                    return cls("ComplexRelationType")
                
                @schemas.classproperty
                def ARTICULATION_RULE(cls):
                    return cls("ArticulationRule")
                
                @schemas.classproperty
                def ASSIGNMENT(cls):
                    return cls("Assignment")
                
                @schemas.classproperty
                def SCOPE(cls):
                    return cls("Scope")
                
                @schemas.classproperty
                def RELATION_TRACE(cls):
                    return cls("RelationTrace")
                
                @schemas.classproperty
                def VALIDATION_RULE(cls):
                    return cls("ValidationRule")
                
                @schemas.classproperty
                def DATA_QUALITY_RULE(cls):
                    return cls("DataQualityRule")
                
                @schemas.classproperty
                def DATA_QUALITY_METRIC(cls):
                    return cls("DataQualityMetric")
                
                @schemas.classproperty
                def ADDRESS(cls):
                    return cls("Address")
                
                @schemas.classproperty
                def INSTANT_MESSAGING_ACCOUNT(cls):
                    return cls("InstantMessagingAccount")
                
                @schemas.classproperty
                def EMAIL(cls):
                    return cls("Email")
                
                @schemas.classproperty
                def PHONE_NUMBER(cls):
                    return cls("PhoneNumber")
                
                @schemas.classproperty
                def WEBSITE(cls):
                    return cls("Website")
                
                @schemas.classproperty
                def ACTIVITY(cls):
                    return cls("Activity")
                
                @schemas.classproperty
                def FORM_PROPERTY(cls):
                    return cls("FormProperty")
                
                @schemas.classproperty
                def WORKFLOW_TASK(cls):
                    return cls("WorkflowTask")
                
                @schemas.classproperty
                def ACTIVITY_CHANGE(cls):
                    return cls("ActivityChange")
                
                @schemas.classproperty
                def WORKFLOW_INSTANCE(cls):
                    return cls("WorkflowInstance")
                
                @schemas.classproperty
                def ROLE(cls):
                    return cls("Role")
                
                @schemas.classproperty
                def ATTRIBUTE_TYPE(cls):
                    return cls("AttributeType")
                
                @schemas.classproperty
                def BOOLEAN_ATTRIBUTE_TYPE(cls):
                    return cls("BooleanAttributeType")
                
                @schemas.classproperty
                def DATE_ATTRIBUTE_TYPE(cls):
                    return cls("DateAttributeType")
                
                @schemas.classproperty
                def DATE_TIME_ATTRIBUTE_TYPE(cls):
                    return cls("DateTimeAttributeType")
                
                @schemas.classproperty
                def MULTI_VALUE_LIST_ATTRIBUTE_TYPE(cls):
                    return cls("MultiValueListAttributeType")
                
                @schemas.classproperty
                def NUMERIC_ATTRIBUTE_TYPE(cls):
                    return cls("NumericAttributeType")
                
                @schemas.classproperty
                def SCRIPT_ATTRIBUTE_TYPE(cls):
                    return cls("ScriptAttributeType")
                
                @schemas.classproperty
                def SINGLE_VALUE_LIST_ATTRIBUTE_TYPE(cls):
                    return cls("SingleValueListAttributeType")
                
                @schemas.classproperty
                def STRING_ATTRIBUTE_TYPE(cls):
                    return cls("StringAttributeType")
                
                @schemas.classproperty
                def VIEW_SHARING_RULE(cls):
                    return cls("ViewSharingRule")
                
                @schemas.classproperty
                def VIEW_ASSIGNMENT_RULE(cls):
                    return cls("ViewAssignmentRule")
                
                @schemas.classproperty
                def JDBC_DRIVER_FILE(cls):
                    return cls("JdbcDriverFile")
                
                @schemas.classproperty
                def JDBC_DRIVER(cls):
                    return cls("JdbcDriver")
                
                @schemas.classproperty
                def JDBC_INGESTION_PROPERTIES(cls):
                    return cls("JdbcIngestionProperties")
                
                @schemas.classproperty
                def CSV_INGESTION_PROPERTIES(cls):
                    return cls("CsvIngestionProperties")
                
                @schemas.classproperty
                def EXCEL_INGESTION_PROPERTIES(cls):
                    return cls("ExcelIngestionProperties")
                
                @schemas.classproperty
                def CONNECTION_STRING_PARAMETER(cls):
                    return cls("ConnectionStringParameter")
                
                @schemas.classproperty
                def ASSIGNED_CHARACTERISTIC_TYPE(cls):
                    return cls("AssignedCharacteristicType")
                
                @schemas.classproperty
                def NOTIFICATION(cls):
                    return cls("Notification")
                
                @schemas.classproperty
                def TAG(cls):
                    return cls("Tag")
                
                @schemas.classproperty
                def COMPLEX_RELATION_LEG_TYPE(cls):
                    return cls("ComplexRelationLegType")
                
                @schemas.classproperty
                def COMPLEX_RELATION_ATTRIBUTE_TYPE(cls):
                    return cls("ComplexRelationAttributeType")
                
                @schemas.classproperty
                def COMPLEX_RELATION_LEG(cls):
                    return cls("ComplexRelationLeg")
                
                @schemas.classproperty
                def BASE_DATA_TYPE(cls):
                    return cls("BaseDataType")
                
                @schemas.classproperty
                def ADVANCED_DATA_TYPE(cls):
                    return cls("AdvancedDataType")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE(cls):
                    return cls("DiagramPicture")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE_SHARING_RULE(cls):
                    return cls("DiagramPictureSharingRule")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE_ASSIGNMENT_RULE(cls):
                    return cls("DiagramPictureAssignmentRule")
                
                @schemas.classproperty
                def RATING(cls):
                    return cls("Rating")
                
                @schemas.classproperty
                def CLASSIFICATION(cls):
                    return cls("Classification")
                
                @schemas.classproperty
                def PHYSICAL_DATA_CONNECTOR(cls):
                    return cls("PhysicalDataConnector")
                
                @schemas.classproperty
                def CONTEXT(cls):
                    return cls("Context")
            createdBy = schemas.UUIDSchema
            createdOn = schemas.Int64Schema
            lastModifiedBy = schemas.UUIDSchema
            lastModifiedOn = schemas.Int64Schema
            system = schemas.BoolSchema
            userName = schemas.StrSchema
            firstName = schemas.StrSchema
            lastName = schemas.StrSchema
            emailAddress = schemas.StrSchema
            
            
            class gender(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "MALE": "MALE",
                        "FEMALE": "FEMALE",
                        "UNKNOWN": "UNKNOWN",
                    }
                
                @schemas.classproperty
                def MALE(cls):
                    return cls("MALE")
                
                @schemas.classproperty
                def FEMALE(cls):
                    return cls("FEMALE")
                
                @schemas.classproperty
                def UNKNOWN(cls):
                    return cls("UNKNOWN")
            language = schemas.StrSchema
            
            
            class additionalEmailAddresses(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['Email']:
                        return Email
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['Email'], typing.List['Email']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'additionalEmailAddresses':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'Email':
                    return super().__getitem__(i)
            
            
            class phoneNumbers(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['PhoneNumber']:
                        return PhoneNumber
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['PhoneNumber'], typing.List['PhoneNumber']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'phoneNumbers':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'PhoneNumber':
                    return super().__getitem__(i)
            
            
            class instantMessagingAccounts(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['InstantMessagingAccount']:
                        return InstantMessagingAccount
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['InstantMessagingAccount'], typing.List['InstantMessagingAccount']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'instantMessagingAccounts':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'InstantMessagingAccount':
                    return super().__getitem__(i)
            
            
            class websites(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['Website']:
                        return Website
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['Website'], typing.List['Website']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'websites':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'Website':
                    return super().__getitem__(i)
            
            
            class addresses(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    @staticmethod
                    def items() -> typing.Type['Address']:
                        return Address
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple['Address'], typing.List['Address']],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'addresses':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> 'Address':
                    return super().__getitem__(i)
            activated = schemas.BoolSchema
            enabled = schemas.BoolSchema
            ldapUser = schemas.BoolSchema
            
            
            class userSource(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "INTERNAL": "INTERNAL",
                        "LDAP": "LDAP",
                        "SSO": "SSO",
                    }
                
                @schemas.classproperty
                def INTERNAL(cls):
                    return cls("INTERNAL")
                
                @schemas.classproperty
                def LDAP(cls):
                    return cls("LDAP")
                
                @schemas.classproperty
                def SSO(cls):
                    return cls("SSO")
            guestUser = schemas.BoolSchema
            apiUser = schemas.BoolSchema
            
            
            class licenseType(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "CONSUMER": "CONSUMER",
                        "AUTHOR": "AUTHOR",
                    }
                
                @schemas.classproperty
                def CONSUMER(cls):
                    return cls("CONSUMER")
                
                @schemas.classproperty
                def AUTHOR(cls):
                    return cls("AUTHOR")
            __annotations__ = {
                "id": id,
                "resourceType": resourceType,
                "createdBy": createdBy,
                "createdOn": createdOn,
                "lastModifiedBy": lastModifiedBy,
                "lastModifiedOn": lastModifiedOn,
                "system": system,
                "userName": userName,
                "firstName": firstName,
                "lastName": lastName,
                "emailAddress": emailAddress,
                "gender": gender,
                "language": language,
                "additionalEmailAddresses": additionalEmailAddresses,
                "phoneNumbers": phoneNumbers,
                "instantMessagingAccounts": instantMessagingAccounts,
                "websites": websites,
                "addresses": addresses,
                "activated": activated,
                "enabled": enabled,
                "ldapUser": ldapUser,
                "userSource": userSource,
                "guestUser": guestUser,
                "apiUser": apiUser,
                "licenseType": licenseType,
            }
    
    id: MetaOapg.properties.id
    resourceType: MetaOapg.properties.resourceType
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["resourceType"]) -> MetaOapg.properties.resourceType: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["createdBy"]) -> MetaOapg.properties.createdBy: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["createdOn"]) -> MetaOapg.properties.createdOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastModifiedBy"]) -> MetaOapg.properties.lastModifiedBy: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastModifiedOn"]) -> MetaOapg.properties.lastModifiedOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["system"]) -> MetaOapg.properties.system: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["userName"]) -> MetaOapg.properties.userName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["firstName"]) -> MetaOapg.properties.firstName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastName"]) -> MetaOapg.properties.lastName: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["emailAddress"]) -> MetaOapg.properties.emailAddress: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["gender"]) -> MetaOapg.properties.gender: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["language"]) -> MetaOapg.properties.language: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["additionalEmailAddresses"]) -> MetaOapg.properties.additionalEmailAddresses: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["phoneNumbers"]) -> MetaOapg.properties.phoneNumbers: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["instantMessagingAccounts"]) -> MetaOapg.properties.instantMessagingAccounts: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["websites"]) -> MetaOapg.properties.websites: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["addresses"]) -> MetaOapg.properties.addresses: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["activated"]) -> MetaOapg.properties.activated: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["enabled"]) -> MetaOapg.properties.enabled: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["ldapUser"]) -> MetaOapg.properties.ldapUser: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["userSource"]) -> MetaOapg.properties.userSource: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["guestUser"]) -> MetaOapg.properties.guestUser: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["apiUser"]) -> MetaOapg.properties.apiUser: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["licenseType"]) -> MetaOapg.properties.licenseType: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["id", "resourceType", "createdBy", "createdOn", "lastModifiedBy", "lastModifiedOn", "system", "userName", "firstName", "lastName", "emailAddress", "gender", "language", "additionalEmailAddresses", "phoneNumbers", "instantMessagingAccounts", "websites", "addresses", "activated", "enabled", "ldapUser", "userSource", "guestUser", "apiUser", "licenseType", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["resourceType"]) -> MetaOapg.properties.resourceType: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["createdBy"]) -> typing.Union[MetaOapg.properties.createdBy, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["createdOn"]) -> typing.Union[MetaOapg.properties.createdOn, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastModifiedBy"]) -> typing.Union[MetaOapg.properties.lastModifiedBy, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastModifiedOn"]) -> typing.Union[MetaOapg.properties.lastModifiedOn, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["system"]) -> typing.Union[MetaOapg.properties.system, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["userName"]) -> typing.Union[MetaOapg.properties.userName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["firstName"]) -> typing.Union[MetaOapg.properties.firstName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastName"]) -> typing.Union[MetaOapg.properties.lastName, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["emailAddress"]) -> typing.Union[MetaOapg.properties.emailAddress, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["gender"]) -> typing.Union[MetaOapg.properties.gender, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["language"]) -> typing.Union[MetaOapg.properties.language, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["additionalEmailAddresses"]) -> typing.Union[MetaOapg.properties.additionalEmailAddresses, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["phoneNumbers"]) -> typing.Union[MetaOapg.properties.phoneNumbers, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["instantMessagingAccounts"]) -> typing.Union[MetaOapg.properties.instantMessagingAccounts, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["websites"]) -> typing.Union[MetaOapg.properties.websites, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["addresses"]) -> typing.Union[MetaOapg.properties.addresses, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["activated"]) -> typing.Union[MetaOapg.properties.activated, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["enabled"]) -> typing.Union[MetaOapg.properties.enabled, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["ldapUser"]) -> typing.Union[MetaOapg.properties.ldapUser, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["userSource"]) -> typing.Union[MetaOapg.properties.userSource, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["guestUser"]) -> typing.Union[MetaOapg.properties.guestUser, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["apiUser"]) -> typing.Union[MetaOapg.properties.apiUser, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["licenseType"]) -> typing.Union[MetaOapg.properties.licenseType, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["id", "resourceType", "createdBy", "createdOn", "lastModifiedBy", "lastModifiedOn", "system", "userName", "firstName", "lastName", "emailAddress", "gender", "language", "additionalEmailAddresses", "phoneNumbers", "instantMessagingAccounts", "websites", "addresses", "activated", "enabled", "ldapUser", "userSource", "guestUser", "apiUser", "licenseType", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        id: typing.Union[MetaOapg.properties.id, str, uuid.UUID, ],
        resourceType: typing.Union[MetaOapg.properties.resourceType, str, ],
        createdBy: typing.Union[MetaOapg.properties.createdBy, str, uuid.UUID, schemas.Unset] = schemas.unset,
        createdOn: typing.Union[MetaOapg.properties.createdOn, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        lastModifiedBy: typing.Union[MetaOapg.properties.lastModifiedBy, str, uuid.UUID, schemas.Unset] = schemas.unset,
        lastModifiedOn: typing.Union[MetaOapg.properties.lastModifiedOn, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        system: typing.Union[MetaOapg.properties.system, bool, schemas.Unset] = schemas.unset,
        userName: typing.Union[MetaOapg.properties.userName, str, schemas.Unset] = schemas.unset,
        firstName: typing.Union[MetaOapg.properties.firstName, str, schemas.Unset] = schemas.unset,
        lastName: typing.Union[MetaOapg.properties.lastName, str, schemas.Unset] = schemas.unset,
        emailAddress: typing.Union[MetaOapg.properties.emailAddress, str, schemas.Unset] = schemas.unset,
        gender: typing.Union[MetaOapg.properties.gender, str, schemas.Unset] = schemas.unset,
        language: typing.Union[MetaOapg.properties.language, str, schemas.Unset] = schemas.unset,
        additionalEmailAddresses: typing.Union[MetaOapg.properties.additionalEmailAddresses, list, tuple, schemas.Unset] = schemas.unset,
        phoneNumbers: typing.Union[MetaOapg.properties.phoneNumbers, list, tuple, schemas.Unset] = schemas.unset,
        instantMessagingAccounts: typing.Union[MetaOapg.properties.instantMessagingAccounts, list, tuple, schemas.Unset] = schemas.unset,
        websites: typing.Union[MetaOapg.properties.websites, list, tuple, schemas.Unset] = schemas.unset,
        addresses: typing.Union[MetaOapg.properties.addresses, list, tuple, schemas.Unset] = schemas.unset,
        activated: typing.Union[MetaOapg.properties.activated, bool, schemas.Unset] = schemas.unset,
        enabled: typing.Union[MetaOapg.properties.enabled, bool, schemas.Unset] = schemas.unset,
        ldapUser: typing.Union[MetaOapg.properties.ldapUser, bool, schemas.Unset] = schemas.unset,
        userSource: typing.Union[MetaOapg.properties.userSource, str, schemas.Unset] = schemas.unset,
        guestUser: typing.Union[MetaOapg.properties.guestUser, bool, schemas.Unset] = schemas.unset,
        apiUser: typing.Union[MetaOapg.properties.apiUser, bool, schemas.Unset] = schemas.unset,
        licenseType: typing.Union[MetaOapg.properties.licenseType, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'User':
        return super().__new__(
            cls,
            *args,
            id=id,
            resourceType=resourceType,
            createdBy=createdBy,
            createdOn=createdOn,
            lastModifiedBy=lastModifiedBy,
            lastModifiedOn=lastModifiedOn,
            system=system,
            userName=userName,
            firstName=firstName,
            lastName=lastName,
            emailAddress=emailAddress,
            gender=gender,
            language=language,
            additionalEmailAddresses=additionalEmailAddresses,
            phoneNumbers=phoneNumbers,
            instantMessagingAccounts=instantMessagingAccounts,
            websites=websites,
            addresses=addresses,
            activated=activated,
            enabled=enabled,
            ldapUser=ldapUser,
            userSource=userSource,
            guestUser=guestUser,
            apiUser=apiUser,
            licenseType=licenseType,
            _configuration=_configuration,
            **kwargs,
        )

from collibra_core.model.address import Address
from collibra_core.model.email import Email
from collibra_core.model.instant_messaging_account import InstantMessagingAccount
from collibra_core.model.phone_number import PhoneNumber
from collibra_core.model.website import Website
