# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from collibra_core import schemas  # noqa: F401


class RoleImpl(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Represents a role.<p>A role is a grouping of rights and responsibilities (permissions) that is assigned to individual users or user groups.<p>Collibra DGC distinguishes between global roles and resource roles.
    """


    class MetaOapg:
        required = {
            "id",
            "resourceType",
        }
        
        class properties:
            id = schemas.UUIDSchema
            
            
            class resourceType(
                schemas.EnumBase,
                schemas.StrSchema
            ):
            
            
                class MetaOapg:
                    enum_value_to_name = {
                        "View": "VIEW",
                        "Asset": "ASSET",
                        "Community": "COMMUNITY",
                        "Domain": "DOMAIN",
                        "AssetType": "ASSET_TYPE",
                        "DomainType": "DOMAIN_TYPE",
                        "Status": "STATUS",
                        "User": "USER",
                        "ClassificationMatch": "CLASSIFICATION_MATCH",
                        "UserGroup": "USER_GROUP",
                        "Attribute": "ATTRIBUTE",
                        "StringAttribute": "STRING_ATTRIBUTE",
                        "ScriptAttribute": "SCRIPT_ATTRIBUTE",
                        "BooleanAttribute": "BOOLEAN_ATTRIBUTE",
                        "DateAttribute": "DATE_ATTRIBUTE",
                        "NumericAttribute": "NUMERIC_ATTRIBUTE",
                        "SingleValueListAttribute": "SINGLE_VALUE_LIST_ATTRIBUTE",
                        "MultiValueListAttribute": "MULTI_VALUE_LIST_ATTRIBUTE",
                        "Comment": "COMMENT",
                        "Attachment": "ATTACHMENT",
                        "Responsibility": "RESPONSIBILITY",
                        "Workflow": "WORKFLOW",
                        "Job": "JOB",
                        "Relation": "RELATION",
                        "RelationType": "RELATION_TYPE",
                        "ComplexRelation": "COMPLEX_RELATION",
                        "ComplexRelationType": "COMPLEX_RELATION_TYPE",
                        "ArticulationRule": "ARTICULATION_RULE",
                        "Assignment": "ASSIGNMENT",
                        "Scope": "SCOPE",
                        "RelationTrace": "RELATION_TRACE",
                        "ValidationRule": "VALIDATION_RULE",
                        "DataQualityRule": "DATA_QUALITY_RULE",
                        "DataQualityMetric": "DATA_QUALITY_METRIC",
                        "Address": "ADDRESS",
                        "InstantMessagingAccount": "INSTANT_MESSAGING_ACCOUNT",
                        "Email": "EMAIL",
                        "PhoneNumber": "PHONE_NUMBER",
                        "Website": "WEBSITE",
                        "Activity": "ACTIVITY",
                        "FormProperty": "FORM_PROPERTY",
                        "WorkflowTask": "WORKFLOW_TASK",
                        "ActivityChange": "ACTIVITY_CHANGE",
                        "WorkflowInstance": "WORKFLOW_INSTANCE",
                        "Role": "ROLE",
                        "AttributeType": "ATTRIBUTE_TYPE",
                        "BooleanAttributeType": "BOOLEAN_ATTRIBUTE_TYPE",
                        "DateAttributeType": "DATE_ATTRIBUTE_TYPE",
                        "DateTimeAttributeType": "DATE_TIME_ATTRIBUTE_TYPE",
                        "MultiValueListAttributeType": "MULTI_VALUE_LIST_ATTRIBUTE_TYPE",
                        "NumericAttributeType": "NUMERIC_ATTRIBUTE_TYPE",
                        "ScriptAttributeType": "SCRIPT_ATTRIBUTE_TYPE",
                        "SingleValueListAttributeType": "SINGLE_VALUE_LIST_ATTRIBUTE_TYPE",
                        "StringAttributeType": "STRING_ATTRIBUTE_TYPE",
                        "ViewSharingRule": "VIEW_SHARING_RULE",
                        "ViewAssignmentRule": "VIEW_ASSIGNMENT_RULE",
                        "JdbcDriverFile": "JDBC_DRIVER_FILE",
                        "JdbcDriver": "JDBC_DRIVER",
                        "JdbcIngestionProperties": "JDBC_INGESTION_PROPERTIES",
                        "CsvIngestionProperties": "CSV_INGESTION_PROPERTIES",
                        "ExcelIngestionProperties": "EXCEL_INGESTION_PROPERTIES",
                        "ConnectionStringParameter": "CONNECTION_STRING_PARAMETER",
                        "AssignedCharacteristicType": "ASSIGNED_CHARACTERISTIC_TYPE",
                        "Notification": "NOTIFICATION",
                        "Tag": "TAG",
                        "ComplexRelationLegType": "COMPLEX_RELATION_LEG_TYPE",
                        "ComplexRelationAttributeType": "COMPLEX_RELATION_ATTRIBUTE_TYPE",
                        "ComplexRelationLeg": "COMPLEX_RELATION_LEG",
                        "BaseDataType": "BASE_DATA_TYPE",
                        "AdvancedDataType": "ADVANCED_DATA_TYPE",
                        "DiagramPicture": "DIAGRAM_PICTURE",
                        "DiagramPictureSharingRule": "DIAGRAM_PICTURE_SHARING_RULE",
                        "DiagramPictureAssignmentRule": "DIAGRAM_PICTURE_ASSIGNMENT_RULE",
                        "Rating": "RATING",
                        "Classification": "CLASSIFICATION",
                        "PhysicalDataConnector": "PHYSICAL_DATA_CONNECTOR",
                        "Context": "CONTEXT",
                    }
                
                @schemas.classproperty
                def VIEW(cls):
                    return cls("View")
                
                @schemas.classproperty
                def ASSET(cls):
                    return cls("Asset")
                
                @schemas.classproperty
                def COMMUNITY(cls):
                    return cls("Community")
                
                @schemas.classproperty
                def DOMAIN(cls):
                    return cls("Domain")
                
                @schemas.classproperty
                def ASSET_TYPE(cls):
                    return cls("AssetType")
                
                @schemas.classproperty
                def DOMAIN_TYPE(cls):
                    return cls("DomainType")
                
                @schemas.classproperty
                def STATUS(cls):
                    return cls("Status")
                
                @schemas.classproperty
                def USER(cls):
                    return cls("User")
                
                @schemas.classproperty
                def CLASSIFICATION_MATCH(cls):
                    return cls("ClassificationMatch")
                
                @schemas.classproperty
                def USER_GROUP(cls):
                    return cls("UserGroup")
                
                @schemas.classproperty
                def ATTRIBUTE(cls):
                    return cls("Attribute")
                
                @schemas.classproperty
                def STRING_ATTRIBUTE(cls):
                    return cls("StringAttribute")
                
                @schemas.classproperty
                def SCRIPT_ATTRIBUTE(cls):
                    return cls("ScriptAttribute")
                
                @schemas.classproperty
                def BOOLEAN_ATTRIBUTE(cls):
                    return cls("BooleanAttribute")
                
                @schemas.classproperty
                def DATE_ATTRIBUTE(cls):
                    return cls("DateAttribute")
                
                @schemas.classproperty
                def NUMERIC_ATTRIBUTE(cls):
                    return cls("NumericAttribute")
                
                @schemas.classproperty
                def SINGLE_VALUE_LIST_ATTRIBUTE(cls):
                    return cls("SingleValueListAttribute")
                
                @schemas.classproperty
                def MULTI_VALUE_LIST_ATTRIBUTE(cls):
                    return cls("MultiValueListAttribute")
                
                @schemas.classproperty
                def COMMENT(cls):
                    return cls("Comment")
                
                @schemas.classproperty
                def ATTACHMENT(cls):
                    return cls("Attachment")
                
                @schemas.classproperty
                def RESPONSIBILITY(cls):
                    return cls("Responsibility")
                
                @schemas.classproperty
                def WORKFLOW(cls):
                    return cls("Workflow")
                
                @schemas.classproperty
                def JOB(cls):
                    return cls("Job")
                
                @schemas.classproperty
                def RELATION(cls):
                    return cls("Relation")
                
                @schemas.classproperty
                def RELATION_TYPE(cls):
                    return cls("RelationType")
                
                @schemas.classproperty
                def COMPLEX_RELATION(cls):
                    return cls("ComplexRelation")
                
                @schemas.classproperty
                def COMPLEX_RELATION_TYPE(cls):
                    return cls("ComplexRelationType")
                
                @schemas.classproperty
                def ARTICULATION_RULE(cls):
                    return cls("ArticulationRule")
                
                @schemas.classproperty
                def ASSIGNMENT(cls):
                    return cls("Assignment")
                
                @schemas.classproperty
                def SCOPE(cls):
                    return cls("Scope")
                
                @schemas.classproperty
                def RELATION_TRACE(cls):
                    return cls("RelationTrace")
                
                @schemas.classproperty
                def VALIDATION_RULE(cls):
                    return cls("ValidationRule")
                
                @schemas.classproperty
                def DATA_QUALITY_RULE(cls):
                    return cls("DataQualityRule")
                
                @schemas.classproperty
                def DATA_QUALITY_METRIC(cls):
                    return cls("DataQualityMetric")
                
                @schemas.classproperty
                def ADDRESS(cls):
                    return cls("Address")
                
                @schemas.classproperty
                def INSTANT_MESSAGING_ACCOUNT(cls):
                    return cls("InstantMessagingAccount")
                
                @schemas.classproperty
                def EMAIL(cls):
                    return cls("Email")
                
                @schemas.classproperty
                def PHONE_NUMBER(cls):
                    return cls("PhoneNumber")
                
                @schemas.classproperty
                def WEBSITE(cls):
                    return cls("Website")
                
                @schemas.classproperty
                def ACTIVITY(cls):
                    return cls("Activity")
                
                @schemas.classproperty
                def FORM_PROPERTY(cls):
                    return cls("FormProperty")
                
                @schemas.classproperty
                def WORKFLOW_TASK(cls):
                    return cls("WorkflowTask")
                
                @schemas.classproperty
                def ACTIVITY_CHANGE(cls):
                    return cls("ActivityChange")
                
                @schemas.classproperty
                def WORKFLOW_INSTANCE(cls):
                    return cls("WorkflowInstance")
                
                @schemas.classproperty
                def ROLE(cls):
                    return cls("Role")
                
                @schemas.classproperty
                def ATTRIBUTE_TYPE(cls):
                    return cls("AttributeType")
                
                @schemas.classproperty
                def BOOLEAN_ATTRIBUTE_TYPE(cls):
                    return cls("BooleanAttributeType")
                
                @schemas.classproperty
                def DATE_ATTRIBUTE_TYPE(cls):
                    return cls("DateAttributeType")
                
                @schemas.classproperty
                def DATE_TIME_ATTRIBUTE_TYPE(cls):
                    return cls("DateTimeAttributeType")
                
                @schemas.classproperty
                def MULTI_VALUE_LIST_ATTRIBUTE_TYPE(cls):
                    return cls("MultiValueListAttributeType")
                
                @schemas.classproperty
                def NUMERIC_ATTRIBUTE_TYPE(cls):
                    return cls("NumericAttributeType")
                
                @schemas.classproperty
                def SCRIPT_ATTRIBUTE_TYPE(cls):
                    return cls("ScriptAttributeType")
                
                @schemas.classproperty
                def SINGLE_VALUE_LIST_ATTRIBUTE_TYPE(cls):
                    return cls("SingleValueListAttributeType")
                
                @schemas.classproperty
                def STRING_ATTRIBUTE_TYPE(cls):
                    return cls("StringAttributeType")
                
                @schemas.classproperty
                def VIEW_SHARING_RULE(cls):
                    return cls("ViewSharingRule")
                
                @schemas.classproperty
                def VIEW_ASSIGNMENT_RULE(cls):
                    return cls("ViewAssignmentRule")
                
                @schemas.classproperty
                def JDBC_DRIVER_FILE(cls):
                    return cls("JdbcDriverFile")
                
                @schemas.classproperty
                def JDBC_DRIVER(cls):
                    return cls("JdbcDriver")
                
                @schemas.classproperty
                def JDBC_INGESTION_PROPERTIES(cls):
                    return cls("JdbcIngestionProperties")
                
                @schemas.classproperty
                def CSV_INGESTION_PROPERTIES(cls):
                    return cls("CsvIngestionProperties")
                
                @schemas.classproperty
                def EXCEL_INGESTION_PROPERTIES(cls):
                    return cls("ExcelIngestionProperties")
                
                @schemas.classproperty
                def CONNECTION_STRING_PARAMETER(cls):
                    return cls("ConnectionStringParameter")
                
                @schemas.classproperty
                def ASSIGNED_CHARACTERISTIC_TYPE(cls):
                    return cls("AssignedCharacteristicType")
                
                @schemas.classproperty
                def NOTIFICATION(cls):
                    return cls("Notification")
                
                @schemas.classproperty
                def TAG(cls):
                    return cls("Tag")
                
                @schemas.classproperty
                def COMPLEX_RELATION_LEG_TYPE(cls):
                    return cls("ComplexRelationLegType")
                
                @schemas.classproperty
                def COMPLEX_RELATION_ATTRIBUTE_TYPE(cls):
                    return cls("ComplexRelationAttributeType")
                
                @schemas.classproperty
                def COMPLEX_RELATION_LEG(cls):
                    return cls("ComplexRelationLeg")
                
                @schemas.classproperty
                def BASE_DATA_TYPE(cls):
                    return cls("BaseDataType")
                
                @schemas.classproperty
                def ADVANCED_DATA_TYPE(cls):
                    return cls("AdvancedDataType")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE(cls):
                    return cls("DiagramPicture")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE_SHARING_RULE(cls):
                    return cls("DiagramPictureSharingRule")
                
                @schemas.classproperty
                def DIAGRAM_PICTURE_ASSIGNMENT_RULE(cls):
                    return cls("DiagramPictureAssignmentRule")
                
                @schemas.classproperty
                def RATING(cls):
                    return cls("Rating")
                
                @schemas.classproperty
                def CLASSIFICATION(cls):
                    return cls("Classification")
                
                @schemas.classproperty
                def PHYSICAL_DATA_CONNECTOR(cls):
                    return cls("PhysicalDataConnector")
                
                @schemas.classproperty
                def CONTEXT(cls):
                    return cls("Context")
            createdBy = schemas.UUIDSchema
            createdOn = schemas.Int64Schema
            lastModifiedBy = schemas.UUIDSchema
            lastModifiedOn = schemas.Int64Schema
            system = schemas.BoolSchema
            name = schemas.StrSchema
            description = schemas.StrSchema
            
            
            class permissions(
                schemas.ListSchema
            ):
            
            
                class MetaOapg:
                    
                    
                    class items(
                        schemas.EnumBase,
                        schemas.StrSchema
                    ):
                    
                    
                        class MetaOapg:
                            enum_value_to_name = {
                                "EDGE": "EDGE",
                                "EDGE_SITE_CONNECT": "EDGE_SITE_CONNECT",
                                "EDGE_SITE_MANAGE": "EDGE_SITE_MANAGE",
                                "EDGE_SITE_ADMINISTER": "EDGE_SITE_ADMINISTER",
                                "EDGE_INTEGRATION_CAPABILITY_MANAGE": "EDGE_INTEGRATION_CAPABILITY_MANAGE",
                                "EDGE_VIEW_CONNECTIONS_AND_CAPABILITIES": "EDGE_VIEW_CONNECTIONS_AND_CAPABILITIES",
                                "EDGE_VIEW_LOGS": "EDGE_VIEW_LOGS",
                                "ASSET_GRID_ADMINISTRATION": "ASSET_GRID_ADMINISTRATION",
                                "ATTACHMENT_ADD": "ATTACHMENT_ADD",
                                "ATTACHMENT_CHANGE": "ATTACHMENT_CHANGE",
                                "ATTACHMENT_REMOVE": "ATTACHMENT_REMOVE",
                                "COMMENT_ADD": "COMMENT_ADD",
                                "COMMENT_CHANGE": "COMMENT_CHANGE",
                                "COMMENT_REMOVE": "COMMENT_REMOVE",
                                "RATING_ADD": "RATING_ADD",
                                "RATING_CHANGE": "RATING_CHANGE",
                                "RATING_REMOVE": "RATING_REMOVE",
                                "COMMUNITY_ADD": "COMMUNITY_ADD",
                                "COMMUNITY_CHANGE": "COMMUNITY_CHANGE",
                                "COMMUNITY_REMOVE": "COMMUNITY_REMOVE",
                                "COMMUNITY_CONFIGURE_EXTERNAL_SYSTEM": "COMMUNITY_CONFIGURE_EXTERNAL_SYSTEM",
                                "COMMUNITY_RESPONSIBILITY_ADD": "COMMUNITY_RESPONSIBILITY_ADD",
                                "COMMUNITY_RESPONSIBILITY_CHANGE": "COMMUNITY_RESPONSIBILITY_CHANGE",
                                "COMMUNITY_RESPONSIBILITY_REMOVE": "COMMUNITY_RESPONSIBILITY_REMOVE",
                                "DOMAIN_ADD": "DOMAIN_ADD",
                                "DOMAIN_CHANGE": "DOMAIN_CHANGE",
                                "DOMAIN_REMOVE": "DOMAIN_REMOVE",
                                "DOMAIN_RESPONSIBILITY_ADD": "DOMAIN_RESPONSIBILITY_ADD",
                                "DOMAIN_RESPONSIBILITY_CHANGE": "DOMAIN_RESPONSIBILITY_CHANGE",
                                "DOMAIN_RESPONSIBILITY_REMOVE": "DOMAIN_RESPONSIBILITY_REMOVE",
                                "WORKFLOW_MANAGE": "WORKFLOW_MANAGE",
                                "WORKFLOW_DESIGNER_ACCESS": "WORKFLOW_DESIGNER_ACCESS",
                                "ASSET_ADD": "ASSET_ADD",
                                "ASSET_CHANGE": "ASSET_CHANGE",
                                "ASSET_REMOVE": "ASSET_REMOVE",
                                "ASSET_STATUS_CHANGE": "ASSET_STATUS_CHANGE",
                                "ASSET_TYPE_CHANGE": "ASSET_TYPE_CHANGE",
                                "ASSET_TAG_CHANGE": "ASSET_TAG_CHANGE",
                                "ASSET_ATTRIBUTE_ADD": "ASSET_ATTRIBUTE_ADD",
                                "ASSET_ATTRIBUTE_CHANGE": "ASSET_ATTRIBUTE_CHANGE",
                                "ASSET_ATTRIBUTE_REMOVE": "ASSET_ATTRIBUTE_REMOVE",
                                "ASSET_RESPONSIBILITY_ADD": "ASSET_RESPONSIBILITY_ADD",
                                "ASSET_RESPONSIBILITY_CHANGE": "ASSET_RESPONSIBILITY_CHANGE",
                                "ASSET_RESPONSIBILITY_REMOVE": "ASSET_RESPONSIBILITY_REMOVE",
                                "VIEW_PERMISSIONS_CHANGE": "VIEW_PERMISSIONS_CHANGE",
                                "BUSINESS_SEMANTICS_GLOSSARY": "BUSINESS_SEMANTICS_GLOSSARY",
                                "REFERENCE_DATA_MANAGER": "REFERENCE_DATA_MANAGER",
                                "DATA_STEWARDSHIP_MANAGER": "DATA_STEWARDSHIP_MANAGER",
                                "SYSTEM_ADMINISTRATION": "SYSTEM_ADMINISTRATION",
                                "USER_ADMINISTRATION": "USER_ADMINISTRATION",
                                "WORKFLOW_ADMINISTRATION": "WORKFLOW_ADMINISTRATION",
                                "DATA_HELPDESK": "DATA_HELPDESK",
                                "POLICY_MANAGER": "POLICY_MANAGER",
                                "DATA_DICTIONARY": "DATA_DICTIONARY",
                                "CATALOG": "CATALOG",
                                "WORKFLOW_MANAGE_ALL": "WORKFLOW_MANAGE_ALL",
                                "WORKFLOW_MESSAGE_EVENTS_USE": "WORKFLOW_MESSAGE_EVENTS_USE",
                                "VIEW_PERMISSIONS_VIEW_ALL": "VIEW_PERMISSIONS_VIEW_ALL",
                                "VIEW_MANAGE": "VIEW_MANAGE",
                                "VIEW_SHARE": "VIEW_SHARE",
                                "VIEW_MANAGE_ALL": "VIEW_MANAGE_ALL",
                                "ADVANCED_DATA_TYPE_ADD": "ADVANCED_DATA_TYPE_ADD",
                                "ADVANCED_DATA_TYPE_EDIT": "ADVANCED_DATA_TYPE_EDIT",
                                "ADVANCED_DATA_TYPE_REMOVE": "ADVANCED_DATA_TYPE_REMOVE",
                                "TAGS_VIEW": "TAGS_VIEW",
                                "TAGS_MANAGE": "TAGS_MANAGE",
                                "VALIDATION_EXECUTION": "VALIDATION_EXECUTION",
                                "ACCESS_DATA": "ACCESS_DATA",
                                "VIEW_SAMPLES": "VIEW_SAMPLES",
                                "RELATION_TYPE_ADD": "RELATION_TYPE_ADD",
                                "RELATION_TYPE_REMOVE": "RELATION_TYPE_REMOVE",
                                "RELATION_TYPE_CHANGE": "RELATION_TYPE_CHANGE",
                                "REGISTER_PROFILING_INFORMATION": "REGISTER_PROFILING_INFORMATION",
                                "REPORTING_DOWNLOAD_INSIGHTS_DATA": "REPORTING_DOWNLOAD_INSIGHTS_DATA",
                                "REPORTING_VIEW_INSIGHTS_REPORTS": "REPORTING_VIEW_INSIGHTS_REPORTS",
                                "INSIGHTS_VIEW": "INSIGHTS_VIEW",
                                "INSIGHTS_SUMMARY": "INSIGHTS_SUMMARY",
                                "TECHNICAL_LINEAGE": "TECHNICAL_LINEAGE",
                                "LOGS_VIEW": "LOGS_VIEW",
                                "RESOURCE_MANAGE_ALL": "RESOURCE_MANAGE_ALL",
                                "CONFIGURATION_VIEW": "CONFIGURATION_VIEW",
                                "CONFIGURATION_EDIT": "CONFIGURATION_EDIT",
                                "BACKSTORE_VIEW": "BACKSTORE_VIEW",
                                "BACKSTORE_EDIT": "BACKSTORE_EDIT",
                                "ASSESSMENTS": "ASSESSMENTS",
                                "METADATA_LAKE": "METADATA_LAKE",
                                "PROTECT": "PROTECT",
                                "PROTECT_EDIT": "PROTECT_EDIT",
                                "PROTECT_ADMINISTRATION": "PROTECT_ADMINISTRATION",
                                "PRIVACY": "PRIVACY",
                            }
                        
                        @schemas.classproperty
                        def EDGE(cls):
                            return cls("EDGE")
                        
                        @schemas.classproperty
                        def EDGE_SITE_CONNECT(cls):
                            return cls("EDGE_SITE_CONNECT")
                        
                        @schemas.classproperty
                        def EDGE_SITE_MANAGE(cls):
                            return cls("EDGE_SITE_MANAGE")
                        
                        @schemas.classproperty
                        def EDGE_SITE_ADMINISTER(cls):
                            return cls("EDGE_SITE_ADMINISTER")
                        
                        @schemas.classproperty
                        def EDGE_INTEGRATION_CAPABILITY_MANAGE(cls):
                            return cls("EDGE_INTEGRATION_CAPABILITY_MANAGE")
                        
                        @schemas.classproperty
                        def EDGE_VIEW_CONNECTIONS_AND_CAPABILITIES(cls):
                            return cls("EDGE_VIEW_CONNECTIONS_AND_CAPABILITIES")
                        
                        @schemas.classproperty
                        def EDGE_VIEW_LOGS(cls):
                            return cls("EDGE_VIEW_LOGS")
                        
                        @schemas.classproperty
                        def ASSET_GRID_ADMINISTRATION(cls):
                            return cls("ASSET_GRID_ADMINISTRATION")
                        
                        @schemas.classproperty
                        def ATTACHMENT_ADD(cls):
                            return cls("ATTACHMENT_ADD")
                        
                        @schemas.classproperty
                        def ATTACHMENT_CHANGE(cls):
                            return cls("ATTACHMENT_CHANGE")
                        
                        @schemas.classproperty
                        def ATTACHMENT_REMOVE(cls):
                            return cls("ATTACHMENT_REMOVE")
                        
                        @schemas.classproperty
                        def COMMENT_ADD(cls):
                            return cls("COMMENT_ADD")
                        
                        @schemas.classproperty
                        def COMMENT_CHANGE(cls):
                            return cls("COMMENT_CHANGE")
                        
                        @schemas.classproperty
                        def COMMENT_REMOVE(cls):
                            return cls("COMMENT_REMOVE")
                        
                        @schemas.classproperty
                        def RATING_ADD(cls):
                            return cls("RATING_ADD")
                        
                        @schemas.classproperty
                        def RATING_CHANGE(cls):
                            return cls("RATING_CHANGE")
                        
                        @schemas.classproperty
                        def RATING_REMOVE(cls):
                            return cls("RATING_REMOVE")
                        
                        @schemas.classproperty
                        def COMMUNITY_ADD(cls):
                            return cls("COMMUNITY_ADD")
                        
                        @schemas.classproperty
                        def COMMUNITY_CHANGE(cls):
                            return cls("COMMUNITY_CHANGE")
                        
                        @schemas.classproperty
                        def COMMUNITY_REMOVE(cls):
                            return cls("COMMUNITY_REMOVE")
                        
                        @schemas.classproperty
                        def COMMUNITY_CONFIGURE_EXTERNAL_SYSTEM(cls):
                            return cls("COMMUNITY_CONFIGURE_EXTERNAL_SYSTEM")
                        
                        @schemas.classproperty
                        def COMMUNITY_RESPONSIBILITY_ADD(cls):
                            return cls("COMMUNITY_RESPONSIBILITY_ADD")
                        
                        @schemas.classproperty
                        def COMMUNITY_RESPONSIBILITY_CHANGE(cls):
                            return cls("COMMUNITY_RESPONSIBILITY_CHANGE")
                        
                        @schemas.classproperty
                        def COMMUNITY_RESPONSIBILITY_REMOVE(cls):
                            return cls("COMMUNITY_RESPONSIBILITY_REMOVE")
                        
                        @schemas.classproperty
                        def DOMAIN_ADD(cls):
                            return cls("DOMAIN_ADD")
                        
                        @schemas.classproperty
                        def DOMAIN_CHANGE(cls):
                            return cls("DOMAIN_CHANGE")
                        
                        @schemas.classproperty
                        def DOMAIN_REMOVE(cls):
                            return cls("DOMAIN_REMOVE")
                        
                        @schemas.classproperty
                        def DOMAIN_RESPONSIBILITY_ADD(cls):
                            return cls("DOMAIN_RESPONSIBILITY_ADD")
                        
                        @schemas.classproperty
                        def DOMAIN_RESPONSIBILITY_CHANGE(cls):
                            return cls("DOMAIN_RESPONSIBILITY_CHANGE")
                        
                        @schemas.classproperty
                        def DOMAIN_RESPONSIBILITY_REMOVE(cls):
                            return cls("DOMAIN_RESPONSIBILITY_REMOVE")
                        
                        @schemas.classproperty
                        def WORKFLOW_MANAGE(cls):
                            return cls("WORKFLOW_MANAGE")
                        
                        @schemas.classproperty
                        def WORKFLOW_DESIGNER_ACCESS(cls):
                            return cls("WORKFLOW_DESIGNER_ACCESS")
                        
                        @schemas.classproperty
                        def ASSET_ADD(cls):
                            return cls("ASSET_ADD")
                        
                        @schemas.classproperty
                        def ASSET_CHANGE(cls):
                            return cls("ASSET_CHANGE")
                        
                        @schemas.classproperty
                        def ASSET_REMOVE(cls):
                            return cls("ASSET_REMOVE")
                        
                        @schemas.classproperty
                        def ASSET_STATUS_CHANGE(cls):
                            return cls("ASSET_STATUS_CHANGE")
                        
                        @schemas.classproperty
                        def ASSET_TYPE_CHANGE(cls):
                            return cls("ASSET_TYPE_CHANGE")
                        
                        @schemas.classproperty
                        def ASSET_TAG_CHANGE(cls):
                            return cls("ASSET_TAG_CHANGE")
                        
                        @schemas.classproperty
                        def ASSET_ATTRIBUTE_ADD(cls):
                            return cls("ASSET_ATTRIBUTE_ADD")
                        
                        @schemas.classproperty
                        def ASSET_ATTRIBUTE_CHANGE(cls):
                            return cls("ASSET_ATTRIBUTE_CHANGE")
                        
                        @schemas.classproperty
                        def ASSET_ATTRIBUTE_REMOVE(cls):
                            return cls("ASSET_ATTRIBUTE_REMOVE")
                        
                        @schemas.classproperty
                        def ASSET_RESPONSIBILITY_ADD(cls):
                            return cls("ASSET_RESPONSIBILITY_ADD")
                        
                        @schemas.classproperty
                        def ASSET_RESPONSIBILITY_CHANGE(cls):
                            return cls("ASSET_RESPONSIBILITY_CHANGE")
                        
                        @schemas.classproperty
                        def ASSET_RESPONSIBILITY_REMOVE(cls):
                            return cls("ASSET_RESPONSIBILITY_REMOVE")
                        
                        @schemas.classproperty
                        def VIEW_PERMISSIONS_CHANGE(cls):
                            return cls("VIEW_PERMISSIONS_CHANGE")
                        
                        @schemas.classproperty
                        def BUSINESS_SEMANTICS_GLOSSARY(cls):
                            return cls("BUSINESS_SEMANTICS_GLOSSARY")
                        
                        @schemas.classproperty
                        def REFERENCE_DATA_MANAGER(cls):
                            return cls("REFERENCE_DATA_MANAGER")
                        
                        @schemas.classproperty
                        def DATA_STEWARDSHIP_MANAGER(cls):
                            return cls("DATA_STEWARDSHIP_MANAGER")
                        
                        @schemas.classproperty
                        def SYSTEM_ADMINISTRATION(cls):
                            return cls("SYSTEM_ADMINISTRATION")
                        
                        @schemas.classproperty
                        def USER_ADMINISTRATION(cls):
                            return cls("USER_ADMINISTRATION")
                        
                        @schemas.classproperty
                        def WORKFLOW_ADMINISTRATION(cls):
                            return cls("WORKFLOW_ADMINISTRATION")
                        
                        @schemas.classproperty
                        def DATA_HELPDESK(cls):
                            return cls("DATA_HELPDESK")
                        
                        @schemas.classproperty
                        def POLICY_MANAGER(cls):
                            return cls("POLICY_MANAGER")
                        
                        @schemas.classproperty
                        def DATA_DICTIONARY(cls):
                            return cls("DATA_DICTIONARY")
                        
                        @schemas.classproperty
                        def CATALOG(cls):
                            return cls("CATALOG")
                        
                        @schemas.classproperty
                        def WORKFLOW_MANAGE_ALL(cls):
                            return cls("WORKFLOW_MANAGE_ALL")
                        
                        @schemas.classproperty
                        def WORKFLOW_MESSAGE_EVENTS_USE(cls):
                            return cls("WORKFLOW_MESSAGE_EVENTS_USE")
                        
                        @schemas.classproperty
                        def VIEW_PERMISSIONS_VIEW_ALL(cls):
                            return cls("VIEW_PERMISSIONS_VIEW_ALL")
                        
                        @schemas.classproperty
                        def VIEW_MANAGE(cls):
                            return cls("VIEW_MANAGE")
                        
                        @schemas.classproperty
                        def VIEW_SHARE(cls):
                            return cls("VIEW_SHARE")
                        
                        @schemas.classproperty
                        def VIEW_MANAGE_ALL(cls):
                            return cls("VIEW_MANAGE_ALL")
                        
                        @schemas.classproperty
                        def ADVANCED_DATA_TYPE_ADD(cls):
                            return cls("ADVANCED_DATA_TYPE_ADD")
                        
                        @schemas.classproperty
                        def ADVANCED_DATA_TYPE_EDIT(cls):
                            return cls("ADVANCED_DATA_TYPE_EDIT")
                        
                        @schemas.classproperty
                        def ADVANCED_DATA_TYPE_REMOVE(cls):
                            return cls("ADVANCED_DATA_TYPE_REMOVE")
                        
                        @schemas.classproperty
                        def TAGS_VIEW(cls):
                            return cls("TAGS_VIEW")
                        
                        @schemas.classproperty
                        def TAGS_MANAGE(cls):
                            return cls("TAGS_MANAGE")
                        
                        @schemas.classproperty
                        def VALIDATION_EXECUTION(cls):
                            return cls("VALIDATION_EXECUTION")
                        
                        @schemas.classproperty
                        def ACCESS_DATA(cls):
                            return cls("ACCESS_DATA")
                        
                        @schemas.classproperty
                        def VIEW_SAMPLES(cls):
                            return cls("VIEW_SAMPLES")
                        
                        @schemas.classproperty
                        def RELATION_TYPE_ADD(cls):
                            return cls("RELATION_TYPE_ADD")
                        
                        @schemas.classproperty
                        def RELATION_TYPE_REMOVE(cls):
                            return cls("RELATION_TYPE_REMOVE")
                        
                        @schemas.classproperty
                        def RELATION_TYPE_CHANGE(cls):
                            return cls("RELATION_TYPE_CHANGE")
                        
                        @schemas.classproperty
                        def REGISTER_PROFILING_INFORMATION(cls):
                            return cls("REGISTER_PROFILING_INFORMATION")
                        
                        @schemas.classproperty
                        def REPORTING_DOWNLOAD_INSIGHTS_DATA(cls):
                            return cls("REPORTING_DOWNLOAD_INSIGHTS_DATA")
                        
                        @schemas.classproperty
                        def REPORTING_VIEW_INSIGHTS_REPORTS(cls):
                            return cls("REPORTING_VIEW_INSIGHTS_REPORTS")
                        
                        @schemas.classproperty
                        def INSIGHTS_VIEW(cls):
                            return cls("INSIGHTS_VIEW")
                        
                        @schemas.classproperty
                        def INSIGHTS_SUMMARY(cls):
                            return cls("INSIGHTS_SUMMARY")
                        
                        @schemas.classproperty
                        def TECHNICAL_LINEAGE(cls):
                            return cls("TECHNICAL_LINEAGE")
                        
                        @schemas.classproperty
                        def LOGS_VIEW(cls):
                            return cls("LOGS_VIEW")
                        
                        @schemas.classproperty
                        def RESOURCE_MANAGE_ALL(cls):
                            return cls("RESOURCE_MANAGE_ALL")
                        
                        @schemas.classproperty
                        def CONFIGURATION_VIEW(cls):
                            return cls("CONFIGURATION_VIEW")
                        
                        @schemas.classproperty
                        def CONFIGURATION_EDIT(cls):
                            return cls("CONFIGURATION_EDIT")
                        
                        @schemas.classproperty
                        def BACKSTORE_VIEW(cls):
                            return cls("BACKSTORE_VIEW")
                        
                        @schemas.classproperty
                        def BACKSTORE_EDIT(cls):
                            return cls("BACKSTORE_EDIT")
                        
                        @schemas.classproperty
                        def ASSESSMENTS(cls):
                            return cls("ASSESSMENTS")
                        
                        @schemas.classproperty
                        def METADATA_LAKE(cls):
                            return cls("METADATA_LAKE")
                        
                        @schemas.classproperty
                        def PROTECT(cls):
                            return cls("PROTECT")
                        
                        @schemas.classproperty
                        def PROTECT_EDIT(cls):
                            return cls("PROTECT_EDIT")
                        
                        @schemas.classproperty
                        def PROTECT_ADMINISTRATION(cls):
                            return cls("PROTECT_ADMINISTRATION")
                        
                        @schemas.classproperty
                        def PRIVACY(cls):
                            return cls("PRIVACY")
            
                def __new__(
                    cls,
                    arg: typing.Union[typing.Tuple[typing.Union[MetaOapg.items, str, ]], typing.List[typing.Union[MetaOapg.items, str, ]]],
                    _configuration: typing.Optional[schemas.Configuration] = None,
                ) -> 'permissions':
                    return super().__new__(
                        cls,
                        arg,
                        _configuration=_configuration,
                    )
            
                def __getitem__(self, i: int) -> MetaOapg.items:
                    return super().__getitem__(i)
            _global = schemas.BoolSchema
            __annotations__ = {
                "id": id,
                "resourceType": resourceType,
                "createdBy": createdBy,
                "createdOn": createdOn,
                "lastModifiedBy": lastModifiedBy,
                "lastModifiedOn": lastModifiedOn,
                "system": system,
                "name": name,
                "description": description,
                "permissions": permissions,
                "global": _global,
            }
    
    id: MetaOapg.properties.id
    resourceType: MetaOapg.properties.resourceType
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["resourceType"]) -> MetaOapg.properties.resourceType: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["createdBy"]) -> MetaOapg.properties.createdBy: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["createdOn"]) -> MetaOapg.properties.createdOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastModifiedBy"]) -> MetaOapg.properties.lastModifiedBy: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["lastModifiedOn"]) -> MetaOapg.properties.lastModifiedOn: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["system"]) -> MetaOapg.properties.system: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["name"]) -> MetaOapg.properties.name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["description"]) -> MetaOapg.properties.description: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["permissions"]) -> MetaOapg.properties.permissions: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["global"]) -> MetaOapg.properties._global: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["id", "resourceType", "createdBy", "createdOn", "lastModifiedBy", "lastModifiedOn", "system", "name", "description", "permissions", "global", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["resourceType"]) -> MetaOapg.properties.resourceType: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["createdBy"]) -> typing.Union[MetaOapg.properties.createdBy, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["createdOn"]) -> typing.Union[MetaOapg.properties.createdOn, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastModifiedBy"]) -> typing.Union[MetaOapg.properties.lastModifiedBy, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["lastModifiedOn"]) -> typing.Union[MetaOapg.properties.lastModifiedOn, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["system"]) -> typing.Union[MetaOapg.properties.system, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["name"]) -> typing.Union[MetaOapg.properties.name, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["description"]) -> typing.Union[MetaOapg.properties.description, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["permissions"]) -> typing.Union[MetaOapg.properties.permissions, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["global"]) -> typing.Union[MetaOapg.properties._global, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["id", "resourceType", "createdBy", "createdOn", "lastModifiedBy", "lastModifiedOn", "system", "name", "description", "permissions", "global", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        id: typing.Union[MetaOapg.properties.id, str, uuid.UUID, ],
        resourceType: typing.Union[MetaOapg.properties.resourceType, str, ],
        createdBy: typing.Union[MetaOapg.properties.createdBy, str, uuid.UUID, schemas.Unset] = schemas.unset,
        createdOn: typing.Union[MetaOapg.properties.createdOn, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        lastModifiedBy: typing.Union[MetaOapg.properties.lastModifiedBy, str, uuid.UUID, schemas.Unset] = schemas.unset,
        lastModifiedOn: typing.Union[MetaOapg.properties.lastModifiedOn, decimal.Decimal, int, schemas.Unset] = schemas.unset,
        system: typing.Union[MetaOapg.properties.system, bool, schemas.Unset] = schemas.unset,
        name: typing.Union[MetaOapg.properties.name, str, schemas.Unset] = schemas.unset,
        description: typing.Union[MetaOapg.properties.description, str, schemas.Unset] = schemas.unset,
        permissions: typing.Union[MetaOapg.properties.permissions, list, tuple, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'RoleImpl':
        return super().__new__(
            cls,
            *args,
            id=id,
            resourceType=resourceType,
            createdBy=createdBy,
            createdOn=createdOn,
            lastModifiedBy=lastModifiedBy,
            lastModifiedOn=lastModifiedOn,
            system=system,
            name=name,
            description=description,
            permissions=permissions,
            _configuration=_configuration,
            **kwargs,
        )
