"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const database_secret_1 = require("./database-secret");
const database_query_1 = require("./private/database-query");
const handler_name_1 = require("./private/database-query-provider/handler-name");
const privileges_1 = require("./private/privileges");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const constructs_1 = require("constructs");
class UserBase extends constructs_1.Construct {
    /**
     * (experimental) Grant this user privilege to access a table.
     *
     * @experimental
     */
    addTablePrivileges(table, ...actions) {
        if (!this.privileges) {
            this.privileges = new privileges_1.UserTablePrivileges(this, 'TablePrivileges', {
                ...this.databaseProps,
                user: this,
            });
        }
        this.privileges.addPrivileges(table, ...actions);
    }
}
/**
 * (experimental) A user in a Redshift cluster.
 *
 * @experimental
 */
class User extends UserBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_redshift_alpha_UserProps(props);
        this.databaseProps = props;
        this.cluster = props.cluster;
        this.databaseName = props.databaseName;
        const username = (_b = props.username) !== null && _b !== void 0 ? _b : cdk.Names.uniqueId(this).toLowerCase();
        const secret = new database_secret_1.DatabaseSecret(this, 'Secret', {
            username,
            encryptionKey: props.encryptionKey,
        });
        const attachedSecret = secret.attach(props.cluster);
        this.password = attachedSecret.secretValueFromJson('password');
        this.resource = new database_query_1.DatabaseQuery(this, 'Resource', {
            ...this.databaseProps,
            handler: handler_name_1.HandlerName.User,
            properties: {
                username,
                passwordSecretArn: attachedSecret.secretArn,
            },
        });
        attachedSecret.grantRead(this.resource);
        this.username = this.resource.getAttString('username');
    }
    /**
     * (experimental) Specify a Redshift user using credentials that already exist.
     *
     * @experimental
     */
    static fromUserAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_redshift_alpha_UserAttributes(attrs);
        return new class extends UserBase {
            constructor() {
                super(...arguments);
                this.username = attrs.username;
                this.password = attrs.password;
                this.cluster = attrs.cluster;
                this.databaseName = attrs.databaseName;
                this.databaseProps = attrs;
            }
        }(scope, id);
    }
    /**
     * (experimental) Apply the given removal policy to this resource.
     *
     * The Removal Policy controls what happens to this resource when it stops
     * being managed by CloudFormation, either because you've removed it from the
     * CDK application or because you've made a change that requires the resource
     * to be replaced.
     *
     * The resource can be destroyed (`RemovalPolicy.DESTROY`), or left in your AWS
     * account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).
     *
     * This resource is destroyed by default.
     *
     * @experimental
     */
    applyRemovalPolicy(policy) {
        this.resource.applyRemovalPolicy(policy);
    }
}
exports.User = User;
_a = JSII_RTTI_SYMBOL_1;
User[_a] = { fqn: "@aws-cdk/aws-redshift-alpha.User", version: "2.0.0-alpha.8" };
//# sourceMappingURL=data:application/json;base64,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