import * as kms from 'aws-cdk-lib/aws-kms';
import * as cdk from 'aws-cdk-lib';
import { ICluster } from './cluster';
import { DatabaseOptions } from './database-options';
import { ITable, TableAction } from './table';
import { Construct, IConstruct } from 'constructs';
/**
 * (experimental) Properties for configuring a Redshift user.
 *
 * @experimental
 */
export interface UserProps extends DatabaseOptions {
    /**
     * (experimental) The name of the user.
     *
     * For valid values, see: https://docs.aws.amazon.com/redshift/latest/dg/r_names.html
     *
     * @default - a name is generated
     * @experimental
     */
    readonly username?: string;
    /**
     * (experimental) KMS key to encrypt the generated secret.
     *
     * @default - the default AWS managed key is used
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) The policy to apply when this resource is removed from the application.
     *
     * @default cdk.RemovalPolicy.Destroy
     * @experimental
     */
    readonly removalPolicy?: cdk.RemovalPolicy;
}
/**
 * (experimental) Represents a user in a Redshift database.
 *
 * @experimental
 */
export interface IUser extends IConstruct {
    /**
     * (experimental) The name of the user.
     *
     * @experimental
     */
    readonly username: string;
    /**
     * (experimental) The password of the user.
     *
     * @experimental
     */
    readonly password: cdk.SecretValue;
    /**
     * (experimental) The cluster where the table is located.
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) The name of the database where the table is located.
     *
     * @experimental
     */
    readonly databaseName: string;
    /**
     * (experimental) Grant this user privilege to access a table.
     *
     * @experimental
     */
    addTablePrivileges(table: ITable, ...actions: TableAction[]): void;
}
/**
 * (experimental) A full specification of a Redshift user that can be used to import it fluently into the CDK application.
 *
 * @experimental
 */
export interface UserAttributes extends DatabaseOptions {
    /**
     * (experimental) The name of the user.
     *
     * @experimental
     */
    readonly username: string;
    /**
     * (experimental) The password of the user.
     *
     * Do not put passwords in CDK code directly.
     *
     * @experimental
     */
    readonly password: cdk.SecretValue;
}
declare abstract class UserBase extends Construct implements IUser {
    abstract readonly username: string;
    abstract readonly password: cdk.SecretValue;
    abstract readonly cluster: ICluster;
    abstract readonly databaseName: string;
    /**
     * The tables that user will have access to
     */
    private privileges?;
    protected abstract readonly databaseProps: DatabaseOptions;
    /**
     * (experimental) Grant this user privilege to access a table.
     *
     * @experimental
     */
    addTablePrivileges(table: ITable, ...actions: TableAction[]): void;
}
/**
 * (experimental) A user in a Redshift cluster.
 *
 * @experimental
 */
export declare class User extends UserBase {
    /**
     * (experimental) Specify a Redshift user using credentials that already exist.
     *
     * @experimental
     */
    static fromUserAttributes(scope: Construct, id: string, attrs: UserAttributes): IUser;
    /**
     * (experimental) The name of the user.
     *
     * @experimental
     */
    readonly username: string;
    /**
     * (experimental) The password of the user.
     *
     * @experimental
     */
    readonly password: cdk.SecretValue;
    /**
     * (experimental) The cluster where the table is located.
     *
     * @experimental
     */
    readonly cluster: ICluster;
    /**
     * (experimental) The name of the database where the table is located.
     *
     * @experimental
     */
    readonly databaseName: string;
    /**
     * @experimental
     */
    protected databaseProps: DatabaseOptions;
    private resource;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: UserProps);
    /**
     * (experimental) Apply the given removal policy to this resource.
     *
     * The Removal Policy controls what happens to this resource when it stops
     * being managed by CloudFormation, either because you've removed it from the
     * CDK application or because you've made a change that requires the resource
     * to be replaced.
     *
     * The resource can be destroyed (`RemovalPolicy.DESTROY`), or left in your AWS
     * account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).
     *
     * This resource is destroyed by default.
     *
     * @experimental
     */
    applyRemovalPolicy(policy: cdk.RemovalPolicy): void;
}
export {};
