# coding: utf-8

"""
    Text Analytics API (v2.0)

    The Text Analytics API is a suite of text analytics web services built with best-in-class Microsoft machine learning algorithms.   The API can be used to analyze unstructured text for tasks such as sentiment analysis, key phrase extraction and language detection.   No training data is needed to use this API; just bring your text data.   This API uses advanced natural language processing techniques to deliver best in class predictions.    Further documentation can be found in https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/overview  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class MatchRecordV2(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'text': 'str',
        'offset': 'int',
        'length': 'int'
    }

    attribute_map = {
        'text': 'text',
        'offset': 'offset',
        'length': 'length'
    }

    def __init__(self, text=None, offset=None, length=None):  # noqa: E501
        """MatchRecordV2 - a model defined in Swagger"""  # noqa: E501

        self._text = None
        self._offset = None
        self._length = None
        self.discriminator = None

        if text is not None:
            self.text = text
        if offset is not None:
            self.offset = offset
        if length is not None:
            self.length = length

    @property
    def text(self):
        """Gets the text of this MatchRecordV2.  # noqa: E501

        Entity text as appears in the request.  # noqa: E501

        :return: The text of this MatchRecordV2.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this MatchRecordV2.

        Entity text as appears in the request.  # noqa: E501

        :param text: The text of this MatchRecordV2.  # noqa: E501
        :type: str
        """

        self._text = text

    @property
    def offset(self):
        """Gets the offset of this MatchRecordV2.  # noqa: E501

        Start position (in Unicode characters) for the entity match text.  # noqa: E501

        :return: The offset of this MatchRecordV2.  # noqa: E501
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """Sets the offset of this MatchRecordV2.

        Start position (in Unicode characters) for the entity match text.  # noqa: E501

        :param offset: The offset of this MatchRecordV2.  # noqa: E501
        :type: int
        """

        self._offset = offset

    @property
    def length(self):
        """Gets the length of this MatchRecordV2.  # noqa: E501

        Length (in Unicode characters) for the entity match text.  # noqa: E501

        :return: The length of this MatchRecordV2.  # noqa: E501
        :rtype: int
        """
        return self._length

    @length.setter
    def length(self, length):
        """Sets the length of this MatchRecordV2.

        Length (in Unicode characters) for the entity match text.  # noqa: E501

        :param length: The length of this MatchRecordV2.  # noqa: E501
        :type: int
        """

        self._length = length

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MatchRecordV2):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
