# coding: utf-8

"""
    Text Analytics API (v2.0)

    The Text Analytics API is a suite of text analytics web services built with best-in-class Microsoft machine learning algorithms.   The API can be used to analyze unstructured text for tasks such as sentiment analysis, key phrase extraction and language detection.   No training data is needed to use this API; just bring your text data.   This API uses advanced natural language processing techniques to deliver best in class predictions.    Further documentation can be found in https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/overview  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from swagger_client.models.match_record_v2 import MatchRecordV2  # noqa: F401,E501


class EntityRecordV2(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'matches': 'list[MatchRecordV2]',
        'wikipedia_language': 'str',
        'wikipedia_id': 'str',
        'wikipedia_url': 'str',
        'bing_id': 'str'
    }

    attribute_map = {
        'name': 'name',
        'matches': 'matches',
        'wikipedia_language': 'wikipediaLanguage',
        'wikipedia_id': 'wikipediaId',
        'wikipedia_url': 'wikipediaUrl',
        'bing_id': 'bingId'
    }

    def __init__(self, name=None, matches=None, wikipedia_language=None, wikipedia_id=None, wikipedia_url=None, bing_id=None):  # noqa: E501
        """EntityRecordV2 - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._matches = None
        self._wikipedia_language = None
        self._wikipedia_id = None
        self._wikipedia_url = None
        self._bing_id = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if matches is not None:
            self.matches = matches
        if wikipedia_language is not None:
            self.wikipedia_language = wikipedia_language
        if wikipedia_id is not None:
            self.wikipedia_id = wikipedia_id
        if wikipedia_url is not None:
            self.wikipedia_url = wikipedia_url
        if bing_id is not None:
            self.bing_id = bing_id

    @property
    def name(self):
        """Gets the name of this EntityRecordV2.  # noqa: E501

        Entity formal name.  # noqa: E501

        :return: The name of this EntityRecordV2.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this EntityRecordV2.

        Entity formal name.  # noqa: E501

        :param name: The name of this EntityRecordV2.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def matches(self):
        """Gets the matches of this EntityRecordV2.  # noqa: E501

        List of instances this entity appears in the text.  # noqa: E501

        :return: The matches of this EntityRecordV2.  # noqa: E501
        :rtype: list[MatchRecordV2]
        """
        return self._matches

    @matches.setter
    def matches(self, matches):
        """Sets the matches of this EntityRecordV2.

        List of instances this entity appears in the text.  # noqa: E501

        :param matches: The matches of this EntityRecordV2.  # noqa: E501
        :type: list[MatchRecordV2]
        """

        self._matches = matches

    @property
    def wikipedia_language(self):
        """Gets the wikipedia_language of this EntityRecordV2.  # noqa: E501

        Wikipedia language for which the WikipediaId and WikipediaUrl refers to.  # noqa: E501

        :return: The wikipedia_language of this EntityRecordV2.  # noqa: E501
        :rtype: str
        """
        return self._wikipedia_language

    @wikipedia_language.setter
    def wikipedia_language(self, wikipedia_language):
        """Sets the wikipedia_language of this EntityRecordV2.

        Wikipedia language for which the WikipediaId and WikipediaUrl refers to.  # noqa: E501

        :param wikipedia_language: The wikipedia_language of this EntityRecordV2.  # noqa: E501
        :type: str
        """

        self._wikipedia_language = wikipedia_language

    @property
    def wikipedia_id(self):
        """Gets the wikipedia_id of this EntityRecordV2.  # noqa: E501

        Wikipedia unique identifier of the recognized entity.  # noqa: E501

        :return: The wikipedia_id of this EntityRecordV2.  # noqa: E501
        :rtype: str
        """
        return self._wikipedia_id

    @wikipedia_id.setter
    def wikipedia_id(self, wikipedia_id):
        """Sets the wikipedia_id of this EntityRecordV2.

        Wikipedia unique identifier of the recognized entity.  # noqa: E501

        :param wikipedia_id: The wikipedia_id of this EntityRecordV2.  # noqa: E501
        :type: str
        """

        self._wikipedia_id = wikipedia_id

    @property
    def wikipedia_url(self):
        """Gets the wikipedia_url of this EntityRecordV2.  # noqa: E501

        URL for the entity's English Wikipedia page.  # noqa: E501

        :return: The wikipedia_url of this EntityRecordV2.  # noqa: E501
        :rtype: str
        """
        return self._wikipedia_url

    @wikipedia_url.setter
    def wikipedia_url(self, wikipedia_url):
        """Sets the wikipedia_url of this EntityRecordV2.

        URL for the entity's English Wikipedia page.  # noqa: E501

        :param wikipedia_url: The wikipedia_url of this EntityRecordV2.  # noqa: E501
        :type: str
        """

        self._wikipedia_url = wikipedia_url

    @property
    def bing_id(self):
        """Gets the bing_id of this EntityRecordV2.  # noqa: E501

        Bing unique identifier of the recognized entity.               Use in conjunction with the Bing Entity Search API to fetch additional relevant information.  # noqa: E501

        :return: The bing_id of this EntityRecordV2.  # noqa: E501
        :rtype: str
        """
        return self._bing_id

    @bing_id.setter
    def bing_id(self, bing_id):
        """Sets the bing_id of this EntityRecordV2.

        Bing unique identifier of the recognized entity.               Use in conjunction with the Bing Entity Search API to fetch additional relevant information.  # noqa: E501

        :param bing_id: The bing_id of this EntityRecordV2.  # noqa: E501
        :type: str
        """

        self._bing_id = bing_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EntityRecordV2):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
