# coding: utf-8

"""
    Text Analytics API (v2.0)

    The Text Analytics API is a suite of text analytics web services built with best-in-class Microsoft machine learning algorithms.   The API can be used to analyze unstructured text for tasks such as sentiment analysis, key phrase extraction and language detection.   No training data is needed to use this API; just bring your text data.   This API uses advanced natural language processing techniques to deliver best in class predictions.    Further documentation can be found in https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/overview  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class DetectedLanguageV2(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'name': 'str',
        'iso6391_name': 'str',
        'score': 'float'
    }

    attribute_map = {
        'name': 'name',
        'iso6391_name': 'iso6391Name',
        'score': 'score'
    }

    def __init__(self, name=None, iso6391_name=None, score=None):  # noqa: E501
        """DetectedLanguageV2 - a model defined in Swagger"""  # noqa: E501

        self._name = None
        self._iso6391_name = None
        self._score = None
        self.discriminator = None

        if name is not None:
            self.name = name
        if iso6391_name is not None:
            self.iso6391_name = iso6391_name
        if score is not None:
            self.score = score

    @property
    def name(self):
        """Gets the name of this DetectedLanguageV2.  # noqa: E501

        Long name of a detected language (e.g. English, French).  # noqa: E501

        :return: The name of this DetectedLanguageV2.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DetectedLanguageV2.

        Long name of a detected language (e.g. English, French).  # noqa: E501

        :param name: The name of this DetectedLanguageV2.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def iso6391_name(self):
        """Gets the iso6391_name of this DetectedLanguageV2.  # noqa: E501

        A two letter representation of the detected language according to the ISO 639-1 standard (e.g. en, fr).  # noqa: E501

        :return: The iso6391_name of this DetectedLanguageV2.  # noqa: E501
        :rtype: str
        """
        return self._iso6391_name

    @iso6391_name.setter
    def iso6391_name(self, iso6391_name):
        """Sets the iso6391_name of this DetectedLanguageV2.

        A two letter representation of the detected language according to the ISO 639-1 standard (e.g. en, fr).  # noqa: E501

        :param iso6391_name: The iso6391_name of this DetectedLanguageV2.  # noqa: E501
        :type: str
        """

        self._iso6391_name = iso6391_name

    @property
    def score(self):
        """Gets the score of this DetectedLanguageV2.  # noqa: E501

        A confidence score between 0 and 1. Scores close to 1 indicate 100% certainty that the identified language is true.  # noqa: E501

        :return: The score of this DetectedLanguageV2.  # noqa: E501
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this DetectedLanguageV2.

        A confidence score between 0 and 1. Scores close to 1 indicate 100% certainty that the identified language is true.  # noqa: E501

        :param score: The score of this DetectedLanguageV2.  # noqa: E501
        :type: float
        """

        self._score = score

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DetectedLanguageV2):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
