# coding: utf-8

"""
    Text Analytics API (v2.0)

    The Text Analytics API is a suite of text analytics web services built with best-in-class Microsoft machine learning algorithms.   The API can be used to analyze unstructured text for tasks such as sentiment analysis, key phrase extraction and language detection.   No training data is needed to use this API; just bring your text data.   This API uses advanced natural language processing techniques to deliver best in class predictions.    Further documentation can be found in https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/overview  # noqa: E501

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def 56f30ceeeda5650db055a3c6(self, **kwargs):  # noqa: E501
        """Key Phrases  # noqa: E501

        The API returns a list of strings denoting the key talking points in the input text. See the <a href=\"https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/text-analytics-supported-languages\">Supported languages in Text Analytics API</a> for the list of enabled languages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.56f30ceeeda5650db055a3c6(async=True)
        >>> result = thread.get()

        :param async bool
        :param MultiLanguageBatchInputV2 multi_language_batch_input_v2: Collection of documents to analyze. Documents can now contain a language field to indicate the text language
        :return: KeyPhraseBatchResultV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.56f30ceeeda5650db055a3c6_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.56f30ceeeda5650db055a3c6_with_http_info(**kwargs)  # noqa: E501
            return data

    def 56f30ceeeda5650db055a3c6_with_http_info(self, **kwargs):  # noqa: E501
        """Key Phrases  # noqa: E501

        The API returns a list of strings denoting the key talking points in the input text. See the <a href=\"https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/text-analytics-supported-languages\">Supported languages in Text Analytics API</a> for the list of enabled languages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.56f30ceeeda5650db055a3c6_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param MultiLanguageBatchInputV2 multi_language_batch_input_v2: Collection of documents to analyze. Documents can now contain a language field to indicate the text language
        :return: KeyPhraseBatchResultV2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['multi_language_batch_input_v2']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method 56f30ceeeda5650db055a3c6" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'multi_language_batch_input_v2' in params:
            body_params = params['multi_language_batch_input_v2']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader', 'apiKeyQuery']  # noqa: E501

        return self.api_client.call_api(
            '/keyPhrases', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='KeyPhraseBatchResultV2',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def 56f30ceeeda5650db055a3c7(self, **kwargs):  # noqa: E501
        """Detect Language  # noqa: E501

        The API returns the detected language and a numeric score between 0 and 1. Scores close to 1 indicate 100% certainty that the identified language is true. A total of 120 languages are supported.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.56f30ceeeda5650db055a3c7(async=True)
        >>> result = thread.get()

        :param async bool
        :param BatchInputV2 batch_input_v2: Collection of documents to analyze.
        :return: LanguageBatchResultV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.56f30ceeeda5650db055a3c7_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.56f30ceeeda5650db055a3c7_with_http_info(**kwargs)  # noqa: E501
            return data

    def 56f30ceeeda5650db055a3c7_with_http_info(self, **kwargs):  # noqa: E501
        """Detect Language  # noqa: E501

        The API returns the detected language and a numeric score between 0 and 1. Scores close to 1 indicate 100% certainty that the identified language is true. A total of 120 languages are supported.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.56f30ceeeda5650db055a3c7_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param BatchInputV2 batch_input_v2: Collection of documents to analyze.
        :return: LanguageBatchResultV2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['batch_input_v2']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method 56f30ceeeda5650db055a3c7" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'batch_input_v2' in params:
            body_params = params['batch_input_v2']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader', 'apiKeyQuery']  # noqa: E501

        return self.api_client.call_api(
            '/languages', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LanguageBatchResultV2',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def 56f30ceeeda5650db055a3c9(self, **kwargs):  # noqa: E501
        """Sentiment  # noqa: E501

        The API returns a numeric score between 0 and 1. Scores close to 1 indicate positive sentiment, while scores close to 0 indicate negative sentiment. A score of 0.5 indicates the lack of sentiment (e.g. a factoid statement). See the <a href=\"https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/text-analytics-supported-languages\">Supported languages in Text Analytics API</a> for the list of enabled languages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.56f30ceeeda5650db055a3c9(async=True)
        >>> result = thread.get()

        :param async bool
        :param MultiLanguageBatchInputV2 multi_language_batch_input_v2: Collection of documents to analyze.
        :return: SentimentBatchResultV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.56f30ceeeda5650db055a3c9_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.56f30ceeeda5650db055a3c9_with_http_info(**kwargs)  # noqa: E501
            return data

    def 56f30ceeeda5650db055a3c9_with_http_info(self, **kwargs):  # noqa: E501
        """Sentiment  # noqa: E501

        The API returns a numeric score between 0 and 1. Scores close to 1 indicate positive sentiment, while scores close to 0 indicate negative sentiment. A score of 0.5 indicates the lack of sentiment (e.g. a factoid statement). See the <a href=\"https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/text-analytics-supported-languages\">Supported languages in Text Analytics API</a> for the list of enabled languages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.56f30ceeeda5650db055a3c9_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param MultiLanguageBatchInputV2 multi_language_batch_input_v2: Collection of documents to analyze.
        :return: SentimentBatchResultV2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['multi_language_batch_input_v2']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method 56f30ceeeda5650db055a3c9" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'multi_language_batch_input_v2' in params:
            body_params = params['multi_language_batch_input_v2']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader', 'apiKeyQuery']  # noqa: E501

        return self.api_client.call_api(
            '/sentiment', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SentimentBatchResultV2',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def 5ac4251d5b4ccd1554da7634(self, **kwargs):  # noqa: E501
        """Entities  # noqa: E501

        The API returns a list of recognized entities in a given document. To get even more information on each recognized entity we recommend using the Bing Entity Search API by querying for the recognized entities names. See the <a href=\"https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/text-analytics-supported-languages\">Supported languages in Text Analytics API</a> for the list of enabled languages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.5ac4251d5b4ccd1554da7634(async=True)
        >>> result = thread.get()

        :param async bool
        :param MultiLanguageBatchInputV2 multi_language_batch_input_v2: Collection of documents to analyze.
        :return: EntitiesBatchResultV2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.5ac4251d5b4ccd1554da7634_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.5ac4251d5b4ccd1554da7634_with_http_info(**kwargs)  # noqa: E501
            return data

    def 5ac4251d5b4ccd1554da7634_with_http_info(self, **kwargs):  # noqa: E501
        """Entities  # noqa: E501

        The API returns a list of recognized entities in a given document. To get even more information on each recognized entity we recommend using the Bing Entity Search API by querying for the recognized entities names. See the <a href=\"https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/text-analytics-supported-languages\">Supported languages in Text Analytics API</a> for the list of enabled languages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.5ac4251d5b4ccd1554da7634_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :param MultiLanguageBatchInputV2 multi_language_batch_input_v2: Collection of documents to analyze.
        :return: EntitiesBatchResultV2
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['multi_language_batch_input_v2']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method 5ac4251d5b4ccd1554da7634" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'multi_language_batch_input_v2' in params:
            body_params = params['multi_language_batch_input_v2']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apiKeyHeader', 'apiKeyQuery']  # noqa: E501

        return self.api_client.call_api(
            '/entities', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntitiesBatchResultV2',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
