# coding: utf-8

"""
    Text Analytics API (v2.0)

    The Text Analytics API is a suite of text analytics web services built with 
    best-in-class Microsoft machine learning algorithms.   
    The API can be used to analyze unstructured text for tasks such as 
    sentiment analysis, key phrase extraction and language detection.   
    
    No training data is needed to use this API; just bring your text data.
    
    This API uses advanced natural language processing techniques to deliver 
    best in class predictions.
    
    Further documentation can be found in https://docs.microsoft.com/en-us/azure/cognitive-services/text-analytics/overview

    OpenAPI spec version: 1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import io
import os
import sys
from shutil import rmtree
from setuptools import setup, find_packages, Command

NAME = 'text-analytics'
VERSION = '1.0.2'
URL = 'https://github.com/wmeints/text-analytics'
AUTHOR = 'Willem Meints'
EMAIL = 'willem.meints@gmail.com'
DESCRIPTION='Azure Cognitive Services Text Analytics API (v2.0)'

# To install the library, run the following
#
# python setup.py install
#
# prerequisite: setuptools
# http://pypi.python.org/pypi/setuptools

REQUIRES = ["urllib3 >= 1.15", "six >= 1.10", "certifi", "python-dateutil"]

here = os.path.abspath(os.path.dirname(__file__))

# Import the README and use it as the long-description.
# Note: this will only work if 'README.md' is present in your MANIFEST.in file!
try:
    with io.open(os.path.join(here, 'README.md'), encoding='utf-8') as f:
        long_description = '\n' + f.read()
except FileNotFoundError:
    long_description = DESCRIPTION

# Load the package's __version__.py module as a dictionary.
about = {}
if not VERSION:
    with open(os.path.join(here, NAME, '__version__.py')) as f:
        exec(f.read(), about)
else:
    about['__version__'] = VERSION

class UploadCommand(Command):
    """Support setup.py upload."""

    description = 'Build and publish the package.'
    user_options = []

    @staticmethod
    def status(s):
        """Prints things in bold."""
        print('\033[1m{0}\033[0m'.format(s))

    def initialize_options(self):
        pass

    def finalize_options(self):
        pass

    def run(self):
        try:
            self.status('Removing previous builds…')
            rmtree(os.path.join(here, 'dist'))
        except OSError:
            pass

        self.status('Building Source and Wheel (universal) distribution…')
        os.system(
            '{0} setup.py sdist bdist_wheel --universal'.format(sys.executable))

        self.status('Uploading the package to PyPI via Twine…')
        os.system('twine upload dist/*')

        self.status('Pushing git tags…')
        os.system('git tag v{0}'.format(about['__version__']))
        os.system('git push --tags')

        sys.exit()

setup(
    name=NAME,
    version=VERSION,
    description=DESCRIPTION,
    author_email=EMAIL,
    url=URL,
    keywords=[
        "Swagger", 
        "Text Analytics API (v2.0)", 
        "Azure", "Cognitive Services"
    ],
    install_requires=REQUIRES,
    packages=find_packages(exclude=['test','docs']),
    include_package_data=True,
    classifiers=[
        'Intended Audience :: Developers',
        'License :: OSI Approved :: Apache Software License',
        'Development Status :: 4 - Beta'
    ],
    cmdclass={
        'upload': UploadCommand,
    },
    long_description=long_description,
    long_description_content_type='text/markdown'
)
