/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.io.Serializable;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.field.UnsupportedDateTimeField;
import org.joda.time.field.UnsupportedDurationField;

public abstract class BaseChronology
extends Chronology
implements Serializable {
    private static final long serialVersionUID = -7310865996721419676L;

    protected BaseChronology() {
    }

    public abstract DateTimeZone getZone();

    public abstract Chronology withUTC();

    public abstract Chronology withZone(DateTimeZone var1);

    public long getDateTimeMillis(int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        long l2 = this.year().set(0L, n2);
        l2 = this.monthOfYear().set(l2, n3);
        l2 = this.dayOfMonth().set(l2, n4);
        return this.millisOfDay().set(l2, n5);
    }

    public long getDateTimeMillis(int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws IllegalArgumentException {
        long l2 = this.year().set(0L, n2);
        l2 = this.monthOfYear().set(l2, n3);
        l2 = this.dayOfMonth().set(l2, n4);
        l2 = this.hourOfDay().set(l2, n5);
        l2 = this.minuteOfHour().set(l2, n6);
        l2 = this.secondOfMinute().set(l2, n7);
        return this.millisOfSecond().set(l2, n8);
    }

    public long getDateTimeMillis(long l2, int n2, int n3, int n4, int n5) throws IllegalArgumentException {
        l2 = this.hourOfDay().set(l2, n2);
        l2 = this.minuteOfHour().set(l2, n3);
        l2 = this.secondOfMinute().set(l2, n4);
        return this.millisOfSecond().set(l2, n5);
    }

    public void validate(ReadablePartial readablePartial, int[] nArray) {
        DateTimeField dateTimeField;
        int n2;
        int n3;
        int n4 = readablePartial.size();
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = nArray[n3];
            dateTimeField = readablePartial.getField(n3);
            if (n2 < dateTimeField.getMinimumValue()) {
                throw new IllegalFieldValueException(dateTimeField.getType(), (Number)n2, (Number)dateTimeField.getMinimumValue(), null);
            }
            if (n2 <= dateTimeField.getMaximumValue()) continue;
            throw new IllegalFieldValueException(dateTimeField.getType(), (Number)n2, null, (Number)dateTimeField.getMaximumValue());
        }
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = nArray[n3];
            dateTimeField = readablePartial.getField(n3);
            if (n2 < dateTimeField.getMinimumValue(readablePartial, nArray)) {
                throw new IllegalFieldValueException(dateTimeField.getType(), (Number)n2, (Number)dateTimeField.getMinimumValue(readablePartial, nArray), null);
            }
            if (n2 <= dateTimeField.getMaximumValue(readablePartial, nArray)) continue;
            throw new IllegalFieldValueException(dateTimeField.getType(), (Number)n2, null, (Number)dateTimeField.getMaximumValue(readablePartial, nArray));
        }
    }

    public int[] get(ReadablePartial readablePartial, long l2) {
        int n2 = readablePartial.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = readablePartial.getFieldType(i2).getField(this).get(l2);
        }
        return nArray;
    }

    public long set(ReadablePartial readablePartial, long l2) {
        int n2 = readablePartial.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 = readablePartial.getFieldType(i2).getField(this).set(l2, readablePartial.getValue(i2));
        }
        return l2;
    }

    public int[] get(ReadablePeriod readablePeriod, long l2, long l3) {
        int n2 = readablePeriod.size();
        int[] nArray = new int[n2];
        if (l2 != l3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                DurationField durationField = readablePeriod.getFieldType(i2).getField(this);
                int n3 = durationField.getDifference(l3, l2);
                if (n3 != 0) {
                    l2 = durationField.add(l2, n3);
                }
                nArray[i2] = n3;
            }
        }
        return nArray;
    }

    public int[] get(ReadablePeriod readablePeriod, long l2) {
        int n2 = readablePeriod.size();
        int[] nArray = new int[n2];
        if (l2 != 0L) {
            long l3 = 0L;
            for (int i2 = 0; i2 < n2; ++i2) {
                DurationField durationField = readablePeriod.getFieldType(i2).getField(this);
                if (!durationField.isPrecise()) continue;
                int n3 = durationField.getDifference(l2, l3);
                l3 = durationField.add(l3, n3);
                nArray[i2] = n3;
            }
        }
        return nArray;
    }

    public long add(ReadablePeriod readablePeriod, long l2, int n2) {
        if (n2 != 0 && readablePeriod != null) {
            int n3 = readablePeriod.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                long l3 = readablePeriod.getValue(i2);
                if (l3 == 0L) continue;
                l2 = readablePeriod.getFieldType(i2).getField(this).add(l2, l3 * (long)n2);
            }
        }
        return l2;
    }

    public long add(long l2, long l3, int n2) {
        if (l3 == 0L || n2 == 0) {
            return l2;
        }
        long l4 = FieldUtils.safeMultiply(l3, n2);
        return FieldUtils.safeAdd(l2, l4);
    }

    public DurationField millis() {
        return UnsupportedDurationField.getInstance(DurationFieldType.millis());
    }

    public DateTimeField millisOfSecond() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.millisOfSecond(), this.millis());
    }

    public DateTimeField millisOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.millisOfDay(), this.millis());
    }

    public DurationField seconds() {
        return UnsupportedDurationField.getInstance(DurationFieldType.seconds());
    }

    public DateTimeField secondOfMinute() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.secondOfMinute(), this.seconds());
    }

    public DateTimeField secondOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.secondOfDay(), this.seconds());
    }

    public DurationField minutes() {
        return UnsupportedDurationField.getInstance(DurationFieldType.minutes());
    }

    public DateTimeField minuteOfHour() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.minuteOfHour(), this.minutes());
    }

    public DateTimeField minuteOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.minuteOfDay(), this.minutes());
    }

    public DurationField hours() {
        return UnsupportedDurationField.getInstance(DurationFieldType.hours());
    }

    public DateTimeField hourOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.hourOfDay(), this.hours());
    }

    public DateTimeField clockhourOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.clockhourOfDay(), this.hours());
    }

    public DurationField halfdays() {
        return UnsupportedDurationField.getInstance(DurationFieldType.halfdays());
    }

    public DateTimeField hourOfHalfday() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.hourOfHalfday(), this.hours());
    }

    public DateTimeField clockhourOfHalfday() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.clockhourOfHalfday(), this.hours());
    }

    public DateTimeField halfdayOfDay() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.halfdayOfDay(), this.halfdays());
    }

    public DurationField days() {
        return UnsupportedDurationField.getInstance(DurationFieldType.days());
    }

    public DateTimeField dayOfWeek() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfWeek(), this.days());
    }

    public DateTimeField dayOfMonth() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfMonth(), this.days());
    }

    public DateTimeField dayOfYear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.dayOfYear(), this.days());
    }

    public DurationField weeks() {
        return UnsupportedDurationField.getInstance(DurationFieldType.weeks());
    }

    public DateTimeField weekOfWeekyear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekOfWeekyear(), this.weeks());
    }

    public DurationField weekyears() {
        return UnsupportedDurationField.getInstance(DurationFieldType.weekyears());
    }

    public DateTimeField weekyear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekyear(), this.weekyears());
    }

    public DateTimeField weekyearOfCentury() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.weekyearOfCentury(), this.weekyears());
    }

    public DurationField months() {
        return UnsupportedDurationField.getInstance(DurationFieldType.months());
    }

    public DateTimeField monthOfYear() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.monthOfYear(), this.months());
    }

    public DurationField years() {
        return UnsupportedDurationField.getInstance(DurationFieldType.years());
    }

    public DateTimeField year() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.year(), this.years());
    }

    public DateTimeField yearOfEra() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.yearOfEra(), this.years());
    }

    public DateTimeField yearOfCentury() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.yearOfCentury(), this.years());
    }

    public DurationField centuries() {
        return UnsupportedDurationField.getInstance(DurationFieldType.centuries());
    }

    public DateTimeField centuryOfEra() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.centuryOfEra(), this.centuries());
    }

    public DurationField eras() {
        return UnsupportedDurationField.getInstance(DurationFieldType.eras());
    }

    public DateTimeField era() {
        return UnsupportedDateTimeField.getInstance(DateTimeFieldType.era(), this.eras());
    }

    public abstract String toString();
}

